/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.personalize.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeSchemaResponse extends PersonalizeResponse implements
        ToCopyableBuilder<DescribeSchemaResponse.Builder, DescribeSchemaResponse> {
    private static final SdkField<DatasetSchema> SCHEMA_FIELD = SdkField.<DatasetSchema> builder(MarshallingType.SDK_POJO)
            .memberName("schema").getter(getter(DescribeSchemaResponse::schema)).setter(setter(Builder::schema))
            .constructor(DatasetSchema::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schema").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEMA_FIELD));

    private final DatasetSchema schema;

    private DescribeSchemaResponse(BuilderImpl builder) {
        super(builder);
        this.schema = builder.schema;
    }

    /**
     * <p>
     * The requested schema.
     * </p>
     * 
     * @return The requested schema.
     */
    public final DatasetSchema schema() {
        return schema;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(schema());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSchemaResponse)) {
            return false;
        }
        DescribeSchemaResponse other = (DescribeSchemaResponse) obj;
        return Objects.equals(schema(), other.schema());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeSchemaResponse").add("Schema", schema()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "schema":
            return Optional.ofNullable(clazz.cast(schema()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeSchemaResponse, T> g) {
        return obj -> g.apply((DescribeSchemaResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PersonalizeResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeSchemaResponse> {
        /**
         * <p>
         * The requested schema.
         * </p>
         * 
         * @param schema
         *        The requested schema.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schema(DatasetSchema schema);

        /**
         * <p>
         * The requested schema.
         * </p>
         * This is a convenience that creates an instance of the {@link DatasetSchema.Builder} avoiding the need to
         * create one manually via {@link DatasetSchema#builder()}.
         *
         * When the {@link Consumer} completes, {@link DatasetSchema.Builder#build()} is called immediately and its
         * result is passed to {@link #schema(DatasetSchema)}.
         * 
         * @param schema
         *        a consumer that will call methods on {@link DatasetSchema.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #schema(DatasetSchema)
         */
        default Builder schema(Consumer<DatasetSchema.Builder> schema) {
            return schema(DatasetSchema.builder().applyMutation(schema).build());
        }
    }

    static final class BuilderImpl extends PersonalizeResponse.BuilderImpl implements Builder {
        private DatasetSchema schema;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSchemaResponse model) {
            super(model);
            schema(model.schema);
        }

        public final DatasetSchema.Builder getSchema() {
            return schema != null ? schema.toBuilder() : null;
        }

        public final void setSchema(DatasetSchema.BuilderImpl schema) {
            this.schema = schema != null ? schema.build() : null;
        }

        @Override
        @Transient
        public final Builder schema(DatasetSchema schema) {
            this.schema = schema;
            return this;
        }

        @Override
        public DescribeSchemaResponse build() {
            return new DescribeSchemaResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
