/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.personalize.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a recommendation generator for a Domain dataset group. You create a recommender in a Domain dataset group
 * for a specific domain use case (domain recipe), and specify the recommender in a <a
 * href="https://docs.aws.amazon.com/personalize/latest/dg/API_RS_GetRecommendations.html">GetRecommendations</a>
 * request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Recommender implements SdkPojo, Serializable, ToCopyableBuilder<Recommender.Builder, Recommender> {
    private static final SdkField<String> RECOMMENDER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("recommenderArn").getter(getter(Recommender::recommenderArn)).setter(setter(Builder::recommenderArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommenderArn").build()).build();

    private static final SdkField<String> DATASET_GROUP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("datasetGroupArn").getter(getter(Recommender::datasetGroupArn)).setter(setter(Builder::datasetGroupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datasetGroupArn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(Recommender::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> RECIPE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("recipeArn").getter(getter(Recommender::recipeArn)).setter(setter(Builder::recipeArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recipeArn").build()).build();

    private static final SdkField<RecommenderConfig> RECOMMENDER_CONFIG_FIELD = SdkField
            .<RecommenderConfig> builder(MarshallingType.SDK_POJO).memberName("recommenderConfig")
            .getter(getter(Recommender::recommenderConfig)).setter(setter(Builder::recommenderConfig))
            .constructor(RecommenderConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommenderConfig").build()).build();

    private static final SdkField<Instant> CREATION_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationDateTime").getter(getter(Recommender::creationDateTime))
            .setter(setter(Builder::creationDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDateTime").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdatedDateTime").getter(getter(Recommender::lastUpdatedDateTime))
            .setter(setter(Builder::lastUpdatedDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedDateTime").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(Recommender::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("failureReason").getter(getter(Recommender::failureReason)).setter(setter(Builder::failureReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureReason").build()).build();

    private static final SdkField<RecommenderUpdateSummary> LATEST_RECOMMENDER_UPDATE_FIELD = SdkField
            .<RecommenderUpdateSummary> builder(MarshallingType.SDK_POJO).memberName("latestRecommenderUpdate")
            .getter(getter(Recommender::latestRecommenderUpdate)).setter(setter(Builder::latestRecommenderUpdate))
            .constructor(RecommenderUpdateSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("latestRecommenderUpdate").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECOMMENDER_ARN_FIELD,
            DATASET_GROUP_ARN_FIELD, NAME_FIELD, RECIPE_ARN_FIELD, RECOMMENDER_CONFIG_FIELD, CREATION_DATE_TIME_FIELD,
            LAST_UPDATED_DATE_TIME_FIELD, STATUS_FIELD, FAILURE_REASON_FIELD, LATEST_RECOMMENDER_UPDATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String recommenderArn;

    private final String datasetGroupArn;

    private final String name;

    private final String recipeArn;

    private final RecommenderConfig recommenderConfig;

    private final Instant creationDateTime;

    private final Instant lastUpdatedDateTime;

    private final String status;

    private final String failureReason;

    private final RecommenderUpdateSummary latestRecommenderUpdate;

    private Recommender(BuilderImpl builder) {
        this.recommenderArn = builder.recommenderArn;
        this.datasetGroupArn = builder.datasetGroupArn;
        this.name = builder.name;
        this.recipeArn = builder.recipeArn;
        this.recommenderConfig = builder.recommenderConfig;
        this.creationDateTime = builder.creationDateTime;
        this.lastUpdatedDateTime = builder.lastUpdatedDateTime;
        this.status = builder.status;
        this.failureReason = builder.failureReason;
        this.latestRecommenderUpdate = builder.latestRecommenderUpdate;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the recommender.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the recommender.
     */
    public final String recommenderArn() {
        return recommenderArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Domain dataset group that contains the recommender.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Domain dataset group that contains the recommender.
     */
    public final String datasetGroupArn() {
        return datasetGroupArn;
    }

    /**
     * <p>
     * The name of the recommender.
     * </p>
     * 
     * @return The name of the recommender.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the recipe (Domain dataset group use case) that the recommender was created
     * for.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the recipe (Domain dataset group use case) that the recommender was
     *         created for.
     */
    public final String recipeArn() {
        return recipeArn;
    }

    /**
     * <p>
     * The configuration details of the recommender.
     * </p>
     * 
     * @return The configuration details of the recommender.
     */
    public final RecommenderConfig recommenderConfig() {
        return recommenderConfig;
    }

    /**
     * <p>
     * The date and time (in Unix format) that the recommender was created.
     * </p>
     * 
     * @return The date and time (in Unix format) that the recommender was created.
     */
    public final Instant creationDateTime() {
        return creationDateTime;
    }

    /**
     * <p>
     * The date and time (in Unix format) that the recommender was last updated.
     * </p>
     * 
     * @return The date and time (in Unix format) that the recommender was last updated.
     */
    public final Instant lastUpdatedDateTime() {
        return lastUpdatedDateTime;
    }

    /**
     * <p>
     * The status of the recommender.
     * </p>
     * <p>
     * A recommender can be in one of the following states:
     * </p>
     * <ul>
     * <li>
     * <p>
     * CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED
     * </p>
     * </li>
     * <li>
     * <p>
     * DELETE PENDING &gt; DELETE IN_PROGRESS
     * </p>
     * </li>
     * </ul>
     * 
     * @return The status of the recommender.</p>
     *         <p>
     *         A recommender can be in one of the following states:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DELETE PENDING &gt; DELETE IN_PROGRESS
     *         </p>
     *         </li>
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * If a recommender fails, the reason behind the failure.
     * </p>
     * 
     * @return If a recommender fails, the reason behind the failure.
     */
    public final String failureReason() {
        return failureReason;
    }

    /**
     * <p>
     * Provides a summary of the latest updates to the recommender.
     * </p>
     * 
     * @return Provides a summary of the latest updates to the recommender.
     */
    public final RecommenderUpdateSummary latestRecommenderUpdate() {
        return latestRecommenderUpdate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(recommenderArn());
        hashCode = 31 * hashCode + Objects.hashCode(datasetGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(recipeArn());
        hashCode = 31 * hashCode + Objects.hashCode(recommenderConfig());
        hashCode = 31 * hashCode + Objects.hashCode(creationDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(latestRecommenderUpdate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Recommender)) {
            return false;
        }
        Recommender other = (Recommender) obj;
        return Objects.equals(recommenderArn(), other.recommenderArn())
                && Objects.equals(datasetGroupArn(), other.datasetGroupArn()) && Objects.equals(name(), other.name())
                && Objects.equals(recipeArn(), other.recipeArn())
                && Objects.equals(recommenderConfig(), other.recommenderConfig())
                && Objects.equals(creationDateTime(), other.creationDateTime())
                && Objects.equals(lastUpdatedDateTime(), other.lastUpdatedDateTime()) && Objects.equals(status(), other.status())
                && Objects.equals(failureReason(), other.failureReason())
                && Objects.equals(latestRecommenderUpdate(), other.latestRecommenderUpdate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Recommender").add("RecommenderArn", recommenderArn()).add("DatasetGroupArn", datasetGroupArn())
                .add("Name", name()).add("RecipeArn", recipeArn()).add("RecommenderConfig", recommenderConfig())
                .add("CreationDateTime", creationDateTime()).add("LastUpdatedDateTime", lastUpdatedDateTime())
                .add("Status", status()).add("FailureReason", failureReason())
                .add("LatestRecommenderUpdate", latestRecommenderUpdate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "recommenderArn":
            return Optional.ofNullable(clazz.cast(recommenderArn()));
        case "datasetGroupArn":
            return Optional.ofNullable(clazz.cast(datasetGroupArn()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "recipeArn":
            return Optional.ofNullable(clazz.cast(recipeArn()));
        case "recommenderConfig":
            return Optional.ofNullable(clazz.cast(recommenderConfig()));
        case "creationDateTime":
            return Optional.ofNullable(clazz.cast(creationDateTime()));
        case "lastUpdatedDateTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedDateTime()));
        case "status":
            return Optional.ofNullable(clazz.cast(status()));
        case "failureReason":
            return Optional.ofNullable(clazz.cast(failureReason()));
        case "latestRecommenderUpdate":
            return Optional.ofNullable(clazz.cast(latestRecommenderUpdate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Recommender, T> g) {
        return obj -> g.apply((Recommender) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Recommender> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the recommender.
         * </p>
         * 
         * @param recommenderArn
         *        The Amazon Resource Name (ARN) of the recommender.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recommenderArn(String recommenderArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Domain dataset group that contains the recommender.
         * </p>
         * 
         * @param datasetGroupArn
         *        The Amazon Resource Name (ARN) of the Domain dataset group that contains the recommender.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetGroupArn(String datasetGroupArn);

        /**
         * <p>
         * The name of the recommender.
         * </p>
         * 
         * @param name
         *        The name of the recommender.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the recipe (Domain dataset group use case) that the recommender was created
         * for.
         * </p>
         * 
         * @param recipeArn
         *        The Amazon Resource Name (ARN) of the recipe (Domain dataset group use case) that the recommender was
         *        created for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recipeArn(String recipeArn);

        /**
         * <p>
         * The configuration details of the recommender.
         * </p>
         * 
         * @param recommenderConfig
         *        The configuration details of the recommender.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recommenderConfig(RecommenderConfig recommenderConfig);

        /**
         * <p>
         * The configuration details of the recommender.
         * </p>
         * This is a convenience that creates an instance of the {@link RecommenderConfig.Builder} avoiding the need to
         * create one manually via {@link RecommenderConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link RecommenderConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #recommenderConfig(RecommenderConfig)}.
         * 
         * @param recommenderConfig
         *        a consumer that will call methods on {@link RecommenderConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #recommenderConfig(RecommenderConfig)
         */
        default Builder recommenderConfig(Consumer<RecommenderConfig.Builder> recommenderConfig) {
            return recommenderConfig(RecommenderConfig.builder().applyMutation(recommenderConfig).build());
        }

        /**
         * <p>
         * The date and time (in Unix format) that the recommender was created.
         * </p>
         * 
         * @param creationDateTime
         *        The date and time (in Unix format) that the recommender was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDateTime(Instant creationDateTime);

        /**
         * <p>
         * The date and time (in Unix format) that the recommender was last updated.
         * </p>
         * 
         * @param lastUpdatedDateTime
         *        The date and time (in Unix format) that the recommender was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedDateTime(Instant lastUpdatedDateTime);

        /**
         * <p>
         * The status of the recommender.
         * </p>
         * <p>
         * A recommender can be in one of the following states:
         * </p>
         * <ul>
         * <li>
         * <p>
         * CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED
         * </p>
         * </li>
         * <li>
         * <p>
         * DELETE PENDING &gt; DELETE IN_PROGRESS
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the recommender.</p>
         *        <p>
         *        A recommender can be in one of the following states:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        DELETE PENDING &gt; DELETE IN_PROGRESS
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * If a recommender fails, the reason behind the failure.
         * </p>
         * 
         * @param failureReason
         *        If a recommender fails, the reason behind the failure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReason(String failureReason);

        /**
         * <p>
         * Provides a summary of the latest updates to the recommender.
         * </p>
         * 
         * @param latestRecommenderUpdate
         *        Provides a summary of the latest updates to the recommender.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestRecommenderUpdate(RecommenderUpdateSummary latestRecommenderUpdate);

        /**
         * <p>
         * Provides a summary of the latest updates to the recommender.
         * </p>
         * This is a convenience that creates an instance of the {@link RecommenderUpdateSummary.Builder} avoiding the
         * need to create one manually via {@link RecommenderUpdateSummary#builder()}.
         *
         * When the {@link Consumer} completes, {@link RecommenderUpdateSummary.Builder#build()} is called immediately
         * and its result is passed to {@link #latestRecommenderUpdate(RecommenderUpdateSummary)}.
         * 
         * @param latestRecommenderUpdate
         *        a consumer that will call methods on {@link RecommenderUpdateSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #latestRecommenderUpdate(RecommenderUpdateSummary)
         */
        default Builder latestRecommenderUpdate(Consumer<RecommenderUpdateSummary.Builder> latestRecommenderUpdate) {
            return latestRecommenderUpdate(RecommenderUpdateSummary.builder().applyMutation(latestRecommenderUpdate).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String recommenderArn;

        private String datasetGroupArn;

        private String name;

        private String recipeArn;

        private RecommenderConfig recommenderConfig;

        private Instant creationDateTime;

        private Instant lastUpdatedDateTime;

        private String status;

        private String failureReason;

        private RecommenderUpdateSummary latestRecommenderUpdate;

        private BuilderImpl() {
        }

        private BuilderImpl(Recommender model) {
            recommenderArn(model.recommenderArn);
            datasetGroupArn(model.datasetGroupArn);
            name(model.name);
            recipeArn(model.recipeArn);
            recommenderConfig(model.recommenderConfig);
            creationDateTime(model.creationDateTime);
            lastUpdatedDateTime(model.lastUpdatedDateTime);
            status(model.status);
            failureReason(model.failureReason);
            latestRecommenderUpdate(model.latestRecommenderUpdate);
        }

        public final String getRecommenderArn() {
            return recommenderArn;
        }

        public final void setRecommenderArn(String recommenderArn) {
            this.recommenderArn = recommenderArn;
        }

        @Override
        @Transient
        public final Builder recommenderArn(String recommenderArn) {
            this.recommenderArn = recommenderArn;
            return this;
        }

        public final String getDatasetGroupArn() {
            return datasetGroupArn;
        }

        public final void setDatasetGroupArn(String datasetGroupArn) {
            this.datasetGroupArn = datasetGroupArn;
        }

        @Override
        @Transient
        public final Builder datasetGroupArn(String datasetGroupArn) {
            this.datasetGroupArn = datasetGroupArn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getRecipeArn() {
            return recipeArn;
        }

        public final void setRecipeArn(String recipeArn) {
            this.recipeArn = recipeArn;
        }

        @Override
        @Transient
        public final Builder recipeArn(String recipeArn) {
            this.recipeArn = recipeArn;
            return this;
        }

        public final RecommenderConfig.Builder getRecommenderConfig() {
            return recommenderConfig != null ? recommenderConfig.toBuilder() : null;
        }

        public final void setRecommenderConfig(RecommenderConfig.BuilderImpl recommenderConfig) {
            this.recommenderConfig = recommenderConfig != null ? recommenderConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder recommenderConfig(RecommenderConfig recommenderConfig) {
            this.recommenderConfig = recommenderConfig;
            return this;
        }

        public final Instant getCreationDateTime() {
            return creationDateTime;
        }

        public final void setCreationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
        }

        @Override
        @Transient
        public final Builder creationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
            return this;
        }

        public final Instant getLastUpdatedDateTime() {
            return lastUpdatedDateTime;
        }

        public final void setLastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
        }

        @Override
        @Transient
        public final Builder lastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final String getFailureReason() {
            return failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        @Transient
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final RecommenderUpdateSummary.Builder getLatestRecommenderUpdate() {
            return latestRecommenderUpdate != null ? latestRecommenderUpdate.toBuilder() : null;
        }

        public final void setLatestRecommenderUpdate(RecommenderUpdateSummary.BuilderImpl latestRecommenderUpdate) {
            this.latestRecommenderUpdate = latestRecommenderUpdate != null ? latestRecommenderUpdate.build() : null;
        }

        @Override
        @Transient
        public final Builder latestRecommenderUpdate(RecommenderUpdateSummary latestRecommenderUpdate) {
            this.latestRecommenderUpdate = latestRecommenderUpdate;
            return this;
        }

        @Override
        public Recommender build() {
            return new Recommender(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
