/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.personalize.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateDatasetGroupRequest extends PersonalizeRequest implements
        ToCopyableBuilder<CreateDatasetGroupRequest.Builder, CreateDatasetGroupRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateDatasetGroupRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(CreateDatasetGroupRequest::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<String> KMS_KEY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("kmsKeyArn").getter(getter(CreateDatasetGroupRequest::kmsKeyArn)).setter(setter(Builder::kmsKeyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyArn").build()).build();

    private static final SdkField<String> DOMAIN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("domain")
            .getter(getter(CreateDatasetGroupRequest::domainAsString)).setter(setter(Builder::domain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domain").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ROLE_ARN_FIELD,
            KMS_KEY_ARN_FIELD, DOMAIN_FIELD));

    private final String name;

    private final String roleArn;

    private final String kmsKeyArn;

    private final String domain;

    private CreateDatasetGroupRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.roleArn = builder.roleArn;
        this.kmsKeyArn = builder.kmsKeyArn;
        this.domain = builder.domain;
    }

    /**
     * <p>
     * The name for the new dataset group.
     * </p>
     * 
     * @return The name for the new dataset group.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The ARN of the Identity and Access Management (IAM) role that has permissions to access the Key Management
     * Service (KMS) key. Supplying an IAM role is only valid when also specifying a KMS key.
     * </p>
     * 
     * @return The ARN of the Identity and Access Management (IAM) role that has permissions to access the Key
     *         Management Service (KMS) key. Supplying an IAM role is only valid when also specifying a KMS key.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of a Key Management Service (KMS) key used to encrypt the datasets.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of a Key Management Service (KMS) key used to encrypt the datasets.
     */
    public final String kmsKeyArn() {
        return kmsKeyArn;
    }

    /**
     * <p>
     * The domain of the dataset group. Specify a domain to create a Domain dataset group. The domain you specify
     * determines the default schemas for datasets and the use cases available for recommenders. If you don't specify a
     * domain, you create a Custom dataset group with solution versions that you deploy with a campaign.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #domain} will
     * return {@link Domain#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #domainAsString}.
     * </p>
     * 
     * @return The domain of the dataset group. Specify a domain to create a Domain dataset group. The domain you
     *         specify determines the default schemas for datasets and the use cases available for recommenders. If you
     *         don't specify a domain, you create a Custom dataset group with solution versions that you deploy with a
     *         campaign.
     * @see Domain
     */
    public final Domain domain() {
        return Domain.fromValue(domain);
    }

    /**
     * <p>
     * The domain of the dataset group. Specify a domain to create a Domain dataset group. The domain you specify
     * determines the default schemas for datasets and the use cases available for recommenders. If you don't specify a
     * domain, you create a Custom dataset group with solution versions that you deploy with a campaign.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #domain} will
     * return {@link Domain#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #domainAsString}.
     * </p>
     * 
     * @return The domain of the dataset group. Specify a domain to create a Domain dataset group. The domain you
     *         specify determines the default schemas for datasets and the use cases available for recommenders. If you
     *         don't specify a domain, you create a Custom dataset group with solution versions that you deploy with a
     *         campaign.
     * @see Domain
     */
    public final String domainAsString() {
        return domain;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(domainAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDatasetGroupRequest)) {
            return false;
        }
        CreateDatasetGroupRequest other = (CreateDatasetGroupRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(kmsKeyArn(), other.kmsKeyArn()) && Objects.equals(domainAsString(), other.domainAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateDatasetGroupRequest").add("Name", name()).add("RoleArn", roleArn())
                .add("KmsKeyArn", kmsKeyArn()).add("Domain", domainAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "kmsKeyArn":
            return Optional.ofNullable(clazz.cast(kmsKeyArn()));
        case "domain":
            return Optional.ofNullable(clazz.cast(domainAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateDatasetGroupRequest, T> g) {
        return obj -> g.apply((CreateDatasetGroupRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PersonalizeRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateDatasetGroupRequest> {
        /**
         * <p>
         * The name for the new dataset group.
         * </p>
         * 
         * @param name
         *        The name for the new dataset group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The ARN of the Identity and Access Management (IAM) role that has permissions to access the Key Management
         * Service (KMS) key. Supplying an IAM role is only valid when also specifying a KMS key.
         * </p>
         * 
         * @param roleArn
         *        The ARN of the Identity and Access Management (IAM) role that has permissions to access the Key
         *        Management Service (KMS) key. Supplying an IAM role is only valid when also specifying a KMS key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of a Key Management Service (KMS) key used to encrypt the datasets.
         * </p>
         * 
         * @param kmsKeyArn
         *        The Amazon Resource Name (ARN) of a Key Management Service (KMS) key used to encrypt the datasets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyArn(String kmsKeyArn);

        /**
         * <p>
         * The domain of the dataset group. Specify a domain to create a Domain dataset group. The domain you specify
         * determines the default schemas for datasets and the use cases available for recommenders. If you don't
         * specify a domain, you create a Custom dataset group with solution versions that you deploy with a campaign.
         * </p>
         * 
         * @param domain
         *        The domain of the dataset group. Specify a domain to create a Domain dataset group. The domain you
         *        specify determines the default schemas for datasets and the use cases available for recommenders. If
         *        you don't specify a domain, you create a Custom dataset group with solution versions that you deploy
         *        with a campaign.
         * @see Domain
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Domain
         */
        Builder domain(String domain);

        /**
         * <p>
         * The domain of the dataset group. Specify a domain to create a Domain dataset group. The domain you specify
         * determines the default schemas for datasets and the use cases available for recommenders. If you don't
         * specify a domain, you create a Custom dataset group with solution versions that you deploy with a campaign.
         * </p>
         * 
         * @param domain
         *        The domain of the dataset group. Specify a domain to create a Domain dataset group. The domain you
         *        specify determines the default schemas for datasets and the use cases available for recommenders. If
         *        you don't specify a domain, you create a Custom dataset group with solution versions that you deploy
         *        with a campaign.
         * @see Domain
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Domain
         */
        Builder domain(Domain domain);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PersonalizeRequest.BuilderImpl implements Builder {
        private String name;

        private String roleArn;

        private String kmsKeyArn;

        private String domain;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDatasetGroupRequest model) {
            super(model);
            name(model.name);
            roleArn(model.roleArn);
            kmsKeyArn(model.kmsKeyArn);
            domain(model.domain);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        @Transient
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getKmsKeyArn() {
            return kmsKeyArn;
        }

        public final void setKmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
        }

        @Override
        @Transient
        public final Builder kmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        public final String getDomain() {
            return domain;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        @Override
        @Transient
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        @Override
        @Transient
        public final Builder domain(Domain domain) {
            this.domain(domain == null ? null : domain.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDatasetGroupRequest build() {
            return new CreateDatasetGroupRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
