/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.personalize.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateRecommenderRequest extends PersonalizeRequest implements
        ToCopyableBuilder<CreateRecommenderRequest.Builder, CreateRecommenderRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateRecommenderRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DATASET_GROUP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("datasetGroupArn").getter(getter(CreateRecommenderRequest::datasetGroupArn))
            .setter(setter(Builder::datasetGroupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datasetGroupArn").build()).build();

    private static final SdkField<String> RECIPE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("recipeArn").getter(getter(CreateRecommenderRequest::recipeArn)).setter(setter(Builder::recipeArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recipeArn").build()).build();

    private static final SdkField<RecommenderConfig> RECOMMENDER_CONFIG_FIELD = SdkField
            .<RecommenderConfig> builder(MarshallingType.SDK_POJO).memberName("recommenderConfig")
            .getter(getter(CreateRecommenderRequest::recommenderConfig)).setter(setter(Builder::recommenderConfig))
            .constructor(RecommenderConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommenderConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            DATASET_GROUP_ARN_FIELD, RECIPE_ARN_FIELD, RECOMMENDER_CONFIG_FIELD));

    private final String name;

    private final String datasetGroupArn;

    private final String recipeArn;

    private final RecommenderConfig recommenderConfig;

    private CreateRecommenderRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.datasetGroupArn = builder.datasetGroupArn;
        this.recipeArn = builder.recipeArn;
        this.recommenderConfig = builder.recommenderConfig;
    }

    /**
     * <p>
     * The name of the recommender.
     * </p>
     * 
     * @return The name of the recommender.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the destination domain dataset group for the recommender.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the destination domain dataset group for the recommender.
     */
    public final String datasetGroupArn() {
        return datasetGroupArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the recipe that the recommender will use. For a recommender, a recipe is a
     * Domain dataset group use case. Only Domain dataset group use cases can be used to create a recommender. For
     * information about use cases see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/domain-use-cases.html">Choosing recommender use
     * cases</a>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the recipe that the recommender will use. For a recommender, a recipe
     *         is a Domain dataset group use case. Only Domain dataset group use cases can be used to create a
     *         recommender. For information about use cases see <a
     *         href="https://docs.aws.amazon.com/personalize/latest/dg/domain-use-cases.html">Choosing recommender use
     *         cases</a>.
     */
    public final String recipeArn() {
        return recipeArn;
    }

    /**
     * <p>
     * The configuration details of the recommender.
     * </p>
     * 
     * @return The configuration details of the recommender.
     */
    public final RecommenderConfig recommenderConfig() {
        return recommenderConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(datasetGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(recipeArn());
        hashCode = 31 * hashCode + Objects.hashCode(recommenderConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRecommenderRequest)) {
            return false;
        }
        CreateRecommenderRequest other = (CreateRecommenderRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(datasetGroupArn(), other.datasetGroupArn())
                && Objects.equals(recipeArn(), other.recipeArn())
                && Objects.equals(recommenderConfig(), other.recommenderConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateRecommenderRequest").add("Name", name()).add("DatasetGroupArn", datasetGroupArn())
                .add("RecipeArn", recipeArn()).add("RecommenderConfig", recommenderConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "datasetGroupArn":
            return Optional.ofNullable(clazz.cast(datasetGroupArn()));
        case "recipeArn":
            return Optional.ofNullable(clazz.cast(recipeArn()));
        case "recommenderConfig":
            return Optional.ofNullable(clazz.cast(recommenderConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateRecommenderRequest, T> g) {
        return obj -> g.apply((CreateRecommenderRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PersonalizeRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateRecommenderRequest> {
        /**
         * <p>
         * The name of the recommender.
         * </p>
         * 
         * @param name
         *        The name of the recommender.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the destination domain dataset group for the recommender.
         * </p>
         * 
         * @param datasetGroupArn
         *        The Amazon Resource Name (ARN) of the destination domain dataset group for the recommender.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetGroupArn(String datasetGroupArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the recipe that the recommender will use. For a recommender, a recipe is a
         * Domain dataset group use case. Only Domain dataset group use cases can be used to create a recommender. For
         * information about use cases see <a
         * href="https://docs.aws.amazon.com/personalize/latest/dg/domain-use-cases.html">Choosing recommender use
         * cases</a>.
         * </p>
         * 
         * @param recipeArn
         *        The Amazon Resource Name (ARN) of the recipe that the recommender will use. For a recommender, a
         *        recipe is a Domain dataset group use case. Only Domain dataset group use cases can be used to create a
         *        recommender. For information about use cases see <a
         *        href="https://docs.aws.amazon.com/personalize/latest/dg/domain-use-cases.html">Choosing recommender
         *        use cases</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recipeArn(String recipeArn);

        /**
         * <p>
         * The configuration details of the recommender.
         * </p>
         * 
         * @param recommenderConfig
         *        The configuration details of the recommender.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recommenderConfig(RecommenderConfig recommenderConfig);

        /**
         * <p>
         * The configuration details of the recommender.
         * </p>
         * This is a convenience that creates an instance of the {@link RecommenderConfig.Builder} avoiding the need to
         * create one manually via {@link RecommenderConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link RecommenderConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #recommenderConfig(RecommenderConfig)}.
         * 
         * @param recommenderConfig
         *        a consumer that will call methods on {@link RecommenderConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #recommenderConfig(RecommenderConfig)
         */
        default Builder recommenderConfig(Consumer<RecommenderConfig.Builder> recommenderConfig) {
            return recommenderConfig(RecommenderConfig.builder().applyMutation(recommenderConfig).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PersonalizeRequest.BuilderImpl implements Builder {
        private String name;

        private String datasetGroupArn;

        private String recipeArn;

        private RecommenderConfig recommenderConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRecommenderRequest model) {
            super(model);
            name(model.name);
            datasetGroupArn(model.datasetGroupArn);
            recipeArn(model.recipeArn);
            recommenderConfig(model.recommenderConfig);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDatasetGroupArn() {
            return datasetGroupArn;
        }

        public final void setDatasetGroupArn(String datasetGroupArn) {
            this.datasetGroupArn = datasetGroupArn;
        }

        @Override
        @Transient
        public final Builder datasetGroupArn(String datasetGroupArn) {
            this.datasetGroupArn = datasetGroupArn;
            return this;
        }

        public final String getRecipeArn() {
            return recipeArn;
        }

        public final void setRecipeArn(String recipeArn) {
            this.recipeArn = recipeArn;
        }

        @Override
        @Transient
        public final Builder recipeArn(String recipeArn) {
            this.recipeArn = recipeArn;
            return this;
        }

        public final RecommenderConfig.Builder getRecommenderConfig() {
            return recommenderConfig != null ? recommenderConfig.toBuilder() : null;
        }

        public final void setRecommenderConfig(RecommenderConfig.BuilderImpl recommenderConfig) {
            this.recommenderConfig = recommenderConfig != null ? recommenderConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder recommenderConfig(RecommenderConfig recommenderConfig) {
            this.recommenderConfig = recommenderConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateRecommenderRequest build() {
            return new CreateRecommenderRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
