/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.personalize.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the additional objective for the solution, such as maximizing streaming minutes or increasing revenue. For
 * more information see <a
 * href="https://docs.aws.amazon.com/personalize/latest/dg/optimizing-solution-for-objective.html">Optimizing a
 * solution</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OptimizationObjective implements SdkPojo, Serializable,
        ToCopyableBuilder<OptimizationObjective.Builder, OptimizationObjective> {
    private static final SdkField<String> ITEM_ATTRIBUTE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("itemAttribute").getter(getter(OptimizationObjective::itemAttribute))
            .setter(setter(Builder::itemAttribute))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("itemAttribute").build()).build();

    private static final SdkField<String> OBJECTIVE_SENSITIVITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("objectiveSensitivity").getter(getter(OptimizationObjective::objectiveSensitivityAsString))
            .setter(setter(Builder::objectiveSensitivity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("objectiveSensitivity").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ITEM_ATTRIBUTE_FIELD,
            OBJECTIVE_SENSITIVITY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String itemAttribute;

    private final String objectiveSensitivity;

    private OptimizationObjective(BuilderImpl builder) {
        this.itemAttribute = builder.itemAttribute;
        this.objectiveSensitivity = builder.objectiveSensitivity;
    }

    /**
     * <p>
     * The numerical metadata column in an Items dataset related to the optimization objective. For example,
     * VIDEO_LENGTH (to maximize streaming minutes), or PRICE (to maximize revenue).
     * </p>
     * 
     * @return The numerical metadata column in an Items dataset related to the optimization objective. For example,
     *         VIDEO_LENGTH (to maximize streaming minutes), or PRICE (to maximize revenue).
     */
    public final String itemAttribute() {
        return itemAttribute;
    }

    /**
     * <p>
     * Specifies how Amazon Personalize balances the importance of your optimization objective versus relevance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #objectiveSensitivity} will return {@link ObjectiveSensitivity#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #objectiveSensitivityAsString}.
     * </p>
     * 
     * @return Specifies how Amazon Personalize balances the importance of your optimization objective versus relevance.
     * @see ObjectiveSensitivity
     */
    public final ObjectiveSensitivity objectiveSensitivity() {
        return ObjectiveSensitivity.fromValue(objectiveSensitivity);
    }

    /**
     * <p>
     * Specifies how Amazon Personalize balances the importance of your optimization objective versus relevance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #objectiveSensitivity} will return {@link ObjectiveSensitivity#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #objectiveSensitivityAsString}.
     * </p>
     * 
     * @return Specifies how Amazon Personalize balances the importance of your optimization objective versus relevance.
     * @see ObjectiveSensitivity
     */
    public final String objectiveSensitivityAsString() {
        return objectiveSensitivity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(itemAttribute());
        hashCode = 31 * hashCode + Objects.hashCode(objectiveSensitivityAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OptimizationObjective)) {
            return false;
        }
        OptimizationObjective other = (OptimizationObjective) obj;
        return Objects.equals(itemAttribute(), other.itemAttribute())
                && Objects.equals(objectiveSensitivityAsString(), other.objectiveSensitivityAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OptimizationObjective").add("ItemAttribute", itemAttribute())
                .add("ObjectiveSensitivity", objectiveSensitivityAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "itemAttribute":
            return Optional.ofNullable(clazz.cast(itemAttribute()));
        case "objectiveSensitivity":
            return Optional.ofNullable(clazz.cast(objectiveSensitivityAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OptimizationObjective, T> g) {
        return obj -> g.apply((OptimizationObjective) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OptimizationObjective> {
        /**
         * <p>
         * The numerical metadata column in an Items dataset related to the optimization objective. For example,
         * VIDEO_LENGTH (to maximize streaming minutes), or PRICE (to maximize revenue).
         * </p>
         * 
         * @param itemAttribute
         *        The numerical metadata column in an Items dataset related to the optimization objective. For example,
         *        VIDEO_LENGTH (to maximize streaming minutes), or PRICE (to maximize revenue).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder itemAttribute(String itemAttribute);

        /**
         * <p>
         * Specifies how Amazon Personalize balances the importance of your optimization objective versus relevance.
         * </p>
         * 
         * @param objectiveSensitivity
         *        Specifies how Amazon Personalize balances the importance of your optimization objective versus
         *        relevance.
         * @see ObjectiveSensitivity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ObjectiveSensitivity
         */
        Builder objectiveSensitivity(String objectiveSensitivity);

        /**
         * <p>
         * Specifies how Amazon Personalize balances the importance of your optimization objective versus relevance.
         * </p>
         * 
         * @param objectiveSensitivity
         *        Specifies how Amazon Personalize balances the importance of your optimization objective versus
         *        relevance.
         * @see ObjectiveSensitivity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ObjectiveSensitivity
         */
        Builder objectiveSensitivity(ObjectiveSensitivity objectiveSensitivity);
    }

    static final class BuilderImpl implements Builder {
        private String itemAttribute;

        private String objectiveSensitivity;

        private BuilderImpl() {
        }

        private BuilderImpl(OptimizationObjective model) {
            itemAttribute(model.itemAttribute);
            objectiveSensitivity(model.objectiveSensitivity);
        }

        public final String getItemAttribute() {
            return itemAttribute;
        }

        public final void setItemAttribute(String itemAttribute) {
            this.itemAttribute = itemAttribute;
        }

        @Override
        @Transient
        public final Builder itemAttribute(String itemAttribute) {
            this.itemAttribute = itemAttribute;
            return this;
        }

        public final String getObjectiveSensitivity() {
            return objectiveSensitivity;
        }

        public final void setObjectiveSensitivity(String objectiveSensitivity) {
            this.objectiveSensitivity = objectiveSensitivity;
        }

        @Override
        @Transient
        public final Builder objectiveSensitivity(String objectiveSensitivity) {
            this.objectiveSensitivity = objectiveSensitivity;
            return this;
        }

        @Override
        @Transient
        public final Builder objectiveSensitivity(ObjectiveSensitivity objectiveSensitivity) {
            this.objectiveSensitivity(objectiveSensitivity == null ? null : objectiveSensitivity.toString());
            return this;
        }

        @Override
        public OptimizationObjective build() {
            return new OptimizationObjective(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
