/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.personalize.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides a summary of the properties of a recommender update. For a complete listing, call the DescribeRecommender
 * API operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RecommenderUpdateSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<RecommenderUpdateSummary.Builder, RecommenderUpdateSummary> {
    private static final SdkField<RecommenderConfig> RECOMMENDER_CONFIG_FIELD = SdkField
            .<RecommenderConfig> builder(MarshallingType.SDK_POJO).memberName("recommenderConfig")
            .getter(getter(RecommenderUpdateSummary::recommenderConfig)).setter(setter(Builder::recommenderConfig))
            .constructor(RecommenderConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommenderConfig").build()).build();

    private static final SdkField<Instant> CREATION_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationDateTime").getter(getter(RecommenderUpdateSummary::creationDateTime))
            .setter(setter(Builder::creationDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDateTime").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdatedDateTime").getter(getter(RecommenderUpdateSummary::lastUpdatedDateTime))
            .setter(setter(Builder::lastUpdatedDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedDateTime").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(RecommenderUpdateSummary::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("failureReason").getter(getter(RecommenderUpdateSummary::failureReason))
            .setter(setter(Builder::failureReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureReason").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECOMMENDER_CONFIG_FIELD,
            CREATION_DATE_TIME_FIELD, LAST_UPDATED_DATE_TIME_FIELD, STATUS_FIELD, FAILURE_REASON_FIELD));

    private static final long serialVersionUID = 1L;

    private final RecommenderConfig recommenderConfig;

    private final Instant creationDateTime;

    private final Instant lastUpdatedDateTime;

    private final String status;

    private final String failureReason;

    private RecommenderUpdateSummary(BuilderImpl builder) {
        this.recommenderConfig = builder.recommenderConfig;
        this.creationDateTime = builder.creationDateTime;
        this.lastUpdatedDateTime = builder.lastUpdatedDateTime;
        this.status = builder.status;
        this.failureReason = builder.failureReason;
    }

    /**
     * <p>
     * The configuration details of the recommender update.
     * </p>
     * 
     * @return The configuration details of the recommender update.
     */
    public final RecommenderConfig recommenderConfig() {
        return recommenderConfig;
    }

    /**
     * <p>
     * The date and time (in Unix format) that the recommender update was created.
     * </p>
     * 
     * @return The date and time (in Unix format) that the recommender update was created.
     */
    public final Instant creationDateTime() {
        return creationDateTime;
    }

    /**
     * <p>
     * The date and time (in Unix time) that the recommender update was last updated.
     * </p>
     * 
     * @return The date and time (in Unix time) that the recommender update was last updated.
     */
    public final Instant lastUpdatedDateTime() {
        return lastUpdatedDateTime;
    }

    /**
     * <p>
     * The status of the recommender update.
     * </p>
     * <p>
     * A recommender can be in one of the following states:
     * </p>
     * <ul>
     * <li>
     * <p>
     * CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED
     * </p>
     * </li>
     * <li>
     * <p>
     * DELETE PENDING &gt; DELETE IN_PROGRESS
     * </p>
     * </li>
     * </ul>
     * 
     * @return The status of the recommender update.</p>
     *         <p>
     *         A recommender can be in one of the following states:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DELETE PENDING &gt; DELETE IN_PROGRESS
     *         </p>
     *         </li>
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * If a recommender update fails, the reason behind the failure.
     * </p>
     * 
     * @return If a recommender update fails, the reason behind the failure.
     */
    public final String failureReason() {
        return failureReason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(recommenderConfig());
        hashCode = 31 * hashCode + Objects.hashCode(creationDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(failureReason());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecommenderUpdateSummary)) {
            return false;
        }
        RecommenderUpdateSummary other = (RecommenderUpdateSummary) obj;
        return Objects.equals(recommenderConfig(), other.recommenderConfig())
                && Objects.equals(creationDateTime(), other.creationDateTime())
                && Objects.equals(lastUpdatedDateTime(), other.lastUpdatedDateTime()) && Objects.equals(status(), other.status())
                && Objects.equals(failureReason(), other.failureReason());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RecommenderUpdateSummary").add("RecommenderConfig", recommenderConfig())
                .add("CreationDateTime", creationDateTime()).add("LastUpdatedDateTime", lastUpdatedDateTime())
                .add("Status", status()).add("FailureReason", failureReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "recommenderConfig":
            return Optional.ofNullable(clazz.cast(recommenderConfig()));
        case "creationDateTime":
            return Optional.ofNullable(clazz.cast(creationDateTime()));
        case "lastUpdatedDateTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedDateTime()));
        case "status":
            return Optional.ofNullable(clazz.cast(status()));
        case "failureReason":
            return Optional.ofNullable(clazz.cast(failureReason()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RecommenderUpdateSummary, T> g) {
        return obj -> g.apply((RecommenderUpdateSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RecommenderUpdateSummary> {
        /**
         * <p>
         * The configuration details of the recommender update.
         * </p>
         * 
         * @param recommenderConfig
         *        The configuration details of the recommender update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recommenderConfig(RecommenderConfig recommenderConfig);

        /**
         * <p>
         * The configuration details of the recommender update.
         * </p>
         * This is a convenience that creates an instance of the {@link RecommenderConfig.Builder} avoiding the need to
         * create one manually via {@link RecommenderConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link RecommenderConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #recommenderConfig(RecommenderConfig)}.
         * 
         * @param recommenderConfig
         *        a consumer that will call methods on {@link RecommenderConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #recommenderConfig(RecommenderConfig)
         */
        default Builder recommenderConfig(Consumer<RecommenderConfig.Builder> recommenderConfig) {
            return recommenderConfig(RecommenderConfig.builder().applyMutation(recommenderConfig).build());
        }

        /**
         * <p>
         * The date and time (in Unix format) that the recommender update was created.
         * </p>
         * 
         * @param creationDateTime
         *        The date and time (in Unix format) that the recommender update was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDateTime(Instant creationDateTime);

        /**
         * <p>
         * The date and time (in Unix time) that the recommender update was last updated.
         * </p>
         * 
         * @param lastUpdatedDateTime
         *        The date and time (in Unix time) that the recommender update was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedDateTime(Instant lastUpdatedDateTime);

        /**
         * <p>
         * The status of the recommender update.
         * </p>
         * <p>
         * A recommender can be in one of the following states:
         * </p>
         * <ul>
         * <li>
         * <p>
         * CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED
         * </p>
         * </li>
         * <li>
         * <p>
         * DELETE PENDING &gt; DELETE IN_PROGRESS
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the recommender update.</p>
         *        <p>
         *        A recommender can be in one of the following states:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        DELETE PENDING &gt; DELETE IN_PROGRESS
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * If a recommender update fails, the reason behind the failure.
         * </p>
         * 
         * @param failureReason
         *        If a recommender update fails, the reason behind the failure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReason(String failureReason);
    }

    static final class BuilderImpl implements Builder {
        private RecommenderConfig recommenderConfig;

        private Instant creationDateTime;

        private Instant lastUpdatedDateTime;

        private String status;

        private String failureReason;

        private BuilderImpl() {
        }

        private BuilderImpl(RecommenderUpdateSummary model) {
            recommenderConfig(model.recommenderConfig);
            creationDateTime(model.creationDateTime);
            lastUpdatedDateTime(model.lastUpdatedDateTime);
            status(model.status);
            failureReason(model.failureReason);
        }

        public final RecommenderConfig.Builder getRecommenderConfig() {
            return recommenderConfig != null ? recommenderConfig.toBuilder() : null;
        }

        public final void setRecommenderConfig(RecommenderConfig.BuilderImpl recommenderConfig) {
            this.recommenderConfig = recommenderConfig != null ? recommenderConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder recommenderConfig(RecommenderConfig recommenderConfig) {
            this.recommenderConfig = recommenderConfig;
            return this;
        }

        public final Instant getCreationDateTime() {
            return creationDateTime;
        }

        public final void setCreationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
        }

        @Override
        @Transient
        public final Builder creationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
            return this;
        }

        public final Instant getLastUpdatedDateTime() {
            return lastUpdatedDateTime;
        }

        public final void setLastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
        }

        @Override
        @Transient
        public final Builder lastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final String getFailureReason() {
            return failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        @Transient
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        @Override
        public RecommenderUpdateSummary build() {
            return new RecommenderUpdateSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
