/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.personalize;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.personalize.model.CreateBatchInferenceJobRequest;
import software.amazon.awssdk.services.personalize.model.CreateBatchInferenceJobResponse;
import software.amazon.awssdk.services.personalize.model.CreateBatchSegmentJobRequest;
import software.amazon.awssdk.services.personalize.model.CreateBatchSegmentJobResponse;
import software.amazon.awssdk.services.personalize.model.CreateCampaignRequest;
import software.amazon.awssdk.services.personalize.model.CreateCampaignResponse;
import software.amazon.awssdk.services.personalize.model.CreateDatasetExportJobRequest;
import software.amazon.awssdk.services.personalize.model.CreateDatasetExportJobResponse;
import software.amazon.awssdk.services.personalize.model.CreateDatasetGroupRequest;
import software.amazon.awssdk.services.personalize.model.CreateDatasetGroupResponse;
import software.amazon.awssdk.services.personalize.model.CreateDatasetImportJobRequest;
import software.amazon.awssdk.services.personalize.model.CreateDatasetImportJobResponse;
import software.amazon.awssdk.services.personalize.model.CreateDatasetRequest;
import software.amazon.awssdk.services.personalize.model.CreateDatasetResponse;
import software.amazon.awssdk.services.personalize.model.CreateEventTrackerRequest;
import software.amazon.awssdk.services.personalize.model.CreateEventTrackerResponse;
import software.amazon.awssdk.services.personalize.model.CreateFilterRequest;
import software.amazon.awssdk.services.personalize.model.CreateFilterResponse;
import software.amazon.awssdk.services.personalize.model.CreateRecommenderRequest;
import software.amazon.awssdk.services.personalize.model.CreateRecommenderResponse;
import software.amazon.awssdk.services.personalize.model.CreateSchemaRequest;
import software.amazon.awssdk.services.personalize.model.CreateSchemaResponse;
import software.amazon.awssdk.services.personalize.model.CreateSolutionRequest;
import software.amazon.awssdk.services.personalize.model.CreateSolutionResponse;
import software.amazon.awssdk.services.personalize.model.CreateSolutionVersionRequest;
import software.amazon.awssdk.services.personalize.model.CreateSolutionVersionResponse;
import software.amazon.awssdk.services.personalize.model.DeleteCampaignRequest;
import software.amazon.awssdk.services.personalize.model.DeleteCampaignResponse;
import software.amazon.awssdk.services.personalize.model.DeleteDatasetGroupRequest;
import software.amazon.awssdk.services.personalize.model.DeleteDatasetGroupResponse;
import software.amazon.awssdk.services.personalize.model.DeleteDatasetRequest;
import software.amazon.awssdk.services.personalize.model.DeleteDatasetResponse;
import software.amazon.awssdk.services.personalize.model.DeleteEventTrackerRequest;
import software.amazon.awssdk.services.personalize.model.DeleteEventTrackerResponse;
import software.amazon.awssdk.services.personalize.model.DeleteFilterRequest;
import software.amazon.awssdk.services.personalize.model.DeleteFilterResponse;
import software.amazon.awssdk.services.personalize.model.DeleteRecommenderRequest;
import software.amazon.awssdk.services.personalize.model.DeleteRecommenderResponse;
import software.amazon.awssdk.services.personalize.model.DeleteSchemaRequest;
import software.amazon.awssdk.services.personalize.model.DeleteSchemaResponse;
import software.amazon.awssdk.services.personalize.model.DeleteSolutionRequest;
import software.amazon.awssdk.services.personalize.model.DeleteSolutionResponse;
import software.amazon.awssdk.services.personalize.model.DescribeAlgorithmRequest;
import software.amazon.awssdk.services.personalize.model.DescribeAlgorithmResponse;
import software.amazon.awssdk.services.personalize.model.DescribeBatchInferenceJobRequest;
import software.amazon.awssdk.services.personalize.model.DescribeBatchInferenceJobResponse;
import software.amazon.awssdk.services.personalize.model.DescribeBatchSegmentJobRequest;
import software.amazon.awssdk.services.personalize.model.DescribeBatchSegmentJobResponse;
import software.amazon.awssdk.services.personalize.model.DescribeCampaignRequest;
import software.amazon.awssdk.services.personalize.model.DescribeCampaignResponse;
import software.amazon.awssdk.services.personalize.model.DescribeDatasetExportJobRequest;
import software.amazon.awssdk.services.personalize.model.DescribeDatasetExportJobResponse;
import software.amazon.awssdk.services.personalize.model.DescribeDatasetGroupRequest;
import software.amazon.awssdk.services.personalize.model.DescribeDatasetGroupResponse;
import software.amazon.awssdk.services.personalize.model.DescribeDatasetImportJobRequest;
import software.amazon.awssdk.services.personalize.model.DescribeDatasetImportJobResponse;
import software.amazon.awssdk.services.personalize.model.DescribeDatasetRequest;
import software.amazon.awssdk.services.personalize.model.DescribeDatasetResponse;
import software.amazon.awssdk.services.personalize.model.DescribeEventTrackerRequest;
import software.amazon.awssdk.services.personalize.model.DescribeEventTrackerResponse;
import software.amazon.awssdk.services.personalize.model.DescribeFeatureTransformationRequest;
import software.amazon.awssdk.services.personalize.model.DescribeFeatureTransformationResponse;
import software.amazon.awssdk.services.personalize.model.DescribeFilterRequest;
import software.amazon.awssdk.services.personalize.model.DescribeFilterResponse;
import software.amazon.awssdk.services.personalize.model.DescribeRecipeRequest;
import software.amazon.awssdk.services.personalize.model.DescribeRecipeResponse;
import software.amazon.awssdk.services.personalize.model.DescribeRecommenderRequest;
import software.amazon.awssdk.services.personalize.model.DescribeRecommenderResponse;
import software.amazon.awssdk.services.personalize.model.DescribeSchemaRequest;
import software.amazon.awssdk.services.personalize.model.DescribeSchemaResponse;
import software.amazon.awssdk.services.personalize.model.DescribeSolutionRequest;
import software.amazon.awssdk.services.personalize.model.DescribeSolutionResponse;
import software.amazon.awssdk.services.personalize.model.DescribeSolutionVersionRequest;
import software.amazon.awssdk.services.personalize.model.DescribeSolutionVersionResponse;
import software.amazon.awssdk.services.personalize.model.GetSolutionMetricsRequest;
import software.amazon.awssdk.services.personalize.model.GetSolutionMetricsResponse;
import software.amazon.awssdk.services.personalize.model.InvalidInputException;
import software.amazon.awssdk.services.personalize.model.InvalidNextTokenException;
import software.amazon.awssdk.services.personalize.model.LimitExceededException;
import software.amazon.awssdk.services.personalize.model.ListBatchInferenceJobsRequest;
import software.amazon.awssdk.services.personalize.model.ListBatchInferenceJobsResponse;
import software.amazon.awssdk.services.personalize.model.ListBatchSegmentJobsRequest;
import software.amazon.awssdk.services.personalize.model.ListBatchSegmentJobsResponse;
import software.amazon.awssdk.services.personalize.model.ListCampaignsRequest;
import software.amazon.awssdk.services.personalize.model.ListCampaignsResponse;
import software.amazon.awssdk.services.personalize.model.ListDatasetExportJobsRequest;
import software.amazon.awssdk.services.personalize.model.ListDatasetExportJobsResponse;
import software.amazon.awssdk.services.personalize.model.ListDatasetGroupsRequest;
import software.amazon.awssdk.services.personalize.model.ListDatasetGroupsResponse;
import software.amazon.awssdk.services.personalize.model.ListDatasetImportJobsRequest;
import software.amazon.awssdk.services.personalize.model.ListDatasetImportJobsResponse;
import software.amazon.awssdk.services.personalize.model.ListDatasetsRequest;
import software.amazon.awssdk.services.personalize.model.ListDatasetsResponse;
import software.amazon.awssdk.services.personalize.model.ListEventTrackersRequest;
import software.amazon.awssdk.services.personalize.model.ListEventTrackersResponse;
import software.amazon.awssdk.services.personalize.model.ListFiltersRequest;
import software.amazon.awssdk.services.personalize.model.ListFiltersResponse;
import software.amazon.awssdk.services.personalize.model.ListRecipesRequest;
import software.amazon.awssdk.services.personalize.model.ListRecipesResponse;
import software.amazon.awssdk.services.personalize.model.ListRecommendersRequest;
import software.amazon.awssdk.services.personalize.model.ListRecommendersResponse;
import software.amazon.awssdk.services.personalize.model.ListSchemasRequest;
import software.amazon.awssdk.services.personalize.model.ListSchemasResponse;
import software.amazon.awssdk.services.personalize.model.ListSolutionVersionsRequest;
import software.amazon.awssdk.services.personalize.model.ListSolutionVersionsResponse;
import software.amazon.awssdk.services.personalize.model.ListSolutionsRequest;
import software.amazon.awssdk.services.personalize.model.ListSolutionsResponse;
import software.amazon.awssdk.services.personalize.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.personalize.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.personalize.model.PersonalizeException;
import software.amazon.awssdk.services.personalize.model.ResourceAlreadyExistsException;
import software.amazon.awssdk.services.personalize.model.ResourceInUseException;
import software.amazon.awssdk.services.personalize.model.ResourceNotFoundException;
import software.amazon.awssdk.services.personalize.model.StopSolutionVersionCreationRequest;
import software.amazon.awssdk.services.personalize.model.StopSolutionVersionCreationResponse;
import software.amazon.awssdk.services.personalize.model.TagResourceRequest;
import software.amazon.awssdk.services.personalize.model.TagResourceResponse;
import software.amazon.awssdk.services.personalize.model.TooManyTagKeysException;
import software.amazon.awssdk.services.personalize.model.TooManyTagsException;
import software.amazon.awssdk.services.personalize.model.UntagResourceRequest;
import software.amazon.awssdk.services.personalize.model.UntagResourceResponse;
import software.amazon.awssdk.services.personalize.model.UpdateCampaignRequest;
import software.amazon.awssdk.services.personalize.model.UpdateCampaignResponse;
import software.amazon.awssdk.services.personalize.model.UpdateRecommenderRequest;
import software.amazon.awssdk.services.personalize.model.UpdateRecommenderResponse;
import software.amazon.awssdk.services.personalize.paginators.ListBatchInferenceJobsIterable;
import software.amazon.awssdk.services.personalize.paginators.ListBatchSegmentJobsIterable;
import software.amazon.awssdk.services.personalize.paginators.ListCampaignsIterable;
import software.amazon.awssdk.services.personalize.paginators.ListDatasetExportJobsIterable;
import software.amazon.awssdk.services.personalize.paginators.ListDatasetGroupsIterable;
import software.amazon.awssdk.services.personalize.paginators.ListDatasetImportJobsIterable;
import software.amazon.awssdk.services.personalize.paginators.ListDatasetsIterable;
import software.amazon.awssdk.services.personalize.paginators.ListEventTrackersIterable;
import software.amazon.awssdk.services.personalize.paginators.ListFiltersIterable;
import software.amazon.awssdk.services.personalize.paginators.ListRecipesIterable;
import software.amazon.awssdk.services.personalize.paginators.ListRecommendersIterable;
import software.amazon.awssdk.services.personalize.paginators.ListSchemasIterable;
import software.amazon.awssdk.services.personalize.paginators.ListSolutionVersionsIterable;
import software.amazon.awssdk.services.personalize.paginators.ListSolutionsIterable;

/**
 * Service client for accessing Amazon Personalize. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * Amazon Personalize is a machine learning service that makes it easy to add individualized recommendations to
 * customers.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface PersonalizeClient extends SdkClient {
    String SERVICE_NAME = "personalize";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "personalize";

    /**
     * Create a {@link PersonalizeClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static PersonalizeClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link PersonalizeClient}.
     */
    static PersonalizeClientBuilder builder() {
        return new DefaultPersonalizeClientBuilder();
    }

    /**
     * <p>
     * Creates a batch inference job. The operation can handle up to 50 million records and the input file must be in
     * JSON format. For more information, see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/creating-batch-inference-job.html">Creating a batch
     * inference job</a>.
     * </p>
     *
     * @param createBatchInferenceJobRequest
     * @return Result of the CreateBatchInferenceJob operation returned by the service.
     * @throws InvalidInputException
     *         Provide a valid value for the field or parameter.
     * @throws ResourceAlreadyExistsException
     *         The specified resource already exists.
     * @throws LimitExceededException
     *         The limit on the number of requests per second has been exceeded.
     * @throws ResourceNotFoundException
     *         Could not find the specified resource.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws TooManyTagsException
     *         You have exceeded the maximum number of tags you can apply to this resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeClient.CreateBatchInferenceJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/CreateBatchInferenceJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateBatchInferenceJobResponse createBatchInferenceJob(CreateBatchInferenceJobRequest createBatchInferenceJobRequest)
            throws InvalidInputException, ResourceAlreadyExistsException, LimitExceededException, ResourceNotFoundException,
            ResourceInUseException, TooManyTagsException, AwsServiceException, SdkClientException, PersonalizeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a batch inference job. The operation can handle up to 50 million records and the input file must be in
     * JSON format. For more information, see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/creating-batch-inference-job.html">Creating a batch
     * inference job</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateBatchInferenceJobRequest.Builder} avoiding
     * the need to create one manually via {@link CreateBatchInferenceJobRequest#builder()}
     * </p>
     *
     * @param createBatchInferenceJobRequest
     *        A {@link Consumer} that will call methods on {@link CreateBatchInferenceJobRequest.Builder} to create a
     *        request.
     * @return Result of the CreateBatchInferenceJob operation returned by the service.
     * @throws InvalidInputException
     *         Provide a valid value for the field or parameter.
     * @throws ResourceAlreadyExistsException
     *         The specified resource already exists.
     * @throws LimitExceededException
     *         The limit on the number of requests per second has been exceeded.
     * @throws ResourceNotFoundException
     *         Could not find the specified resource.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws TooManyTagsException
     *         You have exceeded the maximum number of tags you can apply to this resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeClient.CreateBatchInferenceJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/CreateBatchInferenceJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateBatchInferenceJobResponse createBatchInferenceJob(
            Consumer<CreateBatchInferenceJobRequest.Builder> createBatchInferenceJobRequest) throws InvalidInputException,
            ResourceAlreadyExistsException, LimitExceededException, ResourceNotFoundException, ResourceInUseException,
            TooManyTagsException, AwsServiceException, SdkClientException, PersonalizeException {
        return createBatchInferenceJob(CreateBatchInferenceJobRequest.builder().applyMutation(createBatchInferenceJobRequest)
                .build());
    }

    /**
     * <p>
     * Creates a batch segment job. The operation can handle up to 50 million records and the input file must be in JSON
     * format. For more information, see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/recommendations-batch.html">Getting batch recommendations
     * and user segments</a>.
     * </p>
     *
     * @param createBatchSegmentJobRequest
     * @return Result of the CreateBatchSegmentJob operation returned by the service.
     * @throws InvalidInputException
     *         Provide a valid value for the field or parameter.
     * @throws ResourceAlreadyExistsException
     *         The specified resource already exists.
     * @throws LimitExceededException
     *         The limit on the number of requests per second has been exceeded.
     * @throws ResourceNotFoundException
     *         Could not find the specified resource.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws TooManyTagsException
     *         You have exceeded the maximum number of tags you can apply to this resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeClient.CreateBatchSegmentJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/CreateBatchSegmentJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateBatchSegmentJobResponse createBatchSegmentJob(CreateBatchSegmentJobRequest createBatchSegmentJobRequest)
            throws InvalidInputException, ResourceAlreadyExistsException, LimitExceededException, ResourceNotFoundException,
            ResourceInUseException, TooManyTagsException, AwsServiceException, SdkClientException, PersonalizeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a batch segment job. The operation can handle up to 50 million records and the input file must be in JSON
     * format. For more information, see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/recommendations-batch.html">Getting batch recommendations
     * and user segments</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateBatchSegmentJobRequest.Builder} avoiding the
     * need to create one manually via {@link CreateBatchSegmentJobRequest#builder()}
     * </p>
     *
     * @param createBatchSegmentJobRequest
     *        A {@link Consumer} that will call methods on {@link CreateBatchSegmentJobRequest.Builder} to create a
     *        request.
     * @return Result of the CreateBatchSegmentJob operation returned by the service.
     * @throws InvalidInputException
     *         Provide a valid value for the field or parameter.
     * @throws ResourceAlreadyExistsException
     *         The specified resource already exists.
     * @throws LimitExceededException
     *         The limit on the number of requests per second has been exceeded.
     * @throws ResourceNotFoundException
     *         Could not find the specified resource.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws TooManyTagsException
     *         You have exceeded the maximum number of tags you can apply to this resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeClient.CreateBatchSegmentJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/CreateBatchSegmentJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateBatchSegmentJobResponse createBatchSegmentJob(
            Consumer<CreateBatchSegmentJobRequest.Builder> createBatchSegmentJobRequest) throws InvalidInputException,
            ResourceAlreadyExistsException, LimitExceededException, ResourceNotFoundException, ResourceInUseException,
            TooManyTagsException, AwsServiceException, SdkClientException, PersonalizeException {
        return createBatchSegmentJob(CreateBatchSegmentJobRequest.builder().applyMutation(createBatchSegmentJobRequest).build());
    }

    /**
     * <p>
     * Creates a campaign that deploys a solution version. When a client calls the <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_RS_GetRecommendations.html">GetRecommendations</a>
     * and <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_RS_GetPersonalizedRanking.html">
     * GetPersonalizedRanking</a> APIs, a campaign is specified in the request.
     * </p>
     * <p>
     * <b>Minimum Provisioned TPS and Auto-Scaling</b>
     * </p>
     * <p>
     * A transaction is a single <code>GetRecommendations</code> or <code>GetPersonalizedRanking</code> call.
     * Transactions per second (TPS) is the throughput and unit of billing for Amazon Personalize. The minimum
     * provisioned TPS (<code>minProvisionedTPS</code>) specifies the baseline throughput provisioned by Amazon
     * Personalize, and thus, the minimum billing charge.
     * </p>
     * <p>
     * If your TPS increases beyond <code>minProvisionedTPS</code>, Amazon Personalize auto-scales the provisioned
     * capacity up and down, but never below <code>minProvisionedTPS</code>. There's a short time delay while the
     * capacity is increased that might cause loss of transactions.
     * </p>
     * <p>
     * The actual TPS used is calculated as the average requests/second within a 5-minute window. You pay for maximum of
     * either the minimum provisioned TPS or the actual TPS. We recommend starting with a low
     * <code>minProvisionedTPS</code>, track your usage using Amazon CloudWatch metrics, and then increase the
     * <code>minProvisionedTPS</code> as necessary.
     * </p>
     * <p>
     * <b>Status</b>
     * </p>
     * <p>
     * A campaign can be in one of the following states:
     * </p>
     * <ul>
     * <li>
     * <p>
     * CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED
     * </p>
     * </li>
     * <li>
     * <p>
     * DELETE PENDING &gt; DELETE IN_PROGRESS
     * </p>
     * </li>
     * </ul>
     * <p>
     * To get the campaign status, call <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeCampaign.html">DescribeCampaign</a>.
     * </p>
     * <note>
     * <p>
     * Wait until the <code>status</code> of the campaign is <code>ACTIVE</code> before asking the campaign for
     * recommendations.
     * </p>
     * </note>
     * <p class="title">
     * <b>Related APIs</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_ListCampaigns.html">ListCampaigns</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeCampaign.html">DescribeCampaign</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_UpdateCampaign.html">UpdateCampaign</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_DeleteCampaign.html">DeleteCampaign</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param createCampaignRequest
     * @return Result of the CreateCampaign operation returned by the service.
     * @throws InvalidInputException
     *         Provide a valid value for the field or parameter.
     * @throws ResourceNotFoundException
     *         Could not find the specified resource.
     * @throws ResourceAlreadyExistsException
     *         The specified resource already exists.
     * @throws LimitExceededException
     *         The limit on the number of requests per second has been exceeded.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws TooManyTagsException
     *         You have exceeded the maximum number of tags you can apply to this resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeClient.CreateCampaign
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/CreateCampaign" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateCampaignResponse createCampaign(CreateCampaignRequest createCampaignRequest) throws InvalidInputException,
            ResourceNotFoundException, ResourceAlreadyExistsException, LimitExceededException, ResourceInUseException,
            TooManyTagsException, AwsServiceException, SdkClientException, PersonalizeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a campaign that deploys a solution version. When a client calls the <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_RS_GetRecommendations.html">GetRecommendations</a>
     * and <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_RS_GetPersonalizedRanking.html">
     * GetPersonalizedRanking</a> APIs, a campaign is specified in the request.
     * </p>
     * <p>
     * <b>Minimum Provisioned TPS and Auto-Scaling</b>
     * </p>
     * <p>
     * A transaction is a single <code>GetRecommendations</code> or <code>GetPersonalizedRanking</code> call.
     * Transactions per second (TPS) is the throughput and unit of billing for Amazon Personalize. The minimum
     * provisioned TPS (<code>minProvisionedTPS</code>) specifies the baseline throughput provisioned by Amazon
     * Personalize, and thus, the minimum billing charge.
     * </p>
     * <p>
     * If your TPS increases beyond <code>minProvisionedTPS</code>, Amazon Personalize auto-scales the provisioned
     * capacity up and down, but never below <code>minProvisionedTPS</code>. There's a short time delay while the
     * capacity is increased that might cause loss of transactions.
     * </p>
     * <p>
     * The actual TPS used is calculated as the average requests/second within a 5-minute window. You pay for maximum of
     * either the minimum provisioned TPS or the actual TPS. We recommend starting with a low
     * <code>minProvisionedTPS</code>, track your usage using Amazon CloudWatch metrics, and then increase the
     * <code>minProvisionedTPS</code> as necessary.
     * </p>
     * <p>
     * <b>Status</b>
     * </p>
     * <p>
     * A campaign can be in one of the following states:
     * </p>
     * <ul>
     * <li>
     * <p>
     * CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED
     * </p>
     * </li>
     * <li>
     * <p>
     * DELETE PENDING &gt; DELETE IN_PROGRESS
     * </p>
     * </li>
     * </ul>
     * <p>
     * To get the campaign status, call <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeCampaign.html">DescribeCampaign</a>.
     * </p>
     * <note>
     * <p>
     * Wait until the <code>status</code> of the campaign is <code>ACTIVE</code> before asking the campaign for
     * recommendations.
     * </p>
     * </note>
     * <p class="title">
     * <b>Related APIs</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_ListCampaigns.html">ListCampaigns</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeCampaign.html">DescribeCampaign</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_UpdateCampaign.html">UpdateCampaign</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_DeleteCampaign.html">DeleteCampaign</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateCampaignRequest.Builder} avoiding the need to
     * create one manually via {@link CreateCampaignRequest#builder()}
     * </p>
     *
     * @param createCampaignRequest
     *        A {@link Consumer} that will call methods on {@link CreateCampaignRequest.Builder} to create a request.
     * @return Result of the CreateCampaign operation returned by the service.
     * @throws InvalidInputException
     *         Provide a valid value for the field or parameter.
     * @throws ResourceNotFoundException
     *         Could not find the specified resource.
     * @throws ResourceAlreadyExistsException
     *         The specified resource already exists.
     * @throws LimitExceededException
     *         The limit on the number of requests per second has been exceeded.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws TooManyTagsException
     *         You have exceeded the maximum number of tags you can apply to this resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeClient.CreateCampaign
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/CreateCampaign" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateCampaignResponse createCampaign(Consumer<CreateCampaignRequest.Builder> createCampaignRequest)
            throws InvalidInputException, ResourceNotFoundException, ResourceAlreadyExistsException, LimitExceededException,
            ResourceInUseException, TooManyTagsException, AwsServiceException, SdkClientException, PersonalizeException {
        return createCampaign(CreateCampaignRequest.builder().applyMutation(createCampaignRequest).build());
    }

    /**
     * <p>
     * Creates an empty dataset and adds it to the specified dataset group. Use <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDatasetImportJob.html"
     * >CreateDatasetImportJob</a> to import your training data to a dataset.
     * </p>
     * <p>
     * There are three types of datasets:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Interactions
     * </p>
     * </li>
     * <li>
     * <p>
     * Items
     * </p>
     * </li>
     * <li>
     * <p>
     * Users
     * </p>
     * </li>
     * </ul>
     * <p>
     * Each dataset type has an associated schema with required field types. Only the <code>Interactions</code> dataset
     * is required in order to train a model (also referred to as creating a solution).
     * </p>
     * <p>
     * A dataset can be in one of the following states:
     * </p>
     * <ul>
     * <li>
     * <p>
     * CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED
     * </p>
     * </li>
     * <li>
     * <p>
     * DELETE PENDING &gt; DELETE IN_PROGRESS
     * </p>
     * </li>
     * </ul>
     * <p>
     * To get the status of the dataset, call <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeDataset.html">DescribeDataset</a>.
     * </p>
     * <p class="title">
     * <b>Related APIs</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDatasetGroup.html">CreateDatasetGroup</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_ListDatasets.html">ListDatasets</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeDataset.html">DescribeDataset</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_DeleteDataset.html">DeleteDataset</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param createDatasetRequest
     * @return Result of the CreateDataset operation returned by the service.
     * @throws InvalidInputException
     *         Provide a valid value for the field or parameter.
     * @throws ResourceNotFoundException
     *         Could not find the specified resource.
     * @throws ResourceAlreadyExistsException
     *         The specified resource already exists.
     * @throws LimitExceededException
     *         The limit on the number of requests per second has been exceeded.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws TooManyTagsException
     *         You have exceeded the maximum number of tags you can apply to this resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeClient.CreateDataset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/CreateDataset" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateDatasetResponse createDataset(CreateDatasetRequest createDatasetRequest) throws InvalidInputException,
            ResourceNotFoundException, ResourceAlreadyExistsException, LimitExceededException, ResourceInUseException,
            TooManyTagsException, AwsServiceException, SdkClientException, PersonalizeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an empty dataset and adds it to the specified dataset group. Use <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDatasetImportJob.html"
     * >CreateDatasetImportJob</a> to import your training data to a dataset.
     * </p>
     * <p>
     * There are three types of datasets:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Interactions
     * </p>
     * </li>
     * <li>
     * <p>
     * Items
     * </p>
     * </li>
     * <li>
     * <p>
     * Users
     * </p>
     * </li>
     * </ul>
     * <p>
     * Each dataset type has an associated schema with required field types. Only the <code>Interactions</code> dataset
     * is required in order to train a model (also referred to as creating a solution).
     * </p>
     * <p>
     * A dataset can be in one of the following states:
     * </p>
     * <ul>
     * <li>
     * <p>
     * CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED
     * </p>
     * </li>
     * <li>
     * <p>
     * DELETE PENDING &gt; DELETE IN_PROGRESS
     * </p>
     * </li>
     * </ul>
     * <p>
     * To get the status of the dataset, call <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeDataset.html">DescribeDataset</a>.
     * </p>
     * <p class="title">
     * <b>Related APIs</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDatasetGroup.html">CreateDatasetGroup</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_ListDatasets.html">ListDatasets</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeDataset.html">DescribeDataset</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_DeleteDataset.html">DeleteDataset</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDatasetRequest.Builder} avoiding the need to
     * create one manually via {@link CreateDatasetRequest#builder()}
     * </p>
     *
     * @param createDatasetRequest
     *        A {@link Consumer} that will call methods on {@link CreateDatasetRequest.Builder} to create a request.
     * @return Result of the CreateDataset operation returned by the service.
     * @throws InvalidInputException
     *         Provide a valid value for the field or parameter.
     * @throws ResourceNotFoundException
     *         Could not find the specified resource.
     * @throws ResourceAlreadyExistsException
     *         The specified resource already exists.
     * @throws LimitExceededException
     *         The limit on the number of requests per second has been exceeded.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws TooManyTagsException
     *         You have exceeded the maximum number of tags you can apply to this resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeClient.CreateDataset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/CreateDataset" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateDatasetResponse createDataset(Consumer<CreateDatasetRequest.Builder> createDatasetRequest)
            throws InvalidInputException, ResourceNotFoundException, ResourceAlreadyExistsException, LimitExceededException,
            ResourceInUseException, TooManyTagsException, AwsServiceException, SdkClientException, PersonalizeException {
        return createDataset(CreateDatasetRequest.builder().applyMutation(createDatasetRequest).build());
    }

    /**
     * <p>
     * Creates a job that exports data from your dataset to an Amazon S3 bucket. To allow Amazon Personalize to export
     * the training data, you must specify an service-linked IAM role that gives Amazon Personalize
     * <code>PutObject</code> permissions for your Amazon S3 bucket. For information, see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/export-data.html">Exporting a dataset</a> in the Amazon
     * Personalize developer guide.
     * </p>
     * <p>
     * <b>Status</b>
     * </p>
     * <p>
     * A dataset export job can be in one of the following states:
     * </p>
     * <ul>
     * <li>
     * <p>
     * CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED
     * </p>
     * </li>
     * </ul>
     * <p>
     * To get the status of the export job, call <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeDatasetExportJob.html"
     * >DescribeDatasetExportJob</a>, and specify the Amazon Resource Name (ARN) of the dataset export job. The dataset
     * export is complete when the status shows as ACTIVE. If the status shows as CREATE FAILED, the response includes a
     * <code>failureReason</code> key, which describes why the job failed.
     * </p>
     *
     * @param createDatasetExportJobRequest
     * @return Result of the CreateDatasetExportJob operation returned by the service.
     * @throws InvalidInputException
     *         Provide a valid value for the field or parameter.
     * @throws ResourceNotFoundException
     *         Could not find the specified resource.
     * @throws ResourceAlreadyExistsException
     *         The specified resource already exists.
     * @throws LimitExceededException
     *         The limit on the number of requests per second has been exceeded.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws TooManyTagsException
     *         You have exceeded the maximum number of tags you can apply to this resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeClient.CreateDatasetExportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/CreateDatasetExportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateDatasetExportJobResponse createDatasetExportJob(CreateDatasetExportJobRequest createDatasetExportJobRequest)
            throws InvalidInputException, ResourceNotFoundException, ResourceAlreadyExistsException, LimitExceededException,
            ResourceInUseException, TooManyTagsException, AwsServiceException, SdkClientException, PersonalizeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a job that exports data from your dataset to an Amazon S3 bucket. To allow Amazon Personalize to export
     * the training data, you must specify an service-linked IAM role that gives Amazon Personalize
     * <code>PutObject</code> permissions for your Amazon S3 bucket. For information, see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/export-data.html">Exporting a dataset</a> in the Amazon
     * Personalize developer guide.
     * </p>
     * <p>
     * <b>Status</b>
     * </p>
     * <p>
     * A dataset export job can be in one of the following states:
     * </p>
     * <ul>
     * <li>
     * <p>
     * CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED
     * </p>
     * </li>
     * </ul>
     * <p>
     * To get the status of the export job, call <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeDatasetExportJob.html"
     * >DescribeDatasetExportJob</a>, and specify the Amazon Resource Name (ARN) of the dataset export job. The dataset
     * export is complete when the status shows as ACTIVE. If the status shows as CREATE FAILED, the response includes a
     * <code>failureReason</code> key, which describes why the job failed.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDatasetExportJobRequest.Builder} avoiding the
     * need to create one manually via {@link CreateDatasetExportJobRequest#builder()}
     * </p>
     *
     * @param createDatasetExportJobRequest
     *        A {@link Consumer} that will call methods on {@link CreateDatasetExportJobRequest.Builder} to create a
     *        request.
     * @return Result of the CreateDatasetExportJob operation returned by the service.
     * @throws InvalidInputException
     *         Provide a valid value for the field or parameter.
     * @throws ResourceNotFoundException
     *         Could not find the specified resource.
     * @throws ResourceAlreadyExistsException
     *         The specified resource already exists.
     * @throws LimitExceededException
     *         The limit on the number of requests per second has been exceeded.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws TooManyTagsException
     *         You have exceeded the maximum number of tags you can apply to this resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeClient.CreateDatasetExportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/CreateDatasetExportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateDatasetExportJobResponse createDatasetExportJob(
            Consumer<CreateDatasetExportJobRequest.Builder> createDatasetExportJobRequest) throws InvalidInputException,
            ResourceNotFoundException, ResourceAlreadyExistsException, LimitExceededException, ResourceInUseException,
            TooManyTagsException, AwsServiceException, SdkClientException, PersonalizeException {
        return createDatasetExportJob(CreateDatasetExportJobRequest.builder().applyMutation(createDatasetExportJobRequest)
                .build());
    }

    /**
     * <p>
     * Creates an empty dataset group. A dataset group is a container for Amazon Personalize resources. A dataset group
     * can contain at most three datasets, one for each type of dataset:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Interactions
     * </p>
     * </li>
     * <li>
     * <p>
     * Items
     * </p>
     * </li>
     * <li>
     * <p>
     * Users
     * </p>
     * </li>
     * </ul>
     * <p>
     * A dataset group can be a Domain dataset group, where you specify a domain and use pre-configured resources like
     * recommenders, or a Custom dataset group, where you use custom resources, such as a solution with a solution
     * version, that you deploy with a campaign. If you start with a Domain dataset group, you can still add custom
     * resources such as solutions and solution versions trained with recipes for custom use cases and deployed with
     * campaigns.
     * </p>
     * <p>
     * A dataset group can be in one of the following states:
     * </p>
     * <ul>
     * <li>
     * <p>
     * CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED
     * </p>
     * </li>
     * <li>
     * <p>
     * DELETE PENDING
     * </p>
     * </li>
     * </ul>
     * <p>
     * To get the status of the dataset group, call <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeDatasetGroup.html">DescribeDatasetGroup</a>.
     * If the status shows as CREATE FAILED, the response includes a <code>failureReason</code> key, which describes why
     * the creation failed.
     * </p>
     * <note>
     * <p>
     * You must wait until the <code>status</code> of the dataset group is <code>ACTIVE</code> before adding a dataset
     * to the group.
     * </p>
     * </note>
     * <p>
     * You can specify an Key Management Service (KMS) key to encrypt the datasets in the group. If you specify a KMS
     * key, you must also include an Identity and Access Management (IAM) role that has permission to access the key.
     * </p>
     * <p class="title">
     * <b>APIs that require a dataset group ARN in the request</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDataset.html">CreateDataset</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateEventTracker.html">CreateEventTracker</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSolution.html">CreateSolution</a>
     * </p>
     * </li>
     * </ul>
     * <p class="title">
     * <b>Related APIs</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_ListDatasetGroups.html">ListDatasetGroups</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeDatasetGroup.html">DescribeDatasetGroup</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_DeleteDatasetGroup.html">DeleteDatasetGroup</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param createDatasetGroupRequest
     * @return Result of the CreateDatasetGroup operation returned by the service.
     * @throws InvalidInputException
     *         Provide a valid value for the field or parameter.
     * @throws ResourceAlreadyExistsException
     *         The specified resource already exists.
     * @throws LimitExceededException
     *         The limit on the number of requests per second has been exceeded.
     * @throws TooManyTagsException
     *         You have exceeded the maximum number of tags you can apply to this resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeClient.CreateDatasetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/CreateDatasetGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateDatasetGroupResponse createDatasetGroup(CreateDatasetGroupRequest createDatasetGroupRequest)
            throws InvalidInputException, ResourceAlreadyExistsException, LimitExceededException, TooManyTagsException,
            AwsServiceException, SdkClientException, PersonalizeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an empty dataset group. A dataset group is a container for Amazon Personalize resources. A dataset group
     * can contain at most three datasets, one for each type of dataset:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Interactions
     * </p>
     * </li>
     * <li>
     * <p>
     * Items
     * </p>
     * </li>
     * <li>
     * <p>
     * Users
     * </p>
     * </li>
     * </ul>
     * <p>
     * A dataset group can be a Domain dataset group, where you specify a domain and use pre-configured resources like
     * recommenders, or a Custom dataset group, where you use custom resources, such as a solution with a solution
     * version, that you deploy with a campaign. If you start with a Domain dataset group, you can still add custom
     * resources such as solutions and solution versions trained with recipes for custom use cases and deployed with
     * campaigns.
     * </p>
     * <p>
     * A dataset group can be in one of the following states:
     * </p>
     * <ul>
     * <li>
     * <p>
     * CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED
     * </p>
     * </li>
     * <li>
     * <p>
     * DELETE PENDING
     * </p>
     * </li>
     * </ul>
     * <p>
     * To get the status of the dataset group, call <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeDatasetGroup.html">DescribeDatasetGroup</a>.
     * If the status shows as CREATE FAILED, the response includes a <code>failureReason</code> key, which describes why
     * the creation failed.
     * </p>
     * <note>
     * <p>
     * You must wait until the <code>status</code> of the dataset group is <code>ACTIVE</code> before adding a dataset
     * to the group.
     * </p>
     * </note>
     * <p>
     * You can specify an Key Management Service (KMS) key to encrypt the datasets in the group. If you specify a KMS
     * key, you must also include an Identity and Access Management (IAM) role that has permission to access the key.
     * </p>
     * <p class="title">
     * <b>APIs that require a dataset group ARN in the request</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDataset.html">CreateDataset</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateEventTracker.html">CreateEventTracker</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSolution.html">CreateSolution</a>
     * </p>
     * </li>
     * </ul>
     * <p class="title">
     * <b>Related APIs</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_ListDatasetGroups.html">ListDatasetGroups</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeDatasetGroup.html">DescribeDatasetGroup</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_DeleteDatasetGroup.html">DeleteDatasetGroup</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDatasetGroupRequest.Builder} avoiding the
     * need to create one manually via {@link CreateDatasetGroupRequest#builder()}
     * </p>
     *
     * @param createDatasetGroupRequest
     *        A {@link Consumer} that will call methods on {@link CreateDatasetGroupRequest.Builder} to create a
     *        request.
     * @return Result of the CreateDatasetGroup operation returned by the service.
     * @throws InvalidInputException
     *         Provide a valid value for the field or parameter.
     * @throws ResourceAlreadyExistsException
     *         The specified resource already exists.
     * @throws LimitExceededException
     *         The limit on the number of requests per second has been exceeded.
     * @throws TooManyTagsException
     *         You have exceeded the maximum number of tags you can apply to this resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeClient.CreateDatasetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/CreateDatasetGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateDatasetGroupResponse createDatasetGroup(Consumer<CreateDatasetGroupRequest.Builder> createDatasetGroupRequest)
            throws InvalidInputException, ResourceAlreadyExistsException, LimitExceededException, TooManyTagsException,
            AwsServiceException, SdkClientException, PersonalizeException {
        return createDatasetGroup(CreateDatasetGroupRequest.builder().applyMutation(createDatasetGroupRequest).build());
    }

    /**
     * <p>
     * Creates a job that imports training data from your data source (an Amazon S3 bucket) to an Amazon Personalize
     * dataset. To allow Amazon Personalize to ACTIVE -or- CREATE FAILED
     * </p>
     * </li> </ul>
     * <p>
     * To get the status of the import job, call <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeDatasetImportJob.html"
     * >DescribeDatasetImportJob</a>, providing the Amazon Resource Name (ARN) of the dataset import job. The dataset
     * import is complete when the status shows as ACTIVE. If the status shows as CREATE FAILED, the response includes a
     * <code>failureReason</code> key, which describes why the job failed.
     * </p>
     * <note>
     * <p>
     * Importing takes time. You must wait until the status shows as ACTIVE before training a model using the dataset.
     * </p>
     * </note>
     * <p class="title">
     * <b>Related APIs</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_ListDatasetImportJobs.html">ListDatasetImportJobs</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeDatasetImportJob.html">
     * DescribeDatasetImportJob</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param createDatasetImportJobRequest
     * @return Result of the CreateDatasetImportJob operation returned by the service.
     * @throws InvalidInputException
     *         Provide a valid value for the field or parameter.
     * @throws ResourceNotFoundException
     *         Could not find the specified resource.
     * @throws ResourceAlreadyExistsException
     *         The specified resource already exists.
     * @throws LimitExceededException
     *         The limit on the number of requests per second has been exceeded.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws TooManyTagsException
     *         You have exceeded the maximum number of tags you can apply to this resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeClient.CreateDatasetImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/CreateDatasetImportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateDatasetImportJobResponse createDatasetImportJob(CreateDatasetImportJobRequest createDatasetImportJobRequest)
            throws InvalidInputException, ResourceNotFoundException, ResourceAlreadyExistsException, LimitExceededException,
            ResourceInUseException, TooManyTagsException, AwsServiceException, SdkClientException, PersonalizeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a job that imports training data from your data source (an Amazon S3 bucket) to an Amazon Personalize
     * dataset. To allow Amazon Personalize to import the training data, you must specify an IAM service role that has
     * permission to read from the data source, as Amazon Personalize makes a copy of your data and processes it
     * internally. For information on granting access to your Amazon S3 bucket, see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/granting-personalize-s3-access.html">Giving Amazon
     * Personalize Access to Amazon S3 Resources</a>.
     * </p>
     * <important>
     * <p>
     * The dataset import job replaces any existing data in the dataset that you imported in bulk.
     * </p>
     * </important>
     * <p>
     * <b>Status</b>
     * </p>
     * <p>
     * A dataset import job can be in one of the following states:
     * </p>
     * <ul>
     * <li>
     * <p>
     * CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED
     * </p>
     * </li>
     * </ul>
     * <p>
     * To get the status of the import job, call <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeDatasetImportJob.html"
     * >DescribeDatasetImportJob</a>, providing the Amazon Resource Name (ARN) of the dataset import job. The dataset
     * import is complete when the status shows as ACTIVE. If the status shows as CREATE FAILED, the response includes a
     * <code>failureReason</code> key, which describes why the job failed.
     * </p>
     * <note>
     * <p>
     * Importing takes time. You must wait until the status shows as ACTIVE before training a model using the dataset.
     * </p>
     * </note>
     * <p class="title">
     * <b>Related APIs</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_ListDatasetImportJobs.html">ListDatasetImportJobs</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeDatasetImportJob.html">
     * DescribeDatasetImportJob</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDatasetImportJobRequest.Builder} avoiding the
     * need to create one manually via {@link CreateDatasetImportJobRequest#builder()}
     * </p>
     *
     * @param createDatasetImportJobRequest
     *        A {@link Consumer} that will call methods on {@link CreateDatasetImportJobRequest.Builder} to create a
     *        request.
     * @return Result of the CreateDatasetImportJob operation returned by the service.
     * @throws InvalidInputException
     *         Provide a valid value for the field or parameter.
     * @throws ResourceNotFoundException
     *         Could not find the specified resource.
     * @throws ResourceAlreadyExistsException
     *         The specified resource already exists.
     * @throws LimitExceededException
     *         The limit on the number of requests per second has been exceeded.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws TooManyTagsException
     *         You have exceeded the maximum number of tags you can apply to this resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeClient.CreateDatasetImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/CreateDatasetImportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateDatasetImportJobResponse createDatasetImportJob(
            Consumer<CreateDatasetImportJobRequest.Builder> createDatasetImportJobRequest) throws InvalidInputException,
            ResourceNotFoundException, ResourceAlreadyExistsException, LimitExceededException, ResourceInUseException,
            TooManyTagsException, AwsServiceException, SdkClientException, PersonalizeException {
        return createDatasetImportJob(CreateDatasetImportJobRequest.builder().applyMutation(createDatasetImportJobRequest)
                .build());
    }

    /**
     * <p>
     * Creates an event tracker that you use when adding event data to a specified dataset group using the <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_UBS_PutEvents.html">PutEvents</a> API.
     * </p>
     * <note>
     * <p>
     * Only one event tracker can be associated with a dataset group. You will get an error if you call
     * <code>CreateEventTracker</code> using the same dataset group as an existing event tracker.
     * </p>
     * </note>
     * <p>
     * When you create an event tracker, the response includes a tracking ID, which you pass as a parameter when you use
     * the <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_UBS_PutEvents.html">PutEvents</a> operation.
     * Amazon Personalize then appends the event data to the Interactions dataset of the dataset group you specify in
     * your event tracker.
     * </p>
     * <p>
     * The event tracker can be in one of the following states:
     * </p>
     * <ul>
     * <li>
     * <p>
     * CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED
     * </p>
     * </li>
     * <li>
     * <p>
     * DELETE PENDING &gt; DELETE IN_PROGRESS
     * </p>
     * </li>
     * </ul>
     * <p>
     * To get the status of the event tracker, call <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeEventTracker.html">DescribeEventTracker</a>.
     * </p>
     * <note>
     * <p>
     * The event tracker must be in the ACTIVE state before using the tracking ID.
     * </p>
     * </note>
     * <p class="title">
     * <b>Related APIs</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_ListEventTrackers.html">ListEventTrackers</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeEventTracker.html">DescribeEventTracker</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_DeleteEventTracker.html">DeleteEventTracker</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param createEventTrackerRequest
     * @return Result of the CreateEventTracker operation returned by the service.
     * @throws InvalidInputException
     *         Provide a valid value for the field or parameter.
     * @throws ResourceAlreadyExistsException
     *         The specified resource already exists.
     * @throws ResourceNotFoundException
     *         Could not find the specified resource.
     * @throws LimitExceededException
     *         The limit on the number of requests per second has been exceeded.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws TooManyTagsException
     *         You have exceeded the maximum number of tags you can apply to this resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeClient.CreateEventTracker
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/CreateEventTracker"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateEventTrackerResponse createEventTracker(CreateEventTrackerRequest createEventTrackerRequest)
            throws InvalidInputException, ResourceAlreadyExistsException, ResourceNotFoundException, LimitExceededException,
            ResourceInUseException, TooManyTagsException, AwsServiceException, SdkClientException, PersonalizeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an event tracker that you use when adding event data to a specified dataset group using the <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_UBS_PutEvents.html">PutEvents</a> API.
     * </p>
     * <note>
     * <p>
     * Only one event tracker can be associated with a dataset group. You will get an error if you call
     * <code>CreateEventTracker</code> using the same dataset group as an existing event tracker.
     * </p>
     * </note>
     * <p>
     * When you create an event tracker, the response includes a tracking ID, which you pass as a parameter when you use
     * the <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_UBS_PutEvents.html">PutEvents</a> operation.
     * Amazon Personalize then appends the event data to the Interactions dataset of the dataset group you specify in
     * your event tracker.
     * </p>
     * <p>
     * The event tracker can be in one of the following states:
     * </p>
     * <ul>
     * <li>
     * <p>
     * CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED
     * </p>
     * </li>
     * <li>
     * <p>
     * DELETE PENDING &gt; DELETE IN_PROGRESS
     * </p>
     * </li>
     * </ul>
     * <p>
     * To get the status of the event tracker, call <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeEventTracker.html">DescribeEventTracker</a>.
     * </p>
     * <note>
     * <p>
     * The event tracker must be in the ACTIVE state before using the tracking ID.
     * </p>
     * </note>
     * <p class="title">
     * <b>Related APIs</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_ListEventTrackers.html">ListEventTrackers</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeEventTracker.html">DescribeEventTracker</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_DeleteEventTracker.html">DeleteEventTracker</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateEventTrackerRequest.Builder} avoiding the
     * need to create one manually via {@link CreateEventTrackerRequest#builder()}
     * </p>
     *
     * @param createEventTrackerRequest
     *        A {@link Consumer} that will call methods on {@link CreateEventTrackerRequest.Builder} to create a
     *        request.
     * @return Result of the CreateEventTracker operation returned by the service.
     * @throws InvalidInputException
     *         Provide a valid value for the field or parameter.
     * @throws ResourceAlreadyExistsException
     *         The specified resource already exists.
     * @throws ResourceNotFoundException
     *         Could not find the specified resource.
     * @throws LimitExceededException
     *         The limit on the number of requests per second has been exceeded.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws TooManyTagsException
     *         You have exceeded the maximum number of tags you can apply to this resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeClient.CreateEventTracker
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/CreateEventTracker"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateEventTrackerResponse createEventTracker(Consumer<CreateEventTrackerRequest.Builder> createEventTrackerRequest)
            throws InvalidInputException, ResourceAlreadyExistsException, ResourceNotFoundException, LimitExceededException,
            ResourceInUseException, TooManyTagsException, AwsServiceException, SdkClientException, PersonalizeException {
        return createEventTracker(CreateEventTrackerRequest.builder().applyMutation(createEventTrackerRequest).build());
    }

    /**
     * <p>
     * Creates a recommendation filter. For more information, see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/filter.html">Filtering recommendations and user
     * segments</a>.
     * </p>
     *
     * @param createFilterRequest
     * @return Result of the CreateFilter operation returned by the service.
     * @throws InvalidInputException
     *         Provide a valid value for the field or parameter.
     * @throws ResourceAlreadyExistsException
     *         The specified resource already exists.
     * @throws ResourceNotFoundException
     *         Could not find the specified resource.
     * @throws LimitExceededException
     *         The limit on the number of requests per second has been exceeded.
     * @throws TooManyTagsException
     *         You have exceeded the maximum number of tags you can apply to this resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeClient.CreateFilter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/CreateFilter" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateFilterResponse createFilter(CreateFilterRequest createFilterRequest) throws InvalidInputException,
            ResourceAlreadyExistsException, ResourceNotFoundException, LimitExceededException, TooManyTagsException,
            AwsServiceException, SdkClientException, PersonalizeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a recommendation filter. For more information, see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/filter.html">Filtering recommendations and user
     * segments</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateFilterRequest.Builder} avoiding the need to
     * create one manually via {@link CreateFilterRequest#builder()}
     * </p>
     *
     * @param createFilterRequest
     *        A {@link Consumer} that will call methods on {@link CreateFilterRequest.Builder} to create a request.
     * @return Result of the CreateFilter operation returned by the service.
     * @throws InvalidInputException
     *         Provide a valid value for the field or parameter.
     * @throws ResourceAlreadyExistsException
     *         The specified resource already exists.
     * @throws ResourceNotFoundException
     *         Could not find the specified resource.
     * @throws LimitExceededException
     *         The limit on the number of requests per second has been exceeded.
     * @throws TooManyTagsException
     *         You have exceeded the maximum number of tags you can apply to this resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeClient.CreateFilter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/CreateFilter" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateFilterResponse createFilter(Consumer<CreateFilterRequest.Builder> createFilterRequest)
            throws InvalidInputException, ResourceAlreadyExistsException, ResourceNotFoundException, LimitExceededException,
            TooManyTagsException, AwsServiceException, SdkClientException, PersonalizeException {
        return createFilter(CreateFilterRequest.builder().applyMutation(createFilterRequest).build());
    }

    /**
     * <p>
     * Creates a recommender with the recipe (a Domain dataset group use case) you specify. You create recommenders for
     * a Domain dataset group and specify the recommender's Amazon Resource Name (ARN) when you make a <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_RS_GetRecommendations.html">GetRecommendations</a>
     * request.
     * </p>
     * <p>
     * <b>Minimum recommendation requests per second</b>
     * </p>
     * <p>
     * When you create a recommender, you can configure the recommender's minimum recommendation requests per second.
     * The minimum recommendation requests per second (<code>minRecommendationRequestsPerSecond</code>) specifies the
     * baseline recommendation request throughput provisioned by Amazon Personalize. The default
     * minRecommendationRequestsPerSecond is <code>1</code>. A recommendation request is a single
     * <code>GetRecommendations</code> operation. Request throughput is measured in requests per second and Amazon
     * Personalize uses your requests per second to derive your requests per hour and the price of your recommender
     * usage.
     * </p>
     * <p>
     * If your requests per second increases beyond <code>minRecommendationRequestsPerSecond</code>, Amazon Personalize
     * auto-scales the provisioned capacity up and down, but never below <code>minRecommendationRequestsPerSecond</code>
     * . There's a short time delay while the capacity is increased that might cause loss of requests.
     * </p>
     * <p>
     * Your bill is the greater of either the minimum requests per hour (based on minRecommendationRequestsPerSecond) or
     * the actual number of requests. The actual request throughput used is calculated as the average requests/second
     * within a one-hour window. We recommend starting with the default <code>minRecommendationRequestsPerSecond</code>,
     * track your usage using Amazon CloudWatch metrics, and then increase the
     * <code>minRecommendationRequestsPerSecond</code> as necessary.
     * </p>
     * <p>
     * <b>Status</b>
     * </p>
     * <p>
     * A recommender can be in one of the following states:
     * </p>
     * <ul>
     * <li>
     * <p>
     * CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED
     * </p>
     * </li>
     * <li>
     * <p>
     * DELETE PENDING &gt; DELETE IN_PROGRESS
     * </p>
     * </li>
     * </ul>
     * <p>
     * To get the recommender status, call <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeRecommender.html">DescribeRecommender</a>.
     * </p>
     * <note>
     * <p>
     * Wait until the <code>status</code> of the recommender is <code>ACTIVE</code> before asking the recommender for
     * recommendations.
     * </p>
     * </note>
     * <p class="title">
     * <b>Related APIs</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_ListRecommenders.html">ListRecommenders</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeRecommender.html">DescribeRecommender</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_UpdateRecommender.html">UpdateRecommender</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_DeleteRecommender.html">DeleteRecommender</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param createRecommenderRequest
     * @return Result of the CreateRecommender operation returned by the service.
     * @throws InvalidInputException
     *         Provide a valid value for the field or parameter.
     * @throws ResourceAlreadyExistsException
     *         The specified resource already exists.
     * @throws ResourceNotFoundException
     *         Could not find the specified resource.
     * @throws LimitExceededException
     *         The limit on the number of requests per second has been exceeded.
     * @throws TooManyTagsException
     *         You have exceeded the maximum number of tags you can apply to this resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeClient.CreateRecommender
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/CreateRecommender" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateRecommenderResponse createRecommender(CreateRecommenderRequest createRecommenderRequest)
            throws InvalidInputException, ResourceAlreadyExistsException, ResourceNotFoundException, LimitExceededException,
            TooManyTagsException, AwsServiceException, SdkClientException, PersonalizeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a recommender with the recipe (a Domain dataset group use case) you specify. You create recommenders for
     * a Domain dataset group and specify the recommender's Amazon Resource Name (ARN) when you make a <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_RS_GetRecommendations.html">GetRecommendations</a>
     * request.
     * </p>
     * <p>
     * <b>Minimum recommendation requests per second</b>
     * </p>
     * <p>
     * When you create a recommender, you can configure the recommender's minimum recommendation requests per second.
     * The minimum recommendation requests per second (<code>minRecommendationRequestsPerSecond</code>) specifies the
     * baseline recommendation request throughput provisioned by Amazon Personalize. The default
     * minRecommendationRequestsPerSecond is <code>1</code>. A recommendation request is a single
     * <code>GetRecommendations</code> operation. Request throughput is measured in requests per second and Amazon
     * Personalize uses your requests per second to derive your requests per hour and the price of your recommender
     * usage.
     * </p>
     * <p>
     * If your requests per second increases beyond <code>minRecommendationRequestsPerSecond</code>, Amazon Personalize
     * auto-scales the provisioned capacity up and down, but never below <code>minRecommendationRequestsPerSecond</code>
     * . There's a short time delay while the capacity is increased that might cause loss of requests.
     * </p>
     * <p>
     * Your bill is the greater of either the minimum requests per hour (based on minRecommendationRequestsPerSecond) or
     * the actual number of requests. The actual request throughput used is calculated as the average requests/second
     * within a one-hour window. We recommend starting with the default <code>minRecommendationRequestsPerSecond</code>,
     * track your usage using Amazon CloudWatch metrics, and then increase the
     * <code>minRecommendationRequestsPerSecond</code> as necessary.
     * </p>
     * <p>
     * <b>Status</b>
     * </p>
     * <p>
     * A recommender can be in one of the following states:
     * </p>
     * <ul>
     * <li>
     * <p>
     * CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED
     * </p>
     * </li>
     * <li>
     * <p>
     * DELETE PENDING &gt; DELETE IN_PROGRESS
     * </p>
     * </li>
     * </ul>
     * <p>
     * To get the recommender status, call <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeRecommender.html">DescribeRecommender</a>.
     * </p>
     * <note>
     * <p>
     * Wait until the <code>status</code> of the recommender is <code>ACTIVE</code> before asking the recommender for
     * recommendations.
     * </p>
     * </note>
     * <p class="title">
     * <b>Related APIs</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_ListRecommenders.html">ListRecommenders</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeRecommender.html">DescribeRecommender</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_UpdateRecommender.html">UpdateRecommender</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_DeleteRecommender.html">DeleteRecommender</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateRecommenderRequest.Builder} avoiding the need
     * to create one manually via {@link CreateRecommenderRequest#builder()}
     * </p>
     *
     * @param createRecommenderRequest
     *        A {@link Consumer} that will call methods on {@link CreateRecommenderRequest.Builder} to create a request.
     * @return Result of the CreateRecommender operation returned by the service.
     * @throws InvalidInputException
     *         Provide a valid value for the field or parameter.
     * @throws ResourceAlreadyExistsException
     *         The specified resource already exists.
     * @throws ResourceNotFoundException
     *         Could not find the specified resource.
     * @throws LimitExceededException
     *         The limit on the number of requests per second has been exceeded.
     * @throws TooManyTagsException
     *         You have exceeded the maximum number of tags you can apply to this resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeClient.CreateRecommender
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/CreateRecommender" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateRecommenderResponse createRecommender(Consumer<CreateRecommenderRequest.Builder> createRecommenderRequest)
            throws InvalidInputException, ResourceAlreadyExistsException, ResourceNotFoundException, LimitExceededException,
            TooManyTagsException, AwsServiceException, SdkClientException, PersonalizeException {
        return createRecommender(CreateRecommenderRequest.builder().applyMutation(createRecommenderRequest).build());
    }

    /**
     * <p>
     * Creates an Amazon Personalize schema from the specified schema string. The schema you create must be in Avro JSON
     * format.
     * </p>
     * <p>
     * Amazon Personalize recognizes three schema variants. Each schema is associated with a dataset type and has a set
     * of required field and keywords. If you are creating a schema for a dataset in a Domain dataset group, you provide
     * the domain of the Domain dataset group. You specify a schema when you call <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDataset.html">CreateDataset</a>.
     * </p>
     * <p class="title">
     * <b>Related APIs</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_ListSchemas.html">ListSchemas</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeSchema.html">DescribeSchema</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_DeleteSchema.html">DeleteSchema</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param createSchemaRequest
     * @return Result of the CreateSchema operation returned by the service.
     * @throws InvalidInputException
     *         Provide a valid value for the field or parameter.
     * @throws ResourceAlreadyExistsException
     *         The specified resource already exists.
     * @throws LimitExceededException
     *         The limit on the number of requests per second has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeClient.CreateSchema
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/CreateSchema" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateSchemaResponse createSchema(CreateSchemaRequest createSchemaRequest) throws InvalidInputException,
            ResourceAlreadyExistsException, LimitExceededException, AwsServiceException, SdkClientException, PersonalizeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Amazon Personalize schema from the specified schema string. The schema you create must be in Avro JSON
     * format.
     * </p>
     * <p>
     * Amazon Personalize recognizes three schema variants. Each schema is associated with a dataset type and has a set
     * of required field and keywords. If you are creating a schema for a dataset in a Domain dataset group, you provide
     * the domain of the Domain dataset group. You specify a schema when you call <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDataset.html">CreateDataset</a>.
     * </p>
     * <p class="title">
     * <b>Related APIs</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_ListSchemas.html">ListSchemas</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeSchema.html">DescribeSchema</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_DeleteSchema.html">DeleteSchema</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSchemaRequest.Builder} avoiding the need to
     * create one manually via {@link CreateSchemaRequest#builder()}
     * </p>
     *
     * @param createSchemaRequest
     *        A {@link Consumer} that will call methods on {@link CreateSchemaRequest.Builder} to create a request.
     * @return Result of the CreateSchema operation returned by the service.
     * @throws InvalidInputException
     *         Provide a valid value for the field or parameter.
     * @throws ResourceAlreadyExistsException
     *         The specified resource already exists.
     * @throws LimitExceededException
     *         The limit on the number of requests per second has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeClient.CreateSchema
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/CreateSchema" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateSchemaResponse createSchema(Consumer<CreateSchemaRequest.Builder> createSchemaRequest)
            throws InvalidInputException, ResourceAlreadyExistsException, LimitExceededException, AwsServiceException,
            SdkClientException, PersonalizeException {
        return createSchema(CreateSchemaRequest.builder().applyMutation(createSchemaRequest).build());
    }

    /**
     * <p>
     * Creates the configuration for training a model. A trained model is known as a solution. After the configuration
     * is created, you train the model (create a solution) by calling the <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSolutionVersion.html">CreateSolutionVersion</a>
     * operation. Every time you call <code>CreateSolutionVersion</code>, a new version of the solution is created.
     * </p>
     * <p>
     * After creating a solution version, you check its accuracy by calling <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_GetSolutionMetrics.html">GetSolutionMetrics</a>. When
     * you are satisfied with the version, you deploy it using <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateCampaign.html">CreateCampaign</a>. The campaign
     * provides recommendations to a client through the <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_RS_GetRecommendations.html">GetRecommendations</a>
     * API.
     * </p>
     * <p>
     * To train a model, Amazon Personalize requires training data and a recipe. The training data comes from the
     * dataset group that you provide in the request. A recipe specifies the training algorithm and a feature
     * transformation. You can specify one of the predefined recipes provided by Amazon Personalize. Alternatively, you
     * can specify <code>performAutoML</code> and Amazon Personalize will analyze your data and select the optimum
     * USER_PERSONALIZATION recipe for you.
     * </p>
     * <note>
     * <p>
     * Amazon Personalize doesn't support configuring the <code>hpoObjective</code> for solution hyperparameter
     * optimization at this time.
     * </p>
     * </note>
     * <p>
     * <b>Status</b>
     * </p>
     * <p>
     * A solution can be in one of the following states:
     * </p>
     * <ul>
     * <li>
     * <p>
     * CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED
     * </p>
     * </li>
     * <li>
     * <p>
     * DELETE PENDING &gt; DELETE IN_PROGRESS
     * </p>
     * </li>
     * </ul>
     * <p>
     * To get the status of the solution, call <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeSolution.html">DescribeSolution</a>. Wait
     * until the status shows as ACTIVE before calling <code>CreateSolutionVersion</code>.
     * </p>
     * <p class="title">
     * <b>Related APIs</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_ListSolutions.html">ListSolutions</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSolutionVersion.html">CreateSolutionVersion</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeSolution.html">DescribeSolution</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_DeleteSolution.html">DeleteSolution</a>
     * </p>
     * </li>
     * </ul>
     * <ul>
     * <li>
     * <p>
     * <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_ListSolutionVersions.html">ListSolutionVersions</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeSolutionVersion.html">
     * DescribeSolutionVersion</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param createSolutionRequest
     * @return Result of the CreateSolution operation returned by the service.
     * @throws InvalidInputException
     *         Provide a valid value for the field or parameter.
     * @throws ResourceAlreadyExistsException
     *         The specified resource already exists.
     * @throws ResourceNotFoundException
     *         Could not find the specified resource.
     * @throws LimitExceededException
     *         The limit on the number of requests per second has been exceeded.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws TooManyTagsException
     *         You have exceeded the maximum number of tags you can apply to this resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeClient.CreateSolution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/CreateSolution" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateSolutionResponse createSolution(CreateSolutionRequest createSolutionRequest) throws InvalidInputException,
            ResourceAlreadyExistsException, ResourceNotFoundException, LimitExceededException, ResourceInUseException,
            TooManyTagsException, AwsServiceException, SdkClientException, PersonalizeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates the configuration for training a model. A trained model is known as a solution. After the configuration
     * is created, you train the model (create a solution) by calling the <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSolutionVersion.html">CreateSolutionVersion</a>
     * operation. Every time you call <code>CreateSolutionVersion</code>, a new version of the solution is created.
     * </p>
     * <p>
     * After creating a solution version, you check its accuracy by calling <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_GetSolutionMetrics.html">GetSolutionMetrics</a>. When
     * you are satisfied with the version, you deploy it using <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateCampaign.html">CreateCampaign</a>. The campaign
     * provides recommendations to a client through the <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_RS_GetRecommendations.html">GetRecommendations</a>
     * API.
     * </p>
     * <p>
     * To train a model, Amazon Personalize requires training data and a recipe. The training data comes from the
     * dataset group that you provide in the request. A recipe specifies the training algorithm and a feature
     * transformation. You can specify one of the predefined recipes provided by Amazon Personalize. Alternatively, you
     * can specify <code>performAutoML</code> and Amazon Personalize will analyze your data and select the optimum
     * USER_PERSONALIZATION recipe for you.
     * </p>
     * <note>
     * <p>
     * Amazon Personalize doesn't support configuring the <code>hpoObjective</code> for solution hyperparameter
     * optimization at this time.
     * </p>
     * </note>
     * <p>
     * <b>Status</b>
     * </p>
     * <p>
     * A solution can be in one of the following states:
     * </p>
     * <ul>
     * <li>
     * <p>
     * CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED
     * </p>
     * </li>
     * <li>
     * <p>
     * DELETE PENDING &gt; DELETE IN_PROGRESS
     * </p>
     * </li>
     * </ul>
     * <p>
     * To get the status of the solution, call <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeSolution.html">DescribeSolution</a>. Wait
     * until the status shows as ACTIVE before calling <code>CreateSolutionVersion</code>.
     * </p>
     * <p class="title">
     * <b>Related APIs</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_ListSolutions.html">ListSolutions</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSolutionVersion.html">CreateSolutionVersion</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeSolution.html">DescribeSolution</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_DeleteSolution.html">DeleteSolution</a>
     * </p>
     * </li>
     * </ul>
     * <ul>
     * <li>
     * <p>
     * <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_ListSolutionVersions.html">ListSolutionVersions</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeSolutionVersion.html">
     * DescribeSolutionVersion</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSolutionRequest.Builder} avoiding the need to
     * create one manually via {@link CreateSolutionRequest#builder()}
     * </p>
     *
     * @param createSolutionRequest
     *        A {@link Consumer} that will call methods on {@link CreateSolutionRequest.Builder} to create a request.
     * @return Result of the CreateSolution operation returned by the service.
     * @throws InvalidInputException
     *         Provide a valid value for the field or parameter.
     * @throws ResourceAlreadyExistsException
     *         The specified resource already exists.
     * @throws ResourceNotFoundException
     *         Could not find the specified resource.
     * @throws LimitExceededException
     *         The limit on the number of requests per second has been exceeded.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws TooManyTagsException
     *         You have exceeded the maximum number of tags you can apply to this resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeClient.CreateSolution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/CreateSolution" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateSolutionResponse createSolution(Consumer<CreateSolutionRequest.Builder> createSolutionRequest)
            throws InvalidInputException, ResourceAlreadyExistsException, ResourceNotFoundException, LimitExceededException,
            ResourceInUseException, TooManyTagsException, AwsServiceException, SdkClientException, PersonalizeException {
        return createSolution(CreateSolutionRequest.builder().applyMutation(createSolutionRequest).build());
    }

    /**
     * <p>
     * Trains or retrains an active solution in a Custom dataset group. A solution is created using the <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSolution.html">CreateSolution</a> operation and
     * must be in the ACTIVE state before calling <code>CreateSolutionVersion</code>. A new version of the solution is
     * created every time you call this operation.
     * </p>
     * <p>
     * <b>Status</b>
     * </p>
     * <p>
     * A solution version can be in one of the following states:
     * </p>
     * <ul>
     * <li>
     * <p>
     * CREATE PENDING
     * </p>
     * </li>
     * <li>
     * <p>
     * CREATE IN_PROGRESS
     * </p>
     * </li>
     * <li>
     * <p>
     * ACTIVE
     * </p>
     * </li>
     * <li>
     * <p>
     * CREATE FAILED
     * </p>
     * </li>
     * <li>
     * <p>
     * CREATE STOPPING
     * </p>
     * </li>
     * <li>
     * <p>
     * CREATE STOPPED
     * </p>
     * </li>
     * </ul>
     * <p>
     * To get the status of the version, call <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeSolutionVersion.html"
     * >DescribeSolutionVersion</a>. Wait until the status shows as ACTIVE before calling <code>CreateCampaign</code>.
     * </p>
     * <p>
     * If the status shows as CREATE FAILED, the response includes a <code>failureReason</code> key, which describes why
     * the job failed.
     * </p>
     * <p class="title">
     * <b>Related APIs</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_ListSolutionVersions.html">ListSolutionVersions</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeSolutionVersion.html">
     * DescribeSolutionVersion</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_ListSolutions.html">ListSolutions</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSolution.html">CreateSolution</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeSolution.html">DescribeSolution</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_DeleteSolution.html">DeleteSolution</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param createSolutionVersionRequest
     * @return Result of the CreateSolutionVersion operation returned by the service.
     * @throws InvalidInputException
     *         Provide a valid value for the field or parameter.
     * @throws ResourceNotFoundException
     *         Could not find the specified resource.
     * @throws LimitExceededException
     *         The limit on the number of requests per second has been exceeded.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws TooManyTagsException
     *         You have exceeded the maximum number of tags you can apply to this resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeClient.CreateSolutionVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/CreateSolutionVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateSolutionVersionResponse createSolutionVersion(CreateSolutionVersionRequest createSolutionVersionRequest)
            throws InvalidInputException, ResourceNotFoundException, LimitExceededException, ResourceInUseException,
            TooManyTagsException, AwsServiceException, SdkClientException, PersonalizeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Trains or retrains an active solution in a Custom dataset group. A solution is created using the <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSolution.html">CreateSolution</a> operation and
     * must be in the ACTIVE state before calling <code>CreateSolutionVersion</code>. A new version of the solution is
     * created every time you call this operation.
     * </p>
     * <p>
     * <b>Status</b>
     * </p>
     * <p>
     * A solution version can be in one of the following states:
     * </p>
     * <ul>
     * <li>
     * <p>
     * CREATE PENDING
     * </p>
     * </li>
     * <li>
     * <p>
     * CREATE IN_PROGRESS
     * </p>
     * </li>
     * <li>
     * <p>
     * ACTIVE
     * </p>
     * </li>
     * <li>
     * <p>
     * CREATE FAILED
     * </p>
     * </li>
     * <li>
     * <p>
     * CREATE STOPPING
     * </p>
     * </li>
     * <li>
     * <p>
     * CREATE STOPPED
     * </p>
     * </li>
     * </ul>
     * <p>
     * To get the status of the version, call <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeSolutionVersion.html"
     * >DescribeSolutionVersion</a>. Wait until the status shows as ACTIVE before calling <code>CreateCampaign</code>.
     * </p>
     * <p>
     * If the status shows as CREATE FAILED, the response includes a <code>failureReason</code> key, which describes why
     * the job failed.
     * </p>
     * <p class="title">
     * <b>Related APIs</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_ListSolutionVersions.html">ListSolutionVersions</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeSolutionVersion.html">
     * DescribeSolutionVersion</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_ListSolutions.html">ListSolutions</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSolution.html">CreateSolution</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeSolution.html">DescribeSolution</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_DeleteSolution.html">DeleteSolution</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSolutionVersionRequest.Builder} avoiding the
     * need to create one manually via {@link CreateSolutionVersionRequest#builder()}
     * </p>
     *
     * @param createSolutionVersionRequest
     *        A {@link Consumer} that will call methods on {@link CreateSolutionVersionRequest.Builder} to create a
     *        request.
     * @return Result of the CreateSolutionVersion operation returned by the service.
     * @throws InvalidInputException
     *         Provide a valid value for the field or parameter.
     * @throws ResourceNotFoundException
     *         Could not find the specified resource.
     * @throws LimitExceededException
     *         The limit on the number of requests per second has been exceeded.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws TooManyTagsException
     *         You have exceeded the maximum number of tags you can apply to this resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeClient.CreateSolutionVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/CreateSolutionVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateSolutionVersionResponse createSolutionVersion(
            Consumer<CreateSolutionVersionRequest.Builder> createSolutionVersionRequest) throws InvalidInputException,
            ResourceNotFoundException, LimitExceededException, ResourceInUseException, TooManyTagsException, AwsServiceException,
            SdkClientException, PersonalizeException {
        return createSolutionVersion(CreateSolutionVersionRequest.builder().applyMutation(createSolutionVersionRequest).build());
    }

    /**
     * <p>
     * Removes a campaign by deleting the solution deployment. The solution that the campaign is based on is not deleted
     * and can be redeployed when needed. A deleted campaign can no longer be specified in a <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_RS_GetRecommendations.html">GetRecommendations</a>
     * request. For information on creating campaigns, see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateCampaign.html">CreateCampaign</a>.
     * </p>
     *
     * @param deleteCampaignRequest
     * @return Result of the DeleteCampaign operation returned by the service.
     * @throws InvalidInputException
     *         Provide a valid value for the field or parameter.
     * @throws ResourceNotFoundException
     *         Could not find the specified resource.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeClient.DeleteCampaign
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DeleteCampaign" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteCampaignResponse deleteCampaign(DeleteCampaignRequest deleteCampaignRequest) throws InvalidInputException,
            ResourceNotFoundException, ResourceInUseException, AwsServiceException, SdkClientException, PersonalizeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a campaign by deleting the solution deployment. The solution that the campaign is based on is not deleted
     * and can be redeployed when needed. A deleted campaign can no longer be specified in a <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_RS_GetRecommendations.html">GetRecommendations</a>
     * request. For information on creating campaigns, see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateCampaign.html">CreateCampaign</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteCampaignRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteCampaignRequest#builder()}
     * </p>
     *
     * @param deleteCampaignRequest
     *        A {@link Consumer} that will call methods on {@link DeleteCampaignRequest.Builder} to create a request.
     * @return Result of the DeleteCampaign operation returned by the service.
     * @throws InvalidInputException
     *         Provide a valid value for the field or parameter.
     * @throws ResourceNotFoundException
     *         Could not find the specified resource.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeClient.DeleteCampaign
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DeleteCampaign" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteCampaignResponse deleteCampaign(Consumer<DeleteCampaignRequest.Builder> deleteCampaignRequest)
            throws InvalidInputException, ResourceNotFoundException, ResourceInUseException, AwsServiceException,
            SdkClientException, PersonalizeException {
        return deleteCampaign(DeleteCampaignRequest.builder().applyMutation(deleteCampaignRequest).build());
    }

    /**
     * <p>
     * Deletes a dataset. You can't delete a dataset if an associated <code>DatasetImportJob</code> or
     * <code>SolutionVersion</code> is in the CREATE PENDING or IN PROGRESS state. For more information on datasets, see
     * <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDataset.html">CreateDataset</a>.
     * </p>
     *
     * @param deleteDatasetRequest
     * @return Result of the DeleteDataset operation returned by the service.
     * @throws InvalidInputException
     *         Provide a valid value for the field or parameter.
     * @throws ResourceNotFoundException
     *         Could not find the specified resource.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeClient.DeleteDataset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DeleteDataset" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteDatasetResponse deleteDataset(DeleteDatasetRequest deleteDatasetRequest) throws InvalidInputException,
            ResourceNotFoundException, ResourceInUseException, AwsServiceException, SdkClientException, PersonalizeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a dataset. You can't delete a dataset if an associated <code>DatasetImportJob</code> or
     * <code>SolutionVersion</code> is in the CREATE PENDING or IN PROGRESS state. For more information on datasets, see
     * <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDataset.html">CreateDataset</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDatasetRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteDatasetRequest#builder()}
     * </p>
     *
     * @param deleteDatasetRequest
     *        A {@link Consumer} that will call methods on {@link DeleteDatasetRequest.Builder} to create a request.
     * @return Result of the DeleteDataset operation returned by the service.
     * @throws InvalidInputException
     *         Provide a valid value for the field or parameter.
     * @throws ResourceNotFoundException
     *         Could not find the specified resource.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeClient.DeleteDataset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DeleteDataset" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteDatasetResponse deleteDataset(Consumer<DeleteDatasetRequest.Builder> deleteDatasetRequest)
            throws InvalidInputException, ResourceNotFoundException, ResourceInUseException, AwsServiceException,
            SdkClientException, PersonalizeException {
        return deleteDataset(DeleteDatasetRequest.builder().applyMutation(deleteDatasetRequest).build());
    }

    /**
     * <p>
     * Deletes a dataset group. Before you delete a dataset group, you must delete the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * All associated event trackers.
     * </p>
     * </li>
     * <li>
     * <p>
     * All associated solutions.
     * </p>
     * </li>
     * <li>
     * <p>
     * All datasets in the dataset group.
     * </p>
     * </li>
     * </ul>
     *
     * @param deleteDatasetGroupRequest
     * @return Result of the DeleteDatasetGroup operation returned by the service.
     * @throws InvalidInputException
     *         Provide a valid value for the field or parameter.
     * @throws ResourceNotFoundException
     *         Could not find the specified resource.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeClient.DeleteDatasetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DeleteDatasetGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteDatasetGroupResponse deleteDatasetGroup(DeleteDatasetGroupRequest deleteDatasetGroupRequest)
            throws InvalidInputException, ResourceNotFoundException, ResourceInUseException, AwsServiceException,
            SdkClientException, PersonalizeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a dataset group. Before you delete a dataset group, you must delete the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * All associated event trackers.
     * </p>
     * </li>
     * <li>
     * <p>
     * All associated solutions.
     * </p>
     * </li>
     * <li>
     * <p>
     * All datasets in the dataset group.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDatasetGroupRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteDatasetGroupRequest#builder()}
     * </p>
     *
     * @param deleteDatasetGroupRequest
     *        A {@link Consumer} that will call methods on {@link DeleteDatasetGroupRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteDatasetGroup operation returned by the service.
     * @throws InvalidInputException
     *         Provide a valid value for the field or parameter.
     * @throws ResourceNotFoundException
     *         Could not find the specified resource.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeClient.DeleteDatasetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DeleteDatasetGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteDatasetGroupResponse deleteDatasetGroup(Consumer<DeleteDatasetGroupRequest.Builder> deleteDatasetGroupRequest)
            throws InvalidInputException, ResourceNotFoundException, ResourceInUseException, AwsServiceException,
            SdkClientException, PersonalizeException {
        return deleteDatasetGroup(DeleteDatasetGroupRequest.builder().applyMutation(deleteDatasetGroupRequest).build());
    }

    /**
     * <p>
     * Deletes the event tracker. Does not delete the event-interactions dataset from the associated dataset group. For
     * more information on event trackers, see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateEventTracker.html">CreateEventTracker</a>.
     * </p>
     *
     * @param deleteEventTrackerRequest
     * @return Result of the DeleteEventTracker operation returned by the service.
     * @throws InvalidInputException
     *         Provide a valid value for the field or parameter.
     * @throws ResourceNotFoundException
     *         Could not find the specified resource.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeClient.DeleteEventTracker
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DeleteEventTracker"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteEventTrackerResponse deleteEventTracker(DeleteEventTrackerRequest deleteEventTrackerRequest)
            throws InvalidInputException, ResourceNotFoundException, ResourceInUseException, AwsServiceException,
            SdkClientException, PersonalizeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the event tracker. Does not delete the event-interactions dataset from the associated dataset group. For
     * more information on event trackers, see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateEventTracker.html">CreateEventTracker</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteEventTrackerRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteEventTrackerRequest#builder()}
     * </p>
     *
     * @param deleteEventTrackerRequest
     *        A {@link Consumer} that will call methods on {@link DeleteEventTrackerRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteEventTracker operation returned by the service.
     * @throws InvalidInputException
     *         Provide a valid value for the field or parameter.
     * @throws ResourceNotFoundException
     *         Could not find the specified resource.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeClient.DeleteEventTracker
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DeleteEventTracker"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteEventTrackerResponse deleteEventTracker(Consumer<DeleteEventTrackerRequest.Builder> deleteEventTrackerRequest)
            throws InvalidInputException, ResourceNotFoundException, ResourceInUseException, AwsServiceException,
            SdkClientException, PersonalizeException {
        return deleteEventTracker(DeleteEventTrackerRequest.builder().applyMutation(deleteEventTrackerRequest).build());
    }

    /**
     * <p>
     * Deletes a filter.
     * </p>
     *
     * @param deleteFilterRequest
     * @return Result of the DeleteFilter operation returned by the service.
     * @throws InvalidInputException
     *         Provide a valid value for the field or parameter.
     * @throws ResourceNotFoundException
     *         Could not find the specified resource.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeClient.DeleteFilter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DeleteFilter" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteFilterResponse deleteFilter(DeleteFilterRequest deleteFilterRequest) throws InvalidInputException,
            ResourceNotFoundException, ResourceInUseException, AwsServiceException, SdkClientException, PersonalizeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a filter.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteFilterRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteFilterRequest#builder()}
     * </p>
     *
     * @param deleteFilterRequest
     *        A {@link Consumer} that will call methods on {@link DeleteFilterRequest.Builder} to create a request.
     * @return Result of the DeleteFilter operation returned by the service.
     * @throws InvalidInputException
     *         Provide a valid value for the field or parameter.
     * @throws ResourceNotFoundException
     *         Could not find the specified resource.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeClient.DeleteFilter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DeleteFilter" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteFilterResponse deleteFilter(Consumer<DeleteFilterRequest.Builder> deleteFilterRequest)
            throws InvalidInputException, ResourceNotFoundException, ResourceInUseException, AwsServiceException,
            SdkClientException, PersonalizeException {
        return deleteFilter(DeleteFilterRequest.builder().applyMutation(deleteFilterRequest).build());
    }

    /**
     * <p>
     * Deactivates and removes a recommender. A deleted recommender can no longer be specified in a <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_RS_GetRecommendations.html">GetRecommendations</a>
     * request.
     * </p>
     *
     * @param deleteRecommenderRequest
     * @return Result of the DeleteRecommender operation returned by the service.
     * @throws InvalidInputException
     *         Provide a valid value for the field or parameter.
     * @throws ResourceNotFoundException
     *         Could not find the specified resource.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeClient.DeleteRecommender
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DeleteRecommender" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteRecommenderResponse deleteRecommender(DeleteRecommenderRequest deleteRecommenderRequest)
            throws InvalidInputException, ResourceNotFoundException, ResourceInUseException, AwsServiceException,
            SdkClientException, PersonalizeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deactivates and removes a recommender. A deleted recommender can no longer be specified in a <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_RS_GetRecommendations.html">GetRecommendations</a>
     * request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteRecommenderRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteRecommenderRequest#builder()}
     * </p>
     *
     * @param deleteRecommenderRequest
     *        A {@link Consumer} that will call methods on {@link DeleteRecommenderRequest.Builder} to create a request.
     * @return Result of the DeleteRecommender operation returned by the service.
     * @throws InvalidInputException
     *         Provide a valid value for the field or parameter.
     * @throws ResourceNotFoundException
     *         Could not find the specified resource.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeClient.DeleteRecommender
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DeleteRecommender" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteRecommenderResponse deleteRecommender(Consumer<DeleteRecommenderRequest.Builder> deleteRecommenderRequest)
            throws InvalidInputException, ResourceNotFoundException, ResourceInUseException, AwsServiceException,
            SdkClientException, PersonalizeException {
        return deleteRecommender(DeleteRecommenderRequest.builder().applyMutation(deleteRecommenderRequest).build());
    }

    /**
     * <p>
     * Deletes a schema. Before deleting a schema, you must delete all datasets referencing the schema. For more
     * information on schemas, see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSchema.html">CreateSchema</a>.
     * </p>
     *
     * @param deleteSchemaRequest
     * @return Result of the DeleteSchema operation returned by the service.
     * @throws InvalidInputException
     *         Provide a valid value for the field or parameter.
     * @throws ResourceNotFoundException
     *         Could not find the specified resource.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeClient.DeleteSchema
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DeleteSchema" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteSchemaResponse deleteSchema(DeleteSchemaRequest deleteSchemaRequest) throws InvalidInputException,
            ResourceNotFoundException, ResourceInUseException, AwsServiceException, SdkClientException, PersonalizeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a schema. Before deleting a schema, you must delete all datasets referencing the schema. For more
     * information on schemas, see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSchema.html">CreateSchema</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSchemaRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteSchemaRequest#builder()}
     * </p>
     *
     * @param deleteSchemaRequest
     *        A {@link Consumer} that will call methods on {@link DeleteSchemaRequest.Builder} to create a request.
     * @return Result of the DeleteSchema operation returned by the service.
     * @throws InvalidInputException
     *         Provide a valid value for the field or parameter.
     * @throws ResourceNotFoundException
     *         Could not find the specified resource.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeClient.DeleteSchema
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DeleteSchema" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteSchemaResponse deleteSchema(Consumer<DeleteSchemaRequest.Builder> deleteSchemaRequest)
            throws InvalidInputException, ResourceNotFoundException, ResourceInUseException, AwsServiceException,
            SdkClientException, PersonalizeException {
        return deleteSchema(DeleteSchemaRequest.builder().applyMutation(deleteSchemaRequest).build());
    }

    /**
     * <p>
     * Deletes all versions of a solution and the <code>Solution</code> object itself. Before deleting a solution, you
     * must delete all campaigns based on the solution. To determine what campaigns are using the solution, call <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_ListCampaigns.html">ListCampaigns</a> and supply the
     * Amazon Resource Name (ARN) of the solution. You can't delete a solution if an associated
     * <code>SolutionVersion</code> is in the CREATE PENDING or IN PROGRESS state. For more information on solutions,
     * see <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSolution.html">CreateSolution</a>.
     * </p>
     *
     * @param deleteSolutionRequest
     * @return Result of the DeleteSolution operation returned by the service.
     * @throws InvalidInputException
     *         Provide a valid value for the field or parameter.
     * @throws ResourceNotFoundException
     *         Could not find the specified resource.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeClient.DeleteSolution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DeleteSolution" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteSolutionResponse deleteSolution(DeleteSolutionRequest deleteSolutionRequest) throws InvalidInputException,
            ResourceNotFoundException, ResourceInUseException, AwsServiceException, SdkClientException, PersonalizeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes all versions of a solution and the <code>Solution</code> object itself. Before deleting a solution, you
     * must delete all campaigns based on the solution. To determine what campaigns are using the solution, call <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_ListCampaigns.html">ListCampaigns</a> and supply the
     * Amazon Resource Name (ARN) of the solution. You can't delete a solution if an associated
     * <code>SolutionVersion</code> is in the CREATE PENDING or IN PROGRESS state. For more information on solutions,
     * see <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSolution.html">CreateSolution</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSolutionRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteSolutionRequest#builder()}
     * </p>
     *
     * @param deleteSolutionRequest
     *        A {@link Consumer} that will call methods on {@link DeleteSolutionRequest.Builder} to create a request.
     * @return Result of the DeleteSolution operation returned by the service.
     * @throws InvalidInputException
     *         Provide a valid value for the field or parameter.
     * @throws ResourceNotFoundException
     *         Could not find the specified resource.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeClient.DeleteSolution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DeleteSolution" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteSolutionResponse deleteSolution(Consumer<DeleteSolutionRequest.Builder> deleteSolutionRequest)
            throws InvalidInputException, ResourceNotFoundException, ResourceInUseException, AwsServiceException,
            SdkClientException, PersonalizeException {
        return deleteSolution(DeleteSolutionRequest.builder().applyMutation(deleteSolutionRequest).build());
    }

    /**
     * <p>
     * Describes the given algorithm.
     * </p>
     *
     * @param describeAlgorithmRequest
     * @return Result of the DescribeAlgorithm operation returned by the service.
     * @throws InvalidInputException
     *         Provide a valid value for the field or parameter.
     * @throws ResourceNotFoundException
     *         Could not find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeClient.DescribeAlgorithm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DescribeAlgorithm" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeAlgorithmResponse describeAlgorithm(DescribeAlgorithmRequest describeAlgorithmRequest)
            throws InvalidInputException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            PersonalizeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the given algorithm.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAlgorithmRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeAlgorithmRequest#builder()}
     * </p>
     *
     * @param describeAlgorithmRequest
     *        A {@link Consumer} that will call methods on {@link DescribeAlgorithmRequest.Builder} to create a request.
     * @return Result of the DescribeAlgorithm operation returned by the service.
     * @throws InvalidInputException
     *         Provide a valid value for the field or parameter.
     * @throws ResourceNotFoundException
     *         Could not find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeClient.DescribeAlgorithm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DescribeAlgorithm" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeAlgorithmResponse describeAlgorithm(Consumer<DescribeAlgorithmRequest.Builder> describeAlgorithmRequest)
            throws InvalidInputException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            PersonalizeException {
        return describeAlgorithm(DescribeAlgorithmRequest.builder().applyMutation(describeAlgorithmRequest).build());
    }

    /**
     * <p>
     * Gets the properties of a batch inference job including name, Amazon Resource Name (ARN), status, input and output
     * configurations, and the ARN of the solution version used to generate the recommendations.
     * </p>
     *
     * @param describeBatchInferenceJobRequest
     * @return Result of the DescribeBatchInferenceJob operation returned by the service.
     * @throws InvalidInputException
     *         Provide a valid value for the field or parameter.
     * @throws ResourceNotFoundException
     *         Could not find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeClient.DescribeBatchInferenceJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DescribeBatchInferenceJob"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeBatchInferenceJobResponse describeBatchInferenceJob(
            DescribeBatchInferenceJobRequest describeBatchInferenceJobRequest) throws InvalidInputException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, PersonalizeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the properties of a batch inference job including name, Amazon Resource Name (ARN), status, input and output
     * configurations, and the ARN of the solution version used to generate the recommendations.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeBatchInferenceJobRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeBatchInferenceJobRequest#builder()}
     * </p>
     *
     * @param describeBatchInferenceJobRequest
     *        A {@link Consumer} that will call methods on {@link DescribeBatchInferenceJobRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeBatchInferenceJob operation returned by the service.
     * @throws InvalidInputException
     *         Provide a valid value for the field or parameter.
     * @throws ResourceNotFoundException
     *         Could not find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeClient.DescribeBatchInferenceJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DescribeBatchInferenceJob"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeBatchInferenceJobResponse describeBatchInferenceJob(
            Consumer<DescribeBatchInferenceJobRequest.Builder> describeBatchInferenceJobRequest) throws InvalidInputException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, PersonalizeException {
        return describeBatchInferenceJob(DescribeBatchInferenceJobRequest.builder()
                .applyMutation(describeBatchInferenceJobRequest).build());
    }

    /**
     * <p>
     * Gets the properties of a batch segment job including name, Amazon Resource Name (ARN), status, input and output
     * configurations, and the ARN of the solution version used to generate segments.
     * </p>
     *
     * @param describeBatchSegmentJobRequest
     * @return Result of the DescribeBatchSegmentJob operation returned by the service.
     * @throws InvalidInputException
     *         Provide a valid value for the field or parameter.
     * @throws ResourceNotFoundException
     *         Could not find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeClient.DescribeBatchSegmentJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DescribeBatchSegmentJob"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeBatchSegmentJobResponse describeBatchSegmentJob(DescribeBatchSegmentJobRequest describeBatchSegmentJobRequest)
            throws InvalidInputException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            PersonalizeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the properties of a batch segment job including name, Amazon Resource Name (ARN), status, input and output
     * configurations, and the ARN of the solution version used to generate segments.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeBatchSegmentJobRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeBatchSegmentJobRequest#builder()}
     * </p>
     *
     * @param describeBatchSegmentJobRequest
     *        A {@link Consumer} that will call methods on {@link DescribeBatchSegmentJobRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeBatchSegmentJob operation returned by the service.
     * @throws InvalidInputException
     *         Provide a valid value for the field or parameter.
     * @throws ResourceNotFoundException
     *         Could not find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeClient.DescribeBatchSegmentJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DescribeBatchSegmentJob"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeBatchSegmentJobResponse describeBatchSegmentJob(
            Consumer<DescribeBatchSegmentJobRequest.Builder> describeBatchSegmentJobRequest) throws InvalidInputException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, PersonalizeException {
        return describeBatchSegmentJob(DescribeBatchSegmentJobRequest.builder().applyMutation(describeBatchSegmentJobRequest)
                .build());
    }

    /**
     * <p>
     * Describes the given campaign, including its status.
     * </p>
     * <p>
     * A campaign can be in one of the following states:
     * </p>
     * <ul>
     * <li>
     * <p>
     * CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED
     * </p>
     * </li>
     * <li>
     * <p>
     * DELETE PENDING &gt; DELETE IN_PROGRESS
     * </p>
     * </li>
     * </ul>
     * <p>
     * When the <code>status</code> is <code>CREATE FAILED</code>, the response includes the <code>failureReason</code>
     * key, which describes why.
     * </p>
     * <p>
     * For more information on campaigns, see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateCampaign.html">CreateCampaign</a>.
     * </p>
     *
     * @param describeCampaignRequest
     * @return Result of the DescribeCampaign operation returned by the service.
     * @throws InvalidInputException
     *         Provide a valid value for the field or parameter.
     * @throws ResourceNotFoundException
     *         Could not find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeClient.DescribeCampaign
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DescribeCampaign" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeCampaignResponse describeCampaign(DescribeCampaignRequest describeCampaignRequest)
            throws InvalidInputException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            PersonalizeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the given campaign, including its status.
     * </p>
     * <p>
     * A campaign can be in one of the following states:
     * </p>
     * <ul>
     * <li>
     * <p>
     * CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED
     * </p>
     * </li>
     * <li>
     * <p>
     * DELETE PENDING &gt; DELETE IN_PROGRESS
     * </p>
     * </li>
     * </ul>
     * <p>
     * When the <code>status</code> is <code>CREATE FAILED</code>, the response includes the <code>failureReason</code>
     * key, which describes why.
     * </p>
     * <p>
     * For more information on campaigns, see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateCampaign.html">CreateCampaign</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeCampaignRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeCampaignRequest#builder()}
     * </p>
     *
     * @param describeCampaignRequest
     *        A {@link Consumer} that will call methods on {@link DescribeCampaignRequest.Builder} to create a request.
     * @return Result of the DescribeCampaign operation returned by the service.
     * @throws InvalidInputException
     *         Provide a valid value for the field or parameter.
     * @throws ResourceNotFoundException
     *         Could not find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeClient.DescribeCampaign
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DescribeCampaign" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeCampaignResponse describeCampaign(Consumer<DescribeCampaignRequest.Builder> describeCampaignRequest)
            throws InvalidInputException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            PersonalizeException {
        return describeCampaign(DescribeCampaignRequest.builder().applyMutation(describeCampaignRequest).build());
    }

    /**
     * <p>
     * Describes the given dataset. For more information on datasets, see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDataset.html">CreateDataset</a>.
     * </p>
     *
     * @param describeDatasetRequest
     * @return Result of the DescribeDataset operation returned by the service.
     * @throws InvalidInputException
     *         Provide a valid value for the field or parameter.
     * @throws ResourceNotFoundException
     *         Could not find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeClient.DescribeDataset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DescribeDataset" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeDatasetResponse describeDataset(DescribeDatasetRequest describeDatasetRequest) throws InvalidInputException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, PersonalizeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the given dataset. For more information on datasets, see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDataset.html">CreateDataset</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDatasetRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeDatasetRequest#builder()}
     * </p>
     *
     * @param describeDatasetRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDatasetRequest.Builder} to create a request.
     * @return Result of the DescribeDataset operation returned by the service.
     * @throws InvalidInputException
     *         Provide a valid value for the field or parameter.
     * @throws ResourceNotFoundException
     *         Could not find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeClient.DescribeDataset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DescribeDataset" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeDatasetResponse describeDataset(Consumer<DescribeDatasetRequest.Builder> describeDatasetRequest)
            throws InvalidInputException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            PersonalizeException {
        return describeDataset(DescribeDatasetRequest.builder().applyMutation(describeDatasetRequest).build());
    }

    /**
     * <p>
     * Describes the dataset export job created by <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDatasetExportJob.html"
     * >CreateDatasetExportJob</a>, including the export job status.
     * </p>
     *
     * @param describeDatasetExportJobRequest
     * @return Result of the DescribeDatasetExportJob operation returned by the service.
     * @throws InvalidInputException
     *         Provide a valid value for the field or parameter.
     * @throws ResourceNotFoundException
     *         Could not find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeClient.DescribeDatasetExportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DescribeDatasetExportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDatasetExportJobResponse describeDatasetExportJob(
            DescribeDatasetExportJobRequest describeDatasetExportJobRequest) throws InvalidInputException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, PersonalizeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the dataset export job created by <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDatasetExportJob.html"
     * >CreateDatasetExportJob</a>, including the export job status.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDatasetExportJobRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeDatasetExportJobRequest#builder()}
     * </p>
     *
     * @param describeDatasetExportJobRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDatasetExportJobRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeDatasetExportJob operation returned by the service.
     * @throws InvalidInputException
     *         Provide a valid value for the field or parameter.
     * @throws ResourceNotFoundException
     *         Could not find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeClient.DescribeDatasetExportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DescribeDatasetExportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDatasetExportJobResponse describeDatasetExportJob(
            Consumer<DescribeDatasetExportJobRequest.Builder> describeDatasetExportJobRequest) throws InvalidInputException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, PersonalizeException {
        return describeDatasetExportJob(DescribeDatasetExportJobRequest.builder().applyMutation(describeDatasetExportJobRequest)
                .build());
    }

    /**
     * <p>
     * Describes the given dataset group. For more information on dataset groups, see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDatasetGroup.html">CreateDatasetGroup</a>.
     * </p>
     *
     * @param describeDatasetGroupRequest
     * @return Result of the DescribeDatasetGroup operation returned by the service.
     * @throws InvalidInputException
     *         Provide a valid value for the field or parameter.
     * @throws ResourceNotFoundException
     *         Could not find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeClient.DescribeDatasetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DescribeDatasetGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDatasetGroupResponse describeDatasetGroup(DescribeDatasetGroupRequest describeDatasetGroupRequest)
            throws InvalidInputException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            PersonalizeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the given dataset group. For more information on dataset groups, see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDatasetGroup.html">CreateDatasetGroup</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDatasetGroupRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeDatasetGroupRequest#builder()}
     * </p>
     *
     * @param describeDatasetGroupRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDatasetGroupRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeDatasetGroup operation returned by the service.
     * @throws InvalidInputException
     *         Provide a valid value for the field or parameter.
     * @throws ResourceNotFoundException
     *         Could not find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeClient.DescribeDatasetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DescribeDatasetGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDatasetGroupResponse describeDatasetGroup(
            Consumer<DescribeDatasetGroupRequest.Builder> describeDatasetGroupRequest) throws InvalidInputException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, PersonalizeException {
        return describeDatasetGroup(DescribeDatasetGroupRequest.builder().applyMutation(describeDatasetGroupRequest).build());
    }

    /**
     * <p>
     * Describes the dataset import job created by <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDatasetImportJob.html"
     * >CreateDatasetImportJob</a>, including the import job status.
     * </p>
     *
     * @param describeDatasetImportJobRequest
     * @return Result of the DescribeDatasetImportJob operation returned by the service.
     * @throws InvalidInputException
     *         Provide a valid value for the field or parameter.
     * @throws ResourceNotFoundException
     *         Could not find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeClient.DescribeDatasetImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DescribeDatasetImportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDatasetImportJobResponse describeDatasetImportJob(
            DescribeDatasetImportJobRequest describeDatasetImportJobRequest) throws InvalidInputException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, PersonalizeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the dataset import job created by <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDatasetImportJob.html"
     * >CreateDatasetImportJob</a>, including the import job status.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDatasetImportJobRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeDatasetImportJobRequest#builder()}
     * </p>
     *
     * @param describeDatasetImportJobRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDatasetImportJobRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeDatasetImportJob operation returned by the service.
     * @throws InvalidInputException
     *         Provide a valid value for the field or parameter.
     * @throws ResourceNotFoundException
     *         Could not find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeClient.DescribeDatasetImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DescribeDatasetImportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDatasetImportJobResponse describeDatasetImportJob(
            Consumer<DescribeDatasetImportJobRequest.Builder> describeDatasetImportJobRequest) throws InvalidInputException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, PersonalizeException {
        return describeDatasetImportJob(DescribeDatasetImportJobRequest.builder().applyMutation(describeDatasetImportJobRequest)
                .build());
    }

    /**
     * <p>
     * Describes an event tracker. The response includes the <code>trackingId</code> and <code>status</code> of the
     * event tracker. For more information on event trackers, see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateEventTracker.html">CreateEventTracker</a>.
     * </p>
     *
     * @param describeEventTrackerRequest
     * @return Result of the DescribeEventTracker operation returned by the service.
     * @throws InvalidInputException
     *         Provide a valid value for the field or parameter.
     * @throws ResourceNotFoundException
     *         Could not find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeClient.DescribeEventTracker
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DescribeEventTracker"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEventTrackerResponse describeEventTracker(DescribeEventTrackerRequest describeEventTrackerRequest)
            throws InvalidInputException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            PersonalizeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes an event tracker. The response includes the <code>trackingId</code> and <code>status</code> of the
     * event tracker. For more information on event trackers, see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateEventTracker.html">CreateEventTracker</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEventTrackerRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeEventTrackerRequest#builder()}
     * </p>
     *
     * @param describeEventTrackerRequest
     *        A {@link Consumer} that will call methods on {@link DescribeEventTrackerRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeEventTracker operation returned by the service.
     * @throws InvalidInputException
     *         Provide a valid value for the field or parameter.
     * @throws ResourceNotFoundException
     *         Could not find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeClient.DescribeEventTracker
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DescribeEventTracker"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEventTrackerResponse describeEventTracker(
            Consumer<DescribeEventTrackerRequest.Builder> describeEventTrackerRequest) throws InvalidInputException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, PersonalizeException {
        return describeEventTracker(DescribeEventTrackerRequest.builder().applyMutation(describeEventTrackerRequest).build());
    }

    /**
     * <p>
     * Describes the given feature transformation.
     * </p>
     *
     * @param describeFeatureTransformationRequest
     * @return Result of the DescribeFeatureTransformation operation returned by the service.
     * @throws InvalidInputException
     *         Provide a valid value for the field or parameter.
     * @throws ResourceNotFoundException
     *         Could not find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeClient.DescribeFeatureTransformation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DescribeFeatureTransformation"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeFeatureTransformationResponse describeFeatureTransformation(
            DescribeFeatureTransformationRequest describeFeatureTransformationRequest) throws InvalidInputException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, PersonalizeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the given feature transformation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeFeatureTransformationRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeFeatureTransformationRequest#builder()}
     * </p>
     *
     * @param describeFeatureTransformationRequest
     *        A {@link Consumer} that will call methods on {@link DescribeFeatureTransformationRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeFeatureTransformation operation returned by the service.
     * @throws InvalidInputException
     *         Provide a valid value for the field or parameter.
     * @throws ResourceNotFoundException
     *         Could not find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeClient.DescribeFeatureTransformation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DescribeFeatureTransformation"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeFeatureTransformationResponse describeFeatureTransformation(
            Consumer<DescribeFeatureTransformationRequest.Builder> describeFeatureTransformationRequest)
            throws InvalidInputException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            PersonalizeException {
        return describeFeatureTransformation(DescribeFeatureTransformationRequest.builder()
                .applyMutation(describeFeatureTransformationRequest).build());
    }

    /**
     * <p>
     * Describes a filter's properties.
     * </p>
     *
     * @param describeFilterRequest
     * @return Result of the DescribeFilter operation returned by the service.
     * @throws InvalidInputException
     *         Provide a valid value for the field or parameter.
     * @throws ResourceNotFoundException
     *         Could not find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeClient.DescribeFilter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DescribeFilter" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeFilterResponse describeFilter(DescribeFilterRequest describeFilterRequest) throws InvalidInputException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, PersonalizeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes a filter's properties.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeFilterRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeFilterRequest#builder()}
     * </p>
     *
     * @param describeFilterRequest
     *        A {@link Consumer} that will call methods on {@link DescribeFilterRequest.Builder} to create a request.
     * @return Result of the DescribeFilter operation returned by the service.
     * @throws InvalidInputException
     *         Provide a valid value for the field or parameter.
     * @throws ResourceNotFoundException
     *         Could not find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeClient.DescribeFilter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DescribeFilter" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeFilterResponse describeFilter(Consumer<DescribeFilterRequest.Builder> describeFilterRequest)
            throws InvalidInputException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            PersonalizeException {
        return describeFilter(DescribeFilterRequest.builder().applyMutation(describeFilterRequest).build());
    }

    /**
     * <p>
     * Describes a recipe.
     * </p>
     * <p>
     * A recipe contains three items:
     * </p>
     * <ul>
     * <li>
     * <p>
     * An algorithm that trains a model.
     * </p>
     * </li>
     * <li>
     * <p>
     * Hyperparameters that govern the training.
     * </p>
     * </li>
     * <li>
     * <p>
     * Feature transformation information for modifying the input data before training.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Amazon Personalize provides a set of predefined recipes. You specify a recipe when you create a solution with the
     * <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSolution.html">CreateSolution</a> API.
     * <code>CreateSolution</code> trains a model by using the algorithm in the specified recipe and a training dataset.
     * The solution, when deployed as a campaign, can provide recommendations using the <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_RS_GetRecommendations.html">GetRecommendations</a>
     * API.
     * </p>
     *
     * @param describeRecipeRequest
     * @return Result of the DescribeRecipe operation returned by the service.
     * @throws InvalidInputException
     *         Provide a valid value for the field or parameter.
     * @throws ResourceNotFoundException
     *         Could not find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeClient.DescribeRecipe
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DescribeRecipe" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeRecipeResponse describeRecipe(DescribeRecipeRequest describeRecipeRequest) throws InvalidInputException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, PersonalizeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes a recipe.
     * </p>
     * <p>
     * A recipe contains three items:
     * </p>
     * <ul>
     * <li>
     * <p>
     * An algorithm that trains a model.
     * </p>
     * </li>
     * <li>
     * <p>
     * Hyperparameters that govern the training.
     * </p>
     * </li>
     * <li>
     * <p>
     * Feature transformation information for modifying the input data before training.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Amazon Personalize provides a set of predefined recipes. You specify a recipe when you create a solution with the
     * <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSolution.html">CreateSolution</a> API.
     * <code>CreateSolution</code> trains a model by using the algorithm in the specified recipe and a training dataset.
     * The solution, when deployed as a campaign, can provide recommendations using the <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_RS_GetRecommendations.html">GetRecommendations</a>
     * API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeRecipeRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeRecipeRequest#builder()}
     * </p>
     *
     * @param describeRecipeRequest
     *        A {@link Consumer} that will call methods on {@link DescribeRecipeRequest.Builder} to create a request.
     * @return Result of the DescribeRecipe operation returned by the service.
     * @throws InvalidInputException
     *         Provide a valid value for the field or parameter.
     * @throws ResourceNotFoundException
     *         Could not find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeClient.DescribeRecipe
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DescribeRecipe" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeRecipeResponse describeRecipe(Consumer<DescribeRecipeRequest.Builder> describeRecipeRequest)
            throws InvalidInputException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            PersonalizeException {
        return describeRecipe(DescribeRecipeRequest.builder().applyMutation(describeRecipeRequest).build());
    }

    /**
     * <p>
     * Describes the given recommender, including its status.
     * </p>
     * <p>
     * A recommender can be in one of the following states:
     * </p>
     * <ul>
     * <li>
     * <p>
     * CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED
     * </p>
     * </li>
     * <li>
     * <p>
     * DELETE PENDING &gt; DELETE IN_PROGRESS
     * </p>
     * </li>
     * </ul>
     * <p>
     * When the <code>status</code> is <code>CREATE FAILED</code>, the response includes the <code>failureReason</code>
     * key, which describes why.
     * </p>
     * <p>
     * For more information on recommenders, see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateRecommender.html">CreateRecommender</a>.
     * </p>
     *
     * @param describeRecommenderRequest
     * @return Result of the DescribeRecommender operation returned by the service.
     * @throws InvalidInputException
     *         Provide a valid value for the field or parameter.
     * @throws ResourceNotFoundException
     *         Could not find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeClient.DescribeRecommender
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DescribeRecommender"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeRecommenderResponse describeRecommender(DescribeRecommenderRequest describeRecommenderRequest)
            throws InvalidInputException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            PersonalizeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the given recommender, including its status.
     * </p>
     * <p>
     * A recommender can be in one of the following states:
     * </p>
     * <ul>
     * <li>
     * <p>
     * CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED
     * </p>
     * </li>
     * <li>
     * <p>
     * DELETE PENDING &gt; DELETE IN_PROGRESS
     * </p>
     * </li>
     * </ul>
     * <p>
     * When the <code>status</code> is <code>CREATE FAILED</code>, the response includes the <code>failureReason</code>
     * key, which describes why.
     * </p>
     * <p>
     * For more information on recommenders, see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateRecommender.html">CreateRecommender</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeRecommenderRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeRecommenderRequest#builder()}
     * </p>
     *
     * @param describeRecommenderRequest
     *        A {@link Consumer} that will call methods on {@link DescribeRecommenderRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeRecommender operation returned by the service.
     * @throws InvalidInputException
     *         Provide a valid value for the field or parameter.
     * @throws ResourceNotFoundException
     *         Could not find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeClient.DescribeRecommender
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DescribeRecommender"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeRecommenderResponse describeRecommender(
            Consumer<DescribeRecommenderRequest.Builder> describeRecommenderRequest) throws InvalidInputException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, PersonalizeException {
        return describeRecommender(DescribeRecommenderRequest.builder().applyMutation(describeRecommenderRequest).build());
    }

    /**
     * <p>
     * Describes a schema. For more information on schemas, see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSchema.html">CreateSchema</a>.
     * </p>
     *
     * @param describeSchemaRequest
     * @return Result of the DescribeSchema operation returned by the service.
     * @throws InvalidInputException
     *         Provide a valid value for the field or parameter.
     * @throws ResourceNotFoundException
     *         Could not find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeClient.DescribeSchema
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DescribeSchema" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeSchemaResponse describeSchema(DescribeSchemaRequest describeSchemaRequest) throws InvalidInputException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, PersonalizeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes a schema. For more information on schemas, see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSchema.html">CreateSchema</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeSchemaRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeSchemaRequest#builder()}
     * </p>
     *
     * @param describeSchemaRequest
     *        A {@link Consumer} that will call methods on {@link DescribeSchemaRequest.Builder} to create a request.
     * @return Result of the DescribeSchema operation returned by the service.
     * @throws InvalidInputException
     *         Provide a valid value for the field or parameter.
     * @throws ResourceNotFoundException
     *         Could not find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeClient.DescribeSchema
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DescribeSchema" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeSchemaResponse describeSchema(Consumer<DescribeSchemaRequest.Builder> describeSchemaRequest)
            throws InvalidInputException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            PersonalizeException {
        return describeSchema(DescribeSchemaRequest.builder().applyMutation(describeSchemaRequest).build());
    }

    /**
     * <p>
     * Describes a solution. For more information on solutions, see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSolution.html">CreateSolution</a>.
     * </p>
     *
     * @param describeSolutionRequest
     * @return Result of the DescribeSolution operation returned by the service.
     * @throws InvalidInputException
     *         Provide a valid value for the field or parameter.
     * @throws ResourceNotFoundException
     *         Could not find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeClient.DescribeSolution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DescribeSolution" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeSolutionResponse describeSolution(DescribeSolutionRequest describeSolutionRequest)
            throws InvalidInputException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            PersonalizeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes a solution. For more information on solutions, see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSolution.html">CreateSolution</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeSolutionRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeSolutionRequest#builder()}
     * </p>
     *
     * @param describeSolutionRequest
     *        A {@link Consumer} that will call methods on {@link DescribeSolutionRequest.Builder} to create a request.
     * @return Result of the DescribeSolution operation returned by the service.
     * @throws InvalidInputException
     *         Provide a valid value for the field or parameter.
     * @throws ResourceNotFoundException
     *         Could not find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeClient.DescribeSolution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DescribeSolution" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeSolutionResponse describeSolution(Consumer<DescribeSolutionRequest.Builder> describeSolutionRequest)
            throws InvalidInputException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            PersonalizeException {
        return describeSolution(DescribeSolutionRequest.builder().applyMutation(describeSolutionRequest).build());
    }

    /**
     * <p>
     * Describes a specific version of a solution. For more information on solutions, see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSolution.html">CreateSolution</a>
     * </p>
     *
     * @param describeSolutionVersionRequest
     * @return Result of the DescribeSolutionVersion operation returned by the service.
     * @throws InvalidInputException
     *         Provide a valid value for the field or parameter.
     * @throws ResourceNotFoundException
     *         Could not find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeClient.DescribeSolutionVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DescribeSolutionVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeSolutionVersionResponse describeSolutionVersion(DescribeSolutionVersionRequest describeSolutionVersionRequest)
            throws InvalidInputException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            PersonalizeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes a specific version of a solution. For more information on solutions, see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSolution.html">CreateSolution</a>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeSolutionVersionRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeSolutionVersionRequest#builder()}
     * </p>
     *
     * @param describeSolutionVersionRequest
     *        A {@link Consumer} that will call methods on {@link DescribeSolutionVersionRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeSolutionVersion operation returned by the service.
     * @throws InvalidInputException
     *         Provide a valid value for the field or parameter.
     * @throws ResourceNotFoundException
     *         Could not find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeClient.DescribeSolutionVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DescribeSolutionVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeSolutionVersionResponse describeSolutionVersion(
            Consumer<DescribeSolutionVersionRequest.Builder> describeSolutionVersionRequest) throws InvalidInputException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, PersonalizeException {
        return describeSolutionVersion(DescribeSolutionVersionRequest.builder().applyMutation(describeSolutionVersionRequest)
                .build());
    }

    /**
     * <p>
     * Gets the metrics for the specified solution version.
     * </p>
     *
     * @param getSolutionMetricsRequest
     * @return Result of the GetSolutionMetrics operation returned by the service.
     * @throws InvalidInputException
     *         Provide a valid value for the field or parameter.
     * @throws ResourceNotFoundException
     *         Could not find the specified resource.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeClient.GetSolutionMetrics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/GetSolutionMetrics"
     *      target="_top">AWS API Documentation</a>
     */
    default GetSolutionMetricsResponse getSolutionMetrics(GetSolutionMetricsRequest getSolutionMetricsRequest)
            throws InvalidInputException, ResourceNotFoundException, ResourceInUseException, AwsServiceException,
            SdkClientException, PersonalizeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the metrics for the specified solution version.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSolutionMetricsRequest.Builder} avoiding the
     * need to create one manually via {@link GetSolutionMetricsRequest#builder()}
     * </p>
     *
     * @param getSolutionMetricsRequest
     *        A {@link Consumer} that will call methods on {@link GetSolutionMetricsRequest.Builder} to create a
     *        request.
     * @return Result of the GetSolutionMetrics operation returned by the service.
     * @throws InvalidInputException
     *         Provide a valid value for the field or parameter.
     * @throws ResourceNotFoundException
     *         Could not find the specified resource.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeClient.GetSolutionMetrics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/GetSolutionMetrics"
     *      target="_top">AWS API Documentation</a>
     */
    default GetSolutionMetricsResponse getSolutionMetrics(Consumer<GetSolutionMetricsRequest.Builder> getSolutionMetricsRequest)
            throws InvalidInputException, ResourceNotFoundException, ResourceInUseException, AwsServiceException,
            SdkClientException, PersonalizeException {
        return getSolutionMetrics(GetSolutionMetricsRequest.builder().applyMutation(getSolutionMetricsRequest).build());
    }

    /**
     * <p>
     * Gets a list of the batch inference jobs that have been performed off of a solution version.
     * </p>
     *
     * @param listBatchInferenceJobsRequest
     * @return Result of the ListBatchInferenceJobs operation returned by the service.
     * @throws InvalidInputException
     *         Provide a valid value for the field or parameter.
     * @throws InvalidNextTokenException
     *         The token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeClient.ListBatchInferenceJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/ListBatchInferenceJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBatchInferenceJobsResponse listBatchInferenceJobs(ListBatchInferenceJobsRequest listBatchInferenceJobsRequest)
            throws InvalidInputException, InvalidNextTokenException, AwsServiceException, SdkClientException,
            PersonalizeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of the batch inference jobs that have been performed off of a solution version.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBatchInferenceJobsRequest.Builder} avoiding the
     * need to create one manually via {@link ListBatchInferenceJobsRequest#builder()}
     * </p>
     *
     * @param listBatchInferenceJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListBatchInferenceJobsRequest.Builder} to create a
     *        request.
     * @return Result of the ListBatchInferenceJobs operation returned by the service.
     * @throws InvalidInputException
     *         Provide a valid value for the field or parameter.
     * @throws InvalidNextTokenException
     *         The token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeClient.ListBatchInferenceJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/ListBatchInferenceJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBatchInferenceJobsResponse listBatchInferenceJobs(
            Consumer<ListBatchInferenceJobsRequest.Builder> listBatchInferenceJobsRequest) throws InvalidInputException,
            InvalidNextTokenException, AwsServiceException, SdkClientException, PersonalizeException {
        return listBatchInferenceJobs(ListBatchInferenceJobsRequest.builder().applyMutation(listBatchInferenceJobsRequest)
                .build());
    }

    /**
     * <p>
     * Gets a list of the batch inference jobs that have been performed off of a solution version.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listBatchInferenceJobs(software.amazon.awssdk.services.personalize.model.ListBatchInferenceJobsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.personalize.paginators.ListBatchInferenceJobsIterable responses = client.listBatchInferenceJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.personalize.paginators.ListBatchInferenceJobsIterable responses = client
     *             .listBatchInferenceJobsPaginator(request);
     *     for (software.amazon.awssdk.services.personalize.model.ListBatchInferenceJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.personalize.paginators.ListBatchInferenceJobsIterable responses = client.listBatchInferenceJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBatchInferenceJobs(software.amazon.awssdk.services.personalize.model.ListBatchInferenceJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listBatchInferenceJobsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidInputException
     *         Provide a valid value for the field or parameter.
     * @throws InvalidNextTokenException
     *         The token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeClient.ListBatchInferenceJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/ListBatchInferenceJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBatchInferenceJobsIterable listBatchInferenceJobsPaginator(
            ListBatchInferenceJobsRequest listBatchInferenceJobsRequest) throws InvalidInputException, InvalidNextTokenException,
            AwsServiceException, SdkClientException, PersonalizeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of the batch inference jobs that have been performed off of a solution version.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listBatchInferenceJobs(software.amazon.awssdk.services.personalize.model.ListBatchInferenceJobsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.personalize.paginators.ListBatchInferenceJobsIterable responses = client.listBatchInferenceJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.personalize.paginators.ListBatchInferenceJobsIterable responses = client
     *             .listBatchInferenceJobsPaginator(request);
     *     for (software.amazon.awssdk.services.personalize.model.ListBatchInferenceJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.personalize.paginators.ListBatchInferenceJobsIterable responses = client.listBatchInferenceJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBatchInferenceJobs(software.amazon.awssdk.services.personalize.model.ListBatchInferenceJobsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBatchInferenceJobsRequest.Builder} avoiding the
     * need to create one manually via {@link ListBatchInferenceJobsRequest#builder()}
     * </p>
     *
     * @param listBatchInferenceJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListBatchInferenceJobsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidInputException
     *         Provide a valid value for the field or parameter.
     * @throws InvalidNextTokenException
     *         The token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeClient.ListBatchInferenceJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/ListBatchInferenceJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBatchInferenceJobsIterable listBatchInferenceJobsPaginator(
            Consumer<ListBatchInferenceJobsRequest.Builder> listBatchInferenceJobsRequest) throws InvalidInputException,
            InvalidNextTokenException, AwsServiceException, SdkClientException, PersonalizeException {
        return listBatchInferenceJobsPaginator(ListBatchInferenceJobsRequest.builder()
                .applyMutation(listBatchInferenceJobsRequest).build());
    }

    /**
     * <p>
     * Gets a list of the batch segment jobs that have been performed off of a solution version that you specify.
     * </p>
     *
     * @param listBatchSegmentJobsRequest
     * @return Result of the ListBatchSegmentJobs operation returned by the service.
     * @throws InvalidInputException
     *         Provide a valid value for the field or parameter.
     * @throws InvalidNextTokenException
     *         The token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeClient.ListBatchSegmentJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/ListBatchSegmentJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBatchSegmentJobsResponse listBatchSegmentJobs(ListBatchSegmentJobsRequest listBatchSegmentJobsRequest)
            throws InvalidInputException, InvalidNextTokenException, AwsServiceException, SdkClientException,
            PersonalizeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of the batch segment jobs that have been performed off of a solution version that you specify.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBatchSegmentJobsRequest.Builder} avoiding the
     * need to create one manually via {@link ListBatchSegmentJobsRequest#builder()}
     * </p>
     *
     * @param listBatchSegmentJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListBatchSegmentJobsRequest.Builder} to create a
     *        request.
     * @return Result of the ListBatchSegmentJobs operation returned by the service.
     * @throws InvalidInputException
     *         Provide a valid value for the field or parameter.
     * @throws InvalidNextTokenException
     *         The token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeClient.ListBatchSegmentJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/ListBatchSegmentJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBatchSegmentJobsResponse listBatchSegmentJobs(
            Consumer<ListBatchSegmentJobsRequest.Builder> listBatchSegmentJobsRequest) throws InvalidInputException,
            InvalidNextTokenException, AwsServiceException, SdkClientException, PersonalizeException {
        return listBatchSegmentJobs(ListBatchSegmentJobsRequest.builder().applyMutation(listBatchSegmentJobsRequest).build());
    }

    /**
     * <p>
     * Gets a list of the batch segment jobs that have been performed off of a solution version that you specify.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listBatchSegmentJobs(software.amazon.awssdk.services.personalize.model.ListBatchSegmentJobsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.personalize.paginators.ListBatchSegmentJobsIterable responses = client.listBatchSegmentJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.personalize.paginators.ListBatchSegmentJobsIterable responses = client
     *             .listBatchSegmentJobsPaginator(request);
     *     for (software.amazon.awssdk.services.personalize.model.ListBatchSegmentJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.personalize.paginators.ListBatchSegmentJobsIterable responses = client.listBatchSegmentJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBatchSegmentJobs(software.amazon.awssdk.services.personalize.model.ListBatchSegmentJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listBatchSegmentJobsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidInputException
     *         Provide a valid value for the field or parameter.
     * @throws InvalidNextTokenException
     *         The token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeClient.ListBatchSegmentJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/ListBatchSegmentJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBatchSegmentJobsIterable listBatchSegmentJobsPaginator(ListBatchSegmentJobsRequest listBatchSegmentJobsRequest)
            throws InvalidInputException, InvalidNextTokenException, AwsServiceException, SdkClientException,
            PersonalizeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of the batch segment jobs that have been performed off of a solution version that you specify.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listBatchSegmentJobs(software.amazon.awssdk.services.personalize.model.ListBatchSegmentJobsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.personalize.paginators.ListBatchSegmentJobsIterable responses = client.listBatchSegmentJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.personalize.paginators.ListBatchSegmentJobsIterable responses = client
     *             .listBatchSegmentJobsPaginator(request);
     *     for (software.amazon.awssdk.services.personalize.model.ListBatchSegmentJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.personalize.paginators.ListBatchSegmentJobsIterable responses = client.listBatchSegmentJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBatchSegmentJobs(software.amazon.awssdk.services.personalize.model.ListBatchSegmentJobsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBatchSegmentJobsRequest.Builder} avoiding the
     * need to create one manually via {@link ListBatchSegmentJobsRequest#builder()}
     * </p>
     *
     * @param listBatchSegmentJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListBatchSegmentJobsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidInputException
     *         Provide a valid value for the field or parameter.
     * @throws InvalidNextTokenException
     *         The token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeClient.ListBatchSegmentJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/ListBatchSegmentJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBatchSegmentJobsIterable listBatchSegmentJobsPaginator(
            Consumer<ListBatchSegmentJobsRequest.Builder> listBatchSegmentJobsRequest) throws InvalidInputException,
            InvalidNextTokenException, AwsServiceException, SdkClientException, PersonalizeException {
        return listBatchSegmentJobsPaginator(ListBatchSegmentJobsRequest.builder().applyMutation(listBatchSegmentJobsRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of campaigns that use the given solution. When a solution is not specified, all the campaigns
     * associated with the account are listed. The response provides the properties for each campaign, including the
     * Amazon Resource Name (ARN). For more information on campaigns, see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateCampaign.html">CreateCampaign</a>.
     * </p>
     *
     * @param listCampaignsRequest
     * @return Result of the ListCampaigns operation returned by the service.
     * @throws InvalidInputException
     *         Provide a valid value for the field or parameter.
     * @throws InvalidNextTokenException
     *         The token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeClient.ListCampaigns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/ListCampaigns" target="_top">AWS API
     *      Documentation</a>
     */
    default ListCampaignsResponse listCampaigns(ListCampaignsRequest listCampaignsRequest) throws InvalidInputException,
            InvalidNextTokenException, AwsServiceException, SdkClientException, PersonalizeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of campaigns that use the given solution. When a solution is not specified, all the campaigns
     * associated with the account are listed. The response provides the properties for each campaign, including the
     * Amazon Resource Name (ARN). For more information on campaigns, see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateCampaign.html">CreateCampaign</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCampaignsRequest.Builder} avoiding the need to
     * create one manually via {@link ListCampaignsRequest#builder()}
     * </p>
     *
     * @param listCampaignsRequest
     *        A {@link Consumer} that will call methods on {@link ListCampaignsRequest.Builder} to create a request.
     * @return Result of the ListCampaigns operation returned by the service.
     * @throws InvalidInputException
     *         Provide a valid value for the field or parameter.
     * @throws InvalidNextTokenException
     *         The token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeClient.ListCampaigns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/ListCampaigns" target="_top">AWS API
     *      Documentation</a>
     */
    default ListCampaignsResponse listCampaigns(Consumer<ListCampaignsRequest.Builder> listCampaignsRequest)
            throws InvalidInputException, InvalidNextTokenException, AwsServiceException, SdkClientException,
            PersonalizeException {
        return listCampaigns(ListCampaignsRequest.builder().applyMutation(listCampaignsRequest).build());
    }

    /**
     * <p>
     * Returns a list of campaigns that use the given solution. When a solution is not specified, all the campaigns
     * associated with the account are listed. The response provides the properties for each campaign, including the
     * Amazon Resource Name (ARN). For more information on campaigns, see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateCampaign.html">CreateCampaign</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listCampaigns(software.amazon.awssdk.services.personalize.model.ListCampaignsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.personalize.paginators.ListCampaignsIterable responses = client.listCampaignsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.personalize.paginators.ListCampaignsIterable responses = client
     *             .listCampaignsPaginator(request);
     *     for (software.amazon.awssdk.services.personalize.model.ListCampaignsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.personalize.paginators.ListCampaignsIterable responses = client.listCampaignsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCampaigns(software.amazon.awssdk.services.personalize.model.ListCampaignsRequest)} operation.</b>
     * </p>
     *
     * @param listCampaignsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidInputException
     *         Provide a valid value for the field or parameter.
     * @throws InvalidNextTokenException
     *         The token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeClient.ListCampaigns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/ListCampaigns" target="_top">AWS API
     *      Documentation</a>
     */
    default ListCampaignsIterable listCampaignsPaginator(ListCampaignsRequest listCampaignsRequest) throws InvalidInputException,
            InvalidNextTokenException, AwsServiceException, SdkClientException, PersonalizeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of campaigns that use the given solution. When a solution is not specified, all the campaigns
     * associated with the account are listed. The response provides the properties for each campaign, including the
     * Amazon Resource Name (ARN). For more information on campaigns, see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateCampaign.html">CreateCampaign</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listCampaigns(software.amazon.awssdk.services.personalize.model.ListCampaignsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.personalize.paginators.ListCampaignsIterable responses = client.listCampaignsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.personalize.paginators.ListCampaignsIterable responses = client
     *             .listCampaignsPaginator(request);
     *     for (software.amazon.awssdk.services.personalize.model.ListCampaignsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.personalize.paginators.ListCampaignsIterable responses = client.listCampaignsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCampaigns(software.amazon.awssdk.services.personalize.model.ListCampaignsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCampaignsRequest.Builder} avoiding the need to
     * create one manually via {@link ListCampaignsRequest#builder()}
     * </p>
     *
     * @param listCampaignsRequest
     *        A {@link Consumer} that will call methods on {@link ListCampaignsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidInputException
     *         Provide a valid value for the field or parameter.
     * @throws InvalidNextTokenException
     *         The token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeClient.ListCampaigns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/ListCampaigns" target="_top">AWS API
     *      Documentation</a>
     */
    default ListCampaignsIterable listCampaignsPaginator(Consumer<ListCampaignsRequest.Builder> listCampaignsRequest)
            throws InvalidInputException, InvalidNextTokenException, AwsServiceException, SdkClientException,
            PersonalizeException {
        return listCampaignsPaginator(ListCampaignsRequest.builder().applyMutation(listCampaignsRequest).build());
    }

    /**
     * <p>
     * Returns a list of dataset export jobs that use the given dataset. When a dataset is not specified, all the
     * dataset export jobs associated with the account are listed. The response provides the properties for each dataset
     * export job, including the Amazon Resource Name (ARN). For more information on dataset export jobs, see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDatasetExportJob.html"
     * >CreateDatasetExportJob</a>. For more information on datasets, see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDataset.html">CreateDataset</a>.
     * </p>
     *
     * @param listDatasetExportJobsRequest
     * @return Result of the ListDatasetExportJobs operation returned by the service.
     * @throws InvalidInputException
     *         Provide a valid value for the field or parameter.
     * @throws InvalidNextTokenException
     *         The token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeClient.ListDatasetExportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/ListDatasetExportJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDatasetExportJobsResponse listDatasetExportJobs(ListDatasetExportJobsRequest listDatasetExportJobsRequest)
            throws InvalidInputException, InvalidNextTokenException, AwsServiceException, SdkClientException,
            PersonalizeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of dataset export jobs that use the given dataset. When a dataset is not specified, all the
     * dataset export jobs associated with the account are listed. The response provides the properties for each dataset
     * export job, including the Amazon Resource Name (ARN). For more information on dataset export jobs, see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDatasetExportJob.html"
     * >CreateDatasetExportJob</a>. For more information on datasets, see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDataset.html">CreateDataset</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDatasetExportJobsRequest.Builder} avoiding the
     * need to create one manually via {@link ListDatasetExportJobsRequest#builder()}
     * </p>
     *
     * @param listDatasetExportJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListDatasetExportJobsRequest.Builder} to create a
     *        request.
     * @return Result of the ListDatasetExportJobs operation returned by the service.
     * @throws InvalidInputException
     *         Provide a valid value for the field or parameter.
     * @throws InvalidNextTokenException
     *         The token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeClient.ListDatasetExportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/ListDatasetExportJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDatasetExportJobsResponse listDatasetExportJobs(
            Consumer<ListDatasetExportJobsRequest.Builder> listDatasetExportJobsRequest) throws InvalidInputException,
            InvalidNextTokenException, AwsServiceException, SdkClientException, PersonalizeException {
        return listDatasetExportJobs(ListDatasetExportJobsRequest.builder().applyMutation(listDatasetExportJobsRequest).build());
    }

    /**
     * <p>
     * Returns a list of dataset export jobs that use the given dataset. When a dataset is not specified, all the
     * dataset export jobs associated with the account are listed. The response provides the properties for each dataset
     * export job, including the Amazon Resource Name (ARN). For more information on dataset export jobs, see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDatasetExportJob.html"
     * >CreateDatasetExportJob</a>. For more information on datasets, see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDataset.html">CreateDataset</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDatasetExportJobs(software.amazon.awssdk.services.personalize.model.ListDatasetExportJobsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.personalize.paginators.ListDatasetExportJobsIterable responses = client.listDatasetExportJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.personalize.paginators.ListDatasetExportJobsIterable responses = client
     *             .listDatasetExportJobsPaginator(request);
     *     for (software.amazon.awssdk.services.personalize.model.ListDatasetExportJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.personalize.paginators.ListDatasetExportJobsIterable responses = client.listDatasetExportJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDatasetExportJobs(software.amazon.awssdk.services.personalize.model.ListDatasetExportJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDatasetExportJobsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidInputException
     *         Provide a valid value for the field or parameter.
     * @throws InvalidNextTokenException
     *         The token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeClient.ListDatasetExportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/ListDatasetExportJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDatasetExportJobsIterable listDatasetExportJobsPaginator(ListDatasetExportJobsRequest listDatasetExportJobsRequest)
            throws InvalidInputException, InvalidNextTokenException, AwsServiceException, SdkClientException,
            PersonalizeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of dataset export jobs that use the given dataset. When a dataset is not specified, all the
     * dataset export jobs associated with the account are listed. The response provides the properties for each dataset
     * export job, including the Amazon Resource Name (ARN). For more information on dataset export jobs, see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDatasetExportJob.html"
     * >CreateDatasetExportJob</a>. For more information on datasets, see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDataset.html">CreateDataset</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDatasetExportJobs(software.amazon.awssdk.services.personalize.model.ListDatasetExportJobsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.personalize.paginators.ListDatasetExportJobsIterable responses = client.listDatasetExportJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.personalize.paginators.ListDatasetExportJobsIterable responses = client
     *             .listDatasetExportJobsPaginator(request);
     *     for (software.amazon.awssdk.services.personalize.model.ListDatasetExportJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.personalize.paginators.ListDatasetExportJobsIterable responses = client.listDatasetExportJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDatasetExportJobs(software.amazon.awssdk.services.personalize.model.ListDatasetExportJobsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDatasetExportJobsRequest.Builder} avoiding the
     * need to create one manually via {@link ListDatasetExportJobsRequest#builder()}
     * </p>
     *
     * @param listDatasetExportJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListDatasetExportJobsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidInputException
     *         Provide a valid value for the field or parameter.
     * @throws InvalidNextTokenException
     *         The token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeClient.ListDatasetExportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/ListDatasetExportJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDatasetExportJobsIterable listDatasetExportJobsPaginator(
            Consumer<ListDatasetExportJobsRequest.Builder> listDatasetExportJobsRequest) throws InvalidInputException,
            InvalidNextTokenException, AwsServiceException, SdkClientException, PersonalizeException {
        return listDatasetExportJobsPaginator(ListDatasetExportJobsRequest.builder().applyMutation(listDatasetExportJobsRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of dataset groups. The response provides the properties for each dataset group, including the
     * Amazon Resource Name (ARN). For more information on dataset groups, see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDatasetGroup.html">CreateDatasetGroup</a>.
     * </p>
     *
     * @param listDatasetGroupsRequest
     * @return Result of the ListDatasetGroups operation returned by the service.
     * @throws InvalidNextTokenException
     *         The token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeClient.ListDatasetGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/ListDatasetGroups" target="_top">AWS
     *      API Documentation</a>
     */
    default ListDatasetGroupsResponse listDatasetGroups(ListDatasetGroupsRequest listDatasetGroupsRequest)
            throws InvalidNextTokenException, AwsServiceException, SdkClientException, PersonalizeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of dataset groups. The response provides the properties for each dataset group, including the
     * Amazon Resource Name (ARN). For more information on dataset groups, see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDatasetGroup.html">CreateDatasetGroup</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDatasetGroupsRequest.Builder} avoiding the need
     * to create one manually via {@link ListDatasetGroupsRequest#builder()}
     * </p>
     *
     * @param listDatasetGroupsRequest
     *        A {@link Consumer} that will call methods on {@link ListDatasetGroupsRequest.Builder} to create a request.
     * @return Result of the ListDatasetGroups operation returned by the service.
     * @throws InvalidNextTokenException
     *         The token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeClient.ListDatasetGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/ListDatasetGroups" target="_top">AWS
     *      API Documentation</a>
     */
    default ListDatasetGroupsResponse listDatasetGroups(Consumer<ListDatasetGroupsRequest.Builder> listDatasetGroupsRequest)
            throws InvalidNextTokenException, AwsServiceException, SdkClientException, PersonalizeException {
        return listDatasetGroups(ListDatasetGroupsRequest.builder().applyMutation(listDatasetGroupsRequest).build());
    }

    /**
     * <p>
     * Returns a list of dataset groups. The response provides the properties for each dataset group, including the
     * Amazon Resource Name (ARN). For more information on dataset groups, see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDatasetGroup.html">CreateDatasetGroup</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDatasetGroups(software.amazon.awssdk.services.personalize.model.ListDatasetGroupsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.personalize.paginators.ListDatasetGroupsIterable responses = client.listDatasetGroupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.personalize.paginators.ListDatasetGroupsIterable responses = client
     *             .listDatasetGroupsPaginator(request);
     *     for (software.amazon.awssdk.services.personalize.model.ListDatasetGroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.personalize.paginators.ListDatasetGroupsIterable responses = client.listDatasetGroupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDatasetGroups(software.amazon.awssdk.services.personalize.model.ListDatasetGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDatasetGroupsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidNextTokenException
     *         The token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeClient.ListDatasetGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/ListDatasetGroups" target="_top">AWS
     *      API Documentation</a>
     */
    default ListDatasetGroupsIterable listDatasetGroupsPaginator(ListDatasetGroupsRequest listDatasetGroupsRequest)
            throws InvalidNextTokenException, AwsServiceException, SdkClientException, PersonalizeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of dataset groups. The response provides the properties for each dataset group, including the
     * Amazon Resource Name (ARN). For more information on dataset groups, see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDatasetGroup.html">CreateDatasetGroup</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDatasetGroups(software.amazon.awssdk.services.personalize.model.ListDatasetGroupsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.personalize.paginators.ListDatasetGroupsIterable responses = client.listDatasetGroupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.personalize.paginators.ListDatasetGroupsIterable responses = client
     *             .listDatasetGroupsPaginator(request);
     *     for (software.amazon.awssdk.services.personalize.model.ListDatasetGroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.personalize.paginators.ListDatasetGroupsIterable responses = client.listDatasetGroupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDatasetGroups(software.amazon.awssdk.services.personalize.model.ListDatasetGroupsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDatasetGroupsRequest.Builder} avoiding the need
     * to create one manually via {@link ListDatasetGroupsRequest#builder()}
     * </p>
     *
     * @param listDatasetGroupsRequest
     *        A {@link Consumer} that will call methods on {@link ListDatasetGroupsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidNextTokenException
     *         The token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeClient.ListDatasetGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/ListDatasetGroups" target="_top">AWS
     *      API Documentation</a>
     */
    default ListDatasetGroupsIterable listDatasetGroupsPaginator(
            Consumer<ListDatasetGroupsRequest.Builder> listDatasetGroupsRequest) throws InvalidNextTokenException,
            AwsServiceException, SdkClientException, PersonalizeException {
        return listDatasetGroupsPaginator(ListDatasetGroupsRequest.builder().applyMutation(listDatasetGroupsRequest).build());
    }

    /**
     * <p>
     * Returns a list of dataset import jobs that use the given dataset. When a dataset is not specified, all the
     * dataset import jobs associated with the account are listed. The response provides the properties for each dataset
     * import job, including the Amazon Resource Name (ARN). For more information on dataset import jobs, see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDatasetImportJob.html"
     * >CreateDatasetImportJob</a>. For more information on datasets, see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDataset.html">CreateDataset</a>.
     * </p>
     *
     * @param listDatasetImportJobsRequest
     * @return Result of the ListDatasetImportJobs operation returned by the service.
     * @throws InvalidInputException
     *         Provide a valid value for the field or parameter.
     * @throws InvalidNextTokenException
     *         The token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeClient.ListDatasetImportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/ListDatasetImportJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDatasetImportJobsResponse listDatasetImportJobs(ListDatasetImportJobsRequest listDatasetImportJobsRequest)
            throws InvalidInputException, InvalidNextTokenException, AwsServiceException, SdkClientException,
            PersonalizeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of dataset import jobs that use the given dataset. When a dataset is not specified, all the
     * dataset import jobs associated with the account are listed. The response provides the properties for each dataset
     * import job, including the Amazon Resource Name (ARN). For more information on dataset import jobs, see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDatasetImportJob.html"
     * >CreateDatasetImportJob</a>. For more information on datasets, see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDataset.html">CreateDataset</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDatasetImportJobsRequest.Builder} avoiding the
     * need to create one manually via {@link ListDatasetImportJobsRequest#builder()}
     * </p>
     *
     * @param listDatasetImportJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListDatasetImportJobsRequest.Builder} to create a
     *        request.
     * @return Result of the ListDatasetImportJobs operation returned by the service.
     * @throws InvalidInputException
     *         Provide a valid value for the field or parameter.
     * @throws InvalidNextTokenException
     *         The token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeClient.ListDatasetImportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/ListDatasetImportJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDatasetImportJobsResponse listDatasetImportJobs(
            Consumer<ListDatasetImportJobsRequest.Builder> listDatasetImportJobsRequest) throws InvalidInputException,
            InvalidNextTokenException, AwsServiceException, SdkClientException, PersonalizeException {
        return listDatasetImportJobs(ListDatasetImportJobsRequest.builder().applyMutation(listDatasetImportJobsRequest).build());
    }

    /**
     * <p>
     * Returns a list of dataset import jobs that use the given dataset. When a dataset is not specified, all the
     * dataset import jobs associated with the account are listed. The response provides the properties for each dataset
     * import job, including the Amazon Resource Name (ARN). For more information on dataset import jobs, see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDatasetImportJob.html"
     * >CreateDatasetImportJob</a>. For more information on datasets, see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDataset.html">CreateDataset</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDatasetImportJobs(software.amazon.awssdk.services.personalize.model.ListDatasetImportJobsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.personalize.paginators.ListDatasetImportJobsIterable responses = client.listDatasetImportJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.personalize.paginators.ListDatasetImportJobsIterable responses = client
     *             .listDatasetImportJobsPaginator(request);
     *     for (software.amazon.awssdk.services.personalize.model.ListDatasetImportJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.personalize.paginators.ListDatasetImportJobsIterable responses = client.listDatasetImportJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDatasetImportJobs(software.amazon.awssdk.services.personalize.model.ListDatasetImportJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDatasetImportJobsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidInputException
     *         Provide a valid value for the field or parameter.
     * @throws InvalidNextTokenException
     *         The token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeClient.ListDatasetImportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/ListDatasetImportJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDatasetImportJobsIterable listDatasetImportJobsPaginator(ListDatasetImportJobsRequest listDatasetImportJobsRequest)
            throws InvalidInputException, InvalidNextTokenException, AwsServiceException, SdkClientException,
            PersonalizeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of dataset import jobs that use the given dataset. When a dataset is not specified, all the
     * dataset import jobs associated with the account are listed. The response provides the properties for each dataset
     * import job, including the Amazon Resource Name (ARN). For more information on dataset import jobs, see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDatasetImportJob.html"
     * >CreateDatasetImportJob</a>. For more information on datasets, see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDataset.html">CreateDataset</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDatasetImportJobs(software.amazon.awssdk.services.personalize.model.ListDatasetImportJobsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.personalize.paginators.ListDatasetImportJobsIterable responses = client.listDatasetImportJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.personalize.paginators.ListDatasetImportJobsIterable responses = client
     *             .listDatasetImportJobsPaginator(request);
     *     for (software.amazon.awssdk.services.personalize.model.ListDatasetImportJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.personalize.paginators.ListDatasetImportJobsIterable responses = client.listDatasetImportJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDatasetImportJobs(software.amazon.awssdk.services.personalize.model.ListDatasetImportJobsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDatasetImportJobsRequest.Builder} avoiding the
     * need to create one manually via {@link ListDatasetImportJobsRequest#builder()}
     * </p>
     *
     * @param listDatasetImportJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListDatasetImportJobsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidInputException
     *         Provide a valid value for the field or parameter.
     * @throws InvalidNextTokenException
     *         The token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeClient.ListDatasetImportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/ListDatasetImportJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDatasetImportJobsIterable listDatasetImportJobsPaginator(
            Consumer<ListDatasetImportJobsRequest.Builder> listDatasetImportJobsRequest) throws InvalidInputException,
            InvalidNextTokenException, AwsServiceException, SdkClientException, PersonalizeException {
        return listDatasetImportJobsPaginator(ListDatasetImportJobsRequest.builder().applyMutation(listDatasetImportJobsRequest)
                .build());
    }

    /**
     * <p>
     * Returns the list of datasets contained in the given dataset group. The response provides the properties for each
     * dataset, including the Amazon Resource Name (ARN). For more information on datasets, see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDataset.html">CreateDataset</a>.
     * </p>
     *
     * @param listDatasetsRequest
     * @return Result of the ListDatasets operation returned by the service.
     * @throws InvalidInputException
     *         Provide a valid value for the field or parameter.
     * @throws InvalidNextTokenException
     *         The token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeClient.ListDatasets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/ListDatasets" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDatasetsResponse listDatasets(ListDatasetsRequest listDatasetsRequest) throws InvalidInputException,
            InvalidNextTokenException, AwsServiceException, SdkClientException, PersonalizeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the list of datasets contained in the given dataset group. The response provides the properties for each
     * dataset, including the Amazon Resource Name (ARN). For more information on datasets, see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDataset.html">CreateDataset</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDatasetsRequest.Builder} avoiding the need to
     * create one manually via {@link ListDatasetsRequest#builder()}
     * </p>
     *
     * @param listDatasetsRequest
     *        A {@link Consumer} that will call methods on {@link ListDatasetsRequest.Builder} to create a request.
     * @return Result of the ListDatasets operation returned by the service.
     * @throws InvalidInputException
     *         Provide a valid value for the field or parameter.
     * @throws InvalidNextTokenException
     *         The token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeClient.ListDatasets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/ListDatasets" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDatasetsResponse listDatasets(Consumer<ListDatasetsRequest.Builder> listDatasetsRequest)
            throws InvalidInputException, InvalidNextTokenException, AwsServiceException, SdkClientException,
            PersonalizeException {
        return listDatasets(ListDatasetsRequest.builder().applyMutation(listDatasetsRequest).build());
    }

    /**
     * <p>
     * Returns the list of datasets contained in the given dataset group. The response provides the properties for each
     * dataset, including the Amazon Resource Name (ARN). For more information on datasets, see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDataset.html">CreateDataset</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listDatasets(software.amazon.awssdk.services.personalize.model.ListDatasetsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.personalize.paginators.ListDatasetsIterable responses = client.listDatasetsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.personalize.paginators.ListDatasetsIterable responses = client.listDatasetsPaginator(request);
     *     for (software.amazon.awssdk.services.personalize.model.ListDatasetsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.personalize.paginators.ListDatasetsIterable responses = client.listDatasetsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDatasets(software.amazon.awssdk.services.personalize.model.ListDatasetsRequest)} operation.</b>
     * </p>
     *
     * @param listDatasetsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidInputException
     *         Provide a valid value for the field or parameter.
     * @throws InvalidNextTokenException
     *         The token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeClient.ListDatasets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/ListDatasets" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDatasetsIterable listDatasetsPaginator(ListDatasetsRequest listDatasetsRequest) throws InvalidInputException,
            InvalidNextTokenException, AwsServiceException, SdkClientException, PersonalizeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the list of datasets contained in the given dataset group. The response provides the properties for each
     * dataset, including the Amazon Resource Name (ARN). For more information on datasets, see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDataset.html">CreateDataset</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listDatasets(software.amazon.awssdk.services.personalize.model.ListDatasetsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.personalize.paginators.ListDatasetsIterable responses = client.listDatasetsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.personalize.paginators.ListDatasetsIterable responses = client.listDatasetsPaginator(request);
     *     for (software.amazon.awssdk.services.personalize.model.ListDatasetsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.personalize.paginators.ListDatasetsIterable responses = client.listDatasetsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDatasets(software.amazon.awssdk.services.personalize.model.ListDatasetsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDatasetsRequest.Builder} avoiding the need to
     * create one manually via {@link ListDatasetsRequest#builder()}
     * </p>
     *
     * @param listDatasetsRequest
     *        A {@link Consumer} that will call methods on {@link ListDatasetsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidInputException
     *         Provide a valid value for the field or parameter.
     * @throws InvalidNextTokenException
     *         The token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeClient.ListDatasets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/ListDatasets" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDatasetsIterable listDatasetsPaginator(Consumer<ListDatasetsRequest.Builder> listDatasetsRequest)
            throws InvalidInputException, InvalidNextTokenException, AwsServiceException, SdkClientException,
            PersonalizeException {
        return listDatasetsPaginator(ListDatasetsRequest.builder().applyMutation(listDatasetsRequest).build());
    }

    /**
     * <p>
     * Returns the list of event trackers associated with the account. The response provides the properties for each
     * event tracker, including the Amazon Resource Name (ARN) and tracking ID. For more information on event trackers,
     * see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateEventTracker.html">CreateEventTracker</a>.
     * </p>
     *
     * @param listEventTrackersRequest
     * @return Result of the ListEventTrackers operation returned by the service.
     * @throws InvalidInputException
     *         Provide a valid value for the field or parameter.
     * @throws InvalidNextTokenException
     *         The token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeClient.ListEventTrackers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/ListEventTrackers" target="_top">AWS
     *      API Documentation</a>
     */
    default ListEventTrackersResponse listEventTrackers(ListEventTrackersRequest listEventTrackersRequest)
            throws InvalidInputException, InvalidNextTokenException, AwsServiceException, SdkClientException,
            PersonalizeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the list of event trackers associated with the account. The response provides the properties for each
     * event tracker, including the Amazon Resource Name (ARN) and tracking ID. For more information on event trackers,
     * see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateEventTracker.html">CreateEventTracker</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEventTrackersRequest.Builder} avoiding the need
     * to create one manually via {@link ListEventTrackersRequest#builder()}
     * </p>
     *
     * @param listEventTrackersRequest
     *        A {@link Consumer} that will call methods on {@link ListEventTrackersRequest.Builder} to create a request.
     * @return Result of the ListEventTrackers operation returned by the service.
     * @throws InvalidInputException
     *         Provide a valid value for the field or parameter.
     * @throws InvalidNextTokenException
     *         The token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeClient.ListEventTrackers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/ListEventTrackers" target="_top">AWS
     *      API Documentation</a>
     */
    default ListEventTrackersResponse listEventTrackers(Consumer<ListEventTrackersRequest.Builder> listEventTrackersRequest)
            throws InvalidInputException, InvalidNextTokenException, AwsServiceException, SdkClientException,
            PersonalizeException {
        return listEventTrackers(ListEventTrackersRequest.builder().applyMutation(listEventTrackersRequest).build());
    }

    /**
     * <p>
     * Returns the list of event trackers associated with the account. The response provides the properties for each
     * event tracker, including the Amazon Resource Name (ARN) and tracking ID. For more information on event trackers,
     * see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateEventTracker.html">CreateEventTracker</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listEventTrackers(software.amazon.awssdk.services.personalize.model.ListEventTrackersRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.personalize.paginators.ListEventTrackersIterable responses = client.listEventTrackersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.personalize.paginators.ListEventTrackersIterable responses = client
     *             .listEventTrackersPaginator(request);
     *     for (software.amazon.awssdk.services.personalize.model.ListEventTrackersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.personalize.paginators.ListEventTrackersIterable responses = client.listEventTrackersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEventTrackers(software.amazon.awssdk.services.personalize.model.ListEventTrackersRequest)}
     * operation.</b>
     * </p>
     *
     * @param listEventTrackersRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidInputException
     *         Provide a valid value for the field or parameter.
     * @throws InvalidNextTokenException
     *         The token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeClient.ListEventTrackers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/ListEventTrackers" target="_top">AWS
     *      API Documentation</a>
     */
    default ListEventTrackersIterable listEventTrackersPaginator(ListEventTrackersRequest listEventTrackersRequest)
            throws InvalidInputException, InvalidNextTokenException, AwsServiceException, SdkClientException,
            PersonalizeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the list of event trackers associated with the account. The response provides the properties for each
     * event tracker, including the Amazon Resource Name (ARN) and tracking ID. For more information on event trackers,
     * see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateEventTracker.html">CreateEventTracker</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listEventTrackers(software.amazon.awssdk.services.personalize.model.ListEventTrackersRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.personalize.paginators.ListEventTrackersIterable responses = client.listEventTrackersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.personalize.paginators.ListEventTrackersIterable responses = client
     *             .listEventTrackersPaginator(request);
     *     for (software.amazon.awssdk.services.personalize.model.ListEventTrackersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.personalize.paginators.ListEventTrackersIterable responses = client.listEventTrackersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEventTrackers(software.amazon.awssdk.services.personalize.model.ListEventTrackersRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEventTrackersRequest.Builder} avoiding the need
     * to create one manually via {@link ListEventTrackersRequest#builder()}
     * </p>
     *
     * @param listEventTrackersRequest
     *        A {@link Consumer} that will call methods on {@link ListEventTrackersRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidInputException
     *         Provide a valid value for the field or parameter.
     * @throws InvalidNextTokenException
     *         The token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeClient.ListEventTrackers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/ListEventTrackers" target="_top">AWS
     *      API Documentation</a>
     */
    default ListEventTrackersIterable listEventTrackersPaginator(
            Consumer<ListEventTrackersRequest.Builder> listEventTrackersRequest) throws InvalidInputException,
            InvalidNextTokenException, AwsServiceException, SdkClientException, PersonalizeException {
        return listEventTrackersPaginator(ListEventTrackersRequest.builder().applyMutation(listEventTrackersRequest).build());
    }

    /**
     * <p>
     * Lists all filters that belong to a given dataset group.
     * </p>
     *
     * @param listFiltersRequest
     * @return Result of the ListFilters operation returned by the service.
     * @throws InvalidInputException
     *         Provide a valid value for the field or parameter.
     * @throws InvalidNextTokenException
     *         The token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeClient.ListFilters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/ListFilters" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFiltersResponse listFilters(ListFiltersRequest listFiltersRequest) throws InvalidInputException,
            InvalidNextTokenException, AwsServiceException, SdkClientException, PersonalizeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all filters that belong to a given dataset group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFiltersRequest.Builder} avoiding the need to
     * create one manually via {@link ListFiltersRequest#builder()}
     * </p>
     *
     * @param listFiltersRequest
     *        A {@link Consumer} that will call methods on {@link ListFiltersRequest.Builder} to create a request.
     * @return Result of the ListFilters operation returned by the service.
     * @throws InvalidInputException
     *         Provide a valid value for the field or parameter.
     * @throws InvalidNextTokenException
     *         The token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeClient.ListFilters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/ListFilters" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFiltersResponse listFilters(Consumer<ListFiltersRequest.Builder> listFiltersRequest)
            throws InvalidInputException, InvalidNextTokenException, AwsServiceException, SdkClientException,
            PersonalizeException {
        return listFilters(ListFiltersRequest.builder().applyMutation(listFiltersRequest).build());
    }

    /**
     * <p>
     * Lists all filters that belong to a given dataset group.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listFilters(software.amazon.awssdk.services.personalize.model.ListFiltersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.personalize.paginators.ListFiltersIterable responses = client.listFiltersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.personalize.paginators.ListFiltersIterable responses = client.listFiltersPaginator(request);
     *     for (software.amazon.awssdk.services.personalize.model.ListFiltersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.personalize.paginators.ListFiltersIterable responses = client.listFiltersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFilters(software.amazon.awssdk.services.personalize.model.ListFiltersRequest)} operation.</b>
     * </p>
     *
     * @param listFiltersRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidInputException
     *         Provide a valid value for the field or parameter.
     * @throws InvalidNextTokenException
     *         The token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeClient.ListFilters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/ListFilters" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFiltersIterable listFiltersPaginator(ListFiltersRequest listFiltersRequest) throws InvalidInputException,
            InvalidNextTokenException, AwsServiceException, SdkClientException, PersonalizeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all filters that belong to a given dataset group.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listFilters(software.amazon.awssdk.services.personalize.model.ListFiltersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.personalize.paginators.ListFiltersIterable responses = client.listFiltersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.personalize.paginators.ListFiltersIterable responses = client.listFiltersPaginator(request);
     *     for (software.amazon.awssdk.services.personalize.model.ListFiltersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.personalize.paginators.ListFiltersIterable responses = client.listFiltersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFilters(software.amazon.awssdk.services.personalize.model.ListFiltersRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFiltersRequest.Builder} avoiding the need to
     * create one manually via {@link ListFiltersRequest#builder()}
     * </p>
     *
     * @param listFiltersRequest
     *        A {@link Consumer} that will call methods on {@link ListFiltersRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidInputException
     *         Provide a valid value for the field or parameter.
     * @throws InvalidNextTokenException
     *         The token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeClient.ListFilters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/ListFilters" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFiltersIterable listFiltersPaginator(Consumer<ListFiltersRequest.Builder> listFiltersRequest)
            throws InvalidInputException, InvalidNextTokenException, AwsServiceException, SdkClientException,
            PersonalizeException {
        return listFiltersPaginator(ListFiltersRequest.builder().applyMutation(listFiltersRequest).build());
    }

    /**
     * <p>
     * Returns a list of available recipes. The response provides the properties for each recipe, including the recipe's
     * Amazon Resource Name (ARN).
     * </p>
     *
     * @param listRecipesRequest
     * @return Result of the ListRecipes operation returned by the service.
     * @throws InvalidNextTokenException
     *         The token is not valid.
     * @throws InvalidInputException
     *         Provide a valid value for the field or parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeClient.ListRecipes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/ListRecipes" target="_top">AWS API
     *      Documentation</a>
     */
    default ListRecipesResponse listRecipes(ListRecipesRequest listRecipesRequest) throws InvalidNextTokenException,
            InvalidInputException, AwsServiceException, SdkClientException, PersonalizeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of available recipes. The response provides the properties for each recipe, including the recipe's
     * Amazon Resource Name (ARN).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRecipesRequest.Builder} avoiding the need to
     * create one manually via {@link ListRecipesRequest#builder()}
     * </p>
     *
     * @param listRecipesRequest
     *        A {@link Consumer} that will call methods on {@link ListRecipesRequest.Builder} to create a request.
     * @return Result of the ListRecipes operation returned by the service.
     * @throws InvalidNextTokenException
     *         The token is not valid.
     * @throws InvalidInputException
     *         Provide a valid value for the field or parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeClient.ListRecipes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/ListRecipes" target="_top">AWS API
     *      Documentation</a>
     */
    default ListRecipesResponse listRecipes(Consumer<ListRecipesRequest.Builder> listRecipesRequest)
            throws InvalidNextTokenException, InvalidInputException, AwsServiceException, SdkClientException,
            PersonalizeException {
        return listRecipes(ListRecipesRequest.builder().applyMutation(listRecipesRequest).build());
    }

    /**
     * <p>
     * Returns a list of available recipes. The response provides the properties for each recipe, including the recipe's
     * Amazon Resource Name (ARN).
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listRecipes(software.amazon.awssdk.services.personalize.model.ListRecipesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.personalize.paginators.ListRecipesIterable responses = client.listRecipesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.personalize.paginators.ListRecipesIterable responses = client.listRecipesPaginator(request);
     *     for (software.amazon.awssdk.services.personalize.model.ListRecipesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.personalize.paginators.ListRecipesIterable responses = client.listRecipesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRecipes(software.amazon.awssdk.services.personalize.model.ListRecipesRequest)} operation.</b>
     * </p>
     *
     * @param listRecipesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidNextTokenException
     *         The token is not valid.
     * @throws InvalidInputException
     *         Provide a valid value for the field or parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeClient.ListRecipes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/ListRecipes" target="_top">AWS API
     *      Documentation</a>
     */
    default ListRecipesIterable listRecipesPaginator(ListRecipesRequest listRecipesRequest) throws InvalidNextTokenException,
            InvalidInputException, AwsServiceException, SdkClientException, PersonalizeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of available recipes. The response provides the properties for each recipe, including the recipe's
     * Amazon Resource Name (ARN).
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listRecipes(software.amazon.awssdk.services.personalize.model.ListRecipesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.personalize.paginators.ListRecipesIterable responses = client.listRecipesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.personalize.paginators.ListRecipesIterable responses = client.listRecipesPaginator(request);
     *     for (software.amazon.awssdk.services.personalize.model.ListRecipesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.personalize.paginators.ListRecipesIterable responses = client.listRecipesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRecipes(software.amazon.awssdk.services.personalize.model.ListRecipesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRecipesRequest.Builder} avoiding the need to
     * create one manually via {@link ListRecipesRequest#builder()}
     * </p>
     *
     * @param listRecipesRequest
     *        A {@link Consumer} that will call methods on {@link ListRecipesRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidNextTokenException
     *         The token is not valid.
     * @throws InvalidInputException
     *         Provide a valid value for the field or parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeClient.ListRecipes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/ListRecipes" target="_top">AWS API
     *      Documentation</a>
     */
    default ListRecipesIterable listRecipesPaginator(Consumer<ListRecipesRequest.Builder> listRecipesRequest)
            throws InvalidNextTokenException, InvalidInputException, AwsServiceException, SdkClientException,
            PersonalizeException {
        return listRecipesPaginator(ListRecipesRequest.builder().applyMutation(listRecipesRequest).build());
    }

    /**
     * <p>
     * Returns a list of recommenders in a given Domain dataset group. When a Domain dataset group is not specified, all
     * the recommenders associated with the account are listed. The response provides the properties for each
     * recommender, including the Amazon Resource Name (ARN). For more information on recommenders, see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateRecommender.html">CreateRecommender</a>.
     * </p>
     *
     * @param listRecommendersRequest
     * @return Result of the ListRecommenders operation returned by the service.
     * @throws InvalidInputException
     *         Provide a valid value for the field or parameter.
     * @throws InvalidNextTokenException
     *         The token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeClient.ListRecommenders
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/ListRecommenders" target="_top">AWS
     *      API Documentation</a>
     */
    default ListRecommendersResponse listRecommenders(ListRecommendersRequest listRecommendersRequest)
            throws InvalidInputException, InvalidNextTokenException, AwsServiceException, SdkClientException,
            PersonalizeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of recommenders in a given Domain dataset group. When a Domain dataset group is not specified, all
     * the recommenders associated with the account are listed. The response provides the properties for each
     * recommender, including the Amazon Resource Name (ARN). For more information on recommenders, see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateRecommender.html">CreateRecommender</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRecommendersRequest.Builder} avoiding the need
     * to create one manually via {@link ListRecommendersRequest#builder()}
     * </p>
     *
     * @param listRecommendersRequest
     *        A {@link Consumer} that will call methods on {@link ListRecommendersRequest.Builder} to create a request.
     * @return Result of the ListRecommenders operation returned by the service.
     * @throws InvalidInputException
     *         Provide a valid value for the field or parameter.
     * @throws InvalidNextTokenException
     *         The token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeClient.ListRecommenders
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/ListRecommenders" target="_top">AWS
     *      API Documentation</a>
     */
    default ListRecommendersResponse listRecommenders(Consumer<ListRecommendersRequest.Builder> listRecommendersRequest)
            throws InvalidInputException, InvalidNextTokenException, AwsServiceException, SdkClientException,
            PersonalizeException {
        return listRecommenders(ListRecommendersRequest.builder().applyMutation(listRecommendersRequest).build());
    }

    /**
     * <p>
     * Returns a list of recommenders in a given Domain dataset group. When a Domain dataset group is not specified, all
     * the recommenders associated with the account are listed. The response provides the properties for each
     * recommender, including the Amazon Resource Name (ARN). For more information on recommenders, see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateRecommender.html">CreateRecommender</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listRecommenders(software.amazon.awssdk.services.personalize.model.ListRecommendersRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.personalize.paginators.ListRecommendersIterable responses = client.listRecommendersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.personalize.paginators.ListRecommendersIterable responses = client
     *             .listRecommendersPaginator(request);
     *     for (software.amazon.awssdk.services.personalize.model.ListRecommendersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.personalize.paginators.ListRecommendersIterable responses = client.listRecommendersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRecommenders(software.amazon.awssdk.services.personalize.model.ListRecommendersRequest)}
     * operation.</b>
     * </p>
     *
     * @param listRecommendersRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidInputException
     *         Provide a valid value for the field or parameter.
     * @throws InvalidNextTokenException
     *         The token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeClient.ListRecommenders
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/ListRecommenders" target="_top">AWS
     *      API Documentation</a>
     */
    default ListRecommendersIterable listRecommendersPaginator(ListRecommendersRequest listRecommendersRequest)
            throws InvalidInputException, InvalidNextTokenException, AwsServiceException, SdkClientException,
            PersonalizeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of recommenders in a given Domain dataset group. When a Domain dataset group is not specified, all
     * the recommenders associated with the account are listed. The response provides the properties for each
     * recommender, including the Amazon Resource Name (ARN). For more information on recommenders, see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateRecommender.html">CreateRecommender</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listRecommenders(software.amazon.awssdk.services.personalize.model.ListRecommendersRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.personalize.paginators.ListRecommendersIterable responses = client.listRecommendersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.personalize.paginators.ListRecommendersIterable responses = client
     *             .listRecommendersPaginator(request);
     *     for (software.amazon.awssdk.services.personalize.model.ListRecommendersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.personalize.paginators.ListRecommendersIterable responses = client.listRecommendersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRecommenders(software.amazon.awssdk.services.personalize.model.ListRecommendersRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRecommendersRequest.Builder} avoiding the need
     * to create one manually via {@link ListRecommendersRequest#builder()}
     * </p>
     *
     * @param listRecommendersRequest
     *        A {@link Consumer} that will call methods on {@link ListRecommendersRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidInputException
     *         Provide a valid value for the field or parameter.
     * @throws InvalidNextTokenException
     *         The token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeClient.ListRecommenders
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/ListRecommenders" target="_top">AWS
     *      API Documentation</a>
     */
    default ListRecommendersIterable listRecommendersPaginator(Consumer<ListRecommendersRequest.Builder> listRecommendersRequest)
            throws InvalidInputException, InvalidNextTokenException, AwsServiceException, SdkClientException,
            PersonalizeException {
        return listRecommendersPaginator(ListRecommendersRequest.builder().applyMutation(listRecommendersRequest).build());
    }

    /**
     * <p>
     * Returns the list of schemas associated with the account. The response provides the properties for each schema,
     * including the Amazon Resource Name (ARN). For more information on schemas, see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSchema.html">CreateSchema</a>.
     * </p>
     *
     * @param listSchemasRequest
     * @return Result of the ListSchemas operation returned by the service.
     * @throws InvalidNextTokenException
     *         The token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeClient.ListSchemas
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/ListSchemas" target="_top">AWS API
     *      Documentation</a>
     */
    default ListSchemasResponse listSchemas(ListSchemasRequest listSchemasRequest) throws InvalidNextTokenException,
            AwsServiceException, SdkClientException, PersonalizeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the list of schemas associated with the account. The response provides the properties for each schema,
     * including the Amazon Resource Name (ARN). For more information on schemas, see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSchema.html">CreateSchema</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSchemasRequest.Builder} avoiding the need to
     * create one manually via {@link ListSchemasRequest#builder()}
     * </p>
     *
     * @param listSchemasRequest
     *        A {@link Consumer} that will call methods on {@link ListSchemasRequest.Builder} to create a request.
     * @return Result of the ListSchemas operation returned by the service.
     * @throws InvalidNextTokenException
     *         The token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeClient.ListSchemas
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/ListSchemas" target="_top">AWS API
     *      Documentation</a>
     */
    default ListSchemasResponse listSchemas(Consumer<ListSchemasRequest.Builder> listSchemasRequest)
            throws InvalidNextTokenException, AwsServiceException, SdkClientException, PersonalizeException {
        return listSchemas(ListSchemasRequest.builder().applyMutation(listSchemasRequest).build());
    }

    /**
     * <p>
     * Returns the list of schemas associated with the account. The response provides the properties for each schema,
     * including the Amazon Resource Name (ARN). For more information on schemas, see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSchema.html">CreateSchema</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listSchemas(software.amazon.awssdk.services.personalize.model.ListSchemasRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.personalize.paginators.ListSchemasIterable responses = client.listSchemasPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.personalize.paginators.ListSchemasIterable responses = client.listSchemasPaginator(request);
     *     for (software.amazon.awssdk.services.personalize.model.ListSchemasResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.personalize.paginators.ListSchemasIterable responses = client.listSchemasPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSchemas(software.amazon.awssdk.services.personalize.model.ListSchemasRequest)} operation.</b>
     * </p>
     *
     * @param listSchemasRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidNextTokenException
     *         The token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeClient.ListSchemas
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/ListSchemas" target="_top">AWS API
     *      Documentation</a>
     */
    default ListSchemasIterable listSchemasPaginator(ListSchemasRequest listSchemasRequest) throws InvalidNextTokenException,
            AwsServiceException, SdkClientException, PersonalizeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the list of schemas associated with the account. The response provides the properties for each schema,
     * including the Amazon Resource Name (ARN). For more information on schemas, see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSchema.html">CreateSchema</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listSchemas(software.amazon.awssdk.services.personalize.model.ListSchemasRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.personalize.paginators.ListSchemasIterable responses = client.listSchemasPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.personalize.paginators.ListSchemasIterable responses = client.listSchemasPaginator(request);
     *     for (software.amazon.awssdk.services.personalize.model.ListSchemasResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.personalize.paginators.ListSchemasIterable responses = client.listSchemasPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSchemas(software.amazon.awssdk.services.personalize.model.ListSchemasRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSchemasRequest.Builder} avoiding the need to
     * create one manually via {@link ListSchemasRequest#builder()}
     * </p>
     *
     * @param listSchemasRequest
     *        A {@link Consumer} that will call methods on {@link ListSchemasRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidNextTokenException
     *         The token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeClient.ListSchemas
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/ListSchemas" target="_top">AWS API
     *      Documentation</a>
     */
    default ListSchemasIterable listSchemasPaginator(Consumer<ListSchemasRequest.Builder> listSchemasRequest)
            throws InvalidNextTokenException, AwsServiceException, SdkClientException, PersonalizeException {
        return listSchemasPaginator(ListSchemasRequest.builder().applyMutation(listSchemasRequest).build());
    }

    /**
     * <p>
     * Returns a list of solution versions for the given solution. When a solution is not specified, all the solution
     * versions associated with the account are listed. The response provides the properties for each solution version,
     * including the Amazon Resource Name (ARN).
     * </p>
     *
     * @param listSolutionVersionsRequest
     * @return Result of the ListSolutionVersions operation returned by the service.
     * @throws InvalidInputException
     *         Provide a valid value for the field or parameter.
     * @throws ResourceNotFoundException
     *         Could not find the specified resource.
     * @throws InvalidNextTokenException
     *         The token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeClient.ListSolutionVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/ListSolutionVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSolutionVersionsResponse listSolutionVersions(ListSolutionVersionsRequest listSolutionVersionsRequest)
            throws InvalidInputException, ResourceNotFoundException, InvalidNextTokenException, AwsServiceException,
            SdkClientException, PersonalizeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of solution versions for the given solution. When a solution is not specified, all the solution
     * versions associated with the account are listed. The response provides the properties for each solution version,
     * including the Amazon Resource Name (ARN).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSolutionVersionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListSolutionVersionsRequest#builder()}
     * </p>
     *
     * @param listSolutionVersionsRequest
     *        A {@link Consumer} that will call methods on {@link ListSolutionVersionsRequest.Builder} to create a
     *        request.
     * @return Result of the ListSolutionVersions operation returned by the service.
     * @throws InvalidInputException
     *         Provide a valid value for the field or parameter.
     * @throws ResourceNotFoundException
     *         Could not find the specified resource.
     * @throws InvalidNextTokenException
     *         The token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeClient.ListSolutionVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/ListSolutionVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSolutionVersionsResponse listSolutionVersions(
            Consumer<ListSolutionVersionsRequest.Builder> listSolutionVersionsRequest) throws InvalidInputException,
            ResourceNotFoundException, InvalidNextTokenException, AwsServiceException, SdkClientException, PersonalizeException {
        return listSolutionVersions(ListSolutionVersionsRequest.builder().applyMutation(listSolutionVersionsRequest).build());
    }

    /**
     * <p>
     * Returns a list of solution versions for the given solution. When a solution is not specified, all the solution
     * versions associated with the account are listed. The response provides the properties for each solution version,
     * including the Amazon Resource Name (ARN).
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSolutionVersions(software.amazon.awssdk.services.personalize.model.ListSolutionVersionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.personalize.paginators.ListSolutionVersionsIterable responses = client.listSolutionVersionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.personalize.paginators.ListSolutionVersionsIterable responses = client
     *             .listSolutionVersionsPaginator(request);
     *     for (software.amazon.awssdk.services.personalize.model.ListSolutionVersionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.personalize.paginators.ListSolutionVersionsIterable responses = client.listSolutionVersionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSolutionVersions(software.amazon.awssdk.services.personalize.model.ListSolutionVersionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listSolutionVersionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidInputException
     *         Provide a valid value for the field or parameter.
     * @throws ResourceNotFoundException
     *         Could not find the specified resource.
     * @throws InvalidNextTokenException
     *         The token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeClient.ListSolutionVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/ListSolutionVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSolutionVersionsIterable listSolutionVersionsPaginator(ListSolutionVersionsRequest listSolutionVersionsRequest)
            throws InvalidInputException, ResourceNotFoundException, InvalidNextTokenException, AwsServiceException,
            SdkClientException, PersonalizeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of solution versions for the given solution. When a solution is not specified, all the solution
     * versions associated with the account are listed. The response provides the properties for each solution version,
     * including the Amazon Resource Name (ARN).
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSolutionVersions(software.amazon.awssdk.services.personalize.model.ListSolutionVersionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.personalize.paginators.ListSolutionVersionsIterable responses = client.listSolutionVersionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.personalize.paginators.ListSolutionVersionsIterable responses = client
     *             .listSolutionVersionsPaginator(request);
     *     for (software.amazon.awssdk.services.personalize.model.ListSolutionVersionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.personalize.paginators.ListSolutionVersionsIterable responses = client.listSolutionVersionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSolutionVersions(software.amazon.awssdk.services.personalize.model.ListSolutionVersionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSolutionVersionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListSolutionVersionsRequest#builder()}
     * </p>
     *
     * @param listSolutionVersionsRequest
     *        A {@link Consumer} that will call methods on {@link ListSolutionVersionsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidInputException
     *         Provide a valid value for the field or parameter.
     * @throws ResourceNotFoundException
     *         Could not find the specified resource.
     * @throws InvalidNextTokenException
     *         The token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeClient.ListSolutionVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/ListSolutionVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSolutionVersionsIterable listSolutionVersionsPaginator(
            Consumer<ListSolutionVersionsRequest.Builder> listSolutionVersionsRequest) throws InvalidInputException,
            ResourceNotFoundException, InvalidNextTokenException, AwsServiceException, SdkClientException, PersonalizeException {
        return listSolutionVersionsPaginator(ListSolutionVersionsRequest.builder().applyMutation(listSolutionVersionsRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of solutions that use the given dataset group. When a dataset group is not specified, all the
     * solutions associated with the account are listed. The response provides the properties for each solution,
     * including the Amazon Resource Name (ARN). For more information on solutions, see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSolution.html">CreateSolution</a>.
     * </p>
     *
     * @param listSolutionsRequest
     * @return Result of the ListSolutions operation returned by the service.
     * @throws InvalidInputException
     *         Provide a valid value for the field or parameter.
     * @throws InvalidNextTokenException
     *         The token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeClient.ListSolutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/ListSolutions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListSolutionsResponse listSolutions(ListSolutionsRequest listSolutionsRequest) throws InvalidInputException,
            InvalidNextTokenException, AwsServiceException, SdkClientException, PersonalizeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of solutions that use the given dataset group. When a dataset group is not specified, all the
     * solutions associated with the account are listed. The response provides the properties for each solution,
     * including the Amazon Resource Name (ARN). For more information on solutions, see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSolution.html">CreateSolution</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSolutionsRequest.Builder} avoiding the need to
     * create one manually via {@link ListSolutionsRequest#builder()}
     * </p>
     *
     * @param listSolutionsRequest
     *        A {@link Consumer} that will call methods on {@link ListSolutionsRequest.Builder} to create a request.
     * @return Result of the ListSolutions operation returned by the service.
     * @throws InvalidInputException
     *         Provide a valid value for the field or parameter.
     * @throws InvalidNextTokenException
     *         The token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeClient.ListSolutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/ListSolutions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListSolutionsResponse listSolutions(Consumer<ListSolutionsRequest.Builder> listSolutionsRequest)
            throws InvalidInputException, InvalidNextTokenException, AwsServiceException, SdkClientException,
            PersonalizeException {
        return listSolutions(ListSolutionsRequest.builder().applyMutation(listSolutionsRequest).build());
    }

    /**
     * <p>
     * Returns a list of solutions that use the given dataset group. When a dataset group is not specified, all the
     * solutions associated with the account are listed. The response provides the properties for each solution,
     * including the Amazon Resource Name (ARN). For more information on solutions, see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSolution.html">CreateSolution</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSolutions(software.amazon.awssdk.services.personalize.model.ListSolutionsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.personalize.paginators.ListSolutionsIterable responses = client.listSolutionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.personalize.paginators.ListSolutionsIterable responses = client
     *             .listSolutionsPaginator(request);
     *     for (software.amazon.awssdk.services.personalize.model.ListSolutionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.personalize.paginators.ListSolutionsIterable responses = client.listSolutionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSolutions(software.amazon.awssdk.services.personalize.model.ListSolutionsRequest)} operation.</b>
     * </p>
     *
     * @param listSolutionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidInputException
     *         Provide a valid value for the field or parameter.
     * @throws InvalidNextTokenException
     *         The token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeClient.ListSolutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/ListSolutions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListSolutionsIterable listSolutionsPaginator(ListSolutionsRequest listSolutionsRequest) throws InvalidInputException,
            InvalidNextTokenException, AwsServiceException, SdkClientException, PersonalizeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of solutions that use the given dataset group. When a dataset group is not specified, all the
     * solutions associated with the account are listed. The response provides the properties for each solution,
     * including the Amazon Resource Name (ARN). For more information on solutions, see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSolution.html">CreateSolution</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSolutions(software.amazon.awssdk.services.personalize.model.ListSolutionsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.personalize.paginators.ListSolutionsIterable responses = client.listSolutionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.personalize.paginators.ListSolutionsIterable responses = client
     *             .listSolutionsPaginator(request);
     *     for (software.amazon.awssdk.services.personalize.model.ListSolutionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.personalize.paginators.ListSolutionsIterable responses = client.listSolutionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSolutions(software.amazon.awssdk.services.personalize.model.ListSolutionsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSolutionsRequest.Builder} avoiding the need to
     * create one manually via {@link ListSolutionsRequest#builder()}
     * </p>
     *
     * @param listSolutionsRequest
     *        A {@link Consumer} that will call methods on {@link ListSolutionsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidInputException
     *         Provide a valid value for the field or parameter.
     * @throws InvalidNextTokenException
     *         The token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeClient.ListSolutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/ListSolutions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListSolutionsIterable listSolutionsPaginator(Consumer<ListSolutionsRequest.Builder> listSolutionsRequest)
            throws InvalidInputException, InvalidNextTokenException, AwsServiceException, SdkClientException,
            PersonalizeException {
        return listSolutionsPaginator(ListSolutionsRequest.builder().applyMutation(listSolutionsRequest).build());
    }

    /**
     * <p>
     * Get a list of <a href="https://docs.aws.amazon.com/personalize/latest/dev/tagging-resources.html">tags</a>
     * attached to a resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws InvalidInputException
     *         Provide a valid value for the field or parameter.
     * @throws ResourceNotFoundException
     *         Could not find the specified resource.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws InvalidInputException, ResourceNotFoundException, ResourceInUseException, AwsServiceException,
            SdkClientException, PersonalizeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get a list of <a href="https://docs.aws.amazon.com/personalize/latest/dev/tagging-resources.html">tags</a>
     * attached to a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws InvalidInputException
     *         Provide a valid value for the field or parameter.
     * @throws ResourceNotFoundException
     *         Could not find the specified resource.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws InvalidInputException,
            ResourceNotFoundException, ResourceInUseException, AwsServiceException, SdkClientException, PersonalizeException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Stops creating a solution version that is in a state of CREATE_PENDING or CREATE IN_PROGRESS.
     * </p>
     * <p>
     * Depending on the current state of the solution version, the solution version state changes as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * CREATE_PENDING &gt; CREATE_STOPPED
     * </p>
     * <p>
     * or
     * </p>
     * </li>
     * <li>
     * <p>
     * CREATE_IN_PROGRESS &gt; CREATE_STOPPING &gt; CREATE_STOPPED
     * </p>
     * </li>
     * </ul>
     * <p>
     * You are billed for all of the training completed up until you stop the solution version creation. You cannot
     * resume creating a solution version once it has been stopped.
     * </p>
     *
     * @param stopSolutionVersionCreationRequest
     * @return Result of the StopSolutionVersionCreation operation returned by the service.
     * @throws InvalidInputException
     *         Provide a valid value for the field or parameter.
     * @throws ResourceNotFoundException
     *         Could not find the specified resource.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeClient.StopSolutionVersionCreation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/StopSolutionVersionCreation"
     *      target="_top">AWS API Documentation</a>
     */
    default StopSolutionVersionCreationResponse stopSolutionVersionCreation(
            StopSolutionVersionCreationRequest stopSolutionVersionCreationRequest) throws InvalidInputException,
            ResourceNotFoundException, ResourceInUseException, AwsServiceException, SdkClientException, PersonalizeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops creating a solution version that is in a state of CREATE_PENDING or CREATE IN_PROGRESS.
     * </p>
     * <p>
     * Depending on the current state of the solution version, the solution version state changes as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * CREATE_PENDING &gt; CREATE_STOPPED
     * </p>
     * <p>
     * or
     * </p>
     * </li>
     * <li>
     * <p>
     * CREATE_IN_PROGRESS &gt; CREATE_STOPPING &gt; CREATE_STOPPED
     * </p>
     * </li>
     * </ul>
     * <p>
     * You are billed for all of the training completed up until you stop the solution version creation. You cannot
     * resume creating a solution version once it has been stopped.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopSolutionVersionCreationRequest.Builder}
     * avoiding the need to create one manually via {@link StopSolutionVersionCreationRequest#builder()}
     * </p>
     *
     * @param stopSolutionVersionCreationRequest
     *        A {@link Consumer} that will call methods on {@link StopSolutionVersionCreationRequest.Builder} to create
     *        a request.
     * @return Result of the StopSolutionVersionCreation operation returned by the service.
     * @throws InvalidInputException
     *         Provide a valid value for the field or parameter.
     * @throws ResourceNotFoundException
     *         Could not find the specified resource.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeClient.StopSolutionVersionCreation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/StopSolutionVersionCreation"
     *      target="_top">AWS API Documentation</a>
     */
    default StopSolutionVersionCreationResponse stopSolutionVersionCreation(
            Consumer<StopSolutionVersionCreationRequest.Builder> stopSolutionVersionCreationRequest)
            throws InvalidInputException, ResourceNotFoundException, ResourceInUseException, AwsServiceException,
            SdkClientException, PersonalizeException {
        return stopSolutionVersionCreation(StopSolutionVersionCreationRequest.builder()
                .applyMutation(stopSolutionVersionCreationRequest).build());
    }

    /**
     * <p>
     * Add a list of tags to a resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws InvalidInputException
     *         Provide a valid value for the field or parameter.
     * @throws ResourceNotFoundException
     *         Could not find the specified resource.
     * @throws TooManyTagsException
     *         You have exceeded the maximum number of tags you can apply to this resource.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws LimitExceededException
     *         The limit on the number of requests per second has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws InvalidInputException,
            ResourceNotFoundException, TooManyTagsException, ResourceInUseException, LimitExceededException, AwsServiceException,
            SdkClientException, PersonalizeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Add a list of tags to a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request.
     * @return Result of the TagResource operation returned by the service.
     * @throws InvalidInputException
     *         Provide a valid value for the field or parameter.
     * @throws ResourceNotFoundException
     *         Could not find the specified resource.
     * @throws TooManyTagsException
     *         You have exceeded the maximum number of tags you can apply to this resource.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws LimitExceededException
     *         The limit on the number of requests per second has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest)
            throws InvalidInputException, ResourceNotFoundException, TooManyTagsException, ResourceInUseException,
            LimitExceededException, AwsServiceException, SdkClientException, PersonalizeException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Remove <a href="https://docs.aws.amazon.com/personalize/latest/dev/tagging-resources.html">tags</a> that are
     * attached to a resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws InvalidInputException
     *         Provide a valid value for the field or parameter.
     * @throws ResourceNotFoundException
     *         Could not find the specified resource.
     * @throws TooManyTagKeysException
     *         The request contains more tag keys than can be associated with a resource (50 tag keys per resource).
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws InvalidInputException,
            ResourceNotFoundException, TooManyTagKeysException, ResourceInUseException, AwsServiceException, SdkClientException,
            PersonalizeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Remove <a href="https://docs.aws.amazon.com/personalize/latest/dev/tagging-resources.html">tags</a> that are
     * attached to a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws InvalidInputException
     *         Provide a valid value for the field or parameter.
     * @throws ResourceNotFoundException
     *         Could not find the specified resource.
     * @throws TooManyTagKeysException
     *         The request contains more tag keys than can be associated with a resource (50 tag keys per resource).
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws InvalidInputException, ResourceNotFoundException, TooManyTagKeysException, ResourceInUseException,
            AwsServiceException, SdkClientException, PersonalizeException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates a campaign by either deploying a new solution or changing the value of the campaign's
     * <code>minProvisionedTPS</code> parameter.
     * </p>
     * <p>
     * To update a campaign, the campaign status must be ACTIVE or CREATE FAILED. Check the campaign status using the <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeCampaign.html">DescribeCampaign</a>
     * operation.
     * </p>
     * <note>
     * <p>
     * You must wait until the <code>status</code> of the updated campaign is <code>ACTIVE</code> before asking the
     * campaign for recommendations.
     * </p>
     * </note>
     * <p>
     * For more information on campaigns, see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateCampaign.html">CreateCampaign</a>.
     * </p>
     *
     * @param updateCampaignRequest
     * @return Result of the UpdateCampaign operation returned by the service.
     * @throws InvalidInputException
     *         Provide a valid value for the field or parameter.
     * @throws ResourceNotFoundException
     *         Could not find the specified resource.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeClient.UpdateCampaign
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/UpdateCampaign" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateCampaignResponse updateCampaign(UpdateCampaignRequest updateCampaignRequest) throws InvalidInputException,
            ResourceNotFoundException, ResourceInUseException, AwsServiceException, SdkClientException, PersonalizeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a campaign by either deploying a new solution or changing the value of the campaign's
     * <code>minProvisionedTPS</code> parameter.
     * </p>
     * <p>
     * To update a campaign, the campaign status must be ACTIVE or CREATE FAILED. Check the campaign status using the <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeCampaign.html">DescribeCampaign</a>
     * operation.
     * </p>
     * <note>
     * <p>
     * You must wait until the <code>status</code> of the updated campaign is <code>ACTIVE</code> before asking the
     * campaign for recommendations.
     * </p>
     * </note>
     * <p>
     * For more information on campaigns, see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateCampaign.html">CreateCampaign</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateCampaignRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateCampaignRequest#builder()}
     * </p>
     *
     * @param updateCampaignRequest
     *        A {@link Consumer} that will call methods on {@link UpdateCampaignRequest.Builder} to create a request.
     * @return Result of the UpdateCampaign operation returned by the service.
     * @throws InvalidInputException
     *         Provide a valid value for the field or parameter.
     * @throws ResourceNotFoundException
     *         Could not find the specified resource.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeClient.UpdateCampaign
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/UpdateCampaign" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateCampaignResponse updateCampaign(Consumer<UpdateCampaignRequest.Builder> updateCampaignRequest)
            throws InvalidInputException, ResourceNotFoundException, ResourceInUseException, AwsServiceException,
            SdkClientException, PersonalizeException {
        return updateCampaign(UpdateCampaignRequest.builder().applyMutation(updateCampaignRequest).build());
    }

    /**
     * <p>
     * Updates the recommender to modify the recommender configuration.
     * </p>
     *
     * @param updateRecommenderRequest
     * @return Result of the UpdateRecommender operation returned by the service.
     * @throws InvalidInputException
     *         Provide a valid value for the field or parameter.
     * @throws ResourceNotFoundException
     *         Could not find the specified resource.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeClient.UpdateRecommender
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/UpdateRecommender" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateRecommenderResponse updateRecommender(UpdateRecommenderRequest updateRecommenderRequest)
            throws InvalidInputException, ResourceNotFoundException, ResourceInUseException, AwsServiceException,
            SdkClientException, PersonalizeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the recommender to modify the recommender configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateRecommenderRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateRecommenderRequest#builder()}
     * </p>
     *
     * @param updateRecommenderRequest
     *        A {@link Consumer} that will call methods on {@link UpdateRecommenderRequest.Builder} to create a request.
     * @return Result of the UpdateRecommender operation returned by the service.
     * @throws InvalidInputException
     *         Provide a valid value for the field or parameter.
     * @throws ResourceNotFoundException
     *         Could not find the specified resource.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeClient.UpdateRecommender
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/UpdateRecommender" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateRecommenderResponse updateRecommender(Consumer<UpdateRecommenderRequest.Builder> updateRecommenderRequest)
            throws InvalidInputException, ResourceNotFoundException, ResourceInUseException, AwsServiceException,
            SdkClientException, PersonalizeException {
        return updateRecommender(UpdateRecommenderRequest.builder().applyMutation(updateRecommenderRequest).build());
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }
}
