/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.personalize.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The output configuration parameters of a dataset export job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DatasetExportJobOutput implements SdkPojo, Serializable,
        ToCopyableBuilder<DatasetExportJobOutput.Builder, DatasetExportJobOutput> {
    private static final SdkField<S3DataConfig> S3_DATA_DESTINATION_FIELD = SdkField
            .<S3DataConfig> builder(MarshallingType.SDK_POJO).memberName("s3DataDestination")
            .getter(getter(DatasetExportJobOutput::s3DataDestination)).setter(setter(Builder::s3DataDestination))
            .constructor(S3DataConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3DataDestination").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_DATA_DESTINATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final S3DataConfig s3DataDestination;

    private DatasetExportJobOutput(BuilderImpl builder) {
        this.s3DataDestination = builder.s3DataDestination;
    }

    /**
     * Returns the value of the S3DataDestination property for this object.
     * 
     * @return The value of the S3DataDestination property for this object.
     */
    public final S3DataConfig s3DataDestination() {
        return s3DataDestination;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(s3DataDestination());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DatasetExportJobOutput)) {
            return false;
        }
        DatasetExportJobOutput other = (DatasetExportJobOutput) obj;
        return Objects.equals(s3DataDestination(), other.s3DataDestination());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DatasetExportJobOutput").add("S3DataDestination", s3DataDestination()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "s3DataDestination":
            return Optional.ofNullable(clazz.cast(s3DataDestination()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DatasetExportJobOutput, T> g) {
        return obj -> g.apply((DatasetExportJobOutput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DatasetExportJobOutput> {
        /**
         * Sets the value of the S3DataDestination property for this object.
         *
         * @param s3DataDestination
         *        The new value for the S3DataDestination property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3DataDestination(S3DataConfig s3DataDestination);

        /**
         * Sets the value of the S3DataDestination property for this object.
         *
         * This is a convenience method that creates an instance of the {@link S3DataConfig.Builder} avoiding the need
         * to create one manually via {@link S3DataConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link S3DataConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #s3DataDestination(S3DataConfig)}.
         * 
         * @param s3DataDestination
         *        a consumer that will call methods on {@link S3DataConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3DataDestination(S3DataConfig)
         */
        default Builder s3DataDestination(Consumer<S3DataConfig.Builder> s3DataDestination) {
            return s3DataDestination(S3DataConfig.builder().applyMutation(s3DataDestination).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private S3DataConfig s3DataDestination;

        private BuilderImpl() {
        }

        private BuilderImpl(DatasetExportJobOutput model) {
            s3DataDestination(model.s3DataDestination);
        }

        public final S3DataConfig.Builder getS3DataDestination() {
            return s3DataDestination != null ? s3DataDestination.toBuilder() : null;
        }

        public final void setS3DataDestination(S3DataConfig.BuilderImpl s3DataDestination) {
            this.s3DataDestination = s3DataDestination != null ? s3DataDestination.build() : null;
        }

        @Override
        public final Builder s3DataDestination(S3DataConfig s3DataDestination) {
            this.s3DataDestination = s3DataDestination;
            return this;
        }

        @Override
        public DatasetExportJobOutput build() {
            return new DatasetExportJobOutput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
