/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.personalize.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateRecommenderRequest extends PersonalizeRequest implements
        ToCopyableBuilder<UpdateRecommenderRequest.Builder, UpdateRecommenderRequest> {
    private static final SdkField<String> RECOMMENDER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("recommenderArn").getter(getter(UpdateRecommenderRequest::recommenderArn))
            .setter(setter(Builder::recommenderArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommenderArn").build()).build();

    private static final SdkField<RecommenderConfig> RECOMMENDER_CONFIG_FIELD = SdkField
            .<RecommenderConfig> builder(MarshallingType.SDK_POJO).memberName("recommenderConfig")
            .getter(getter(UpdateRecommenderRequest::recommenderConfig)).setter(setter(Builder::recommenderConfig))
            .constructor(RecommenderConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommenderConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECOMMENDER_ARN_FIELD,
            RECOMMENDER_CONFIG_FIELD));

    private final String recommenderArn;

    private final RecommenderConfig recommenderConfig;

    private UpdateRecommenderRequest(BuilderImpl builder) {
        super(builder);
        this.recommenderArn = builder.recommenderArn;
        this.recommenderConfig = builder.recommenderConfig;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the recommender to modify.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the recommender to modify.
     */
    public final String recommenderArn() {
        return recommenderArn;
    }

    /**
     * <p>
     * The configuration details of the recommender.
     * </p>
     * 
     * @return The configuration details of the recommender.
     */
    public final RecommenderConfig recommenderConfig() {
        return recommenderConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(recommenderArn());
        hashCode = 31 * hashCode + Objects.hashCode(recommenderConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateRecommenderRequest)) {
            return false;
        }
        UpdateRecommenderRequest other = (UpdateRecommenderRequest) obj;
        return Objects.equals(recommenderArn(), other.recommenderArn())
                && Objects.equals(recommenderConfig(), other.recommenderConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateRecommenderRequest").add("RecommenderArn", recommenderArn())
                .add("RecommenderConfig", recommenderConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "recommenderArn":
            return Optional.ofNullable(clazz.cast(recommenderArn()));
        case "recommenderConfig":
            return Optional.ofNullable(clazz.cast(recommenderConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateRecommenderRequest, T> g) {
        return obj -> g.apply((UpdateRecommenderRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PersonalizeRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateRecommenderRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the recommender to modify.
         * </p>
         * 
         * @param recommenderArn
         *        The Amazon Resource Name (ARN) of the recommender to modify.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recommenderArn(String recommenderArn);

        /**
         * <p>
         * The configuration details of the recommender.
         * </p>
         * 
         * @param recommenderConfig
         *        The configuration details of the recommender.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recommenderConfig(RecommenderConfig recommenderConfig);

        /**
         * <p>
         * The configuration details of the recommender.
         * </p>
         * This is a convenience method that creates an instance of the {@link RecommenderConfig.Builder} avoiding the
         * need to create one manually via {@link RecommenderConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link RecommenderConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #recommenderConfig(RecommenderConfig)}.
         * 
         * @param recommenderConfig
         *        a consumer that will call methods on {@link RecommenderConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #recommenderConfig(RecommenderConfig)
         */
        default Builder recommenderConfig(Consumer<RecommenderConfig.Builder> recommenderConfig) {
            return recommenderConfig(RecommenderConfig.builder().applyMutation(recommenderConfig).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PersonalizeRequest.BuilderImpl implements Builder {
        private String recommenderArn;

        private RecommenderConfig recommenderConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateRecommenderRequest model) {
            super(model);
            recommenderArn(model.recommenderArn);
            recommenderConfig(model.recommenderConfig);
        }

        public final String getRecommenderArn() {
            return recommenderArn;
        }

        public final void setRecommenderArn(String recommenderArn) {
            this.recommenderArn = recommenderArn;
        }

        @Override
        public final Builder recommenderArn(String recommenderArn) {
            this.recommenderArn = recommenderArn;
            return this;
        }

        public final RecommenderConfig.Builder getRecommenderConfig() {
            return recommenderConfig != null ? recommenderConfig.toBuilder() : null;
        }

        public final void setRecommenderConfig(RecommenderConfig.BuilderImpl recommenderConfig) {
            this.recommenderConfig = recommenderConfig != null ? recommenderConfig.build() : null;
        }

        @Override
        public final Builder recommenderConfig(RecommenderConfig recommenderConfig) {
            this.recommenderConfig = recommenderConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateRecommenderRequest build() {
            return new UpdateRecommenderRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
