/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.personalize.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListBatchInferenceJobsResponse extends PersonalizeResponse implements
        ToCopyableBuilder<ListBatchInferenceJobsResponse.Builder, ListBatchInferenceJobsResponse> {
    private static final SdkField<List<BatchInferenceJobSummary>> BATCH_INFERENCE_JOBS_FIELD = SdkField
            .<List<BatchInferenceJobSummary>> builder(MarshallingType.LIST)
            .memberName("batchInferenceJobs")
            .getter(getter(ListBatchInferenceJobsResponse::batchInferenceJobs))
            .setter(setter(Builder::batchInferenceJobs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("batchInferenceJobs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BatchInferenceJobSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(BatchInferenceJobSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListBatchInferenceJobsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BATCH_INFERENCE_JOBS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<BatchInferenceJobSummary> batchInferenceJobs;

    private final String nextToken;

    private ListBatchInferenceJobsResponse(BuilderImpl builder) {
        super(builder);
        this.batchInferenceJobs = builder.batchInferenceJobs;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the BatchInferenceJobs property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasBatchInferenceJobs() {
        return batchInferenceJobs != null && !(batchInferenceJobs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list containing information on each job that is returned.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBatchInferenceJobs} method.
     * </p>
     * 
     * @return A list containing information on each job that is returned.
     */
    public final List<BatchInferenceJobSummary> batchInferenceJobs() {
        return batchInferenceJobs;
    }

    /**
     * <p>
     * The token to use to retrieve the next page of results. The value is <code>null</code> when there are no more
     * results to return.
     * </p>
     * 
     * @return The token to use to retrieve the next page of results. The value is <code>null</code> when there are no
     *         more results to return.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasBatchInferenceJobs() ? batchInferenceJobs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBatchInferenceJobsResponse)) {
            return false;
        }
        ListBatchInferenceJobsResponse other = (ListBatchInferenceJobsResponse) obj;
        return hasBatchInferenceJobs() == other.hasBatchInferenceJobs()
                && Objects.equals(batchInferenceJobs(), other.batchInferenceJobs())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListBatchInferenceJobsResponse")
                .add("BatchInferenceJobs", hasBatchInferenceJobs() ? batchInferenceJobs() : null).add("NextToken", nextToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "batchInferenceJobs":
            return Optional.ofNullable(clazz.cast(batchInferenceJobs()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListBatchInferenceJobsResponse, T> g) {
        return obj -> g.apply((ListBatchInferenceJobsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PersonalizeResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListBatchInferenceJobsResponse> {
        /**
         * <p>
         * A list containing information on each job that is returned.
         * </p>
         * 
         * @param batchInferenceJobs
         *        A list containing information on each job that is returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder batchInferenceJobs(Collection<BatchInferenceJobSummary> batchInferenceJobs);

        /**
         * <p>
         * A list containing information on each job that is returned.
         * </p>
         * 
         * @param batchInferenceJobs
         *        A list containing information on each job that is returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder batchInferenceJobs(BatchInferenceJobSummary... batchInferenceJobs);

        /**
         * <p>
         * A list containing information on each job that is returned.
         * </p>
         * This is a convenience that creates an instance of the {@link List<BatchInferenceJobSummary>.Builder} avoiding
         * the need to create one manually via {@link List<BatchInferenceJobSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<BatchInferenceJobSummary>.Builder#build()} is called
         * immediately and its result is passed to {@link #batchInferenceJobs(List<BatchInferenceJobSummary>)}.
         * 
         * @param batchInferenceJobs
         *        a consumer that will call methods on {@link List<BatchInferenceJobSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #batchInferenceJobs(List<BatchInferenceJobSummary>)
         */
        Builder batchInferenceJobs(Consumer<BatchInferenceJobSummary.Builder>... batchInferenceJobs);

        /**
         * <p>
         * The token to use to retrieve the next page of results. The value is <code>null</code> when there are no more
         * results to return.
         * </p>
         * 
         * @param nextToken
         *        The token to use to retrieve the next page of results. The value is <code>null</code> when there are
         *        no more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends PersonalizeResponse.BuilderImpl implements Builder {
        private List<BatchInferenceJobSummary> batchInferenceJobs = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListBatchInferenceJobsResponse model) {
            super(model);
            batchInferenceJobs(model.batchInferenceJobs);
            nextToken(model.nextToken);
        }

        public final List<BatchInferenceJobSummary.Builder> getBatchInferenceJobs() {
            List<BatchInferenceJobSummary.Builder> result = BatchInferenceJobsCopier.copyToBuilder(this.batchInferenceJobs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBatchInferenceJobs(Collection<BatchInferenceJobSummary.BuilderImpl> batchInferenceJobs) {
            this.batchInferenceJobs = BatchInferenceJobsCopier.copyFromBuilder(batchInferenceJobs);
        }

        @Override
        @Transient
        public final Builder batchInferenceJobs(Collection<BatchInferenceJobSummary> batchInferenceJobs) {
            this.batchInferenceJobs = BatchInferenceJobsCopier.copy(batchInferenceJobs);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder batchInferenceJobs(BatchInferenceJobSummary... batchInferenceJobs) {
            batchInferenceJobs(Arrays.asList(batchInferenceJobs));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder batchInferenceJobs(Consumer<BatchInferenceJobSummary.Builder>... batchInferenceJobs) {
            batchInferenceJobs(Stream.of(batchInferenceJobs)
                    .map(c -> BatchInferenceJobSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListBatchInferenceJobsResponse build() {
            return new ListBatchInferenceJobsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
