/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.personalize.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeRecipeResponse extends PersonalizeResponse implements
        ToCopyableBuilder<DescribeRecipeResponse.Builder, DescribeRecipeResponse> {
    private static final SdkField<Recipe> RECIPE_FIELD = SdkField.<Recipe> builder(MarshallingType.SDK_POJO).memberName("recipe")
            .getter(getter(DescribeRecipeResponse::recipe)).setter(setter(Builder::recipe)).constructor(Recipe::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recipe").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECIPE_FIELD));

    private final Recipe recipe;

    private DescribeRecipeResponse(BuilderImpl builder) {
        super(builder);
        this.recipe = builder.recipe;
    }

    /**
     * <p>
     * An object that describes the recipe.
     * </p>
     * 
     * @return An object that describes the recipe.
     */
    public final Recipe recipe() {
        return recipe;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(recipe());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeRecipeResponse)) {
            return false;
        }
        DescribeRecipeResponse other = (DescribeRecipeResponse) obj;
        return Objects.equals(recipe(), other.recipe());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeRecipeResponse").add("Recipe", recipe()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "recipe":
            return Optional.ofNullable(clazz.cast(recipe()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeRecipeResponse, T> g) {
        return obj -> g.apply((DescribeRecipeResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PersonalizeResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeRecipeResponse> {
        /**
         * <p>
         * An object that describes the recipe.
         * </p>
         * 
         * @param recipe
         *        An object that describes the recipe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recipe(Recipe recipe);

        /**
         * <p>
         * An object that describes the recipe.
         * </p>
         * This is a convenience that creates an instance of the {@link Recipe.Builder} avoiding the need to create one
         * manually via {@link Recipe#builder()}.
         *
         * When the {@link Consumer} completes, {@link Recipe.Builder#build()} is called immediately and its result is
         * passed to {@link #recipe(Recipe)}.
         * 
         * @param recipe
         *        a consumer that will call methods on {@link Recipe.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #recipe(Recipe)
         */
        default Builder recipe(Consumer<Recipe.Builder> recipe) {
            return recipe(Recipe.builder().applyMutation(recipe).build());
        }
    }

    static final class BuilderImpl extends PersonalizeResponse.BuilderImpl implements Builder {
        private Recipe recipe;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeRecipeResponse model) {
            super(model);
            recipe(model.recipe);
        }

        public final Recipe.Builder getRecipe() {
            return recipe != null ? recipe.toBuilder() : null;
        }

        public final void setRecipe(Recipe.BuilderImpl recipe) {
            this.recipe = recipe != null ? recipe.build() : null;
        }

        @Override
        @Transient
        public final Builder recipe(Recipe recipe) {
            this.recipe = recipe;
            return this;
        }

        @Override
        public DescribeRecipeResponse build() {
            return new DescribeRecipeResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
