/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.personalize.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides a summary of the properties of a dataset import job. For a complete listing, call the
 * <a>DescribeDatasetImportJob</a> API.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DatasetImportJobSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<DatasetImportJobSummary.Builder, DatasetImportJobSummary> {
    private static final SdkField<String> DATASET_IMPORT_JOB_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("datasetImportJobArn").getter(getter(DatasetImportJobSummary::datasetImportJobArn))
            .setter(setter(Builder::datasetImportJobArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datasetImportJobArn").build())
            .build();

    private static final SdkField<String> JOB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("jobName").getter(getter(DatasetImportJobSummary::jobName)).setter(setter(Builder::jobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobName").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(DatasetImportJobSummary::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Instant> CREATION_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationDateTime").getter(getter(DatasetImportJobSummary::creationDateTime))
            .setter(setter(Builder::creationDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDateTime").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdatedDateTime").getter(getter(DatasetImportJobSummary::lastUpdatedDateTime))
            .setter(setter(Builder::lastUpdatedDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedDateTime").build())
            .build();

    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("failureReason").getter(getter(DatasetImportJobSummary::failureReason))
            .setter(setter(Builder::failureReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureReason").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASET_IMPORT_JOB_ARN_FIELD,
            JOB_NAME_FIELD, STATUS_FIELD, CREATION_DATE_TIME_FIELD, LAST_UPDATED_DATE_TIME_FIELD, FAILURE_REASON_FIELD));

    private static final long serialVersionUID = 1L;

    private final String datasetImportJobArn;

    private final String jobName;

    private final String status;

    private final Instant creationDateTime;

    private final Instant lastUpdatedDateTime;

    private final String failureReason;

    private DatasetImportJobSummary(BuilderImpl builder) {
        this.datasetImportJobArn = builder.datasetImportJobArn;
        this.jobName = builder.jobName;
        this.status = builder.status;
        this.creationDateTime = builder.creationDateTime;
        this.lastUpdatedDateTime = builder.lastUpdatedDateTime;
        this.failureReason = builder.failureReason;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the dataset import job.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the dataset import job.
     */
    public final String datasetImportJobArn() {
        return datasetImportJobArn;
    }

    /**
     * <p>
     * The name of the dataset import job.
     * </p>
     * 
     * @return The name of the dataset import job.
     */
    public final String jobName() {
        return jobName;
    }

    /**
     * <p>
     * The status of the dataset ACTIVE -or- CREATE FAILED
     * </p>
     * </li> </ul>
     * 
     * @return The status of the dataset import job.</p>
     *         <p>
     *         A dataset import job can be in one of the following states:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED
     *         </p>
     *         </li>
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * The date and time (in Unix time) that the dataset import job was created.
     * </p>
     * 
     * @return The date and time (in Unix time) that the dataset import job was created.
     */
    public final Instant creationDateTime() {
        return creationDateTime;
    }

    /**
     * <p>
     * The date and time (in Unix time) that the dataset import job status was last updated.
     * </p>
     * 
     * @return The date and time (in Unix time) that the dataset import job status was last updated.
     */
    public final Instant lastUpdatedDateTime() {
        return lastUpdatedDateTime;
    }

    /**
     * <p>
     * If a dataset import job fails, the reason behind the failure.
     * </p>
     * 
     * @return If a dataset import job fails, the reason behind the failure.
     */
    public final String failureReason() {
        return failureReason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(datasetImportJobArn());
        hashCode = 31 * hashCode + Objects.hashCode(jobName());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(creationDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(failureReason());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DatasetImportJobSummary)) {
            return false;
        }
        DatasetImportJobSummary other = (DatasetImportJobSummary) obj;
        return Objects.equals(datasetImportJobArn(), other.datasetImportJobArn()) && Objects.equals(jobName(), other.jobName())
                && Objects.equals(status(), other.status()) && Objects.equals(creationDateTime(), other.creationDateTime())
                && Objects.equals(lastUpdatedDateTime(), other.lastUpdatedDateTime())
                && Objects.equals(failureReason(), other.failureReason());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DatasetImportJobSummary").add("DatasetImportJobArn", datasetImportJobArn())
                .add("JobName", jobName()).add("Status", status()).add("CreationDateTime", creationDateTime())
                .add("LastUpdatedDateTime", lastUpdatedDateTime()).add("FailureReason", failureReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "datasetImportJobArn":
            return Optional.ofNullable(clazz.cast(datasetImportJobArn()));
        case "jobName":
            return Optional.ofNullable(clazz.cast(jobName()));
        case "status":
            return Optional.ofNullable(clazz.cast(status()));
        case "creationDateTime":
            return Optional.ofNullable(clazz.cast(creationDateTime()));
        case "lastUpdatedDateTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedDateTime()));
        case "failureReason":
            return Optional.ofNullable(clazz.cast(failureReason()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DatasetImportJobSummary, T> g) {
        return obj -> g.apply((DatasetImportJobSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DatasetImportJobSummary> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the dataset import job.
         * </p>
         * 
         * @param datasetImportJobArn
         *        The Amazon Resource Name (ARN) of the dataset import job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetImportJobArn(String datasetImportJobArn);

        /**
         * <p>
         * The name of the dataset import job.
         * </p>
         * 
         * @param jobName
         *        The name of the dataset import job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobName(String jobName);

        /**
         * <p>
         * The status of the dataset import job.
         * </p>
         * <p>
         * A dataset import job can be in one of the following states:
         * </p>
         * <ul>
         * <li>
         * <p>
         * CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the dataset import job.</p>
         *        <p>
         *        A dataset import job can be in one of the following states:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The date and time (in Unix time) that the dataset import job was created.
         * </p>
         * 
         * @param creationDateTime
         *        The date and time (in Unix time) that the dataset import job was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDateTime(Instant creationDateTime);

        /**
         * <p>
         * The date and time (in Unix time) that the dataset import job status was last updated.
         * </p>
         * 
         * @param lastUpdatedDateTime
         *        The date and time (in Unix time) that the dataset import job status was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedDateTime(Instant lastUpdatedDateTime);

        /**
         * <p>
         * If a dataset import job fails, the reason behind the failure.
         * </p>
         * 
         * @param failureReason
         *        If a dataset import job fails, the reason behind the failure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReason(String failureReason);
    }

    static final class BuilderImpl implements Builder {
        private String datasetImportJobArn;

        private String jobName;

        private String status;

        private Instant creationDateTime;

        private Instant lastUpdatedDateTime;

        private String failureReason;

        private BuilderImpl() {
        }

        private BuilderImpl(DatasetImportJobSummary model) {
            datasetImportJobArn(model.datasetImportJobArn);
            jobName(model.jobName);
            status(model.status);
            creationDateTime(model.creationDateTime);
            lastUpdatedDateTime(model.lastUpdatedDateTime);
            failureReason(model.failureReason);
        }

        public final String getDatasetImportJobArn() {
            return datasetImportJobArn;
        }

        public final void setDatasetImportJobArn(String datasetImportJobArn) {
            this.datasetImportJobArn = datasetImportJobArn;
        }

        @Override
        @Transient
        public final Builder datasetImportJobArn(String datasetImportJobArn) {
            this.datasetImportJobArn = datasetImportJobArn;
            return this;
        }

        public final String getJobName() {
            return jobName;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        @Override
        @Transient
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final Instant getCreationDateTime() {
            return creationDateTime;
        }

        public final void setCreationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
        }

        @Override
        @Transient
        public final Builder creationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
            return this;
        }

        public final Instant getLastUpdatedDateTime() {
            return lastUpdatedDateTime;
        }

        public final void setLastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
        }

        @Override
        @Transient
        public final Builder lastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
            return this;
        }

        public final String getFailureReason() {
            return failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        @Transient
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        @Override
        public DatasetImportJobSummary build() {
            return new DatasetImportJobSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
