/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.personalize.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.personalize.PersonalizeAsyncClient;
import software.amazon.awssdk.services.personalize.model.ListMetricAttributionMetricsRequest;
import software.amazon.awssdk.services.personalize.model.ListMetricAttributionMetricsResponse;
import software.amazon.awssdk.services.personalize.model.MetricAttribute;

public class ListMetricAttributionMetricsPublisher
implements SdkPublisher<ListMetricAttributionMetricsResponse> {
    private final PersonalizeAsyncClient client;
    private final ListMetricAttributionMetricsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListMetricAttributionMetricsPublisher(PersonalizeAsyncClient client, ListMetricAttributionMetricsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListMetricAttributionMetricsPublisher(PersonalizeAsyncClient client, ListMetricAttributionMetricsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListMetricAttributionMetricsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListMetricAttributionMetricsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<MetricAttribute> metrics() {
        Function<ListMetricAttributionMetricsResponse, Iterator> getIterator = response -> {
            if (response != null && response.metrics() != null) {
                return response.metrics().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListMetricAttributionMetricsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListMetricAttributionMetricsResponseFetcher
    implements AsyncPageFetcher<ListMetricAttributionMetricsResponse> {
        private ListMetricAttributionMetricsResponseFetcher() {
        }

        public boolean hasNextPage(ListMetricAttributionMetricsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListMetricAttributionMetricsResponse> nextPage(ListMetricAttributionMetricsResponse previousPage) {
            if (previousPage == null) {
                return ListMetricAttributionMetricsPublisher.this.client.listMetricAttributionMetrics(ListMetricAttributionMetricsPublisher.this.firstRequest);
            }
            return ListMetricAttributionMetricsPublisher.this.client.listMetricAttributionMetrics((ListMetricAttributionMetricsRequest)((Object)ListMetricAttributionMetricsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

