/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.personalize.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.personalize.PersonalizeClient;
import software.amazon.awssdk.services.personalize.model.EventTrackerSummary;
import software.amazon.awssdk.services.personalize.model.ListEventTrackersRequest;
import software.amazon.awssdk.services.personalize.model.ListEventTrackersResponse;

public class ListEventTrackersIterable
implements SdkIterable<ListEventTrackersResponse> {
    private final PersonalizeClient client;
    private final ListEventTrackersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListEventTrackersIterable(PersonalizeClient client, ListEventTrackersRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListEventTrackersResponseFetcher();
    }

    public Iterator<ListEventTrackersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<EventTrackerSummary> eventTrackers() {
        Function<ListEventTrackersResponse, Iterator> getIterator = response -> {
            if (response != null && response.eventTrackers() != null) {
                return response.eventTrackers().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListEventTrackersResponseFetcher
    implements SyncPageFetcher<ListEventTrackersResponse> {
        private ListEventTrackersResponseFetcher() {
        }

        public boolean hasNextPage(ListEventTrackersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListEventTrackersResponse nextPage(ListEventTrackersResponse previousPage) {
            if (previousPage == null) {
                return ListEventTrackersIterable.this.client.listEventTrackers(ListEventTrackersIterable.this.firstRequest);
            }
            return ListEventTrackersIterable.this.client.listEventTrackers((ListEventTrackersRequest)((Object)ListEventTrackersIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

