/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.personalize.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.personalize.PersonalizeAsyncClient;
import software.amazon.awssdk.services.personalize.model.ListMetricAttributionsRequest;
import software.amazon.awssdk.services.personalize.model.ListMetricAttributionsResponse;
import software.amazon.awssdk.services.personalize.model.MetricAttributionSummary;

public class ListMetricAttributionsPublisher
implements SdkPublisher<ListMetricAttributionsResponse> {
    private final PersonalizeAsyncClient client;
    private final ListMetricAttributionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListMetricAttributionsPublisher(PersonalizeAsyncClient client, ListMetricAttributionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListMetricAttributionsPublisher(PersonalizeAsyncClient client, ListMetricAttributionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListMetricAttributionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListMetricAttributionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<MetricAttributionSummary> metricAttributions() {
        Function<ListMetricAttributionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.metricAttributions() != null) {
                return response.metricAttributions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListMetricAttributionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListMetricAttributionsResponseFetcher
    implements AsyncPageFetcher<ListMetricAttributionsResponse> {
        private ListMetricAttributionsResponseFetcher() {
        }

        public boolean hasNextPage(ListMetricAttributionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListMetricAttributionsResponse> nextPage(ListMetricAttributionsResponse previousPage) {
            if (previousPage == null) {
                return ListMetricAttributionsPublisher.this.client.listMetricAttributions(ListMetricAttributionsPublisher.this.firstRequest);
            }
            return ListMetricAttributionsPublisher.this.client.listMetricAttributions((ListMetricAttributionsRequest)((Object)ListMetricAttributionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

