/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.personalize.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information on a batch segment job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchSegmentJob implements SdkPojo, Serializable, ToCopyableBuilder<BatchSegmentJob.Builder, BatchSegmentJob> {
    private static final SdkField<String> JOB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("jobName").getter(getter(BatchSegmentJob::jobName)).setter(setter(Builder::jobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobName").build()).build();

    private static final SdkField<String> BATCH_SEGMENT_JOB_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("batchSegmentJobArn").getter(getter(BatchSegmentJob::batchSegmentJobArn))
            .setter(setter(Builder::batchSegmentJobArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("batchSegmentJobArn").build())
            .build();

    private static final SdkField<String> FILTER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("filterArn").getter(getter(BatchSegmentJob::filterArn)).setter(setter(Builder::filterArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterArn").build()).build();

    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("failureReason").getter(getter(BatchSegmentJob::failureReason)).setter(setter(Builder::failureReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureReason").build()).build();

    private static final SdkField<String> SOLUTION_VERSION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("solutionVersionArn").getter(getter(BatchSegmentJob::solutionVersionArn))
            .setter(setter(Builder::solutionVersionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("solutionVersionArn").build())
            .build();

    private static final SdkField<Integer> NUM_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("numResults").getter(getter(BatchSegmentJob::numResults)).setter(setter(Builder::numResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numResults").build()).build();

    private static final SdkField<BatchSegmentJobInput> JOB_INPUT_FIELD = SdkField
            .<BatchSegmentJobInput> builder(MarshallingType.SDK_POJO).memberName("jobInput")
            .getter(getter(BatchSegmentJob::jobInput)).setter(setter(Builder::jobInput))
            .constructor(BatchSegmentJobInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobInput").build()).build();

    private static final SdkField<BatchSegmentJobOutput> JOB_OUTPUT_FIELD = SdkField
            .<BatchSegmentJobOutput> builder(MarshallingType.SDK_POJO).memberName("jobOutput")
            .getter(getter(BatchSegmentJob::jobOutput)).setter(setter(Builder::jobOutput))
            .constructor(BatchSegmentJobOutput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobOutput").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(BatchSegmentJob::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(BatchSegmentJob::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Instant> CREATION_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationDateTime").getter(getter(BatchSegmentJob::creationDateTime))
            .setter(setter(Builder::creationDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDateTime").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdatedDateTime").getter(getter(BatchSegmentJob::lastUpdatedDateTime))
            .setter(setter(Builder::lastUpdatedDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedDateTime").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_NAME_FIELD,
            BATCH_SEGMENT_JOB_ARN_FIELD, FILTER_ARN_FIELD, FAILURE_REASON_FIELD, SOLUTION_VERSION_ARN_FIELD, NUM_RESULTS_FIELD,
            JOB_INPUT_FIELD, JOB_OUTPUT_FIELD, ROLE_ARN_FIELD, STATUS_FIELD, CREATION_DATE_TIME_FIELD,
            LAST_UPDATED_DATE_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String jobName;

    private final String batchSegmentJobArn;

    private final String filterArn;

    private final String failureReason;

    private final String solutionVersionArn;

    private final Integer numResults;

    private final BatchSegmentJobInput jobInput;

    private final BatchSegmentJobOutput jobOutput;

    private final String roleArn;

    private final String status;

    private final Instant creationDateTime;

    private final Instant lastUpdatedDateTime;

    private BatchSegmentJob(BuilderImpl builder) {
        this.jobName = builder.jobName;
        this.batchSegmentJobArn = builder.batchSegmentJobArn;
        this.filterArn = builder.filterArn;
        this.failureReason = builder.failureReason;
        this.solutionVersionArn = builder.solutionVersionArn;
        this.numResults = builder.numResults;
        this.jobInput = builder.jobInput;
        this.jobOutput = builder.jobOutput;
        this.roleArn = builder.roleArn;
        this.status = builder.status;
        this.creationDateTime = builder.creationDateTime;
        this.lastUpdatedDateTime = builder.lastUpdatedDateTime;
    }

    /**
     * <p>
     * The name of the batch segment job.
     * </p>
     * 
     * @return The name of the batch segment job.
     */
    public final String jobName() {
        return jobName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the batch segment job.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the batch segment job.
     */
    public final String batchSegmentJobArn() {
        return batchSegmentJobArn;
    }

    /**
     * <p>
     * The ARN of the filter used on the batch segment job.
     * </p>
     * 
     * @return The ARN of the filter used on the batch segment job.
     */
    public final String filterArn() {
        return filterArn;
    }

    /**
     * <p>
     * If the batch segment job failed, the reason for the failure.
     * </p>
     * 
     * @return If the batch segment job failed, the reason for the failure.
     */
    public final String failureReason() {
        return failureReason;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the solution version used by the batch segment job to generate batch segments.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the solution version used by the batch segment job to generate batch
     *         segments.
     */
    public final String solutionVersionArn() {
        return solutionVersionArn;
    }

    /**
     * <p>
     * The number of predicted users generated by the batch segment job for each line of input data. The maximum number
     * of users per segment is 5 million.
     * </p>
     * 
     * @return The number of predicted users generated by the batch segment job for each line of input data. The maximum
     *         number of users per segment is 5 million.
     */
    public final Integer numResults() {
        return numResults;
    }

    /**
     * <p>
     * The Amazon S3 path that leads to the input data used to generate the batch segment job.
     * </p>
     * 
     * @return The Amazon S3 path that leads to the input data used to generate the batch segment job.
     */
    public final BatchSegmentJobInput jobInput() {
        return jobInput;
    }

    /**
     * <p>
     * The Amazon S3 bucket that contains the output data generated by the batch segment job.
     * </p>
     * 
     * @return The Amazon S3 bucket that contains the output data generated by the batch segment job.
     */
    public final BatchSegmentJobOutput jobOutput() {
        return jobOutput;
    }

    /**
     * <p>
     * The ARN of the Amazon Identity and Access Management (IAM) role that requested the batch segment job.
     * </p>
     * 
     * @return The ARN of the Amazon Identity and Access Management (IAM) role that requested the batch segment job.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The status of the batch segment job. The status is one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * PENDING
     * </p>
     * </li>
     * <li>
     * <p>
     * IN PROGRESS
     * </p>
     * </li>
     * <li>
     * <p>
     * ACTIVE
     * </p>
     * </li>
     * <li>
     * <p>
     * CREATE FAILED
     * </p>
     * </li>
     * </ul>
     * 
     * @return The status of the batch segment job. The status is one of the following values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         PENDING
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         IN PROGRESS
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ACTIVE
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CREATE FAILED
     *         </p>
     *         </li>
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * The time at which the batch segment job was created.
     * </p>
     * 
     * @return The time at which the batch segment job was created.
     */
    public final Instant creationDateTime() {
        return creationDateTime;
    }

    /**
     * <p>
     * The time at which the batch segment job last updated.
     * </p>
     * 
     * @return The time at which the batch segment job last updated.
     */
    public final Instant lastUpdatedDateTime() {
        return lastUpdatedDateTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(jobName());
        hashCode = 31 * hashCode + Objects.hashCode(batchSegmentJobArn());
        hashCode = 31 * hashCode + Objects.hashCode(filterArn());
        hashCode = 31 * hashCode + Objects.hashCode(failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(solutionVersionArn());
        hashCode = 31 * hashCode + Objects.hashCode(numResults());
        hashCode = 31 * hashCode + Objects.hashCode(jobInput());
        hashCode = 31 * hashCode + Objects.hashCode(jobOutput());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(creationDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedDateTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchSegmentJob)) {
            return false;
        }
        BatchSegmentJob other = (BatchSegmentJob) obj;
        return Objects.equals(jobName(), other.jobName()) && Objects.equals(batchSegmentJobArn(), other.batchSegmentJobArn())
                && Objects.equals(filterArn(), other.filterArn()) && Objects.equals(failureReason(), other.failureReason())
                && Objects.equals(solutionVersionArn(), other.solutionVersionArn())
                && Objects.equals(numResults(), other.numResults()) && Objects.equals(jobInput(), other.jobInput())
                && Objects.equals(jobOutput(), other.jobOutput()) && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(status(), other.status()) && Objects.equals(creationDateTime(), other.creationDateTime())
                && Objects.equals(lastUpdatedDateTime(), other.lastUpdatedDateTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchSegmentJob").add("JobName", jobName()).add("BatchSegmentJobArn", batchSegmentJobArn())
                .add("FilterArn", filterArn()).add("FailureReason", failureReason())
                .add("SolutionVersionArn", solutionVersionArn()).add("NumResults", numResults()).add("JobInput", jobInput())
                .add("JobOutput", jobOutput()).add("RoleArn", roleArn()).add("Status", status())
                .add("CreationDateTime", creationDateTime()).add("LastUpdatedDateTime", lastUpdatedDateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "jobName":
            return Optional.ofNullable(clazz.cast(jobName()));
        case "batchSegmentJobArn":
            return Optional.ofNullable(clazz.cast(batchSegmentJobArn()));
        case "filterArn":
            return Optional.ofNullable(clazz.cast(filterArn()));
        case "failureReason":
            return Optional.ofNullable(clazz.cast(failureReason()));
        case "solutionVersionArn":
            return Optional.ofNullable(clazz.cast(solutionVersionArn()));
        case "numResults":
            return Optional.ofNullable(clazz.cast(numResults()));
        case "jobInput":
            return Optional.ofNullable(clazz.cast(jobInput()));
        case "jobOutput":
            return Optional.ofNullable(clazz.cast(jobOutput()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "status":
            return Optional.ofNullable(clazz.cast(status()));
        case "creationDateTime":
            return Optional.ofNullable(clazz.cast(creationDateTime()));
        case "lastUpdatedDateTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedDateTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchSegmentJob, T> g) {
        return obj -> g.apply((BatchSegmentJob) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BatchSegmentJob> {
        /**
         * <p>
         * The name of the batch segment job.
         * </p>
         * 
         * @param jobName
         *        The name of the batch segment job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobName(String jobName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the batch segment job.
         * </p>
         * 
         * @param batchSegmentJobArn
         *        The Amazon Resource Name (ARN) of the batch segment job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder batchSegmentJobArn(String batchSegmentJobArn);

        /**
         * <p>
         * The ARN of the filter used on the batch segment job.
         * </p>
         * 
         * @param filterArn
         *        The ARN of the filter used on the batch segment job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterArn(String filterArn);

        /**
         * <p>
         * If the batch segment job failed, the reason for the failure.
         * </p>
         * 
         * @param failureReason
         *        If the batch segment job failed, the reason for the failure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReason(String failureReason);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the solution version used by the batch segment job to generate batch
         * segments.
         * </p>
         * 
         * @param solutionVersionArn
         *        The Amazon Resource Name (ARN) of the solution version used by the batch segment job to generate batch
         *        segments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder solutionVersionArn(String solutionVersionArn);

        /**
         * <p>
         * The number of predicted users generated by the batch segment job for each line of input data. The maximum
         * number of users per segment is 5 million.
         * </p>
         * 
         * @param numResults
         *        The number of predicted users generated by the batch segment job for each line of input data. The
         *        maximum number of users per segment is 5 million.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numResults(Integer numResults);

        /**
         * <p>
         * The Amazon S3 path that leads to the input data used to generate the batch segment job.
         * </p>
         * 
         * @param jobInput
         *        The Amazon S3 path that leads to the input data used to generate the batch segment job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobInput(BatchSegmentJobInput jobInput);

        /**
         * <p>
         * The Amazon S3 path that leads to the input data used to generate the batch segment job.
         * </p>
         * This is a convenience method that creates an instance of the {@link BatchSegmentJobInput.Builder} avoiding
         * the need to create one manually via {@link BatchSegmentJobInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BatchSegmentJobInput.Builder#build()} is called immediately and
         * its result is passed to {@link #jobInput(BatchSegmentJobInput)}.
         * 
         * @param jobInput
         *        a consumer that will call methods on {@link BatchSegmentJobInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #jobInput(BatchSegmentJobInput)
         */
        default Builder jobInput(Consumer<BatchSegmentJobInput.Builder> jobInput) {
            return jobInput(BatchSegmentJobInput.builder().applyMutation(jobInput).build());
        }

        /**
         * <p>
         * The Amazon S3 bucket that contains the output data generated by the batch segment job.
         * </p>
         * 
         * @param jobOutput
         *        The Amazon S3 bucket that contains the output data generated by the batch segment job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobOutput(BatchSegmentJobOutput jobOutput);

        /**
         * <p>
         * The Amazon S3 bucket that contains the output data generated by the batch segment job.
         * </p>
         * This is a convenience method that creates an instance of the {@link BatchSegmentJobOutput.Builder} avoiding
         * the need to create one manually via {@link BatchSegmentJobOutput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BatchSegmentJobOutput.Builder#build()} is called immediately and
         * its result is passed to {@link #jobOutput(BatchSegmentJobOutput)}.
         * 
         * @param jobOutput
         *        a consumer that will call methods on {@link BatchSegmentJobOutput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #jobOutput(BatchSegmentJobOutput)
         */
        default Builder jobOutput(Consumer<BatchSegmentJobOutput.Builder> jobOutput) {
            return jobOutput(BatchSegmentJobOutput.builder().applyMutation(jobOutput).build());
        }

        /**
         * <p>
         * The ARN of the Amazon Identity and Access Management (IAM) role that requested the batch segment job.
         * </p>
         * 
         * @param roleArn
         *        The ARN of the Amazon Identity and Access Management (IAM) role that requested the batch segment job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The status of the batch segment job. The status is one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * PENDING
         * </p>
         * </li>
         * <li>
         * <p>
         * IN PROGRESS
         * </p>
         * </li>
         * <li>
         * <p>
         * ACTIVE
         * </p>
         * </li>
         * <li>
         * <p>
         * CREATE FAILED
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the batch segment job. The status is one of the following values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        PENDING
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        IN PROGRESS
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ACTIVE
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        CREATE FAILED
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The time at which the batch segment job was created.
         * </p>
         * 
         * @param creationDateTime
         *        The time at which the batch segment job was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDateTime(Instant creationDateTime);

        /**
         * <p>
         * The time at which the batch segment job last updated.
         * </p>
         * 
         * @param lastUpdatedDateTime
         *        The time at which the batch segment job last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedDateTime(Instant lastUpdatedDateTime);
    }

    static final class BuilderImpl implements Builder {
        private String jobName;

        private String batchSegmentJobArn;

        private String filterArn;

        private String failureReason;

        private String solutionVersionArn;

        private Integer numResults;

        private BatchSegmentJobInput jobInput;

        private BatchSegmentJobOutput jobOutput;

        private String roleArn;

        private String status;

        private Instant creationDateTime;

        private Instant lastUpdatedDateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchSegmentJob model) {
            jobName(model.jobName);
            batchSegmentJobArn(model.batchSegmentJobArn);
            filterArn(model.filterArn);
            failureReason(model.failureReason);
            solutionVersionArn(model.solutionVersionArn);
            numResults(model.numResults);
            jobInput(model.jobInput);
            jobOutput(model.jobOutput);
            roleArn(model.roleArn);
            status(model.status);
            creationDateTime(model.creationDateTime);
            lastUpdatedDateTime(model.lastUpdatedDateTime);
        }

        public final String getJobName() {
            return jobName;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final String getBatchSegmentJobArn() {
            return batchSegmentJobArn;
        }

        public final void setBatchSegmentJobArn(String batchSegmentJobArn) {
            this.batchSegmentJobArn = batchSegmentJobArn;
        }

        @Override
        public final Builder batchSegmentJobArn(String batchSegmentJobArn) {
            this.batchSegmentJobArn = batchSegmentJobArn;
            return this;
        }

        public final String getFilterArn() {
            return filterArn;
        }

        public final void setFilterArn(String filterArn) {
            this.filterArn = filterArn;
        }

        @Override
        public final Builder filterArn(String filterArn) {
            this.filterArn = filterArn;
            return this;
        }

        public final String getFailureReason() {
            return failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final String getSolutionVersionArn() {
            return solutionVersionArn;
        }

        public final void setSolutionVersionArn(String solutionVersionArn) {
            this.solutionVersionArn = solutionVersionArn;
        }

        @Override
        public final Builder solutionVersionArn(String solutionVersionArn) {
            this.solutionVersionArn = solutionVersionArn;
            return this;
        }

        public final Integer getNumResults() {
            return numResults;
        }

        public final void setNumResults(Integer numResults) {
            this.numResults = numResults;
        }

        @Override
        public final Builder numResults(Integer numResults) {
            this.numResults = numResults;
            return this;
        }

        public final BatchSegmentJobInput.Builder getJobInput() {
            return jobInput != null ? jobInput.toBuilder() : null;
        }

        public final void setJobInput(BatchSegmentJobInput.BuilderImpl jobInput) {
            this.jobInput = jobInput != null ? jobInput.build() : null;
        }

        @Override
        public final Builder jobInput(BatchSegmentJobInput jobInput) {
            this.jobInput = jobInput;
            return this;
        }

        public final BatchSegmentJobOutput.Builder getJobOutput() {
            return jobOutput != null ? jobOutput.toBuilder() : null;
        }

        public final void setJobOutput(BatchSegmentJobOutput.BuilderImpl jobOutput) {
            this.jobOutput = jobOutput != null ? jobOutput.build() : null;
        }

        @Override
        public final Builder jobOutput(BatchSegmentJobOutput jobOutput) {
            this.jobOutput = jobOutput;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final Instant getCreationDateTime() {
            return creationDateTime;
        }

        public final void setCreationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
        }

        @Override
        public final Builder creationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
            return this;
        }

        public final Instant getLastUpdatedDateTime() {
            return lastUpdatedDateTime;
        }

        public final void setLastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
        }

        @Override
        public final Builder lastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
            return this;
        }

        @Override
        public BatchSegmentJob build() {
            return new BatchSegmentJob(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
