/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.personalize.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A dataset group is a collection of related datasets (Item interactions, Users, Items, Actions, Action interactions).
 * You create a dataset group by calling <a
 * href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDatasetGroup.html">CreateDatasetGroup</a>. You then
 * create a dataset and add it to a dataset group by calling <a
 * href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDataset.html">CreateDataset</a>. The dataset group
 * is used to create and train a solution by calling <a
 * href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSolution.html">CreateSolution</a>. A dataset group
 * can contain only one of each type of dataset.
 * </p>
 * <p>
 * You can specify an Key Management Service (KMS) key to encrypt the datasets in the group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DatasetGroup implements SdkPojo, Serializable, ToCopyableBuilder<DatasetGroup.Builder, DatasetGroup> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(DatasetGroup::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DATASET_GROUP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("datasetGroupArn").getter(getter(DatasetGroup::datasetGroupArn)).setter(setter(Builder::datasetGroupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datasetGroupArn").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(DatasetGroup::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(DatasetGroup::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<String> KMS_KEY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("kmsKeyArn").getter(getter(DatasetGroup::kmsKeyArn)).setter(setter(Builder::kmsKeyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyArn").build()).build();

    private static final SdkField<Instant> CREATION_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationDateTime").getter(getter(DatasetGroup::creationDateTime))
            .setter(setter(Builder::creationDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDateTime").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdatedDateTime").getter(getter(DatasetGroup::lastUpdatedDateTime))
            .setter(setter(Builder::lastUpdatedDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedDateTime").build())
            .build();

    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("failureReason").getter(getter(DatasetGroup::failureReason)).setter(setter(Builder::failureReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureReason").build()).build();

    private static final SdkField<String> DOMAIN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("domain")
            .getter(getter(DatasetGroup::domainAsString)).setter(setter(Builder::domain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domain").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            DATASET_GROUP_ARN_FIELD, STATUS_FIELD, ROLE_ARN_FIELD, KMS_KEY_ARN_FIELD, CREATION_DATE_TIME_FIELD,
            LAST_UPDATED_DATE_TIME_FIELD, FAILURE_REASON_FIELD, DOMAIN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String datasetGroupArn;

    private final String status;

    private final String roleArn;

    private final String kmsKeyArn;

    private final Instant creationDateTime;

    private final Instant lastUpdatedDateTime;

    private final String failureReason;

    private final String domain;

    private DatasetGroup(BuilderImpl builder) {
        this.name = builder.name;
        this.datasetGroupArn = builder.datasetGroupArn;
        this.status = builder.status;
        this.roleArn = builder.roleArn;
        this.kmsKeyArn = builder.kmsKeyArn;
        this.creationDateTime = builder.creationDateTime;
        this.lastUpdatedDateTime = builder.lastUpdatedDateTime;
        this.failureReason = builder.failureReason;
        this.domain = builder.domain;
    }

    /**
     * <p>
     * The name of the dataset group.
     * </p>
     * 
     * @return The name of the dataset group.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the dataset group.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the dataset group.
     */
    public final String datasetGroupArn() {
        return datasetGroupArn;
    }

    /**
     * <p>
     * The current status of the dataset group.
     * </p>
     * <p>
     * A dataset group can be in one of the following states:
     * </p>
     * <ul>
     * <li>
     * <p>
     * CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED
     * </p>
     * </li>
     * <li>
     * <p>
     * DELETE PENDING
     * </p>
     * </li>
     * </ul>
     * 
     * @return The current status of the dataset group.</p>
     *         <p>
     *         A dataset group can be in one of the following states:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DELETE PENDING
     *         </p>
     *         </li>
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * The ARN of the Identity and Access Management (IAM) role that has permissions to access the Key Management
     * Service (KMS) key. Supplying an IAM role is only valid when also specifying a KMS key.
     * </p>
     * 
     * @return The ARN of the Identity and Access Management (IAM) role that has permissions to access the Key
     *         Management Service (KMS) key. Supplying an IAM role is only valid when also specifying a KMS key.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Key Management Service (KMS) key used to encrypt the datasets.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Key Management Service (KMS) key used to encrypt the datasets.
     */
    public final String kmsKeyArn() {
        return kmsKeyArn;
    }

    /**
     * <p>
     * The creation date and time (in Unix time) of the dataset group.
     * </p>
     * 
     * @return The creation date and time (in Unix time) of the dataset group.
     */
    public final Instant creationDateTime() {
        return creationDateTime;
    }

    /**
     * <p>
     * The last update date and time (in Unix time) of the dataset group.
     * </p>
     * 
     * @return The last update date and time (in Unix time) of the dataset group.
     */
    public final Instant lastUpdatedDateTime() {
        return lastUpdatedDateTime;
    }

    /**
     * <p>
     * If creating a dataset group fails, provides the reason why.
     * </p>
     * 
     * @return If creating a dataset group fails, provides the reason why.
     */
    public final String failureReason() {
        return failureReason;
    }

    /**
     * <p>
     * The domain of a Domain dataset group.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #domain} will
     * return {@link Domain#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #domainAsString}.
     * </p>
     * 
     * @return The domain of a Domain dataset group.
     * @see Domain
     */
    public final Domain domain() {
        return Domain.fromValue(domain);
    }

    /**
     * <p>
     * The domain of a Domain dataset group.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #domain} will
     * return {@link Domain#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #domainAsString}.
     * </p>
     * 
     * @return The domain of a Domain dataset group.
     * @see Domain
     */
    public final String domainAsString() {
        return domain;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(datasetGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(creationDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(domainAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DatasetGroup)) {
            return false;
        }
        DatasetGroup other = (DatasetGroup) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(datasetGroupArn(), other.datasetGroupArn())
                && Objects.equals(status(), other.status()) && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(kmsKeyArn(), other.kmsKeyArn()) && Objects.equals(creationDateTime(), other.creationDateTime())
                && Objects.equals(lastUpdatedDateTime(), other.lastUpdatedDateTime())
                && Objects.equals(failureReason(), other.failureReason())
                && Objects.equals(domainAsString(), other.domainAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DatasetGroup").add("Name", name()).add("DatasetGroupArn", datasetGroupArn())
                .add("Status", status()).add("RoleArn", roleArn()).add("KmsKeyArn", kmsKeyArn())
                .add("CreationDateTime", creationDateTime()).add("LastUpdatedDateTime", lastUpdatedDateTime())
                .add("FailureReason", failureReason()).add("Domain", domainAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "datasetGroupArn":
            return Optional.ofNullable(clazz.cast(datasetGroupArn()));
        case "status":
            return Optional.ofNullable(clazz.cast(status()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "kmsKeyArn":
            return Optional.ofNullable(clazz.cast(kmsKeyArn()));
        case "creationDateTime":
            return Optional.ofNullable(clazz.cast(creationDateTime()));
        case "lastUpdatedDateTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedDateTime()));
        case "failureReason":
            return Optional.ofNullable(clazz.cast(failureReason()));
        case "domain":
            return Optional.ofNullable(clazz.cast(domainAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DatasetGroup, T> g) {
        return obj -> g.apply((DatasetGroup) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DatasetGroup> {
        /**
         * <p>
         * The name of the dataset group.
         * </p>
         * 
         * @param name
         *        The name of the dataset group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the dataset group.
         * </p>
         * 
         * @param datasetGroupArn
         *        The Amazon Resource Name (ARN) of the dataset group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetGroupArn(String datasetGroupArn);

        /**
         * <p>
         * The current status of the dataset group.
         * </p>
         * <p>
         * A dataset group can be in one of the following states:
         * </p>
         * <ul>
         * <li>
         * <p>
         * CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED
         * </p>
         * </li>
         * <li>
         * <p>
         * DELETE PENDING
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The current status of the dataset group.</p>
         *        <p>
         *        A dataset group can be in one of the following states:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        DELETE PENDING
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The ARN of the Identity and Access Management (IAM) role that has permissions to access the Key Management
         * Service (KMS) key. Supplying an IAM role is only valid when also specifying a KMS key.
         * </p>
         * 
         * @param roleArn
         *        The ARN of the Identity and Access Management (IAM) role that has permissions to access the Key
         *        Management Service (KMS) key. Supplying an IAM role is only valid when also specifying a KMS key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Key Management Service (KMS) key used to encrypt the datasets.
         * </p>
         * 
         * @param kmsKeyArn
         *        The Amazon Resource Name (ARN) of the Key Management Service (KMS) key used to encrypt the datasets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyArn(String kmsKeyArn);

        /**
         * <p>
         * The creation date and time (in Unix time) of the dataset group.
         * </p>
         * 
         * @param creationDateTime
         *        The creation date and time (in Unix time) of the dataset group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDateTime(Instant creationDateTime);

        /**
         * <p>
         * The last update date and time (in Unix time) of the dataset group.
         * </p>
         * 
         * @param lastUpdatedDateTime
         *        The last update date and time (in Unix time) of the dataset group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedDateTime(Instant lastUpdatedDateTime);

        /**
         * <p>
         * If creating a dataset group fails, provides the reason why.
         * </p>
         * 
         * @param failureReason
         *        If creating a dataset group fails, provides the reason why.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReason(String failureReason);

        /**
         * <p>
         * The domain of a Domain dataset group.
         * </p>
         * 
         * @param domain
         *        The domain of a Domain dataset group.
         * @see Domain
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Domain
         */
        Builder domain(String domain);

        /**
         * <p>
         * The domain of a Domain dataset group.
         * </p>
         * 
         * @param domain
         *        The domain of a Domain dataset group.
         * @see Domain
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Domain
         */
        Builder domain(Domain domain);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String datasetGroupArn;

        private String status;

        private String roleArn;

        private String kmsKeyArn;

        private Instant creationDateTime;

        private Instant lastUpdatedDateTime;

        private String failureReason;

        private String domain;

        private BuilderImpl() {
        }

        private BuilderImpl(DatasetGroup model) {
            name(model.name);
            datasetGroupArn(model.datasetGroupArn);
            status(model.status);
            roleArn(model.roleArn);
            kmsKeyArn(model.kmsKeyArn);
            creationDateTime(model.creationDateTime);
            lastUpdatedDateTime(model.lastUpdatedDateTime);
            failureReason(model.failureReason);
            domain(model.domain);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDatasetGroupArn() {
            return datasetGroupArn;
        }

        public final void setDatasetGroupArn(String datasetGroupArn) {
            this.datasetGroupArn = datasetGroupArn;
        }

        @Override
        public final Builder datasetGroupArn(String datasetGroupArn) {
            this.datasetGroupArn = datasetGroupArn;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getKmsKeyArn() {
            return kmsKeyArn;
        }

        public final void setKmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
        }

        @Override
        public final Builder kmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        public final Instant getCreationDateTime() {
            return creationDateTime;
        }

        public final void setCreationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
        }

        @Override
        public final Builder creationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
            return this;
        }

        public final Instant getLastUpdatedDateTime() {
            return lastUpdatedDateTime;
        }

        public final void setLastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
        }

        @Override
        public final Builder lastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
            return this;
        }

        public final String getFailureReason() {
            return failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final String getDomain() {
            return domain;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        @Override
        public final Builder domain(Domain domain) {
            this.domain(domain == null ? null : domain.toString());
            return this;
        }

        @Override
        public DatasetGroup build() {
            return new DatasetGroup(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
