/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.personalize.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides a summary of the properties of a solution version. For a complete listing, call the <a
 * href="https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeSolutionVersion.html">DescribeSolutionVersion</a>
 * API.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SolutionVersionSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<SolutionVersionSummary.Builder, SolutionVersionSummary> {
    private static final SdkField<String> SOLUTION_VERSION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("solutionVersionArn").getter(getter(SolutionVersionSummary::solutionVersionArn))
            .setter(setter(Builder::solutionVersionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("solutionVersionArn").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(SolutionVersionSummary::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> TRAINING_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("trainingMode").getter(getter(SolutionVersionSummary::trainingModeAsString))
            .setter(setter(Builder::trainingMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trainingMode").build()).build();

    private static final SdkField<String> TRAINING_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("trainingType").getter(getter(SolutionVersionSummary::trainingTypeAsString))
            .setter(setter(Builder::trainingType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trainingType").build()).build();

    private static final SdkField<Instant> CREATION_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationDateTime").getter(getter(SolutionVersionSummary::creationDateTime))
            .setter(setter(Builder::creationDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDateTime").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdatedDateTime").getter(getter(SolutionVersionSummary::lastUpdatedDateTime))
            .setter(setter(Builder::lastUpdatedDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedDateTime").build())
            .build();

    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("failureReason").getter(getter(SolutionVersionSummary::failureReason))
            .setter(setter(Builder::failureReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureReason").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOLUTION_VERSION_ARN_FIELD,
            STATUS_FIELD, TRAINING_MODE_FIELD, TRAINING_TYPE_FIELD, CREATION_DATE_TIME_FIELD, LAST_UPDATED_DATE_TIME_FIELD,
            FAILURE_REASON_FIELD));

    private static final long serialVersionUID = 1L;

    private final String solutionVersionArn;

    private final String status;

    private final String trainingMode;

    private final String trainingType;

    private final Instant creationDateTime;

    private final Instant lastUpdatedDateTime;

    private final String failureReason;

    private SolutionVersionSummary(BuilderImpl builder) {
        this.solutionVersionArn = builder.solutionVersionArn;
        this.status = builder.status;
        this.trainingMode = builder.trainingMode;
        this.trainingType = builder.trainingType;
        this.creationDateTime = builder.creationDateTime;
        this.lastUpdatedDateTime = builder.lastUpdatedDateTime;
        this.failureReason = builder.failureReason;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the solution version.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the solution version.
     */
    public final String solutionVersionArn() {
        return solutionVersionArn;
    }

    /**
     * <p>
     * The status of the solution version.
     * </p>
     * <p>
     * A solution version can be in one of the following states:
     * </p>
     * <ul>
     * <li>
     * <p>
     * CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED
     * </p>
     * </li>
     * </ul>
     * 
     * @return The status of the solution version.</p>
     *         <p>
     *         A solution version can be in one of the following states:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED
     *         </p>
     *         </li>
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * The scope of training to be performed when creating the solution version. A <code>FULL</code> training considers
     * all of the data in your dataset group. An <code>UPDATE</code> processes only the data that has changed since the
     * latest training. Only solution versions created with the User-Personalization recipe can use <code>UPDATE</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #trainingMode} will
     * return {@link TrainingMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #trainingModeAsString}.
     * </p>
     * 
     * @return The scope of training to be performed when creating the solution version. A <code>FULL</code> training
     *         considers all of the data in your dataset group. An <code>UPDATE</code> processes only the data that has
     *         changed since the latest training. Only solution versions created with the User-Personalization recipe
     *         can use <code>UPDATE</code>.
     * @see TrainingMode
     */
    public final TrainingMode trainingMode() {
        return TrainingMode.fromValue(trainingMode);
    }

    /**
     * <p>
     * The scope of training to be performed when creating the solution version. A <code>FULL</code> training considers
     * all of the data in your dataset group. An <code>UPDATE</code> processes only the data that has changed since the
     * latest training. Only solution versions created with the User-Personalization recipe can use <code>UPDATE</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #trainingMode} will
     * return {@link TrainingMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #trainingModeAsString}.
     * </p>
     * 
     * @return The scope of training to be performed when creating the solution version. A <code>FULL</code> training
     *         considers all of the data in your dataset group. An <code>UPDATE</code> processes only the data that has
     *         changed since the latest training. Only solution versions created with the User-Personalization recipe
     *         can use <code>UPDATE</code>.
     * @see TrainingMode
     */
    public final String trainingModeAsString() {
        return trainingMode;
    }

    /**
     * <p>
     * Whether the solution version was created automatically or manually.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #trainingType} will
     * return {@link TrainingType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #trainingTypeAsString}.
     * </p>
     * 
     * @return Whether the solution version was created automatically or manually.
     * @see TrainingType
     */
    public final TrainingType trainingType() {
        return TrainingType.fromValue(trainingType);
    }

    /**
     * <p>
     * Whether the solution version was created automatically or manually.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #trainingType} will
     * return {@link TrainingType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #trainingTypeAsString}.
     * </p>
     * 
     * @return Whether the solution version was created automatically or manually.
     * @see TrainingType
     */
    public final String trainingTypeAsString() {
        return trainingType;
    }

    /**
     * <p>
     * The date and time (in Unix time) that this version of a solution was created.
     * </p>
     * 
     * @return The date and time (in Unix time) that this version of a solution was created.
     */
    public final Instant creationDateTime() {
        return creationDateTime;
    }

    /**
     * <p>
     * The date and time (in Unix time) that the solution version was last updated.
     * </p>
     * 
     * @return The date and time (in Unix time) that the solution version was last updated.
     */
    public final Instant lastUpdatedDateTime() {
        return lastUpdatedDateTime;
    }

    /**
     * <p>
     * If a solution version fails, the reason behind the failure.
     * </p>
     * 
     * @return If a solution version fails, the reason behind the failure.
     */
    public final String failureReason() {
        return failureReason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(solutionVersionArn());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(trainingModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(trainingTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(creationDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(failureReason());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SolutionVersionSummary)) {
            return false;
        }
        SolutionVersionSummary other = (SolutionVersionSummary) obj;
        return Objects.equals(solutionVersionArn(), other.solutionVersionArn()) && Objects.equals(status(), other.status())
                && Objects.equals(trainingModeAsString(), other.trainingModeAsString())
                && Objects.equals(trainingTypeAsString(), other.trainingTypeAsString())
                && Objects.equals(creationDateTime(), other.creationDateTime())
                && Objects.equals(lastUpdatedDateTime(), other.lastUpdatedDateTime())
                && Objects.equals(failureReason(), other.failureReason());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SolutionVersionSummary").add("SolutionVersionArn", solutionVersionArn()).add("Status", status())
                .add("TrainingMode", trainingModeAsString()).add("TrainingType", trainingTypeAsString())
                .add("CreationDateTime", creationDateTime()).add("LastUpdatedDateTime", lastUpdatedDateTime())
                .add("FailureReason", failureReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "solutionVersionArn":
            return Optional.ofNullable(clazz.cast(solutionVersionArn()));
        case "status":
            return Optional.ofNullable(clazz.cast(status()));
        case "trainingMode":
            return Optional.ofNullable(clazz.cast(trainingModeAsString()));
        case "trainingType":
            return Optional.ofNullable(clazz.cast(trainingTypeAsString()));
        case "creationDateTime":
            return Optional.ofNullable(clazz.cast(creationDateTime()));
        case "lastUpdatedDateTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedDateTime()));
        case "failureReason":
            return Optional.ofNullable(clazz.cast(failureReason()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SolutionVersionSummary, T> g) {
        return obj -> g.apply((SolutionVersionSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SolutionVersionSummary> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the solution version.
         * </p>
         * 
         * @param solutionVersionArn
         *        The Amazon Resource Name (ARN) of the solution version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder solutionVersionArn(String solutionVersionArn);

        /**
         * <p>
         * The status of the solution version.
         * </p>
         * <p>
         * A solution version can be in one of the following states:
         * </p>
         * <ul>
         * <li>
         * <p>
         * CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the solution version.</p>
         *        <p>
         *        A solution version can be in one of the following states:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The scope of training to be performed when creating the solution version. A <code>FULL</code> training
         * considers all of the data in your dataset group. An <code>UPDATE</code> processes only the data that has
         * changed since the latest training. Only solution versions created with the User-Personalization recipe can
         * use <code>UPDATE</code>.
         * </p>
         * 
         * @param trainingMode
         *        The scope of training to be performed when creating the solution version. A <code>FULL</code> training
         *        considers all of the data in your dataset group. An <code>UPDATE</code> processes only the data that
         *        has changed since the latest training. Only solution versions created with the User-Personalization
         *        recipe can use <code>UPDATE</code>.
         * @see TrainingMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TrainingMode
         */
        Builder trainingMode(String trainingMode);

        /**
         * <p>
         * The scope of training to be performed when creating the solution version. A <code>FULL</code> training
         * considers all of the data in your dataset group. An <code>UPDATE</code> processes only the data that has
         * changed since the latest training. Only solution versions created with the User-Personalization recipe can
         * use <code>UPDATE</code>.
         * </p>
         * 
         * @param trainingMode
         *        The scope of training to be performed when creating the solution version. A <code>FULL</code> training
         *        considers all of the data in your dataset group. An <code>UPDATE</code> processes only the data that
         *        has changed since the latest training. Only solution versions created with the User-Personalization
         *        recipe can use <code>UPDATE</code>.
         * @see TrainingMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TrainingMode
         */
        Builder trainingMode(TrainingMode trainingMode);

        /**
         * <p>
         * Whether the solution version was created automatically or manually.
         * </p>
         * 
         * @param trainingType
         *        Whether the solution version was created automatically or manually.
         * @see TrainingType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TrainingType
         */
        Builder trainingType(String trainingType);

        /**
         * <p>
         * Whether the solution version was created automatically or manually.
         * </p>
         * 
         * @param trainingType
         *        Whether the solution version was created automatically or manually.
         * @see TrainingType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TrainingType
         */
        Builder trainingType(TrainingType trainingType);

        /**
         * <p>
         * The date and time (in Unix time) that this version of a solution was created.
         * </p>
         * 
         * @param creationDateTime
         *        The date and time (in Unix time) that this version of a solution was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDateTime(Instant creationDateTime);

        /**
         * <p>
         * The date and time (in Unix time) that the solution version was last updated.
         * </p>
         * 
         * @param lastUpdatedDateTime
         *        The date and time (in Unix time) that the solution version was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedDateTime(Instant lastUpdatedDateTime);

        /**
         * <p>
         * If a solution version fails, the reason behind the failure.
         * </p>
         * 
         * @param failureReason
         *        If a solution version fails, the reason behind the failure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReason(String failureReason);
    }

    static final class BuilderImpl implements Builder {
        private String solutionVersionArn;

        private String status;

        private String trainingMode;

        private String trainingType;

        private Instant creationDateTime;

        private Instant lastUpdatedDateTime;

        private String failureReason;

        private BuilderImpl() {
        }

        private BuilderImpl(SolutionVersionSummary model) {
            solutionVersionArn(model.solutionVersionArn);
            status(model.status);
            trainingMode(model.trainingMode);
            trainingType(model.trainingType);
            creationDateTime(model.creationDateTime);
            lastUpdatedDateTime(model.lastUpdatedDateTime);
            failureReason(model.failureReason);
        }

        public final String getSolutionVersionArn() {
            return solutionVersionArn;
        }

        public final void setSolutionVersionArn(String solutionVersionArn) {
            this.solutionVersionArn = solutionVersionArn;
        }

        @Override
        public final Builder solutionVersionArn(String solutionVersionArn) {
            this.solutionVersionArn = solutionVersionArn;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final String getTrainingMode() {
            return trainingMode;
        }

        public final void setTrainingMode(String trainingMode) {
            this.trainingMode = trainingMode;
        }

        @Override
        public final Builder trainingMode(String trainingMode) {
            this.trainingMode = trainingMode;
            return this;
        }

        @Override
        public final Builder trainingMode(TrainingMode trainingMode) {
            this.trainingMode(trainingMode == null ? null : trainingMode.toString());
            return this;
        }

        public final String getTrainingType() {
            return trainingType;
        }

        public final void setTrainingType(String trainingType) {
            this.trainingType = trainingType;
        }

        @Override
        public final Builder trainingType(String trainingType) {
            this.trainingType = trainingType;
            return this;
        }

        @Override
        public final Builder trainingType(TrainingType trainingType) {
            this.trainingType(trainingType == null ? null : trainingType.toString());
            return this;
        }

        public final Instant getCreationDateTime() {
            return creationDateTime;
        }

        public final void setCreationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
        }

        @Override
        public final Builder creationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
            return this;
        }

        public final Instant getLastUpdatedDateTime() {
            return lastUpdatedDateTime;
        }

        public final void setLastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
        }

        @Override
        public final Builder lastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
            return this;
        }

        public final String getFailureReason() {
            return failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        @Override
        public SolutionVersionSummary build() {
            return new SolutionVersionSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
