/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.personalize.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeBatchSegmentJobResponse extends PersonalizeResponse implements
        ToCopyableBuilder<DescribeBatchSegmentJobResponse.Builder, DescribeBatchSegmentJobResponse> {
    private static final SdkField<BatchSegmentJob> BATCH_SEGMENT_JOB_FIELD = SdkField
            .<BatchSegmentJob> builder(MarshallingType.SDK_POJO).memberName("batchSegmentJob")
            .getter(getter(DescribeBatchSegmentJobResponse::batchSegmentJob)).setter(setter(Builder::batchSegmentJob))
            .constructor(BatchSegmentJob::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("batchSegmentJob").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BATCH_SEGMENT_JOB_FIELD));

    private final BatchSegmentJob batchSegmentJob;

    private DescribeBatchSegmentJobResponse(BuilderImpl builder) {
        super(builder);
        this.batchSegmentJob = builder.batchSegmentJob;
    }

    /**
     * <p>
     * Information on the specified batch segment job.
     * </p>
     * 
     * @return Information on the specified batch segment job.
     */
    public final BatchSegmentJob batchSegmentJob() {
        return batchSegmentJob;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(batchSegmentJob());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeBatchSegmentJobResponse)) {
            return false;
        }
        DescribeBatchSegmentJobResponse other = (DescribeBatchSegmentJobResponse) obj;
        return Objects.equals(batchSegmentJob(), other.batchSegmentJob());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeBatchSegmentJobResponse").add("BatchSegmentJob", batchSegmentJob()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "batchSegmentJob":
            return Optional.ofNullable(clazz.cast(batchSegmentJob()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeBatchSegmentJobResponse, T> g) {
        return obj -> g.apply((DescribeBatchSegmentJobResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PersonalizeResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeBatchSegmentJobResponse> {
        /**
         * <p>
         * Information on the specified batch segment job.
         * </p>
         * 
         * @param batchSegmentJob
         *        Information on the specified batch segment job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder batchSegmentJob(BatchSegmentJob batchSegmentJob);

        /**
         * <p>
         * Information on the specified batch segment job.
         * </p>
         * This is a convenience method that creates an instance of the {@link BatchSegmentJob.Builder} avoiding the
         * need to create one manually via {@link BatchSegmentJob#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BatchSegmentJob.Builder#build()} is called immediately and its
         * result is passed to {@link #batchSegmentJob(BatchSegmentJob)}.
         * 
         * @param batchSegmentJob
         *        a consumer that will call methods on {@link BatchSegmentJob.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #batchSegmentJob(BatchSegmentJob)
         */
        default Builder batchSegmentJob(Consumer<BatchSegmentJob.Builder> batchSegmentJob) {
            return batchSegmentJob(BatchSegmentJob.builder().applyMutation(batchSegmentJob).build());
        }
    }

    static final class BuilderImpl extends PersonalizeResponse.BuilderImpl implements Builder {
        private BatchSegmentJob batchSegmentJob;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeBatchSegmentJobResponse model) {
            super(model);
            batchSegmentJob(model.batchSegmentJob);
        }

        public final BatchSegmentJob.Builder getBatchSegmentJob() {
            return batchSegmentJob != null ? batchSegmentJob.toBuilder() : null;
        }

        public final void setBatchSegmentJob(BatchSegmentJob.BuilderImpl batchSegmentJob) {
            this.batchSegmentJob = batchSegmentJob != null ? batchSegmentJob.build() : null;
        }

        @Override
        public final Builder batchSegmentJob(BatchSegmentJob batchSegmentJob) {
            this.batchSegmentJob = batchSegmentJob;
            return this;
        }

        @Override
        public DescribeBatchSegmentJobResponse build() {
            return new DescribeBatchSegmentJobResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
