/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.personalize.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides a summary of the properties of a solution update. For a complete listing, call the <a
 * href="https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeSolution.html">DescribeSolution</a> API.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SolutionUpdateSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<SolutionUpdateSummary.Builder, SolutionUpdateSummary> {
    private static final SdkField<SolutionUpdateConfig> SOLUTION_UPDATE_CONFIG_FIELD = SdkField
            .<SolutionUpdateConfig> builder(MarshallingType.SDK_POJO).memberName("solutionUpdateConfig")
            .getter(getter(SolutionUpdateSummary::solutionUpdateConfig)).setter(setter(Builder::solutionUpdateConfig))
            .constructor(SolutionUpdateConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("solutionUpdateConfig").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(SolutionUpdateSummary::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Boolean> PERFORM_AUTO_TRAINING_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("performAutoTraining").getter(getter(SolutionUpdateSummary::performAutoTraining))
            .setter(setter(Builder::performAutoTraining))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("performAutoTraining").build())
            .build();

    private static final SdkField<Instant> CREATION_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationDateTime").getter(getter(SolutionUpdateSummary::creationDateTime))
            .setter(setter(Builder::creationDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDateTime").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdatedDateTime").getter(getter(SolutionUpdateSummary::lastUpdatedDateTime))
            .setter(setter(Builder::lastUpdatedDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedDateTime").build())
            .build();

    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("failureReason").getter(getter(SolutionUpdateSummary::failureReason))
            .setter(setter(Builder::failureReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureReason").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOLUTION_UPDATE_CONFIG_FIELD,
            STATUS_FIELD, PERFORM_AUTO_TRAINING_FIELD, CREATION_DATE_TIME_FIELD, LAST_UPDATED_DATE_TIME_FIELD,
            FAILURE_REASON_FIELD));

    private static final long serialVersionUID = 1L;

    private final SolutionUpdateConfig solutionUpdateConfig;

    private final String status;

    private final Boolean performAutoTraining;

    private final Instant creationDateTime;

    private final Instant lastUpdatedDateTime;

    private final String failureReason;

    private SolutionUpdateSummary(BuilderImpl builder) {
        this.solutionUpdateConfig = builder.solutionUpdateConfig;
        this.status = builder.status;
        this.performAutoTraining = builder.performAutoTraining;
        this.creationDateTime = builder.creationDateTime;
        this.lastUpdatedDateTime = builder.lastUpdatedDateTime;
        this.failureReason = builder.failureReason;
    }

    /**
     * <p>
     * The configuration details of the solution.
     * </p>
     * 
     * @return The configuration details of the solution.
     */
    public final SolutionUpdateConfig solutionUpdateConfig() {
        return solutionUpdateConfig;
    }

    /**
     * <p>
     * The status of the solution update. A solution update can be in one of the following states:
     * </p>
     * <p>
     * CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED
     * </p>
     * 
     * @return The status of the solution update. A solution update can be in one of the following states:</p>
     *         <p>
     *         CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * Whether the solution automatically creates solution versions.
     * </p>
     * 
     * @return Whether the solution automatically creates solution versions.
     */
    public final Boolean performAutoTraining() {
        return performAutoTraining;
    }

    /**
     * <p>
     * The date and time (in Unix format) that the solution update was created.
     * </p>
     * 
     * @return The date and time (in Unix format) that the solution update was created.
     */
    public final Instant creationDateTime() {
        return creationDateTime;
    }

    /**
     * <p>
     * The date and time (in Unix time) that the solution update was last updated.
     * </p>
     * 
     * @return The date and time (in Unix time) that the solution update was last updated.
     */
    public final Instant lastUpdatedDateTime() {
        return lastUpdatedDateTime;
    }

    /**
     * <p>
     * If a solution update fails, the reason behind the failure.
     * </p>
     * 
     * @return If a solution update fails, the reason behind the failure.
     */
    public final String failureReason() {
        return failureReason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(solutionUpdateConfig());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(performAutoTraining());
        hashCode = 31 * hashCode + Objects.hashCode(creationDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(failureReason());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SolutionUpdateSummary)) {
            return false;
        }
        SolutionUpdateSummary other = (SolutionUpdateSummary) obj;
        return Objects.equals(solutionUpdateConfig(), other.solutionUpdateConfig()) && Objects.equals(status(), other.status())
                && Objects.equals(performAutoTraining(), other.performAutoTraining())
                && Objects.equals(creationDateTime(), other.creationDateTime())
                && Objects.equals(lastUpdatedDateTime(), other.lastUpdatedDateTime())
                && Objects.equals(failureReason(), other.failureReason());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SolutionUpdateSummary").add("SolutionUpdateConfig", solutionUpdateConfig())
                .add("Status", status()).add("PerformAutoTraining", performAutoTraining())
                .add("CreationDateTime", creationDateTime()).add("LastUpdatedDateTime", lastUpdatedDateTime())
                .add("FailureReason", failureReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "solutionUpdateConfig":
            return Optional.ofNullable(clazz.cast(solutionUpdateConfig()));
        case "status":
            return Optional.ofNullable(clazz.cast(status()));
        case "performAutoTraining":
            return Optional.ofNullable(clazz.cast(performAutoTraining()));
        case "creationDateTime":
            return Optional.ofNullable(clazz.cast(creationDateTime()));
        case "lastUpdatedDateTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedDateTime()));
        case "failureReason":
            return Optional.ofNullable(clazz.cast(failureReason()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SolutionUpdateSummary, T> g) {
        return obj -> g.apply((SolutionUpdateSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SolutionUpdateSummary> {
        /**
         * <p>
         * The configuration details of the solution.
         * </p>
         * 
         * @param solutionUpdateConfig
         *        The configuration details of the solution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder solutionUpdateConfig(SolutionUpdateConfig solutionUpdateConfig);

        /**
         * <p>
         * The configuration details of the solution.
         * </p>
         * This is a convenience method that creates an instance of the {@link SolutionUpdateConfig.Builder} avoiding
         * the need to create one manually via {@link SolutionUpdateConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SolutionUpdateConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #solutionUpdateConfig(SolutionUpdateConfig)}.
         * 
         * @param solutionUpdateConfig
         *        a consumer that will call methods on {@link SolutionUpdateConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #solutionUpdateConfig(SolutionUpdateConfig)
         */
        default Builder solutionUpdateConfig(Consumer<SolutionUpdateConfig.Builder> solutionUpdateConfig) {
            return solutionUpdateConfig(SolutionUpdateConfig.builder().applyMutation(solutionUpdateConfig).build());
        }

        /**
         * <p>
         * The status of the solution update. A solution update can be in one of the following states:
         * </p>
         * <p>
         * CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED
         * </p>
         * 
         * @param status
         *        The status of the solution update. A solution update can be in one of the following states:</p>
         *        <p>
         *        CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * Whether the solution automatically creates solution versions.
         * </p>
         * 
         * @param performAutoTraining
         *        Whether the solution automatically creates solution versions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder performAutoTraining(Boolean performAutoTraining);

        /**
         * <p>
         * The date and time (in Unix format) that the solution update was created.
         * </p>
         * 
         * @param creationDateTime
         *        The date and time (in Unix format) that the solution update was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDateTime(Instant creationDateTime);

        /**
         * <p>
         * The date and time (in Unix time) that the solution update was last updated.
         * </p>
         * 
         * @param lastUpdatedDateTime
         *        The date and time (in Unix time) that the solution update was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedDateTime(Instant lastUpdatedDateTime);

        /**
         * <p>
         * If a solution update fails, the reason behind the failure.
         * </p>
         * 
         * @param failureReason
         *        If a solution update fails, the reason behind the failure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReason(String failureReason);
    }

    static final class BuilderImpl implements Builder {
        private SolutionUpdateConfig solutionUpdateConfig;

        private String status;

        private Boolean performAutoTraining;

        private Instant creationDateTime;

        private Instant lastUpdatedDateTime;

        private String failureReason;

        private BuilderImpl() {
        }

        private BuilderImpl(SolutionUpdateSummary model) {
            solutionUpdateConfig(model.solutionUpdateConfig);
            status(model.status);
            performAutoTraining(model.performAutoTraining);
            creationDateTime(model.creationDateTime);
            lastUpdatedDateTime(model.lastUpdatedDateTime);
            failureReason(model.failureReason);
        }

        public final SolutionUpdateConfig.Builder getSolutionUpdateConfig() {
            return solutionUpdateConfig != null ? solutionUpdateConfig.toBuilder() : null;
        }

        public final void setSolutionUpdateConfig(SolutionUpdateConfig.BuilderImpl solutionUpdateConfig) {
            this.solutionUpdateConfig = solutionUpdateConfig != null ? solutionUpdateConfig.build() : null;
        }

        @Override
        public final Builder solutionUpdateConfig(SolutionUpdateConfig solutionUpdateConfig) {
            this.solutionUpdateConfig = solutionUpdateConfig;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final Boolean getPerformAutoTraining() {
            return performAutoTraining;
        }

        public final void setPerformAutoTraining(Boolean performAutoTraining) {
            this.performAutoTraining = performAutoTraining;
        }

        @Override
        public final Builder performAutoTraining(Boolean performAutoTraining) {
            this.performAutoTraining = performAutoTraining;
            return this;
        }

        public final Instant getCreationDateTime() {
            return creationDateTime;
        }

        public final void setCreationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
        }

        @Override
        public final Builder creationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
            return this;
        }

        public final Instant getLastUpdatedDateTime() {
            return lastUpdatedDateTime;
        }

        public final void setLastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
        }

        @Override
        public final Builder lastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
            return this;
        }

        public final String getFailureReason() {
            return failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        @Override
        public SolutionUpdateSummary build() {
            return new SolutionUpdateSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
