/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.personalize.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration details of the solution update.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SolutionUpdateConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<SolutionUpdateConfig.Builder, SolutionUpdateConfig> {
    private static final SdkField<AutoTrainingConfig> AUTO_TRAINING_CONFIG_FIELD = SdkField
            .<AutoTrainingConfig> builder(MarshallingType.SDK_POJO).memberName("autoTrainingConfig")
            .getter(getter(SolutionUpdateConfig::autoTrainingConfig)).setter(setter(Builder::autoTrainingConfig))
            .constructor(AutoTrainingConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoTrainingConfig").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTO_TRAINING_CONFIG_FIELD));

    private static final long serialVersionUID = 1L;

    private final AutoTrainingConfig autoTrainingConfig;

    private SolutionUpdateConfig(BuilderImpl builder) {
        this.autoTrainingConfig = builder.autoTrainingConfig;
    }

    /**
     * Returns the value of the AutoTrainingConfig property for this object.
     * 
     * @return The value of the AutoTrainingConfig property for this object.
     */
    public final AutoTrainingConfig autoTrainingConfig() {
        return autoTrainingConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(autoTrainingConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SolutionUpdateConfig)) {
            return false;
        }
        SolutionUpdateConfig other = (SolutionUpdateConfig) obj;
        return Objects.equals(autoTrainingConfig(), other.autoTrainingConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SolutionUpdateConfig").add("AutoTrainingConfig", autoTrainingConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "autoTrainingConfig":
            return Optional.ofNullable(clazz.cast(autoTrainingConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SolutionUpdateConfig, T> g) {
        return obj -> g.apply((SolutionUpdateConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SolutionUpdateConfig> {
        /**
         * Sets the value of the AutoTrainingConfig property for this object.
         *
         * @param autoTrainingConfig
         *        The new value for the AutoTrainingConfig property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoTrainingConfig(AutoTrainingConfig autoTrainingConfig);

        /**
         * Sets the value of the AutoTrainingConfig property for this object.
         *
         * This is a convenience method that creates an instance of the {@link AutoTrainingConfig.Builder} avoiding the
         * need to create one manually via {@link AutoTrainingConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AutoTrainingConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #autoTrainingConfig(AutoTrainingConfig)}.
         * 
         * @param autoTrainingConfig
         *        a consumer that will call methods on {@link AutoTrainingConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #autoTrainingConfig(AutoTrainingConfig)
         */
        default Builder autoTrainingConfig(Consumer<AutoTrainingConfig.Builder> autoTrainingConfig) {
            return autoTrainingConfig(AutoTrainingConfig.builder().applyMutation(autoTrainingConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AutoTrainingConfig autoTrainingConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(SolutionUpdateConfig model) {
            autoTrainingConfig(model.autoTrainingConfig);
        }

        public final AutoTrainingConfig.Builder getAutoTrainingConfig() {
            return autoTrainingConfig != null ? autoTrainingConfig.toBuilder() : null;
        }

        public final void setAutoTrainingConfig(AutoTrainingConfig.BuilderImpl autoTrainingConfig) {
            this.autoTrainingConfig = autoTrainingConfig != null ? autoTrainingConfig.build() : null;
        }

        @Override
        public final Builder autoTrainingConfig(AutoTrainingConfig autoTrainingConfig) {
            this.autoTrainingConfig = autoTrainingConfig;
            return this;
        }

        @Override
        public SolutionUpdateConfig build() {
            return new SolutionUpdateConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
