/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.personalize.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.personalize.model.PersonalizeRequest;
import software.amazon.awssdk.services.personalize.model.SolutionConfig;
import software.amazon.awssdk.services.personalize.model.Tag;
import software.amazon.awssdk.services.personalize.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateSolutionRequest
extends PersonalizeRequest
implements ToCopyableBuilder<Builder, CreateSolutionRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreateSolutionRequest.getter(CreateSolutionRequest::name)).setter(CreateSolutionRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<Boolean> PERFORM_HPO_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("performHPO").getter(CreateSolutionRequest.getter(CreateSolutionRequest::performHPO)).setter(CreateSolutionRequest.setter(Builder::performHPO)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("performHPO").build()}).build();
    private static final SdkField<Boolean> PERFORM_AUTO_ML_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("performAutoML").getter(CreateSolutionRequest.getter(CreateSolutionRequest::performAutoML)).setter(CreateSolutionRequest.setter(Builder::performAutoML)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("performAutoML").build()}).build();
    private static final SdkField<Boolean> PERFORM_AUTO_TRAINING_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("performAutoTraining").getter(CreateSolutionRequest.getter(CreateSolutionRequest::performAutoTraining)).setter(CreateSolutionRequest.setter(Builder::performAutoTraining)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("performAutoTraining").build()}).build();
    private static final SdkField<String> RECIPE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("recipeArn").getter(CreateSolutionRequest.getter(CreateSolutionRequest::recipeArn)).setter(CreateSolutionRequest.setter(Builder::recipeArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recipeArn").build()}).build();
    private static final SdkField<String> DATASET_GROUP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("datasetGroupArn").getter(CreateSolutionRequest.getter(CreateSolutionRequest::datasetGroupArn)).setter(CreateSolutionRequest.setter(Builder::datasetGroupArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datasetGroupArn").build()}).build();
    private static final SdkField<String> EVENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("eventType").getter(CreateSolutionRequest.getter(CreateSolutionRequest::eventType)).setter(CreateSolutionRequest.setter(Builder::eventType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventType").build()}).build();
    private static final SdkField<SolutionConfig> SOLUTION_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("solutionConfig").getter(CreateSolutionRequest.getter(CreateSolutionRequest::solutionConfig)).setter(CreateSolutionRequest.setter(Builder::solutionConfig)).constructor(SolutionConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("solutionConfig").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tags").getter(CreateSolutionRequest.getter(CreateSolutionRequest::tags)).setter(CreateSolutionRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, PERFORM_HPO_FIELD, PERFORM_AUTO_ML_FIELD, PERFORM_AUTO_TRAINING_FIELD, RECIPE_ARN_FIELD, DATASET_GROUP_ARN_FIELD, EVENT_TYPE_FIELD, SOLUTION_CONFIG_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("name", NAME_FIELD);
            this.put("performHPO", PERFORM_HPO_FIELD);
            this.put("performAutoML", PERFORM_AUTO_ML_FIELD);
            this.put("performAutoTraining", PERFORM_AUTO_TRAINING_FIELD);
            this.put("recipeArn", RECIPE_ARN_FIELD);
            this.put("datasetGroupArn", DATASET_GROUP_ARN_FIELD);
            this.put("eventType", EVENT_TYPE_FIELD);
            this.put("solutionConfig", SOLUTION_CONFIG_FIELD);
            this.put("tags", TAGS_FIELD);
        }
    });
    private final String name;
    private final Boolean performHPO;
    private final Boolean performAutoML;
    private final Boolean performAutoTraining;
    private final String recipeArn;
    private final String datasetGroupArn;
    private final String eventType;
    private final SolutionConfig solutionConfig;
    private final List<Tag> tags;

    private CreateSolutionRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.performHPO = builder.performHPO;
        this.performAutoML = builder.performAutoML;
        this.performAutoTraining = builder.performAutoTraining;
        this.recipeArn = builder.recipeArn;
        this.datasetGroupArn = builder.datasetGroupArn;
        this.eventType = builder.eventType;
        this.solutionConfig = builder.solutionConfig;
        this.tags = builder.tags;
    }

    public final String name() {
        return this.name;
    }

    public final Boolean performHPO() {
        return this.performHPO;
    }

    public final Boolean performAutoML() {
        return this.performAutoML;
    }

    public final Boolean performAutoTraining() {
        return this.performAutoTraining;
    }

    public final String recipeArn() {
        return this.recipeArn;
    }

    public final String datasetGroupArn() {
        return this.datasetGroupArn;
    }

    public final String eventType() {
        return this.eventType;
    }

    public final SolutionConfig solutionConfig() {
        return this.solutionConfig;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.performHPO());
        hashCode = 31 * hashCode + Objects.hashCode(this.performAutoML());
        hashCode = 31 * hashCode + Objects.hashCode(this.performAutoTraining());
        hashCode = 31 * hashCode + Objects.hashCode(this.recipeArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.datasetGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventType());
        hashCode = 31 * hashCode + Objects.hashCode(this.solutionConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSolutionRequest)) {
            return false;
        }
        CreateSolutionRequest other = (CreateSolutionRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.performHPO(), other.performHPO()) && Objects.equals(this.performAutoML(), other.performAutoML()) && Objects.equals(this.performAutoTraining(), other.performAutoTraining()) && Objects.equals(this.recipeArn(), other.recipeArn()) && Objects.equals(this.datasetGroupArn(), other.datasetGroupArn()) && Objects.equals(this.eventType(), other.eventType()) && Objects.equals(this.solutionConfig(), other.solutionConfig()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateSolutionRequest").add("Name", (Object)this.name()).add("PerformHPO", (Object)this.performHPO()).add("PerformAutoML", (Object)this.performAutoML()).add("PerformAutoTraining", (Object)this.performAutoTraining()).add("RecipeArn", (Object)this.recipeArn()).add("DatasetGroupArn", (Object)this.datasetGroupArn()).add("EventType", (Object)this.eventType()).add("SolutionConfig", (Object)this.solutionConfig()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "performHPO": {
                return Optional.ofNullable(clazz.cast(this.performHPO()));
            }
            case "performAutoML": {
                return Optional.ofNullable(clazz.cast(this.performAutoML()));
            }
            case "performAutoTraining": {
                return Optional.ofNullable(clazz.cast(this.performAutoTraining()));
            }
            case "recipeArn": {
                return Optional.ofNullable(clazz.cast(this.recipeArn()));
            }
            case "datasetGroupArn": {
                return Optional.ofNullable(clazz.cast(this.datasetGroupArn()));
            }
            case "eventType": {
                return Optional.ofNullable(clazz.cast(this.eventType()));
            }
            case "solutionConfig": {
                return Optional.ofNullable(clazz.cast(this.solutionConfig()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateSolutionRequest, T> g) {
        return obj -> g.apply((CreateSolutionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PersonalizeRequest.BuilderImpl
    implements Builder {
        private String name;
        private Boolean performHPO;
        private Boolean performAutoML;
        private Boolean performAutoTraining;
        private String recipeArn;
        private String datasetGroupArn;
        private String eventType;
        private SolutionConfig solutionConfig;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSolutionRequest model) {
            super(model);
            this.name(model.name);
            this.performHPO(model.performHPO);
            this.performAutoML(model.performAutoML);
            this.performAutoTraining(model.performAutoTraining);
            this.recipeArn(model.recipeArn);
            this.datasetGroupArn(model.datasetGroupArn);
            this.eventType(model.eventType);
            this.solutionConfig(model.solutionConfig);
            this.tags(model.tags);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Boolean getPerformHPO() {
            return this.performHPO;
        }

        public final void setPerformHPO(Boolean performHPO) {
            this.performHPO = performHPO;
        }

        @Override
        public final Builder performHPO(Boolean performHPO) {
            this.performHPO = performHPO;
            return this;
        }

        public final Boolean getPerformAutoML() {
            return this.performAutoML;
        }

        public final void setPerformAutoML(Boolean performAutoML) {
            this.performAutoML = performAutoML;
        }

        @Override
        public final Builder performAutoML(Boolean performAutoML) {
            this.performAutoML = performAutoML;
            return this;
        }

        public final Boolean getPerformAutoTraining() {
            return this.performAutoTraining;
        }

        public final void setPerformAutoTraining(Boolean performAutoTraining) {
            this.performAutoTraining = performAutoTraining;
        }

        @Override
        public final Builder performAutoTraining(Boolean performAutoTraining) {
            this.performAutoTraining = performAutoTraining;
            return this;
        }

        public final String getRecipeArn() {
            return this.recipeArn;
        }

        public final void setRecipeArn(String recipeArn) {
            this.recipeArn = recipeArn;
        }

        @Override
        public final Builder recipeArn(String recipeArn) {
            this.recipeArn = recipeArn;
            return this;
        }

        public final String getDatasetGroupArn() {
            return this.datasetGroupArn;
        }

        public final void setDatasetGroupArn(String datasetGroupArn) {
            this.datasetGroupArn = datasetGroupArn;
        }

        @Override
        public final Builder datasetGroupArn(String datasetGroupArn) {
            this.datasetGroupArn = datasetGroupArn;
            return this;
        }

        public final String getEventType() {
            return this.eventType;
        }

        public final void setEventType(String eventType) {
            this.eventType = eventType;
        }

        @Override
        public final Builder eventType(String eventType) {
            this.eventType = eventType;
            return this;
        }

        public final SolutionConfig.Builder getSolutionConfig() {
            return this.solutionConfig != null ? this.solutionConfig.toBuilder() : null;
        }

        public final void setSolutionConfig(SolutionConfig.BuilderImpl solutionConfig) {
            this.solutionConfig = solutionConfig != null ? solutionConfig.build() : null;
        }

        @Override
        public final Builder solutionConfig(SolutionConfig solutionConfig) {
            this.solutionConfig = solutionConfig;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateSolutionRequest build() {
            return new CreateSolutionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends PersonalizeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateSolutionRequest> {
        public Builder name(String var1);

        public Builder performHPO(Boolean var1);

        public Builder performAutoML(Boolean var1);

        public Builder performAutoTraining(Boolean var1);

        public Builder recipeArn(String var1);

        public Builder datasetGroupArn(String var1);

        public Builder eventType(String var1);

        public Builder solutionConfig(SolutionConfig var1);

        default public Builder solutionConfig(Consumer<SolutionConfig.Builder> solutionConfig) {
            return this.solutionConfig((SolutionConfig)((SolutionConfig.Builder)SolutionConfig.builder().applyMutation(solutionConfig)).build());
        }

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

