/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.personalize.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateBatchInferenceJobRequest extends PersonalizeRequest implements
        ToCopyableBuilder<CreateBatchInferenceJobRequest.Builder, CreateBatchInferenceJobRequest> {
    private static final SdkField<String> JOB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("jobName").getter(getter(CreateBatchInferenceJobRequest::jobName)).setter(setter(Builder::jobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobName").build()).build();

    private static final SdkField<String> SOLUTION_VERSION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("solutionVersionArn").getter(getter(CreateBatchInferenceJobRequest::solutionVersionArn))
            .setter(setter(Builder::solutionVersionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("solutionVersionArn").build())
            .build();

    private static final SdkField<String> FILTER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("filterArn").getter(getter(CreateBatchInferenceJobRequest::filterArn)).setter(setter(Builder::filterArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterArn").build()).build();

    private static final SdkField<Integer> NUM_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("numResults").getter(getter(CreateBatchInferenceJobRequest::numResults))
            .setter(setter(Builder::numResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numResults").build()).build();

    private static final SdkField<BatchInferenceJobInput> JOB_INPUT_FIELD = SdkField
            .<BatchInferenceJobInput> builder(MarshallingType.SDK_POJO).memberName("jobInput")
            .getter(getter(CreateBatchInferenceJobRequest::jobInput)).setter(setter(Builder::jobInput))
            .constructor(BatchInferenceJobInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobInput").build()).build();

    private static final SdkField<BatchInferenceJobOutput> JOB_OUTPUT_FIELD = SdkField
            .<BatchInferenceJobOutput> builder(MarshallingType.SDK_POJO).memberName("jobOutput")
            .getter(getter(CreateBatchInferenceJobRequest::jobOutput)).setter(setter(Builder::jobOutput))
            .constructor(BatchInferenceJobOutput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobOutput").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(CreateBatchInferenceJobRequest::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<BatchInferenceJobConfig> BATCH_INFERENCE_JOB_CONFIG_FIELD = SdkField
            .<BatchInferenceJobConfig> builder(MarshallingType.SDK_POJO).memberName("batchInferenceJobConfig")
            .getter(getter(CreateBatchInferenceJobRequest::batchInferenceJobConfig))
            .setter(setter(Builder::batchInferenceJobConfig)).constructor(BatchInferenceJobConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("batchInferenceJobConfig").build())
            .build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("tags")
            .getter(getter(CreateBatchInferenceJobRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> BATCH_INFERENCE_JOB_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("batchInferenceJobMode").getter(getter(CreateBatchInferenceJobRequest::batchInferenceJobModeAsString))
            .setter(setter(Builder::batchInferenceJobMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("batchInferenceJobMode").build())
            .build();

    private static final SdkField<ThemeGenerationConfig> THEME_GENERATION_CONFIG_FIELD = SdkField
            .<ThemeGenerationConfig> builder(MarshallingType.SDK_POJO).memberName("themeGenerationConfig")
            .getter(getter(CreateBatchInferenceJobRequest::themeGenerationConfig)).setter(setter(Builder::themeGenerationConfig))
            .constructor(ThemeGenerationConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("themeGenerationConfig").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_NAME_FIELD,
            SOLUTION_VERSION_ARN_FIELD, FILTER_ARN_FIELD, NUM_RESULTS_FIELD, JOB_INPUT_FIELD, JOB_OUTPUT_FIELD, ROLE_ARN_FIELD,
            BATCH_INFERENCE_JOB_CONFIG_FIELD, TAGS_FIELD, BATCH_INFERENCE_JOB_MODE_FIELD, THEME_GENERATION_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("jobName", JOB_NAME_FIELD);
                    put("solutionVersionArn", SOLUTION_VERSION_ARN_FIELD);
                    put("filterArn", FILTER_ARN_FIELD);
                    put("numResults", NUM_RESULTS_FIELD);
                    put("jobInput", JOB_INPUT_FIELD);
                    put("jobOutput", JOB_OUTPUT_FIELD);
                    put("roleArn", ROLE_ARN_FIELD);
                    put("batchInferenceJobConfig", BATCH_INFERENCE_JOB_CONFIG_FIELD);
                    put("tags", TAGS_FIELD);
                    put("batchInferenceJobMode", BATCH_INFERENCE_JOB_MODE_FIELD);
                    put("themeGenerationConfig", THEME_GENERATION_CONFIG_FIELD);
                }
            });

    private final String jobName;

    private final String solutionVersionArn;

    private final String filterArn;

    private final Integer numResults;

    private final BatchInferenceJobInput jobInput;

    private final BatchInferenceJobOutput jobOutput;

    private final String roleArn;

    private final BatchInferenceJobConfig batchInferenceJobConfig;

    private final List<Tag> tags;

    private final String batchInferenceJobMode;

    private final ThemeGenerationConfig themeGenerationConfig;

    private CreateBatchInferenceJobRequest(BuilderImpl builder) {
        super(builder);
        this.jobName = builder.jobName;
        this.solutionVersionArn = builder.solutionVersionArn;
        this.filterArn = builder.filterArn;
        this.numResults = builder.numResults;
        this.jobInput = builder.jobInput;
        this.jobOutput = builder.jobOutput;
        this.roleArn = builder.roleArn;
        this.batchInferenceJobConfig = builder.batchInferenceJobConfig;
        this.tags = builder.tags;
        this.batchInferenceJobMode = builder.batchInferenceJobMode;
        this.themeGenerationConfig = builder.themeGenerationConfig;
    }

    /**
     * <p>
     * The name of the batch inference job to create.
     * </p>
     * 
     * @return The name of the batch inference job to create.
     */
    public final String jobName() {
        return jobName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the solution version that will be used to generate the batch inference
     * recommendations.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the solution version that will be used to generate the batch inference
     *         recommendations.
     */
    public final String solutionVersionArn() {
        return solutionVersionArn;
    }

    /**
     * <p>
     * The ARN of the filter to apply to the batch inference job. For more information on using filters, see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/filter-batch.html">Filtering batch recommendations</a>.
     * </p>
     * 
     * @return The ARN of the filter to apply to the batch inference job. For more information on using filters, see <a
     *         href="https://docs.aws.amazon.com/personalize/latest/dg/filter-batch.html">Filtering batch
     *         recommendations</a>.
     */
    public final String filterArn() {
        return filterArn;
    }

    /**
     * <p>
     * The number of recommendations to retrieve.
     * </p>
     * 
     * @return The number of recommendations to retrieve.
     */
    public final Integer numResults() {
        return numResults;
    }

    /**
     * <p>
     * The Amazon S3 path that leads to the input file to base your recommendations on. The input material must be in
     * JSON format.
     * </p>
     * 
     * @return The Amazon S3 path that leads to the input file to base your recommendations on. The input material must
     *         be in JSON format.
     */
    public final BatchInferenceJobInput jobInput() {
        return jobInput;
    }

    /**
     * <p>
     * The path to the Amazon S3 bucket where the job's output will be stored.
     * </p>
     * 
     * @return The path to the Amazon S3 bucket where the job's output will be stored.
     */
    public final BatchInferenceJobOutput jobOutput() {
        return jobOutput;
    }

    /**
     * <p>
     * The ARN of the Amazon Identity and Access Management role that has permissions to read and write to your input
     * and output Amazon S3 buckets respectively.
     * </p>
     * 
     * @return The ARN of the Amazon Identity and Access Management role that has permissions to read and write to your
     *         input and output Amazon S3 buckets respectively.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The configuration details of a batch inference job.
     * </p>
     * 
     * @return The configuration details of a batch inference job.
     */
    public final BatchInferenceJobConfig batchInferenceJobConfig() {
        return batchInferenceJobConfig;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <a href="https://docs.aws.amazon.com/personalize/latest/dg/tagging-resources.html">tags</a> to apply to
     * the batch inference job.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A list of <a href="https://docs.aws.amazon.com/personalize/latest/dg/tagging-resources.html">tags</a> to
     *         apply to the batch inference job.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * The mode of the batch inference job. To generate descriptive themes for groups of similar items, set the job mode
     * to <code>THEME_GENERATION</code>. If you don't want to generate themes, use the default
     * <code>BATCH_INFERENCE</code>.
     * </p>
     * <p>
     * When you get batch recommendations with themes, you will incur additional costs. For more information, see <a
     * href="https://aws.amazon.com/personalize/pricing/">Amazon Personalize pricing</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #batchInferenceJobMode} will return {@link BatchInferenceJobMode#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #batchInferenceJobModeAsString}.
     * </p>
     * 
     * @return The mode of the batch inference job. To generate descriptive themes for groups of similar items, set the
     *         job mode to <code>THEME_GENERATION</code>. If you don't want to generate themes, use the default
     *         <code>BATCH_INFERENCE</code>.</p>
     *         <p>
     *         When you get batch recommendations with themes, you will incur additional costs. For more information,
     *         see <a href="https://aws.amazon.com/personalize/pricing/">Amazon Personalize pricing</a>.
     * @see BatchInferenceJobMode
     */
    public final BatchInferenceJobMode batchInferenceJobMode() {
        return BatchInferenceJobMode.fromValue(batchInferenceJobMode);
    }

    /**
     * <p>
     * The mode of the batch inference job. To generate descriptive themes for groups of similar items, set the job mode
     * to <code>THEME_GENERATION</code>. If you don't want to generate themes, use the default
     * <code>BATCH_INFERENCE</code>.
     * </p>
     * <p>
     * When you get batch recommendations with themes, you will incur additional costs. For more information, see <a
     * href="https://aws.amazon.com/personalize/pricing/">Amazon Personalize pricing</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #batchInferenceJobMode} will return {@link BatchInferenceJobMode#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #batchInferenceJobModeAsString}.
     * </p>
     * 
     * @return The mode of the batch inference job. To generate descriptive themes for groups of similar items, set the
     *         job mode to <code>THEME_GENERATION</code>. If you don't want to generate themes, use the default
     *         <code>BATCH_INFERENCE</code>.</p>
     *         <p>
     *         When you get batch recommendations with themes, you will incur additional costs. For more information,
     *         see <a href="https://aws.amazon.com/personalize/pricing/">Amazon Personalize pricing</a>.
     * @see BatchInferenceJobMode
     */
    public final String batchInferenceJobModeAsString() {
        return batchInferenceJobMode;
    }

    /**
     * <p>
     * For theme generation jobs, specify the name of the column in your Items dataset that contains each item's name.
     * </p>
     * 
     * @return For theme generation jobs, specify the name of the column in your Items dataset that contains each item's
     *         name.
     */
    public final ThemeGenerationConfig themeGenerationConfig() {
        return themeGenerationConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(jobName());
        hashCode = 31 * hashCode + Objects.hashCode(solutionVersionArn());
        hashCode = 31 * hashCode + Objects.hashCode(filterArn());
        hashCode = 31 * hashCode + Objects.hashCode(numResults());
        hashCode = 31 * hashCode + Objects.hashCode(jobInput());
        hashCode = 31 * hashCode + Objects.hashCode(jobOutput());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(batchInferenceJobConfig());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(batchInferenceJobModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(themeGenerationConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateBatchInferenceJobRequest)) {
            return false;
        }
        CreateBatchInferenceJobRequest other = (CreateBatchInferenceJobRequest) obj;
        return Objects.equals(jobName(), other.jobName()) && Objects.equals(solutionVersionArn(), other.solutionVersionArn())
                && Objects.equals(filterArn(), other.filterArn()) && Objects.equals(numResults(), other.numResults())
                && Objects.equals(jobInput(), other.jobInput()) && Objects.equals(jobOutput(), other.jobOutput())
                && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(batchInferenceJobConfig(), other.batchInferenceJobConfig()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags())
                && Objects.equals(batchInferenceJobModeAsString(), other.batchInferenceJobModeAsString())
                && Objects.equals(themeGenerationConfig(), other.themeGenerationConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateBatchInferenceJobRequest").add("JobName", jobName())
                .add("SolutionVersionArn", solutionVersionArn()).add("FilterArn", filterArn()).add("NumResults", numResults())
                .add("JobInput", jobInput()).add("JobOutput", jobOutput()).add("RoleArn", roleArn())
                .add("BatchInferenceJobConfig", batchInferenceJobConfig()).add("Tags", hasTags() ? tags() : null)
                .add("BatchInferenceJobMode", batchInferenceJobModeAsString())
                .add("ThemeGenerationConfig", themeGenerationConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "jobName":
            return Optional.ofNullable(clazz.cast(jobName()));
        case "solutionVersionArn":
            return Optional.ofNullable(clazz.cast(solutionVersionArn()));
        case "filterArn":
            return Optional.ofNullable(clazz.cast(filterArn()));
        case "numResults":
            return Optional.ofNullable(clazz.cast(numResults()));
        case "jobInput":
            return Optional.ofNullable(clazz.cast(jobInput()));
        case "jobOutput":
            return Optional.ofNullable(clazz.cast(jobOutput()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "batchInferenceJobConfig":
            return Optional.ofNullable(clazz.cast(batchInferenceJobConfig()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "batchInferenceJobMode":
            return Optional.ofNullable(clazz.cast(batchInferenceJobModeAsString()));
        case "themeGenerationConfig":
            return Optional.ofNullable(clazz.cast(themeGenerationConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateBatchInferenceJobRequest, T> g) {
        return obj -> g.apply((CreateBatchInferenceJobRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PersonalizeRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateBatchInferenceJobRequest> {
        /**
         * <p>
         * The name of the batch inference job to create.
         * </p>
         * 
         * @param jobName
         *        The name of the batch inference job to create.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobName(String jobName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the solution version that will be used to generate the batch inference
         * recommendations.
         * </p>
         * 
         * @param solutionVersionArn
         *        The Amazon Resource Name (ARN) of the solution version that will be used to generate the batch
         *        inference recommendations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder solutionVersionArn(String solutionVersionArn);

        /**
         * <p>
         * The ARN of the filter to apply to the batch inference job. For more information on using filters, see <a
         * href="https://docs.aws.amazon.com/personalize/latest/dg/filter-batch.html">Filtering batch
         * recommendations</a>.
         * </p>
         * 
         * @param filterArn
         *        The ARN of the filter to apply to the batch inference job. For more information on using filters, see
         *        <a href="https://docs.aws.amazon.com/personalize/latest/dg/filter-batch.html">Filtering batch
         *        recommendations</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterArn(String filterArn);

        /**
         * <p>
         * The number of recommendations to retrieve.
         * </p>
         * 
         * @param numResults
         *        The number of recommendations to retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numResults(Integer numResults);

        /**
         * <p>
         * The Amazon S3 path that leads to the input file to base your recommendations on. The input material must be
         * in JSON format.
         * </p>
         * 
         * @param jobInput
         *        The Amazon S3 path that leads to the input file to base your recommendations on. The input material
         *        must be in JSON format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobInput(BatchInferenceJobInput jobInput);

        /**
         * <p>
         * The Amazon S3 path that leads to the input file to base your recommendations on. The input material must be
         * in JSON format.
         * </p>
         * This is a convenience method that creates an instance of the {@link BatchInferenceJobInput.Builder} avoiding
         * the need to create one manually via {@link BatchInferenceJobInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BatchInferenceJobInput.Builder#build()} is called immediately and
         * its result is passed to {@link #jobInput(BatchInferenceJobInput)}.
         * 
         * @param jobInput
         *        a consumer that will call methods on {@link BatchInferenceJobInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #jobInput(BatchInferenceJobInput)
         */
        default Builder jobInput(Consumer<BatchInferenceJobInput.Builder> jobInput) {
            return jobInput(BatchInferenceJobInput.builder().applyMutation(jobInput).build());
        }

        /**
         * <p>
         * The path to the Amazon S3 bucket where the job's output will be stored.
         * </p>
         * 
         * @param jobOutput
         *        The path to the Amazon S3 bucket where the job's output will be stored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobOutput(BatchInferenceJobOutput jobOutput);

        /**
         * <p>
         * The path to the Amazon S3 bucket where the job's output will be stored.
         * </p>
         * This is a convenience method that creates an instance of the {@link BatchInferenceJobOutput.Builder} avoiding
         * the need to create one manually via {@link BatchInferenceJobOutput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BatchInferenceJobOutput.Builder#build()} is called immediately
         * and its result is passed to {@link #jobOutput(BatchInferenceJobOutput)}.
         * 
         * @param jobOutput
         *        a consumer that will call methods on {@link BatchInferenceJobOutput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #jobOutput(BatchInferenceJobOutput)
         */
        default Builder jobOutput(Consumer<BatchInferenceJobOutput.Builder> jobOutput) {
            return jobOutput(BatchInferenceJobOutput.builder().applyMutation(jobOutput).build());
        }

        /**
         * <p>
         * The ARN of the Amazon Identity and Access Management role that has permissions to read and write to your
         * input and output Amazon S3 buckets respectively.
         * </p>
         * 
         * @param roleArn
         *        The ARN of the Amazon Identity and Access Management role that has permissions to read and write to
         *        your input and output Amazon S3 buckets respectively.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The configuration details of a batch inference job.
         * </p>
         * 
         * @param batchInferenceJobConfig
         *        The configuration details of a batch inference job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder batchInferenceJobConfig(BatchInferenceJobConfig batchInferenceJobConfig);

        /**
         * <p>
         * The configuration details of a batch inference job.
         * </p>
         * This is a convenience method that creates an instance of the {@link BatchInferenceJobConfig.Builder} avoiding
         * the need to create one manually via {@link BatchInferenceJobConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BatchInferenceJobConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #batchInferenceJobConfig(BatchInferenceJobConfig)}.
         * 
         * @param batchInferenceJobConfig
         *        a consumer that will call methods on {@link BatchInferenceJobConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #batchInferenceJobConfig(BatchInferenceJobConfig)
         */
        default Builder batchInferenceJobConfig(Consumer<BatchInferenceJobConfig.Builder> batchInferenceJobConfig) {
            return batchInferenceJobConfig(BatchInferenceJobConfig.builder().applyMutation(batchInferenceJobConfig).build());
        }

        /**
         * <p>
         * A list of <a href="https://docs.aws.amazon.com/personalize/latest/dg/tagging-resources.html">tags</a> to
         * apply to the batch inference job.
         * </p>
         * 
         * @param tags
         *        A list of <a href="https://docs.aws.amazon.com/personalize/latest/dg/tagging-resources.html">tags</a>
         *        to apply to the batch inference job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * A list of <a href="https://docs.aws.amazon.com/personalize/latest/dg/tagging-resources.html">tags</a> to
         * apply to the batch inference job.
         * </p>
         * 
         * @param tags
         *        A list of <a href="https://docs.aws.amazon.com/personalize/latest/dg/tagging-resources.html">tags</a>
         *        to apply to the batch inference job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * A list of <a href="https://docs.aws.amazon.com/personalize/latest/dg/tagging-resources.html">tags</a> to
         * apply to the batch inference job.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.personalize.model.Tag.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.personalize.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.personalize.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.personalize.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * The mode of the batch inference job. To generate descriptive themes for groups of similar items, set the job
         * mode to <code>THEME_GENERATION</code>. If you don't want to generate themes, use the default
         * <code>BATCH_INFERENCE</code>.
         * </p>
         * <p>
         * When you get batch recommendations with themes, you will incur additional costs. For more information, see <a
         * href="https://aws.amazon.com/personalize/pricing/">Amazon Personalize pricing</a>.
         * </p>
         * 
         * @param batchInferenceJobMode
         *        The mode of the batch inference job. To generate descriptive themes for groups of similar items, set
         *        the job mode to <code>THEME_GENERATION</code>. If you don't want to generate themes, use the default
         *        <code>BATCH_INFERENCE</code>.</p>
         *        <p>
         *        When you get batch recommendations with themes, you will incur additional costs. For more information,
         *        see <a href="https://aws.amazon.com/personalize/pricing/">Amazon Personalize pricing</a>.
         * @see BatchInferenceJobMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BatchInferenceJobMode
         */
        Builder batchInferenceJobMode(String batchInferenceJobMode);

        /**
         * <p>
         * The mode of the batch inference job. To generate descriptive themes for groups of similar items, set the job
         * mode to <code>THEME_GENERATION</code>. If you don't want to generate themes, use the default
         * <code>BATCH_INFERENCE</code>.
         * </p>
         * <p>
         * When you get batch recommendations with themes, you will incur additional costs. For more information, see <a
         * href="https://aws.amazon.com/personalize/pricing/">Amazon Personalize pricing</a>.
         * </p>
         * 
         * @param batchInferenceJobMode
         *        The mode of the batch inference job. To generate descriptive themes for groups of similar items, set
         *        the job mode to <code>THEME_GENERATION</code>. If you don't want to generate themes, use the default
         *        <code>BATCH_INFERENCE</code>.</p>
         *        <p>
         *        When you get batch recommendations with themes, you will incur additional costs. For more information,
         *        see <a href="https://aws.amazon.com/personalize/pricing/">Amazon Personalize pricing</a>.
         * @see BatchInferenceJobMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BatchInferenceJobMode
         */
        Builder batchInferenceJobMode(BatchInferenceJobMode batchInferenceJobMode);

        /**
         * <p>
         * For theme generation jobs, specify the name of the column in your Items dataset that contains each item's
         * name.
         * </p>
         * 
         * @param themeGenerationConfig
         *        For theme generation jobs, specify the name of the column in your Items dataset that contains each
         *        item's name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder themeGenerationConfig(ThemeGenerationConfig themeGenerationConfig);

        /**
         * <p>
         * For theme generation jobs, specify the name of the column in your Items dataset that contains each item's
         * name.
         * </p>
         * This is a convenience method that creates an instance of the {@link ThemeGenerationConfig.Builder} avoiding
         * the need to create one manually via {@link ThemeGenerationConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ThemeGenerationConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #themeGenerationConfig(ThemeGenerationConfig)}.
         * 
         * @param themeGenerationConfig
         *        a consumer that will call methods on {@link ThemeGenerationConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #themeGenerationConfig(ThemeGenerationConfig)
         */
        default Builder themeGenerationConfig(Consumer<ThemeGenerationConfig.Builder> themeGenerationConfig) {
            return themeGenerationConfig(ThemeGenerationConfig.builder().applyMutation(themeGenerationConfig).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PersonalizeRequest.BuilderImpl implements Builder {
        private String jobName;

        private String solutionVersionArn;

        private String filterArn;

        private Integer numResults;

        private BatchInferenceJobInput jobInput;

        private BatchInferenceJobOutput jobOutput;

        private String roleArn;

        private BatchInferenceJobConfig batchInferenceJobConfig;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private String batchInferenceJobMode;

        private ThemeGenerationConfig themeGenerationConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateBatchInferenceJobRequest model) {
            super(model);
            jobName(model.jobName);
            solutionVersionArn(model.solutionVersionArn);
            filterArn(model.filterArn);
            numResults(model.numResults);
            jobInput(model.jobInput);
            jobOutput(model.jobOutput);
            roleArn(model.roleArn);
            batchInferenceJobConfig(model.batchInferenceJobConfig);
            tags(model.tags);
            batchInferenceJobMode(model.batchInferenceJobMode);
            themeGenerationConfig(model.themeGenerationConfig);
        }

        public final String getJobName() {
            return jobName;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final String getSolutionVersionArn() {
            return solutionVersionArn;
        }

        public final void setSolutionVersionArn(String solutionVersionArn) {
            this.solutionVersionArn = solutionVersionArn;
        }

        @Override
        public final Builder solutionVersionArn(String solutionVersionArn) {
            this.solutionVersionArn = solutionVersionArn;
            return this;
        }

        public final String getFilterArn() {
            return filterArn;
        }

        public final void setFilterArn(String filterArn) {
            this.filterArn = filterArn;
        }

        @Override
        public final Builder filterArn(String filterArn) {
            this.filterArn = filterArn;
            return this;
        }

        public final Integer getNumResults() {
            return numResults;
        }

        public final void setNumResults(Integer numResults) {
            this.numResults = numResults;
        }

        @Override
        public final Builder numResults(Integer numResults) {
            this.numResults = numResults;
            return this;
        }

        public final BatchInferenceJobInput.Builder getJobInput() {
            return jobInput != null ? jobInput.toBuilder() : null;
        }

        public final void setJobInput(BatchInferenceJobInput.BuilderImpl jobInput) {
            this.jobInput = jobInput != null ? jobInput.build() : null;
        }

        @Override
        public final Builder jobInput(BatchInferenceJobInput jobInput) {
            this.jobInput = jobInput;
            return this;
        }

        public final BatchInferenceJobOutput.Builder getJobOutput() {
            return jobOutput != null ? jobOutput.toBuilder() : null;
        }

        public final void setJobOutput(BatchInferenceJobOutput.BuilderImpl jobOutput) {
            this.jobOutput = jobOutput != null ? jobOutput.build() : null;
        }

        @Override
        public final Builder jobOutput(BatchInferenceJobOutput jobOutput) {
            this.jobOutput = jobOutput;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final BatchInferenceJobConfig.Builder getBatchInferenceJobConfig() {
            return batchInferenceJobConfig != null ? batchInferenceJobConfig.toBuilder() : null;
        }

        public final void setBatchInferenceJobConfig(BatchInferenceJobConfig.BuilderImpl batchInferenceJobConfig) {
            this.batchInferenceJobConfig = batchInferenceJobConfig != null ? batchInferenceJobConfig.build() : null;
        }

        @Override
        public final Builder batchInferenceJobConfig(BatchInferenceJobConfig batchInferenceJobConfig) {
            this.batchInferenceJobConfig = batchInferenceJobConfig;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getBatchInferenceJobMode() {
            return batchInferenceJobMode;
        }

        public final void setBatchInferenceJobMode(String batchInferenceJobMode) {
            this.batchInferenceJobMode = batchInferenceJobMode;
        }

        @Override
        public final Builder batchInferenceJobMode(String batchInferenceJobMode) {
            this.batchInferenceJobMode = batchInferenceJobMode;
            return this;
        }

        @Override
        public final Builder batchInferenceJobMode(BatchInferenceJobMode batchInferenceJobMode) {
            this.batchInferenceJobMode(batchInferenceJobMode == null ? null : batchInferenceJobMode.toString());
            return this;
        }

        public final ThemeGenerationConfig.Builder getThemeGenerationConfig() {
            return themeGenerationConfig != null ? themeGenerationConfig.toBuilder() : null;
        }

        public final void setThemeGenerationConfig(ThemeGenerationConfig.BuilderImpl themeGenerationConfig) {
            this.themeGenerationConfig = themeGenerationConfig != null ? themeGenerationConfig.build() : null;
        }

        @Override
        public final Builder themeGenerationConfig(ThemeGenerationConfig themeGenerationConfig) {
            this.themeGenerationConfig = themeGenerationConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateBatchInferenceJobRequest build() {
            return new CreateBatchInferenceJobRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
