/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.personalize.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateEventTrackerResponse extends PersonalizeResponse implements
        ToCopyableBuilder<CreateEventTrackerResponse.Builder, CreateEventTrackerResponse> {
    private static final SdkField<String> EVENT_TRACKER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("eventTrackerArn").getter(getter(CreateEventTrackerResponse::eventTrackerArn))
            .setter(setter(Builder::eventTrackerArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventTrackerArn").build()).build();

    private static final SdkField<String> TRACKING_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("trackingId").getter(getter(CreateEventTrackerResponse::trackingId)).setter(setter(Builder::trackingId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trackingId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_TRACKER_ARN_FIELD,
            TRACKING_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("eventTrackerArn", EVENT_TRACKER_ARN_FIELD);
                    put("trackingId", TRACKING_ID_FIELD);
                }
            });

    private final String eventTrackerArn;

    private final String trackingId;

    private CreateEventTrackerResponse(BuilderImpl builder) {
        super(builder);
        this.eventTrackerArn = builder.eventTrackerArn;
        this.trackingId = builder.trackingId;
    }

    /**
     * <p>
     * The ARN of the event tracker.
     * </p>
     * 
     * @return The ARN of the event tracker.
     */
    public final String eventTrackerArn() {
        return eventTrackerArn;
    }

    /**
     * <p>
     * The ID of the event tracker. Include this ID in requests to the <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_UBS_PutEvents.html">PutEvents</a> API.
     * </p>
     * 
     * @return The ID of the event tracker. Include this ID in requests to the <a
     *         href="https://docs.aws.amazon.com/personalize/latest/dg/API_UBS_PutEvents.html">PutEvents</a> API.
     */
    public final String trackingId() {
        return trackingId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(eventTrackerArn());
        hashCode = 31 * hashCode + Objects.hashCode(trackingId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateEventTrackerResponse)) {
            return false;
        }
        CreateEventTrackerResponse other = (CreateEventTrackerResponse) obj;
        return Objects.equals(eventTrackerArn(), other.eventTrackerArn()) && Objects.equals(trackingId(), other.trackingId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateEventTrackerResponse").add("EventTrackerArn", eventTrackerArn())
                .add("TrackingId", trackingId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "eventTrackerArn":
            return Optional.ofNullable(clazz.cast(eventTrackerArn()));
        case "trackingId":
            return Optional.ofNullable(clazz.cast(trackingId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateEventTrackerResponse, T> g) {
        return obj -> g.apply((CreateEventTrackerResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PersonalizeResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateEventTrackerResponse> {
        /**
         * <p>
         * The ARN of the event tracker.
         * </p>
         * 
         * @param eventTrackerArn
         *        The ARN of the event tracker.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventTrackerArn(String eventTrackerArn);

        /**
         * <p>
         * The ID of the event tracker. Include this ID in requests to the <a
         * href="https://docs.aws.amazon.com/personalize/latest/dg/API_UBS_PutEvents.html">PutEvents</a> API.
         * </p>
         * 
         * @param trackingId
         *        The ID of the event tracker. Include this ID in requests to the <a
         *        href="https://docs.aws.amazon.com/personalize/latest/dg/API_UBS_PutEvents.html">PutEvents</a> API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trackingId(String trackingId);
    }

    static final class BuilderImpl extends PersonalizeResponse.BuilderImpl implements Builder {
        private String eventTrackerArn;

        private String trackingId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateEventTrackerResponse model) {
            super(model);
            eventTrackerArn(model.eventTrackerArn);
            trackingId(model.trackingId);
        }

        public final String getEventTrackerArn() {
            return eventTrackerArn;
        }

        public final void setEventTrackerArn(String eventTrackerArn) {
            this.eventTrackerArn = eventTrackerArn;
        }

        @Override
        public final Builder eventTrackerArn(String eventTrackerArn) {
            this.eventTrackerArn = eventTrackerArn;
            return this;
        }

        public final String getTrackingId() {
            return trackingId;
        }

        public final void setTrackingId(String trackingId) {
            this.trackingId = trackingId;
        }

        @Override
        public final Builder trackingId(String trackingId) {
            this.trackingId = trackingId;
            return this;
        }

        @Override
        public CreateEventTrackerResponse build() {
            return new CreateEventTrackerResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
