/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.personalize.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides the name and default range of a integer-valued hyperparameter and whether the hyperparameter is tunable. A
 * tunable hyperparameter can have its value determined during hyperparameter optimization (HPO).
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DefaultIntegerHyperParameterRange implements SdkPojo, Serializable,
        ToCopyableBuilder<DefaultIntegerHyperParameterRange.Builder, DefaultIntegerHyperParameterRange> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(DefaultIntegerHyperParameterRange::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<Integer> MIN_VALUE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("minValue").getter(getter(DefaultIntegerHyperParameterRange::minValue)).setter(setter(Builder::minValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minValue").build()).build();

    private static final SdkField<Integer> MAX_VALUE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxValue").getter(getter(DefaultIntegerHyperParameterRange::maxValue)).setter(setter(Builder::maxValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxValue").build()).build();

    private static final SdkField<Boolean> IS_TUNABLE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("isTunable").getter(getter(DefaultIntegerHyperParameterRange::isTunable))
            .setter(setter(Builder::isTunable))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isTunable").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, MIN_VALUE_FIELD,
            MAX_VALUE_FIELD, IS_TUNABLE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("name", NAME_FIELD);
                    put("minValue", MIN_VALUE_FIELD);
                    put("maxValue", MAX_VALUE_FIELD);
                    put("isTunable", IS_TUNABLE_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String name;

    private final Integer minValue;

    private final Integer maxValue;

    private final Boolean isTunable;

    private DefaultIntegerHyperParameterRange(BuilderImpl builder) {
        this.name = builder.name;
        this.minValue = builder.minValue;
        this.maxValue = builder.maxValue;
        this.isTunable = builder.isTunable;
    }

    /**
     * <p>
     * The name of the hyperparameter.
     * </p>
     * 
     * @return The name of the hyperparameter.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The minimum allowable value for the hyperparameter.
     * </p>
     * 
     * @return The minimum allowable value for the hyperparameter.
     */
    public final Integer minValue() {
        return minValue;
    }

    /**
     * <p>
     * The maximum allowable value for the hyperparameter.
     * </p>
     * 
     * @return The maximum allowable value for the hyperparameter.
     */
    public final Integer maxValue() {
        return maxValue;
    }

    /**
     * <p>
     * Indicates whether the hyperparameter is tunable.
     * </p>
     * 
     * @return Indicates whether the hyperparameter is tunable.
     */
    public final Boolean isTunable() {
        return isTunable;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(minValue());
        hashCode = 31 * hashCode + Objects.hashCode(maxValue());
        hashCode = 31 * hashCode + Objects.hashCode(isTunable());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DefaultIntegerHyperParameterRange)) {
            return false;
        }
        DefaultIntegerHyperParameterRange other = (DefaultIntegerHyperParameterRange) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(minValue(), other.minValue())
                && Objects.equals(maxValue(), other.maxValue()) && Objects.equals(isTunable(), other.isTunable());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DefaultIntegerHyperParameterRange").add("Name", name()).add("MinValue", minValue())
                .add("MaxValue", maxValue()).add("IsTunable", isTunable()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "minValue":
            return Optional.ofNullable(clazz.cast(minValue()));
        case "maxValue":
            return Optional.ofNullable(clazz.cast(maxValue()));
        case "isTunable":
            return Optional.ofNullable(clazz.cast(isTunable()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DefaultIntegerHyperParameterRange, T> g) {
        return obj -> g.apply((DefaultIntegerHyperParameterRange) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DefaultIntegerHyperParameterRange> {
        /**
         * <p>
         * The name of the hyperparameter.
         * </p>
         * 
         * @param name
         *        The name of the hyperparameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The minimum allowable value for the hyperparameter.
         * </p>
         * 
         * @param minValue
         *        The minimum allowable value for the hyperparameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minValue(Integer minValue);

        /**
         * <p>
         * The maximum allowable value for the hyperparameter.
         * </p>
         * 
         * @param maxValue
         *        The maximum allowable value for the hyperparameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxValue(Integer maxValue);

        /**
         * <p>
         * Indicates whether the hyperparameter is tunable.
         * </p>
         * 
         * @param isTunable
         *        Indicates whether the hyperparameter is tunable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isTunable(Boolean isTunable);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private Integer minValue;

        private Integer maxValue;

        private Boolean isTunable;

        private BuilderImpl() {
        }

        private BuilderImpl(DefaultIntegerHyperParameterRange model) {
            name(model.name);
            minValue(model.minValue);
            maxValue(model.maxValue);
            isTunable(model.isTunable);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Integer getMinValue() {
            return minValue;
        }

        public final void setMinValue(Integer minValue) {
            this.minValue = minValue;
        }

        @Override
        public final Builder minValue(Integer minValue) {
            this.minValue = minValue;
            return this;
        }

        public final Integer getMaxValue() {
            return maxValue;
        }

        public final void setMaxValue(Integer maxValue) {
            this.maxValue = maxValue;
        }

        @Override
        public final Builder maxValue(Integer maxValue) {
            this.maxValue = maxValue;
            return this;
        }

        public final Boolean getIsTunable() {
            return isTunable;
        }

        public final void setIsTunable(Boolean isTunable) {
            this.isTunable = isTunable;
        }

        @Override
        public final Builder isTunable(Boolean isTunable) {
            this.isTunable = isTunable;
            return this;
        }

        @Override
        public DefaultIntegerHyperParameterRange build() {
            return new DefaultIntegerHyperParameterRange(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
