/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.personalize.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeBatchInferenceJobResponse extends PersonalizeResponse implements
        ToCopyableBuilder<DescribeBatchInferenceJobResponse.Builder, DescribeBatchInferenceJobResponse> {
    private static final SdkField<BatchInferenceJob> BATCH_INFERENCE_JOB_FIELD = SdkField
            .<BatchInferenceJob> builder(MarshallingType.SDK_POJO).memberName("batchInferenceJob")
            .getter(getter(DescribeBatchInferenceJobResponse::batchInferenceJob)).setter(setter(Builder::batchInferenceJob))
            .constructor(BatchInferenceJob::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("batchInferenceJob").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BATCH_INFERENCE_JOB_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("batchInferenceJob", BATCH_INFERENCE_JOB_FIELD);
                }
            });

    private final BatchInferenceJob batchInferenceJob;

    private DescribeBatchInferenceJobResponse(BuilderImpl builder) {
        super(builder);
        this.batchInferenceJob = builder.batchInferenceJob;
    }

    /**
     * <p>
     * Information on the specified batch inference job.
     * </p>
     * 
     * @return Information on the specified batch inference job.
     */
    public final BatchInferenceJob batchInferenceJob() {
        return batchInferenceJob;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(batchInferenceJob());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeBatchInferenceJobResponse)) {
            return false;
        }
        DescribeBatchInferenceJobResponse other = (DescribeBatchInferenceJobResponse) obj;
        return Objects.equals(batchInferenceJob(), other.batchInferenceJob());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeBatchInferenceJobResponse").add("BatchInferenceJob", batchInferenceJob()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "batchInferenceJob":
            return Optional.ofNullable(clazz.cast(batchInferenceJob()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeBatchInferenceJobResponse, T> g) {
        return obj -> g.apply((DescribeBatchInferenceJobResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PersonalizeResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeBatchInferenceJobResponse> {
        /**
         * <p>
         * Information on the specified batch inference job.
         * </p>
         * 
         * @param batchInferenceJob
         *        Information on the specified batch inference job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder batchInferenceJob(BatchInferenceJob batchInferenceJob);

        /**
         * <p>
         * Information on the specified batch inference job.
         * </p>
         * This is a convenience method that creates an instance of the {@link BatchInferenceJob.Builder} avoiding the
         * need to create one manually via {@link BatchInferenceJob#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BatchInferenceJob.Builder#build()} is called immediately and its
         * result is passed to {@link #batchInferenceJob(BatchInferenceJob)}.
         * 
         * @param batchInferenceJob
         *        a consumer that will call methods on {@link BatchInferenceJob.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #batchInferenceJob(BatchInferenceJob)
         */
        default Builder batchInferenceJob(Consumer<BatchInferenceJob.Builder> batchInferenceJob) {
            return batchInferenceJob(BatchInferenceJob.builder().applyMutation(batchInferenceJob).build());
        }
    }

    static final class BuilderImpl extends PersonalizeResponse.BuilderImpl implements Builder {
        private BatchInferenceJob batchInferenceJob;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeBatchInferenceJobResponse model) {
            super(model);
            batchInferenceJob(model.batchInferenceJob);
        }

        public final BatchInferenceJob.Builder getBatchInferenceJob() {
            return batchInferenceJob != null ? batchInferenceJob.toBuilder() : null;
        }

        public final void setBatchInferenceJob(BatchInferenceJob.BuilderImpl batchInferenceJob) {
            this.batchInferenceJob = batchInferenceJob != null ? batchInferenceJob.build() : null;
        }

        @Override
        public final Builder batchInferenceJob(BatchInferenceJob batchInferenceJob) {
            this.batchInferenceJob = batchInferenceJob;
            return this;
        }

        @Override
        public DescribeBatchInferenceJobResponse build() {
            return new DescribeBatchInferenceJobResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
