/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.personalize.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeMetricAttributionResponse extends PersonalizeResponse implements
        ToCopyableBuilder<DescribeMetricAttributionResponse.Builder, DescribeMetricAttributionResponse> {
    private static final SdkField<MetricAttribution> METRIC_ATTRIBUTION_FIELD = SdkField
            .<MetricAttribution> builder(MarshallingType.SDK_POJO).memberName("metricAttribution")
            .getter(getter(DescribeMetricAttributionResponse::metricAttribution)).setter(setter(Builder::metricAttribution))
            .constructor(MetricAttribution::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricAttribution").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRIC_ATTRIBUTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("metricAttribution", METRIC_ATTRIBUTION_FIELD);
                }
            });

    private final MetricAttribution metricAttribution;

    private DescribeMetricAttributionResponse(BuilderImpl builder) {
        super(builder);
        this.metricAttribution = builder.metricAttribution;
    }

    /**
     * <p>
     * The details of the metric attribution.
     * </p>
     * 
     * @return The details of the metric attribution.
     */
    public final MetricAttribution metricAttribution() {
        return metricAttribution;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(metricAttribution());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeMetricAttributionResponse)) {
            return false;
        }
        DescribeMetricAttributionResponse other = (DescribeMetricAttributionResponse) obj;
        return Objects.equals(metricAttribution(), other.metricAttribution());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeMetricAttributionResponse").add("MetricAttribution", metricAttribution()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "metricAttribution":
            return Optional.ofNullable(clazz.cast(metricAttribution()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeMetricAttributionResponse, T> g) {
        return obj -> g.apply((DescribeMetricAttributionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PersonalizeResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeMetricAttributionResponse> {
        /**
         * <p>
         * The details of the metric attribution.
         * </p>
         * 
         * @param metricAttribution
         *        The details of the metric attribution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricAttribution(MetricAttribution metricAttribution);

        /**
         * <p>
         * The details of the metric attribution.
         * </p>
         * This is a convenience method that creates an instance of the {@link MetricAttribution.Builder} avoiding the
         * need to create one manually via {@link MetricAttribution#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MetricAttribution.Builder#build()} is called immediately and its
         * result is passed to {@link #metricAttribution(MetricAttribution)}.
         * 
         * @param metricAttribution
         *        a consumer that will call methods on {@link MetricAttribution.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metricAttribution(MetricAttribution)
         */
        default Builder metricAttribution(Consumer<MetricAttribution.Builder> metricAttribution) {
            return metricAttribution(MetricAttribution.builder().applyMutation(metricAttribution).build());
        }
    }

    static final class BuilderImpl extends PersonalizeResponse.BuilderImpl implements Builder {
        private MetricAttribution metricAttribution;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeMetricAttributionResponse model) {
            super(model);
            metricAttribution(model.metricAttribution);
        }

        public final MetricAttribution.Builder getMetricAttribution() {
            return metricAttribution != null ? metricAttribution.toBuilder() : null;
        }

        public final void setMetricAttribution(MetricAttribution.BuilderImpl metricAttribution) {
            this.metricAttribution = metricAttribution != null ? metricAttribution.build() : null;
        }

        @Override
        public final Builder metricAttribution(MetricAttribution metricAttribution) {
            this.metricAttribution = metricAttribution;
            return this;
        }

        @Override
        public DescribeMetricAttributionResponse build() {
            return new DescribeMetricAttributionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
