/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.personalize.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeRecommenderRequest extends PersonalizeRequest implements
        ToCopyableBuilder<DescribeRecommenderRequest.Builder, DescribeRecommenderRequest> {
    private static final SdkField<String> RECOMMENDER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("recommenderArn").getter(getter(DescribeRecommenderRequest::recommenderArn))
            .setter(setter(Builder::recommenderArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommenderArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECOMMENDER_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("recommenderArn", RECOMMENDER_ARN_FIELD);
                }
            });

    private final String recommenderArn;

    private DescribeRecommenderRequest(BuilderImpl builder) {
        super(builder);
        this.recommenderArn = builder.recommenderArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the recommender to describe.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the recommender to describe.
     */
    public final String recommenderArn() {
        return recommenderArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(recommenderArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeRecommenderRequest)) {
            return false;
        }
        DescribeRecommenderRequest other = (DescribeRecommenderRequest) obj;
        return Objects.equals(recommenderArn(), other.recommenderArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeRecommenderRequest").add("RecommenderArn", recommenderArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "recommenderArn":
            return Optional.ofNullable(clazz.cast(recommenderArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeRecommenderRequest, T> g) {
        return obj -> g.apply((DescribeRecommenderRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PersonalizeRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeRecommenderRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the recommender to describe.
         * </p>
         * 
         * @param recommenderArn
         *        The Amazon Resource Name (ARN) of the recommender to describe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recommenderArn(String recommenderArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PersonalizeRequest.BuilderImpl implements Builder {
        private String recommenderArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeRecommenderRequest model) {
            super(model);
            recommenderArn(model.recommenderArn);
        }

        public final String getRecommenderArn() {
            return recommenderArn;
        }

        public final void setRecommenderArn(String recommenderArn) {
            this.recommenderArn = recommenderArn;
        }

        @Override
        public final Builder recommenderArn(String recommenderArn) {
            this.recommenderArn = recommenderArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeRecommenderRequest build() {
            return new DescribeRecommenderRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
