/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.personalize.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A string to string map of the configuration details for theme generation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FieldsForThemeGeneration implements SdkPojo, Serializable,
        ToCopyableBuilder<FieldsForThemeGeneration.Builder, FieldsForThemeGeneration> {
    private static final SdkField<String> ITEM_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("itemName").getter(getter(FieldsForThemeGeneration::itemName)).setter(setter(Builder::itemName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("itemName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ITEM_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("itemName", ITEM_NAME_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String itemName;

    private FieldsForThemeGeneration(BuilderImpl builder) {
        this.itemName = builder.itemName;
    }

    /**
     * <p>
     * The name of the Items dataset column that stores the name of each item in the dataset.
     * </p>
     * 
     * @return The name of the Items dataset column that stores the name of each item in the dataset.
     */
    public final String itemName() {
        return itemName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(itemName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FieldsForThemeGeneration)) {
            return false;
        }
        FieldsForThemeGeneration other = (FieldsForThemeGeneration) obj;
        return Objects.equals(itemName(), other.itemName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FieldsForThemeGeneration").add("ItemName", itemName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "itemName":
            return Optional.ofNullable(clazz.cast(itemName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<FieldsForThemeGeneration, T> g) {
        return obj -> g.apply((FieldsForThemeGeneration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FieldsForThemeGeneration> {
        /**
         * <p>
         * The name of the Items dataset column that stores the name of each item in the dataset.
         * </p>
         * 
         * @param itemName
         *        The name of the Items dataset column that stores the name of each item in the dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder itemName(String itemName);
    }

    static final class BuilderImpl implements Builder {
        private String itemName;

        private BuilderImpl() {
        }

        private BuilderImpl(FieldsForThemeGeneration model) {
            itemName(model.itemName);
        }

        public final String getItemName() {
            return itemName;
        }

        public final void setItemName(String itemName) {
            this.itemName = itemName;
        }

        @Override
        public final Builder itemName(String itemName) {
            this.itemName = itemName;
            return this;
        }

        @Override
        public FieldsForThemeGeneration build() {
            return new FieldsForThemeGeneration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
