/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.personalize.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListBatchSegmentJobsResponse extends PersonalizeResponse implements
        ToCopyableBuilder<ListBatchSegmentJobsResponse.Builder, ListBatchSegmentJobsResponse> {
    private static final SdkField<List<BatchSegmentJobSummary>> BATCH_SEGMENT_JOBS_FIELD = SdkField
            .<List<BatchSegmentJobSummary>> builder(MarshallingType.LIST)
            .memberName("batchSegmentJobs")
            .getter(getter(ListBatchSegmentJobsResponse::batchSegmentJobs))
            .setter(setter(Builder::batchSegmentJobs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("batchSegmentJobs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BatchSegmentJobSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(BatchSegmentJobSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListBatchSegmentJobsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BATCH_SEGMENT_JOBS_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("batchSegmentJobs", BATCH_SEGMENT_JOBS_FIELD);
                    put("nextToken", NEXT_TOKEN_FIELD);
                }
            });

    private final List<BatchSegmentJobSummary> batchSegmentJobs;

    private final String nextToken;

    private ListBatchSegmentJobsResponse(BuilderImpl builder) {
        super(builder);
        this.batchSegmentJobs = builder.batchSegmentJobs;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the BatchSegmentJobs property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasBatchSegmentJobs() {
        return batchSegmentJobs != null && !(batchSegmentJobs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list containing information on each job that is returned.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBatchSegmentJobs} method.
     * </p>
     * 
     * @return A list containing information on each job that is returned.
     */
    public final List<BatchSegmentJobSummary> batchSegmentJobs() {
        return batchSegmentJobs;
    }

    /**
     * <p>
     * The token to use to retrieve the next page of results. The value is <code>null</code> when there are no more
     * results to return.
     * </p>
     * 
     * @return The token to use to retrieve the next page of results. The value is <code>null</code> when there are no
     *         more results to return.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasBatchSegmentJobs() ? batchSegmentJobs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBatchSegmentJobsResponse)) {
            return false;
        }
        ListBatchSegmentJobsResponse other = (ListBatchSegmentJobsResponse) obj;
        return hasBatchSegmentJobs() == other.hasBatchSegmentJobs()
                && Objects.equals(batchSegmentJobs(), other.batchSegmentJobs()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListBatchSegmentJobsResponse")
                .add("BatchSegmentJobs", hasBatchSegmentJobs() ? batchSegmentJobs() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "batchSegmentJobs":
            return Optional.ofNullable(clazz.cast(batchSegmentJobs()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListBatchSegmentJobsResponse, T> g) {
        return obj -> g.apply((ListBatchSegmentJobsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PersonalizeResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListBatchSegmentJobsResponse> {
        /**
         * <p>
         * A list containing information on each job that is returned.
         * </p>
         * 
         * @param batchSegmentJobs
         *        A list containing information on each job that is returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder batchSegmentJobs(Collection<BatchSegmentJobSummary> batchSegmentJobs);

        /**
         * <p>
         * A list containing information on each job that is returned.
         * </p>
         * 
         * @param batchSegmentJobs
         *        A list containing information on each job that is returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder batchSegmentJobs(BatchSegmentJobSummary... batchSegmentJobs);

        /**
         * <p>
         * A list containing information on each job that is returned.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.personalize.model.BatchSegmentJobSummary.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.personalize.model.BatchSegmentJobSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.personalize.model.BatchSegmentJobSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #batchSegmentJobs(List<BatchSegmentJobSummary>)}.
         * 
         * @param batchSegmentJobs
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.personalize.model.BatchSegmentJobSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #batchSegmentJobs(java.util.Collection<BatchSegmentJobSummary>)
         */
        Builder batchSegmentJobs(Consumer<BatchSegmentJobSummary.Builder>... batchSegmentJobs);

        /**
         * <p>
         * The token to use to retrieve the next page of results. The value is <code>null</code> when there are no more
         * results to return.
         * </p>
         * 
         * @param nextToken
         *        The token to use to retrieve the next page of results. The value is <code>null</code> when there are
         *        no more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends PersonalizeResponse.BuilderImpl implements Builder {
        private List<BatchSegmentJobSummary> batchSegmentJobs = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListBatchSegmentJobsResponse model) {
            super(model);
            batchSegmentJobs(model.batchSegmentJobs);
            nextToken(model.nextToken);
        }

        public final List<BatchSegmentJobSummary.Builder> getBatchSegmentJobs() {
            List<BatchSegmentJobSummary.Builder> result = BatchSegmentJobsCopier.copyToBuilder(this.batchSegmentJobs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBatchSegmentJobs(Collection<BatchSegmentJobSummary.BuilderImpl> batchSegmentJobs) {
            this.batchSegmentJobs = BatchSegmentJobsCopier.copyFromBuilder(batchSegmentJobs);
        }

        @Override
        public final Builder batchSegmentJobs(Collection<BatchSegmentJobSummary> batchSegmentJobs) {
            this.batchSegmentJobs = BatchSegmentJobsCopier.copy(batchSegmentJobs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder batchSegmentJobs(BatchSegmentJobSummary... batchSegmentJobs) {
            batchSegmentJobs(Arrays.asList(batchSegmentJobs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder batchSegmentJobs(Consumer<BatchSegmentJobSummary.Builder>... batchSegmentJobs) {
            batchSegmentJobs(Stream.of(batchSegmentJobs).map(c -> BatchSegmentJobSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListBatchSegmentJobsResponse build() {
            return new ListBatchSegmentJobsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
