/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.personalize.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListSchemasResponse extends PersonalizeResponse implements
        ToCopyableBuilder<ListSchemasResponse.Builder, ListSchemasResponse> {
    private static final SdkField<List<DatasetSchemaSummary>> SCHEMAS_FIELD = SdkField
            .<List<DatasetSchemaSummary>> builder(MarshallingType.LIST)
            .memberName("schemas")
            .getter(getter(ListSchemasResponse::schemas))
            .setter(setter(Builder::schemas))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schemas").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DatasetSchemaSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(DatasetSchemaSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListSchemasResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEMAS_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("schemas", SCHEMAS_FIELD);
                    put("nextToken", NEXT_TOKEN_FIELD);
                }
            });

    private final List<DatasetSchemaSummary> schemas;

    private final String nextToken;

    private ListSchemasResponse(BuilderImpl builder) {
        super(builder);
        this.schemas = builder.schemas;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Schemas property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSchemas() {
        return schemas != null && !(schemas instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of schemas.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSchemas} method.
     * </p>
     * 
     * @return A list of schemas.
     */
    public final List<DatasetSchemaSummary> schemas() {
        return schemas;
    }

    /**
     * <p>
     * A token used to get the next set of schemas (if they exist).
     * </p>
     * 
     * @return A token used to get the next set of schemas (if they exist).
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasSchemas() ? schemas() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSchemasResponse)) {
            return false;
        }
        ListSchemasResponse other = (ListSchemasResponse) obj;
        return hasSchemas() == other.hasSchemas() && Objects.equals(schemas(), other.schemas())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListSchemasResponse").add("Schemas", hasSchemas() ? schemas() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "schemas":
            return Optional.ofNullable(clazz.cast(schemas()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListSchemasResponse, T> g) {
        return obj -> g.apply((ListSchemasResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PersonalizeResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListSchemasResponse> {
        /**
         * <p>
         * A list of schemas.
         * </p>
         * 
         * @param schemas
         *        A list of schemas.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemas(Collection<DatasetSchemaSummary> schemas);

        /**
         * <p>
         * A list of schemas.
         * </p>
         * 
         * @param schemas
         *        A list of schemas.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemas(DatasetSchemaSummary... schemas);

        /**
         * <p>
         * A list of schemas.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.personalize.model.DatasetSchemaSummary.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.personalize.model.DatasetSchemaSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.personalize.model.DatasetSchemaSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #schemas(List<DatasetSchemaSummary>)}.
         * 
         * @param schemas
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.personalize.model.DatasetSchemaSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #schemas(java.util.Collection<DatasetSchemaSummary>)
         */
        Builder schemas(Consumer<DatasetSchemaSummary.Builder>... schemas);

        /**
         * <p>
         * A token used to get the next set of schemas (if they exist).
         * </p>
         * 
         * @param nextToken
         *        A token used to get the next set of schemas (if they exist).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends PersonalizeResponse.BuilderImpl implements Builder {
        private List<DatasetSchemaSummary> schemas = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSchemasResponse model) {
            super(model);
            schemas(model.schemas);
            nextToken(model.nextToken);
        }

        public final List<DatasetSchemaSummary.Builder> getSchemas() {
            List<DatasetSchemaSummary.Builder> result = SchemasCopier.copyToBuilder(this.schemas);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSchemas(Collection<DatasetSchemaSummary.BuilderImpl> schemas) {
            this.schemas = SchemasCopier.copyFromBuilder(schemas);
        }

        @Override
        public final Builder schemas(Collection<DatasetSchemaSummary> schemas) {
            this.schemas = SchemasCopier.copy(schemas);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder schemas(DatasetSchemaSummary... schemas) {
            schemas(Arrays.asList(schemas));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder schemas(Consumer<DatasetSchemaSummary.Builder>... schemas) {
            schemas(Stream.of(schemas).map(c -> DatasetSchemaSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListSchemasResponse build() {
            return new ListSchemasResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
