/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.personalize.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * If hyperparameter optimization (HPO) was performed, contains the hyperparameter values of the best performing model.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TunedHPOParams implements SdkPojo, Serializable, ToCopyableBuilder<TunedHPOParams.Builder, TunedHPOParams> {
    private static final SdkField<Map<String, String>> ALGORITHM_HYPER_PARAMETERS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("algorithmHyperParameters")
            .getter(getter(TunedHPOParams::algorithmHyperParameters))
            .setter(setter(Builder::algorithmHyperParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("algorithmHyperParameters").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(ALGORITHM_HYPER_PARAMETERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("algorithmHyperParameters", ALGORITHM_HYPER_PARAMETERS_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final Map<String, String> algorithmHyperParameters;

    private TunedHPOParams(BuilderImpl builder) {
        this.algorithmHyperParameters = builder.algorithmHyperParameters;
    }

    /**
     * For responses, this returns true if the service returned a value for the AlgorithmHyperParameters property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAlgorithmHyperParameters() {
        return algorithmHyperParameters != null && !(algorithmHyperParameters instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A list of the hyperparameter values of the best performing model.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAlgorithmHyperParameters} method.
     * </p>
     * 
     * @return A list of the hyperparameter values of the best performing model.
     */
    public final Map<String, String> algorithmHyperParameters() {
        return algorithmHyperParameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAlgorithmHyperParameters() ? algorithmHyperParameters() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TunedHPOParams)) {
            return false;
        }
        TunedHPOParams other = (TunedHPOParams) obj;
        return hasAlgorithmHyperParameters() == other.hasAlgorithmHyperParameters()
                && Objects.equals(algorithmHyperParameters(), other.algorithmHyperParameters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TunedHPOParams")
                .add("AlgorithmHyperParameters", hasAlgorithmHyperParameters() ? algorithmHyperParameters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "algorithmHyperParameters":
            return Optional.ofNullable(clazz.cast(algorithmHyperParameters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<TunedHPOParams, T> g) {
        return obj -> g.apply((TunedHPOParams) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TunedHPOParams> {
        /**
         * <p>
         * A list of the hyperparameter values of the best performing model.
         * </p>
         * 
         * @param algorithmHyperParameters
         *        A list of the hyperparameter values of the best performing model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder algorithmHyperParameters(Map<String, String> algorithmHyperParameters);
    }

    static final class BuilderImpl implements Builder {
        private Map<String, String> algorithmHyperParameters = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TunedHPOParams model) {
            algorithmHyperParameters(model.algorithmHyperParameters);
        }

        public final Map<String, String> getAlgorithmHyperParameters() {
            if (algorithmHyperParameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return algorithmHyperParameters;
        }

        public final void setAlgorithmHyperParameters(Map<String, String> algorithmHyperParameters) {
            this.algorithmHyperParameters = HyperParametersCopier.copy(algorithmHyperParameters);
        }

        @Override
        public final Builder algorithmHyperParameters(Map<String, String> algorithmHyperParameters) {
            this.algorithmHyperParameters = HyperParametersCopier.copy(algorithmHyperParameters);
            return this;
        }

        @Override
        public TunedHPOParams build() {
            return new TunedHPOParams(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
