/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.personalize.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides a summary of the properties of a data deletion job. For a complete listing, call the <a
 * href="https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeDataDeletionJob.html">DescribeDataDeletionJob</a>
 * API operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataDeletionJobSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<DataDeletionJobSummary.Builder, DataDeletionJobSummary> {
    private static final SdkField<String> DATA_DELETION_JOB_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dataDeletionJobArn").getter(getter(DataDeletionJobSummary::dataDeletionJobArn))
            .setter(setter(Builder::dataDeletionJobArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataDeletionJobArn").build())
            .build();

    private static final SdkField<String> DATASET_GROUP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("datasetGroupArn").getter(getter(DataDeletionJobSummary::datasetGroupArn))
            .setter(setter(Builder::datasetGroupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datasetGroupArn").build()).build();

    private static final SdkField<String> JOB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("jobName").getter(getter(DataDeletionJobSummary::jobName)).setter(setter(Builder::jobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobName").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(DataDeletionJobSummary::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Instant> CREATION_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationDateTime").getter(getter(DataDeletionJobSummary::creationDateTime))
            .setter(setter(Builder::creationDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDateTime").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdatedDateTime").getter(getter(DataDeletionJobSummary::lastUpdatedDateTime))
            .setter(setter(Builder::lastUpdatedDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedDateTime").build())
            .build();

    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("failureReason").getter(getter(DataDeletionJobSummary::failureReason))
            .setter(setter(Builder::failureReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureReason").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_DELETION_JOB_ARN_FIELD,
            DATASET_GROUP_ARN_FIELD, JOB_NAME_FIELD, STATUS_FIELD, CREATION_DATE_TIME_FIELD, LAST_UPDATED_DATE_TIME_FIELD,
            FAILURE_REASON_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String dataDeletionJobArn;

    private final String datasetGroupArn;

    private final String jobName;

    private final String status;

    private final Instant creationDateTime;

    private final Instant lastUpdatedDateTime;

    private final String failureReason;

    private DataDeletionJobSummary(BuilderImpl builder) {
        this.dataDeletionJobArn = builder.dataDeletionJobArn;
        this.datasetGroupArn = builder.datasetGroupArn;
        this.jobName = builder.jobName;
        this.status = builder.status;
        this.creationDateTime = builder.creationDateTime;
        this.lastUpdatedDateTime = builder.lastUpdatedDateTime;
        this.failureReason = builder.failureReason;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the data deletion job.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the data deletion job.
     */
    public final String dataDeletionJobArn() {
        return dataDeletionJobArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the dataset group the job deleted records from.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the dataset group the job deleted records from.
     */
    public final String datasetGroupArn() {
        return datasetGroupArn;
    }

    /**
     * <p>
     * The name of the data deletion job.
     * </p>
     * 
     * @return The name of the data deletion job.
     */
    public final String jobName() {
        return jobName;
    }

    /**
     * <p>
     * The status of the data deletion job.
     * </p>
     * <p>
     * A data deletion job can have one of the following statuses:
     * </p>
     * <ul>
     * <li>
     * <p>
     * PENDING &gt; IN_PROGRESS &gt; COMPLETED -or- FAILED
     * </p>
     * </li>
     * </ul>
     * 
     * @return The status of the data deletion job.</p>
     *         <p>
     *         A data deletion job can have one of the following statuses:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         PENDING &gt; IN_PROGRESS &gt; COMPLETED -or- FAILED
     *         </p>
     *         </li>
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * The creation date and time (in Unix time) of the data deletion job.
     * </p>
     * 
     * @return The creation date and time (in Unix time) of the data deletion job.
     */
    public final Instant creationDateTime() {
        return creationDateTime;
    }

    /**
     * <p>
     * The date and time (in Unix time) the data deletion job was last updated.
     * </p>
     * 
     * @return The date and time (in Unix time) the data deletion job was last updated.
     */
    public final Instant lastUpdatedDateTime() {
        return lastUpdatedDateTime;
    }

    /**
     * <p>
     * If a data deletion job fails, provides the reason why.
     * </p>
     * 
     * @return If a data deletion job fails, provides the reason why.
     */
    public final String failureReason() {
        return failureReason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dataDeletionJobArn());
        hashCode = 31 * hashCode + Objects.hashCode(datasetGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(jobName());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(creationDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(failureReason());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataDeletionJobSummary)) {
            return false;
        }
        DataDeletionJobSummary other = (DataDeletionJobSummary) obj;
        return Objects.equals(dataDeletionJobArn(), other.dataDeletionJobArn())
                && Objects.equals(datasetGroupArn(), other.datasetGroupArn()) && Objects.equals(jobName(), other.jobName())
                && Objects.equals(status(), other.status()) && Objects.equals(creationDateTime(), other.creationDateTime())
                && Objects.equals(lastUpdatedDateTime(), other.lastUpdatedDateTime())
                && Objects.equals(failureReason(), other.failureReason());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataDeletionJobSummary").add("DataDeletionJobArn", dataDeletionJobArn())
                .add("DatasetGroupArn", datasetGroupArn()).add("JobName", jobName()).add("Status", status())
                .add("CreationDateTime", creationDateTime()).add("LastUpdatedDateTime", lastUpdatedDateTime())
                .add("FailureReason", failureReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "dataDeletionJobArn":
            return Optional.ofNullable(clazz.cast(dataDeletionJobArn()));
        case "datasetGroupArn":
            return Optional.ofNullable(clazz.cast(datasetGroupArn()));
        case "jobName":
            return Optional.ofNullable(clazz.cast(jobName()));
        case "status":
            return Optional.ofNullable(clazz.cast(status()));
        case "creationDateTime":
            return Optional.ofNullable(clazz.cast(creationDateTime()));
        case "lastUpdatedDateTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedDateTime()));
        case "failureReason":
            return Optional.ofNullable(clazz.cast(failureReason()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("dataDeletionJobArn", DATA_DELETION_JOB_ARN_FIELD);
        map.put("datasetGroupArn", DATASET_GROUP_ARN_FIELD);
        map.put("jobName", JOB_NAME_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("creationDateTime", CREATION_DATE_TIME_FIELD);
        map.put("lastUpdatedDateTime", LAST_UPDATED_DATE_TIME_FIELD);
        map.put("failureReason", FAILURE_REASON_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataDeletionJobSummary, T> g) {
        return obj -> g.apply((DataDeletionJobSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataDeletionJobSummary> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the data deletion job.
         * </p>
         * 
         * @param dataDeletionJobArn
         *        The Amazon Resource Name (ARN) of the data deletion job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataDeletionJobArn(String dataDeletionJobArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the dataset group the job deleted records from.
         * </p>
         * 
         * @param datasetGroupArn
         *        The Amazon Resource Name (ARN) of the dataset group the job deleted records from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetGroupArn(String datasetGroupArn);

        /**
         * <p>
         * The name of the data deletion job.
         * </p>
         * 
         * @param jobName
         *        The name of the data deletion job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobName(String jobName);

        /**
         * <p>
         * The status of the data deletion job.
         * </p>
         * <p>
         * A data deletion job can have one of the following statuses:
         * </p>
         * <ul>
         * <li>
         * <p>
         * PENDING &gt; IN_PROGRESS &gt; COMPLETED -or- FAILED
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the data deletion job.</p>
         *        <p>
         *        A data deletion job can have one of the following statuses:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        PENDING &gt; IN_PROGRESS &gt; COMPLETED -or- FAILED
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The creation date and time (in Unix time) of the data deletion job.
         * </p>
         * 
         * @param creationDateTime
         *        The creation date and time (in Unix time) of the data deletion job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDateTime(Instant creationDateTime);

        /**
         * <p>
         * The date and time (in Unix time) the data deletion job was last updated.
         * </p>
         * 
         * @param lastUpdatedDateTime
         *        The date and time (in Unix time) the data deletion job was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedDateTime(Instant lastUpdatedDateTime);

        /**
         * <p>
         * If a data deletion job fails, provides the reason why.
         * </p>
         * 
         * @param failureReason
         *        If a data deletion job fails, provides the reason why.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReason(String failureReason);
    }

    static final class BuilderImpl implements Builder {
        private String dataDeletionJobArn;

        private String datasetGroupArn;

        private String jobName;

        private String status;

        private Instant creationDateTime;

        private Instant lastUpdatedDateTime;

        private String failureReason;

        private BuilderImpl() {
        }

        private BuilderImpl(DataDeletionJobSummary model) {
            dataDeletionJobArn(model.dataDeletionJobArn);
            datasetGroupArn(model.datasetGroupArn);
            jobName(model.jobName);
            status(model.status);
            creationDateTime(model.creationDateTime);
            lastUpdatedDateTime(model.lastUpdatedDateTime);
            failureReason(model.failureReason);
        }

        public final String getDataDeletionJobArn() {
            return dataDeletionJobArn;
        }

        public final void setDataDeletionJobArn(String dataDeletionJobArn) {
            this.dataDeletionJobArn = dataDeletionJobArn;
        }

        @Override
        public final Builder dataDeletionJobArn(String dataDeletionJobArn) {
            this.dataDeletionJobArn = dataDeletionJobArn;
            return this;
        }

        public final String getDatasetGroupArn() {
            return datasetGroupArn;
        }

        public final void setDatasetGroupArn(String datasetGroupArn) {
            this.datasetGroupArn = datasetGroupArn;
        }

        @Override
        public final Builder datasetGroupArn(String datasetGroupArn) {
            this.datasetGroupArn = datasetGroupArn;
            return this;
        }

        public final String getJobName() {
            return jobName;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final Instant getCreationDateTime() {
            return creationDateTime;
        }

        public final void setCreationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
        }

        @Override
        public final Builder creationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
            return this;
        }

        public final Instant getLastUpdatedDateTime() {
            return lastUpdatedDateTime;
        }

        public final void setLastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
        }

        @Override
        public final Builder lastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
            return this;
        }

        public final String getFailureReason() {
            return failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        @Override
        public DataDeletionJobSummary build() {
            return new DataDeletionJobSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
