/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.personalize.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information on a metric that a metric attribution reports on. For more information, see <a
 * href="https://docs.aws.amazon.com/personalize/latest/dg/measuring-recommendation-impact.html">Measuring impact of
 * recommendations</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MetricAttribute implements SdkPojo, Serializable, ToCopyableBuilder<MetricAttribute.Builder, MetricAttribute> {
    private static final SdkField<String> EVENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("eventType").getter(getter(MetricAttribute::eventType)).setter(setter(Builder::eventType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventType").build()).build();

    private static final SdkField<String> METRIC_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("metricName").getter(getter(MetricAttribute::metricName)).setter(setter(Builder::metricName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricName").build()).build();

    private static final SdkField<String> EXPRESSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("expression").getter(getter(MetricAttribute::expression)).setter(setter(Builder::expression))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expression").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_TYPE_FIELD,
            METRIC_NAME_FIELD, EXPRESSION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String eventType;

    private final String metricName;

    private final String expression;

    private MetricAttribute(BuilderImpl builder) {
        this.eventType = builder.eventType;
        this.metricName = builder.metricName;
        this.expression = builder.expression;
    }

    /**
     * <p>
     * The metric's event type.
     * </p>
     * 
     * @return The metric's event type.
     */
    public final String eventType() {
        return eventType;
    }

    /**
     * <p>
     * The metric's name. The name helps you identify the metric in Amazon CloudWatch or Amazon S3.
     * </p>
     * 
     * @return The metric's name. The name helps you identify the metric in Amazon CloudWatch or Amazon S3.
     */
    public final String metricName() {
        return metricName;
    }

    /**
     * <p>
     * The attribute's expression. Available functions are <code>SUM()</code> or <code>SAMPLECOUNT()</code>. For SUM()
     * functions, provide the dataset type (either Interactions or Items) and column to sum as a parameter. For example
     * SUM(Items.PRICE).
     * </p>
     * 
     * @return The attribute's expression. Available functions are <code>SUM()</code> or <code>SAMPLECOUNT()</code>. For
     *         SUM() functions, provide the dataset type (either Interactions or Items) and column to sum as a
     *         parameter. For example SUM(Items.PRICE).
     */
    public final String expression() {
        return expression;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(eventType());
        hashCode = 31 * hashCode + Objects.hashCode(metricName());
        hashCode = 31 * hashCode + Objects.hashCode(expression());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricAttribute)) {
            return false;
        }
        MetricAttribute other = (MetricAttribute) obj;
        return Objects.equals(eventType(), other.eventType()) && Objects.equals(metricName(), other.metricName())
                && Objects.equals(expression(), other.expression());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MetricAttribute").add("EventType", eventType()).add("MetricName", metricName())
                .add("Expression", expression()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "eventType":
            return Optional.ofNullable(clazz.cast(eventType()));
        case "metricName":
            return Optional.ofNullable(clazz.cast(metricName()));
        case "expression":
            return Optional.ofNullable(clazz.cast(expression()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("eventType", EVENT_TYPE_FIELD);
        map.put("metricName", METRIC_NAME_FIELD);
        map.put("expression", EXPRESSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MetricAttribute, T> g) {
        return obj -> g.apply((MetricAttribute) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MetricAttribute> {
        /**
         * <p>
         * The metric's event type.
         * </p>
         * 
         * @param eventType
         *        The metric's event type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventType(String eventType);

        /**
         * <p>
         * The metric's name. The name helps you identify the metric in Amazon CloudWatch or Amazon S3.
         * </p>
         * 
         * @param metricName
         *        The metric's name. The name helps you identify the metric in Amazon CloudWatch or Amazon S3.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricName(String metricName);

        /**
         * <p>
         * The attribute's expression. Available functions are <code>SUM()</code> or <code>SAMPLECOUNT()</code>. For
         * SUM() functions, provide the dataset type (either Interactions or Items) and column to sum as a parameter.
         * For example SUM(Items.PRICE).
         * </p>
         * 
         * @param expression
         *        The attribute's expression. Available functions are <code>SUM()</code> or <code>SAMPLECOUNT()</code>.
         *        For SUM() functions, provide the dataset type (either Interactions or Items) and column to sum as a
         *        parameter. For example SUM(Items.PRICE).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expression(String expression);
    }

    static final class BuilderImpl implements Builder {
        private String eventType;

        private String metricName;

        private String expression;

        private BuilderImpl() {
        }

        private BuilderImpl(MetricAttribute model) {
            eventType(model.eventType);
            metricName(model.metricName);
            expression(model.expression);
        }

        public final String getEventType() {
            return eventType;
        }

        public final void setEventType(String eventType) {
            this.eventType = eventType;
        }

        @Override
        public final Builder eventType(String eventType) {
            this.eventType = eventType;
            return this;
        }

        public final String getMetricName() {
            return metricName;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        @Override
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        public final String getExpression() {
            return expression;
        }

        public final void setExpression(String expression) {
            this.expression = expression;
        }

        @Override
        public final Builder expression(String expression) {
            this.expression = expression;
            return this;
        }

        @Override
        public MetricAttribute build() {
            return new MetricAttribute(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
