/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.personalize.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeDatasetImportJobResponse extends PersonalizeResponse implements
        ToCopyableBuilder<DescribeDatasetImportJobResponse.Builder, DescribeDatasetImportJobResponse> {
    private static final SdkField<DatasetImportJob> DATASET_IMPORT_JOB_FIELD = SdkField
            .<DatasetImportJob> builder(MarshallingType.SDK_POJO).memberName("datasetImportJob")
            .getter(getter(DescribeDatasetImportJobResponse::datasetImportJob)).setter(setter(Builder::datasetImportJob))
            .constructor(DatasetImportJob::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datasetImportJob").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASET_IMPORT_JOB_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final DatasetImportJob datasetImportJob;

    private DescribeDatasetImportJobResponse(BuilderImpl builder) {
        super(builder);
        this.datasetImportJob = builder.datasetImportJob;
    }

    /**
     * <p>
     * Information about the dataset import job, including the status.
     * </p>
     * <p>
     * The status is one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * CREATE PENDING
     * </p>
     * </li>
     * <li>
     * <p>
     * CREATE IN_PROGRESS
     * </p>
     * </li>
     * <li>
     * <p>
     * ACTIVE
     * </p>
     * </li>
     * <li>
     * <p>
     * CREATE FAILED
     * </p>
     * </li>
     * </ul>
     * 
     * @return Information about the dataset import job, including the status.</p>
     *         <p>
     *         The status is one of the following values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         CREATE PENDING
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CREATE IN_PROGRESS
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ACTIVE
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CREATE FAILED
     *         </p>
     *         </li>
     */
    public final DatasetImportJob datasetImportJob() {
        return datasetImportJob;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(datasetImportJob());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDatasetImportJobResponse)) {
            return false;
        }
        DescribeDatasetImportJobResponse other = (DescribeDatasetImportJobResponse) obj;
        return Objects.equals(datasetImportJob(), other.datasetImportJob());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeDatasetImportJobResponse").add("DatasetImportJob", datasetImportJob()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "datasetImportJob":
            return Optional.ofNullable(clazz.cast(datasetImportJob()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("datasetImportJob", DATASET_IMPORT_JOB_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeDatasetImportJobResponse, T> g) {
        return obj -> g.apply((DescribeDatasetImportJobResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PersonalizeResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeDatasetImportJobResponse> {
        /**
         * <p>
         * Information about the dataset import job, including the status.
         * </p>
         * <p>
         * The status is one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * CREATE PENDING
         * </p>
         * </li>
         * <li>
         * <p>
         * CREATE IN_PROGRESS
         * </p>
         * </li>
         * <li>
         * <p>
         * ACTIVE
         * </p>
         * </li>
         * <li>
         * <p>
         * CREATE FAILED
         * </p>
         * </li>
         * </ul>
         * 
         * @param datasetImportJob
         *        Information about the dataset import job, including the status.</p>
         *        <p>
         *        The status is one of the following values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        CREATE PENDING
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        CREATE IN_PROGRESS
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ACTIVE
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        CREATE FAILED
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetImportJob(DatasetImportJob datasetImportJob);

        /**
         * <p>
         * Information about the dataset import job, including the status.
         * </p>
         * <p>
         * The status is one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * CREATE PENDING
         * </p>
         * </li>
         * <li>
         * <p>
         * CREATE IN_PROGRESS
         * </p>
         * </li>
         * <li>
         * <p>
         * ACTIVE
         * </p>
         * </li>
         * <li>
         * <p>
         * CREATE FAILED
         * </p>
         * </li>
         * </ul>
         * This is a convenience method that creates an instance of the {@link DatasetImportJob.Builder} avoiding the
         * need to create one manually via {@link DatasetImportJob#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DatasetImportJob.Builder#build()} is called immediately and its
         * result is passed to {@link #datasetImportJob(DatasetImportJob)}.
         * 
         * @param datasetImportJob
         *        a consumer that will call methods on {@link DatasetImportJob.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #datasetImportJob(DatasetImportJob)
         */
        default Builder datasetImportJob(Consumer<DatasetImportJob.Builder> datasetImportJob) {
            return datasetImportJob(DatasetImportJob.builder().applyMutation(datasetImportJob).build());
        }
    }

    static final class BuilderImpl extends PersonalizeResponse.BuilderImpl implements Builder {
        private DatasetImportJob datasetImportJob;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDatasetImportJobResponse model) {
            super(model);
            datasetImportJob(model.datasetImportJob);
        }

        public final DatasetImportJob.Builder getDatasetImportJob() {
            return datasetImportJob != null ? datasetImportJob.toBuilder() : null;
        }

        public final void setDatasetImportJob(DatasetImportJob.BuilderImpl datasetImportJob) {
            this.datasetImportJob = datasetImportJob != null ? datasetImportJob.build() : null;
        }

        @Override
        public final Builder datasetImportJob(DatasetImportJob datasetImportJob) {
            this.datasetImportJob = datasetImportJob;
            return this;
        }

        @Override
        public DescribeDatasetImportJobResponse build() {
            return new DescribeDatasetImportJobResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
