/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.personalize.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about an event tracker.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EventTracker implements SdkPojo, Serializable, ToCopyableBuilder<EventTracker.Builder, EventTracker> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(EventTracker::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> EVENT_TRACKER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("eventTrackerArn").getter(getter(EventTracker::eventTrackerArn)).setter(setter(Builder::eventTrackerArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventTrackerArn").build()).build();

    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("accountId").getter(getter(EventTracker::accountId)).setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()).build();

    private static final SdkField<String> TRACKING_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("trackingId").getter(getter(EventTracker::trackingId)).setter(setter(Builder::trackingId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trackingId").build()).build();

    private static final SdkField<String> DATASET_GROUP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("datasetGroupArn").getter(getter(EventTracker::datasetGroupArn)).setter(setter(Builder::datasetGroupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datasetGroupArn").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(EventTracker::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Instant> CREATION_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationDateTime").getter(getter(EventTracker::creationDateTime))
            .setter(setter(Builder::creationDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDateTime").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdatedDateTime").getter(getter(EventTracker::lastUpdatedDateTime))
            .setter(setter(Builder::lastUpdatedDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedDateTime").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            EVENT_TRACKER_ARN_FIELD, ACCOUNT_ID_FIELD, TRACKING_ID_FIELD, DATASET_GROUP_ARN_FIELD, STATUS_FIELD,
            CREATION_DATE_TIME_FIELD, LAST_UPDATED_DATE_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String eventTrackerArn;

    private final String accountId;

    private final String trackingId;

    private final String datasetGroupArn;

    private final String status;

    private final Instant creationDateTime;

    private final Instant lastUpdatedDateTime;

    private EventTracker(BuilderImpl builder) {
        this.name = builder.name;
        this.eventTrackerArn = builder.eventTrackerArn;
        this.accountId = builder.accountId;
        this.trackingId = builder.trackingId;
        this.datasetGroupArn = builder.datasetGroupArn;
        this.status = builder.status;
        this.creationDateTime = builder.creationDateTime;
        this.lastUpdatedDateTime = builder.lastUpdatedDateTime;
    }

    /**
     * <p>
     * The name of the event tracker.
     * </p>
     * 
     * @return The name of the event tracker.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The ARN of the event tracker.
     * </p>
     * 
     * @return The ARN of the event tracker.
     */
    public final String eventTrackerArn() {
        return eventTrackerArn;
    }

    /**
     * <p>
     * The Amazon Web Services account that owns the event tracker.
     * </p>
     * 
     * @return The Amazon Web Services account that owns the event tracker.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * The ID of the event tracker. Include this ID in requests to the <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_UBS_PutEvents.html">PutEvents</a> API.
     * </p>
     * 
     * @return The ID of the event tracker. Include this ID in requests to the <a
     *         href="https://docs.aws.amazon.com/personalize/latest/dg/API_UBS_PutEvents.html">PutEvents</a> API.
     */
    public final String trackingId() {
        return trackingId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the dataset group that receives the event data.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the dataset group that receives the event data.
     */
    public final String datasetGroupArn() {
        return datasetGroupArn;
    }

    /**
     * <p>
     * The status of the event tracker.
     * </p>
     * <p>
     * An event tracker can be in one of the following states:
     * </p>
     * <ul>
     * <li>
     * <p>
     * CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED
     * </p>
     * </li>
     * <li>
     * <p>
     * DELETE PENDING &gt; DELETE IN_PROGRESS
     * </p>
     * </li>
     * </ul>
     * 
     * @return The status of the event tracker.</p>
     *         <p>
     *         An event tracker can be in one of the following states:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DELETE PENDING &gt; DELETE IN_PROGRESS
     *         </p>
     *         </li>
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * The date and time (in Unix format) that the event tracker was created.
     * </p>
     * 
     * @return The date and time (in Unix format) that the event tracker was created.
     */
    public final Instant creationDateTime() {
        return creationDateTime;
    }

    /**
     * <p>
     * The date and time (in Unix time) that the event tracker was last updated.
     * </p>
     * 
     * @return The date and time (in Unix time) that the event tracker was last updated.
     */
    public final Instant lastUpdatedDateTime() {
        return lastUpdatedDateTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(eventTrackerArn());
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(trackingId());
        hashCode = 31 * hashCode + Objects.hashCode(datasetGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(creationDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedDateTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventTracker)) {
            return false;
        }
        EventTracker other = (EventTracker) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(eventTrackerArn(), other.eventTrackerArn())
                && Objects.equals(accountId(), other.accountId()) && Objects.equals(trackingId(), other.trackingId())
                && Objects.equals(datasetGroupArn(), other.datasetGroupArn()) && Objects.equals(status(), other.status())
                && Objects.equals(creationDateTime(), other.creationDateTime())
                && Objects.equals(lastUpdatedDateTime(), other.lastUpdatedDateTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EventTracker").add("Name", name()).add("EventTrackerArn", eventTrackerArn())
                .add("AccountId", accountId()).add("TrackingId", trackingId()).add("DatasetGroupArn", datasetGroupArn())
                .add("Status", status()).add("CreationDateTime", creationDateTime())
                .add("LastUpdatedDateTime", lastUpdatedDateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "eventTrackerArn":
            return Optional.ofNullable(clazz.cast(eventTrackerArn()));
        case "accountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "trackingId":
            return Optional.ofNullable(clazz.cast(trackingId()));
        case "datasetGroupArn":
            return Optional.ofNullable(clazz.cast(datasetGroupArn()));
        case "status":
            return Optional.ofNullable(clazz.cast(status()));
        case "creationDateTime":
            return Optional.ofNullable(clazz.cast(creationDateTime()));
        case "lastUpdatedDateTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedDateTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("name", NAME_FIELD);
        map.put("eventTrackerArn", EVENT_TRACKER_ARN_FIELD);
        map.put("accountId", ACCOUNT_ID_FIELD);
        map.put("trackingId", TRACKING_ID_FIELD);
        map.put("datasetGroupArn", DATASET_GROUP_ARN_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("creationDateTime", CREATION_DATE_TIME_FIELD);
        map.put("lastUpdatedDateTime", LAST_UPDATED_DATE_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EventTracker, T> g) {
        return obj -> g.apply((EventTracker) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EventTracker> {
        /**
         * <p>
         * The name of the event tracker.
         * </p>
         * 
         * @param name
         *        The name of the event tracker.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The ARN of the event tracker.
         * </p>
         * 
         * @param eventTrackerArn
         *        The ARN of the event tracker.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventTrackerArn(String eventTrackerArn);

        /**
         * <p>
         * The Amazon Web Services account that owns the event tracker.
         * </p>
         * 
         * @param accountId
         *        The Amazon Web Services account that owns the event tracker.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * The ID of the event tracker. Include this ID in requests to the <a
         * href="https://docs.aws.amazon.com/personalize/latest/dg/API_UBS_PutEvents.html">PutEvents</a> API.
         * </p>
         * 
         * @param trackingId
         *        The ID of the event tracker. Include this ID in requests to the <a
         *        href="https://docs.aws.amazon.com/personalize/latest/dg/API_UBS_PutEvents.html">PutEvents</a> API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trackingId(String trackingId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the dataset group that receives the event data.
         * </p>
         * 
         * @param datasetGroupArn
         *        The Amazon Resource Name (ARN) of the dataset group that receives the event data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetGroupArn(String datasetGroupArn);

        /**
         * <p>
         * The status of the event tracker.
         * </p>
         * <p>
         * An event tracker can be in one of the following states:
         * </p>
         * <ul>
         * <li>
         * <p>
         * CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED
         * </p>
         * </li>
         * <li>
         * <p>
         * DELETE PENDING &gt; DELETE IN_PROGRESS
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the event tracker.</p>
         *        <p>
         *        An event tracker can be in one of the following states:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        DELETE PENDING &gt; DELETE IN_PROGRESS
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The date and time (in Unix format) that the event tracker was created.
         * </p>
         * 
         * @param creationDateTime
         *        The date and time (in Unix format) that the event tracker was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDateTime(Instant creationDateTime);

        /**
         * <p>
         * The date and time (in Unix time) that the event tracker was last updated.
         * </p>
         * 
         * @param lastUpdatedDateTime
         *        The date and time (in Unix time) that the event tracker was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedDateTime(Instant lastUpdatedDateTime);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String eventTrackerArn;

        private String accountId;

        private String trackingId;

        private String datasetGroupArn;

        private String status;

        private Instant creationDateTime;

        private Instant lastUpdatedDateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(EventTracker model) {
            name(model.name);
            eventTrackerArn(model.eventTrackerArn);
            accountId(model.accountId);
            trackingId(model.trackingId);
            datasetGroupArn(model.datasetGroupArn);
            status(model.status);
            creationDateTime(model.creationDateTime);
            lastUpdatedDateTime(model.lastUpdatedDateTime);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getEventTrackerArn() {
            return eventTrackerArn;
        }

        public final void setEventTrackerArn(String eventTrackerArn) {
            this.eventTrackerArn = eventTrackerArn;
        }

        @Override
        public final Builder eventTrackerArn(String eventTrackerArn) {
            this.eventTrackerArn = eventTrackerArn;
            return this;
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getTrackingId() {
            return trackingId;
        }

        public final void setTrackingId(String trackingId) {
            this.trackingId = trackingId;
        }

        @Override
        public final Builder trackingId(String trackingId) {
            this.trackingId = trackingId;
            return this;
        }

        public final String getDatasetGroupArn() {
            return datasetGroupArn;
        }

        public final void setDatasetGroupArn(String datasetGroupArn) {
            this.datasetGroupArn = datasetGroupArn;
        }

        @Override
        public final Builder datasetGroupArn(String datasetGroupArn) {
            this.datasetGroupArn = datasetGroupArn;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final Instant getCreationDateTime() {
            return creationDateTime;
        }

        public final void setCreationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
        }

        @Override
        public final Builder creationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
            return this;
        }

        public final Instant getLastUpdatedDateTime() {
            return lastUpdatedDateTime;
        }

        public final void setLastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
        }

        @Override
        public final Builder lastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
            return this;
        }

        @Override
        public EventTracker build() {
            return new EventTracker(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
