/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.personalize.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The automatic training configuration to use when <code>performAutoTraining</code> is true.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AutoTrainingConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<AutoTrainingConfig.Builder, AutoTrainingConfig> {
    private static final SdkField<String> SCHEDULING_EXPRESSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("schedulingExpression").getter(getter(AutoTrainingConfig::schedulingExpression))
            .setter(setter(Builder::schedulingExpression))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schedulingExpression").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEDULING_EXPRESSION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String schedulingExpression;

    private AutoTrainingConfig(BuilderImpl builder) {
        this.schedulingExpression = builder.schedulingExpression;
    }

    /**
     * <p>
     * Specifies how often to automatically train new solution versions. Specify a rate expression in rate(<i>value</i>
     * <i>unit</i>) format. For value, specify a number between 1 and 30. For unit, specify <code>day</code> or
     * <code>days</code>. For example, to automatically create a new solution version every 5 days, specify
     * <code>rate(5 days)</code>. The default is every 7 days.
     * </p>
     * <p>
     * For more information about auto training, see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/customizing-solution-config.html">Creating and
     * configuring a solution</a>.
     * </p>
     * 
     * @return Specifies how often to automatically train new solution versions. Specify a rate expression in
     *         rate(<i>value</i> <i>unit</i>) format. For value, specify a number between 1 and 30. For unit, specify
     *         <code>day</code> or <code>days</code>. For example, to automatically create a new solution version every
     *         5 days, specify <code>rate(5 days)</code>. The default is every 7 days.</p>
     *         <p>
     *         For more information about auto training, see <a
     *         href="https://docs.aws.amazon.com/personalize/latest/dg/customizing-solution-config.html">Creating and
     *         configuring a solution</a>.
     */
    public final String schedulingExpression() {
        return schedulingExpression;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(schedulingExpression());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoTrainingConfig)) {
            return false;
        }
        AutoTrainingConfig other = (AutoTrainingConfig) obj;
        return Objects.equals(schedulingExpression(), other.schedulingExpression());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AutoTrainingConfig").add("SchedulingExpression", schedulingExpression()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "schedulingExpression":
            return Optional.ofNullable(clazz.cast(schedulingExpression()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("schedulingExpression", SCHEDULING_EXPRESSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AutoTrainingConfig, T> g) {
        return obj -> g.apply((AutoTrainingConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AutoTrainingConfig> {
        /**
         * <p>
         * Specifies how often to automatically train new solution versions. Specify a rate expression in
         * rate(<i>value</i> <i>unit</i>) format. For value, specify a number between 1 and 30. For unit, specify
         * <code>day</code> or <code>days</code>. For example, to automatically create a new solution version every 5
         * days, specify <code>rate(5 days)</code>. The default is every 7 days.
         * </p>
         * <p>
         * For more information about auto training, see <a
         * href="https://docs.aws.amazon.com/personalize/latest/dg/customizing-solution-config.html">Creating and
         * configuring a solution</a>.
         * </p>
         * 
         * @param schedulingExpression
         *        Specifies how often to automatically train new solution versions. Specify a rate expression in
         *        rate(<i>value</i> <i>unit</i>) format. For value, specify a number between 1 and 30. For unit, specify
         *        <code>day</code> or <code>days</code>. For example, to automatically create a new solution version
         *        every 5 days, specify <code>rate(5 days)</code>. The default is every 7 days.</p>
         *        <p>
         *        For more information about auto training, see <a
         *        href="https://docs.aws.amazon.com/personalize/latest/dg/customizing-solution-config.html">Creating and
         *        configuring a solution</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schedulingExpression(String schedulingExpression);
    }

    static final class BuilderImpl implements Builder {
        private String schedulingExpression;

        private BuilderImpl() {
        }

        private BuilderImpl(AutoTrainingConfig model) {
            schedulingExpression(model.schedulingExpression);
        }

        public final String getSchedulingExpression() {
            return schedulingExpression;
        }

        public final void setSchedulingExpression(String schedulingExpression) {
            this.schedulingExpression = schedulingExpression;
        }

        @Override
        public final Builder schedulingExpression(String schedulingExpression) {
            this.schedulingExpression = schedulingExpression;
            return this;
        }

        @Override
        public AutoTrainingConfig build() {
            return new AutoTrainingConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
