/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.personalize.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides the name and range of a continuous hyperparameter.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ContinuousHyperParameterRange implements SdkPojo, Serializable,
        ToCopyableBuilder<ContinuousHyperParameterRange.Builder, ContinuousHyperParameterRange> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(ContinuousHyperParameterRange::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<Double> MIN_VALUE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("minValue").getter(getter(ContinuousHyperParameterRange::minValue)).setter(setter(Builder::minValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minValue").build()).build();

    private static final SdkField<Double> MAX_VALUE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("maxValue").getter(getter(ContinuousHyperParameterRange::maxValue)).setter(setter(Builder::maxValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxValue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, MIN_VALUE_FIELD,
            MAX_VALUE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final Double minValue;

    private final Double maxValue;

    private ContinuousHyperParameterRange(BuilderImpl builder) {
        this.name = builder.name;
        this.minValue = builder.minValue;
        this.maxValue = builder.maxValue;
    }

    /**
     * <p>
     * The name of the hyperparameter.
     * </p>
     * 
     * @return The name of the hyperparameter.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The minimum allowable value for the hyperparameter.
     * </p>
     * 
     * @return The minimum allowable value for the hyperparameter.
     */
    public final Double minValue() {
        return minValue;
    }

    /**
     * <p>
     * The maximum allowable value for the hyperparameter.
     * </p>
     * 
     * @return The maximum allowable value for the hyperparameter.
     */
    public final Double maxValue() {
        return maxValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(minValue());
        hashCode = 31 * hashCode + Objects.hashCode(maxValue());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContinuousHyperParameterRange)) {
            return false;
        }
        ContinuousHyperParameterRange other = (ContinuousHyperParameterRange) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(minValue(), other.minValue())
                && Objects.equals(maxValue(), other.maxValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ContinuousHyperParameterRange").add("Name", name()).add("MinValue", minValue())
                .add("MaxValue", maxValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "minValue":
            return Optional.ofNullable(clazz.cast(minValue()));
        case "maxValue":
            return Optional.ofNullable(clazz.cast(maxValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("name", NAME_FIELD);
        map.put("minValue", MIN_VALUE_FIELD);
        map.put("maxValue", MAX_VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ContinuousHyperParameterRange, T> g) {
        return obj -> g.apply((ContinuousHyperParameterRange) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ContinuousHyperParameterRange> {
        /**
         * <p>
         * The name of the hyperparameter.
         * </p>
         * 
         * @param name
         *        The name of the hyperparameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The minimum allowable value for the hyperparameter.
         * </p>
         * 
         * @param minValue
         *        The minimum allowable value for the hyperparameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minValue(Double minValue);

        /**
         * <p>
         * The maximum allowable value for the hyperparameter.
         * </p>
         * 
         * @param maxValue
         *        The maximum allowable value for the hyperparameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxValue(Double maxValue);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private Double minValue;

        private Double maxValue;

        private BuilderImpl() {
        }

        private BuilderImpl(ContinuousHyperParameterRange model) {
            name(model.name);
            minValue(model.minValue);
            maxValue(model.maxValue);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Double getMinValue() {
            return minValue;
        }

        public final void setMinValue(Double minValue) {
            this.minValue = minValue;
        }

        @Override
        public final Builder minValue(Double minValue) {
            this.minValue = minValue;
            return this;
        }

        public final Double getMaxValue() {
            return maxValue;
        }

        public final void setMaxValue(Double maxValue) {
            this.maxValue = maxValue;
        }

        @Override
        public final Builder maxValue(Double maxValue) {
            this.maxValue = maxValue;
            return this;
        }

        @Override
        public ContinuousHyperParameterRange build() {
            return new ContinuousHyperParameterRange(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
