/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.personalize.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateDatasetExportJobResponse extends PersonalizeResponse implements
        ToCopyableBuilder<CreateDatasetExportJobResponse.Builder, CreateDatasetExportJobResponse> {
    private static final SdkField<String> DATASET_EXPORT_JOB_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("datasetExportJobArn").getter(getter(CreateDatasetExportJobResponse::datasetExportJobArn))
            .setter(setter(Builder::datasetExportJobArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datasetExportJobArn").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASET_EXPORT_JOB_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String datasetExportJobArn;

    private CreateDatasetExportJobResponse(BuilderImpl builder) {
        super(builder);
        this.datasetExportJobArn = builder.datasetExportJobArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the dataset export job.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the dataset export job.
     */
    public final String datasetExportJobArn() {
        return datasetExportJobArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(datasetExportJobArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDatasetExportJobResponse)) {
            return false;
        }
        CreateDatasetExportJobResponse other = (CreateDatasetExportJobResponse) obj;
        return Objects.equals(datasetExportJobArn(), other.datasetExportJobArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateDatasetExportJobResponse").add("DatasetExportJobArn", datasetExportJobArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "datasetExportJobArn":
            return Optional.ofNullable(clazz.cast(datasetExportJobArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("datasetExportJobArn", DATASET_EXPORT_JOB_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateDatasetExportJobResponse, T> g) {
        return obj -> g.apply((CreateDatasetExportJobResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PersonalizeResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateDatasetExportJobResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the dataset export job.
         * </p>
         * 
         * @param datasetExportJobArn
         *        The Amazon Resource Name (ARN) of the dataset export job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetExportJobArn(String datasetExportJobArn);
    }

    static final class BuilderImpl extends PersonalizeResponse.BuilderImpl implements Builder {
        private String datasetExportJobArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDatasetExportJobResponse model) {
            super(model);
            datasetExportJobArn(model.datasetExportJobArn);
        }

        public final String getDatasetExportJobArn() {
            return datasetExportJobArn;
        }

        public final void setDatasetExportJobArn(String datasetExportJobArn) {
            this.datasetExportJobArn = datasetExportJobArn;
        }

        @Override
        public final Builder datasetExportJobArn(String datasetExportJobArn) {
            this.datasetExportJobArn = datasetExportJobArn;
            return this;
        }

        @Override
        public CreateDatasetExportJobResponse build() {
            return new CreateDatasetExportJobResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
