/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.personalize.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the properties for hyperparameter optimization (HPO).
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HPOConfig implements SdkPojo, Serializable, ToCopyableBuilder<HPOConfig.Builder, HPOConfig> {
    private static final SdkField<HPOObjective> HPO_OBJECTIVE_FIELD = SdkField.<HPOObjective> builder(MarshallingType.SDK_POJO)
            .memberName("hpoObjective").getter(getter(HPOConfig::hpoObjective)).setter(setter(Builder::hpoObjective))
            .constructor(HPOObjective::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hpoObjective").build()).build();

    private static final SdkField<HPOResourceConfig> HPO_RESOURCE_CONFIG_FIELD = SdkField
            .<HPOResourceConfig> builder(MarshallingType.SDK_POJO).memberName("hpoResourceConfig")
            .getter(getter(HPOConfig::hpoResourceConfig)).setter(setter(Builder::hpoResourceConfig))
            .constructor(HPOResourceConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hpoResourceConfig").build()).build();

    private static final SdkField<HyperParameterRanges> ALGORITHM_HYPER_PARAMETER_RANGES_FIELD = SdkField
            .<HyperParameterRanges> builder(MarshallingType.SDK_POJO)
            .memberName("algorithmHyperParameterRanges")
            .getter(getter(HPOConfig::algorithmHyperParameterRanges))
            .setter(setter(Builder::algorithmHyperParameterRanges))
            .constructor(HyperParameterRanges::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("algorithmHyperParameterRanges")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HPO_OBJECTIVE_FIELD,
            HPO_RESOURCE_CONFIG_FIELD, ALGORITHM_HYPER_PARAMETER_RANGES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final HPOObjective hpoObjective;

    private final HPOResourceConfig hpoResourceConfig;

    private final HyperParameterRanges algorithmHyperParameterRanges;

    private HPOConfig(BuilderImpl builder) {
        this.hpoObjective = builder.hpoObjective;
        this.hpoResourceConfig = builder.hpoResourceConfig;
        this.algorithmHyperParameterRanges = builder.algorithmHyperParameterRanges;
    }

    /**
     * <p>
     * The metric to optimize during HPO.
     * </p>
     * <note>
     * <p>
     * Amazon Personalize doesn't support configuring the <code>hpoObjective</code> at this time.
     * </p>
     * </note>
     * 
     * @return The metric to optimize during HPO.</p> <note>
     *         <p>
     *         Amazon Personalize doesn't support configuring the <code>hpoObjective</code> at this time.
     *         </p>
     */
    public final HPOObjective hpoObjective() {
        return hpoObjective;
    }

    /**
     * <p>
     * Describes the resource configuration for HPO.
     * </p>
     * 
     * @return Describes the resource configuration for HPO.
     */
    public final HPOResourceConfig hpoResourceConfig() {
        return hpoResourceConfig;
    }

    /**
     * <p>
     * The hyperparameters and their allowable ranges.
     * </p>
     * 
     * @return The hyperparameters and their allowable ranges.
     */
    public final HyperParameterRanges algorithmHyperParameterRanges() {
        return algorithmHyperParameterRanges;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hpoObjective());
        hashCode = 31 * hashCode + Objects.hashCode(hpoResourceConfig());
        hashCode = 31 * hashCode + Objects.hashCode(algorithmHyperParameterRanges());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HPOConfig)) {
            return false;
        }
        HPOConfig other = (HPOConfig) obj;
        return Objects.equals(hpoObjective(), other.hpoObjective())
                && Objects.equals(hpoResourceConfig(), other.hpoResourceConfig())
                && Objects.equals(algorithmHyperParameterRanges(), other.algorithmHyperParameterRanges());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("HPOConfig").add("HpoObjective", hpoObjective()).add("HpoResourceConfig", hpoResourceConfig())
                .add("AlgorithmHyperParameterRanges", algorithmHyperParameterRanges()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "hpoObjective":
            return Optional.ofNullable(clazz.cast(hpoObjective()));
        case "hpoResourceConfig":
            return Optional.ofNullable(clazz.cast(hpoResourceConfig()));
        case "algorithmHyperParameterRanges":
            return Optional.ofNullable(clazz.cast(algorithmHyperParameterRanges()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("hpoObjective", HPO_OBJECTIVE_FIELD);
        map.put("hpoResourceConfig", HPO_RESOURCE_CONFIG_FIELD);
        map.put("algorithmHyperParameterRanges", ALGORITHM_HYPER_PARAMETER_RANGES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<HPOConfig, T> g) {
        return obj -> g.apply((HPOConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HPOConfig> {
        /**
         * <p>
         * The metric to optimize during HPO.
         * </p>
         * <note>
         * <p>
         * Amazon Personalize doesn't support configuring the <code>hpoObjective</code> at this time.
         * </p>
         * </note>
         * 
         * @param hpoObjective
         *        The metric to optimize during HPO.</p> <note>
         *        <p>
         *        Amazon Personalize doesn't support configuring the <code>hpoObjective</code> at this time.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hpoObjective(HPOObjective hpoObjective);

        /**
         * <p>
         * The metric to optimize during HPO.
         * </p>
         * <note>
         * <p>
         * Amazon Personalize doesn't support configuring the <code>hpoObjective</code> at this time.
         * </p>
         * </note> This is a convenience method that creates an instance of the {@link HPOObjective.Builder} avoiding
         * the need to create one manually via {@link HPOObjective#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link HPOObjective.Builder#build()} is called immediately and its
         * result is passed to {@link #hpoObjective(HPOObjective)}.
         * 
         * @param hpoObjective
         *        a consumer that will call methods on {@link HPOObjective.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #hpoObjective(HPOObjective)
         */
        default Builder hpoObjective(Consumer<HPOObjective.Builder> hpoObjective) {
            return hpoObjective(HPOObjective.builder().applyMutation(hpoObjective).build());
        }

        /**
         * <p>
         * Describes the resource configuration for HPO.
         * </p>
         * 
         * @param hpoResourceConfig
         *        Describes the resource configuration for HPO.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hpoResourceConfig(HPOResourceConfig hpoResourceConfig);

        /**
         * <p>
         * Describes the resource configuration for HPO.
         * </p>
         * This is a convenience method that creates an instance of the {@link HPOResourceConfig.Builder} avoiding the
         * need to create one manually via {@link HPOResourceConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link HPOResourceConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #hpoResourceConfig(HPOResourceConfig)}.
         * 
         * @param hpoResourceConfig
         *        a consumer that will call methods on {@link HPOResourceConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #hpoResourceConfig(HPOResourceConfig)
         */
        default Builder hpoResourceConfig(Consumer<HPOResourceConfig.Builder> hpoResourceConfig) {
            return hpoResourceConfig(HPOResourceConfig.builder().applyMutation(hpoResourceConfig).build());
        }

        /**
         * <p>
         * The hyperparameters and their allowable ranges.
         * </p>
         * 
         * @param algorithmHyperParameterRanges
         *        The hyperparameters and their allowable ranges.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder algorithmHyperParameterRanges(HyperParameterRanges algorithmHyperParameterRanges);

        /**
         * <p>
         * The hyperparameters and their allowable ranges.
         * </p>
         * This is a convenience method that creates an instance of the {@link HyperParameterRanges.Builder} avoiding
         * the need to create one manually via {@link HyperParameterRanges#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link HyperParameterRanges.Builder#build()} is called immediately and
         * its result is passed to {@link #algorithmHyperParameterRanges(HyperParameterRanges)}.
         * 
         * @param algorithmHyperParameterRanges
         *        a consumer that will call methods on {@link HyperParameterRanges.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #algorithmHyperParameterRanges(HyperParameterRanges)
         */
        default Builder algorithmHyperParameterRanges(Consumer<HyperParameterRanges.Builder> algorithmHyperParameterRanges) {
            return algorithmHyperParameterRanges(HyperParameterRanges.builder().applyMutation(algorithmHyperParameterRanges)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private HPOObjective hpoObjective;

        private HPOResourceConfig hpoResourceConfig;

        private HyperParameterRanges algorithmHyperParameterRanges;

        private BuilderImpl() {
        }

        private BuilderImpl(HPOConfig model) {
            hpoObjective(model.hpoObjective);
            hpoResourceConfig(model.hpoResourceConfig);
            algorithmHyperParameterRanges(model.algorithmHyperParameterRanges);
        }

        public final HPOObjective.Builder getHpoObjective() {
            return hpoObjective != null ? hpoObjective.toBuilder() : null;
        }

        public final void setHpoObjective(HPOObjective.BuilderImpl hpoObjective) {
            this.hpoObjective = hpoObjective != null ? hpoObjective.build() : null;
        }

        @Override
        public final Builder hpoObjective(HPOObjective hpoObjective) {
            this.hpoObjective = hpoObjective;
            return this;
        }

        public final HPOResourceConfig.Builder getHpoResourceConfig() {
            return hpoResourceConfig != null ? hpoResourceConfig.toBuilder() : null;
        }

        public final void setHpoResourceConfig(HPOResourceConfig.BuilderImpl hpoResourceConfig) {
            this.hpoResourceConfig = hpoResourceConfig != null ? hpoResourceConfig.build() : null;
        }

        @Override
        public final Builder hpoResourceConfig(HPOResourceConfig hpoResourceConfig) {
            this.hpoResourceConfig = hpoResourceConfig;
            return this;
        }

        public final HyperParameterRanges.Builder getAlgorithmHyperParameterRanges() {
            return algorithmHyperParameterRanges != null ? algorithmHyperParameterRanges.toBuilder() : null;
        }

        public final void setAlgorithmHyperParameterRanges(HyperParameterRanges.BuilderImpl algorithmHyperParameterRanges) {
            this.algorithmHyperParameterRanges = algorithmHyperParameterRanges != null ? algorithmHyperParameterRanges.build()
                    : null;
        }

        @Override
        public final Builder algorithmHyperParameterRanges(HyperParameterRanges algorithmHyperParameterRanges) {
            this.algorithmHyperParameterRanges = algorithmHyperParameterRanges;
            return this;
        }

        @Override
        public HPOConfig build() {
            return new HPOConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
