/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.personalize.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeDataDeletionJobResponse extends PersonalizeResponse implements
        ToCopyableBuilder<DescribeDataDeletionJobResponse.Builder, DescribeDataDeletionJobResponse> {
    private static final SdkField<DataDeletionJob> DATA_DELETION_JOB_FIELD = SdkField
            .<DataDeletionJob> builder(MarshallingType.SDK_POJO).memberName("dataDeletionJob")
            .getter(getter(DescribeDataDeletionJobResponse::dataDeletionJob)).setter(setter(Builder::dataDeletionJob))
            .constructor(DataDeletionJob::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataDeletionJob").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_DELETION_JOB_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final DataDeletionJob dataDeletionJob;

    private DescribeDataDeletionJobResponse(BuilderImpl builder) {
        super(builder);
        this.dataDeletionJob = builder.dataDeletionJob;
    }

    /**
     * <p>
     * Information about the data deletion job, including the status.
     * </p>
     * <p>
     * The status is one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * PENDING
     * </p>
     * </li>
     * <li>
     * <p>
     * IN_PROGRESS
     * </p>
     * </li>
     * <li>
     * <p>
     * COMPLETED
     * </p>
     * </li>
     * <li>
     * <p>
     * FAILED
     * </p>
     * </li>
     * </ul>
     * 
     * @return Information about the data deletion job, including the status.</p>
     *         <p>
     *         The status is one of the following values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         PENDING
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         IN_PROGRESS
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         COMPLETED
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         FAILED
     *         </p>
     *         </li>
     */
    public final DataDeletionJob dataDeletionJob() {
        return dataDeletionJob;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dataDeletionJob());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDataDeletionJobResponse)) {
            return false;
        }
        DescribeDataDeletionJobResponse other = (DescribeDataDeletionJobResponse) obj;
        return Objects.equals(dataDeletionJob(), other.dataDeletionJob());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeDataDeletionJobResponse").add("DataDeletionJob", dataDeletionJob()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "dataDeletionJob":
            return Optional.ofNullable(clazz.cast(dataDeletionJob()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("dataDeletionJob", DATA_DELETION_JOB_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeDataDeletionJobResponse, T> g) {
        return obj -> g.apply((DescribeDataDeletionJobResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PersonalizeResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeDataDeletionJobResponse> {
        /**
         * <p>
         * Information about the data deletion job, including the status.
         * </p>
         * <p>
         * The status is one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * PENDING
         * </p>
         * </li>
         * <li>
         * <p>
         * IN_PROGRESS
         * </p>
         * </li>
         * <li>
         * <p>
         * COMPLETED
         * </p>
         * </li>
         * <li>
         * <p>
         * FAILED
         * </p>
         * </li>
         * </ul>
         * 
         * @param dataDeletionJob
         *        Information about the data deletion job, including the status.</p>
         *        <p>
         *        The status is one of the following values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        PENDING
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        IN_PROGRESS
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        COMPLETED
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        FAILED
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataDeletionJob(DataDeletionJob dataDeletionJob);

        /**
         * <p>
         * Information about the data deletion job, including the status.
         * </p>
         * <p>
         * The status is one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * PENDING
         * </p>
         * </li>
         * <li>
         * <p>
         * IN_PROGRESS
         * </p>
         * </li>
         * <li>
         * <p>
         * COMPLETED
         * </p>
         * </li>
         * <li>
         * <p>
         * FAILED
         * </p>
         * </li>
         * </ul>
         * This is a convenience method that creates an instance of the {@link DataDeletionJob.Builder} avoiding the
         * need to create one manually via {@link DataDeletionJob#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataDeletionJob.Builder#build()} is called immediately and its
         * result is passed to {@link #dataDeletionJob(DataDeletionJob)}.
         * 
         * @param dataDeletionJob
         *        a consumer that will call methods on {@link DataDeletionJob.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataDeletionJob(DataDeletionJob)
         */
        default Builder dataDeletionJob(Consumer<DataDeletionJob.Builder> dataDeletionJob) {
            return dataDeletionJob(DataDeletionJob.builder().applyMutation(dataDeletionJob).build());
        }
    }

    static final class BuilderImpl extends PersonalizeResponse.BuilderImpl implements Builder {
        private DataDeletionJob dataDeletionJob;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDataDeletionJobResponse model) {
            super(model);
            dataDeletionJob(model.dataDeletionJob);
        }

        public final DataDeletionJob.Builder getDataDeletionJob() {
            return dataDeletionJob != null ? dataDeletionJob.toBuilder() : null;
        }

        public final void setDataDeletionJob(DataDeletionJob.BuilderImpl dataDeletionJob) {
            this.dataDeletionJob = dataDeletionJob != null ? dataDeletionJob.build() : null;
        }

        @Override
        public final Builder dataDeletionJob(DataDeletionJob dataDeletionJob) {
            this.dataDeletionJob = dataDeletionJob;
            return this;
        }

        @Override
        public DescribeDataDeletionJobResponse build() {
            return new DescribeDataDeletionJobResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
