/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.personalize.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateSolutionRequest extends PersonalizeRequest implements
        ToCopyableBuilder<UpdateSolutionRequest.Builder, UpdateSolutionRequest> {
    private static final SdkField<String> SOLUTION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("solutionArn").getter(getter(UpdateSolutionRequest::solutionArn)).setter(setter(Builder::solutionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("solutionArn").build()).build();

    private static final SdkField<Boolean> PERFORM_AUTO_TRAINING_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("performAutoTraining").getter(getter(UpdateSolutionRequest::performAutoTraining))
            .setter(setter(Builder::performAutoTraining))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("performAutoTraining").build())
            .build();

    private static final SdkField<SolutionUpdateConfig> SOLUTION_UPDATE_CONFIG_FIELD = SdkField
            .<SolutionUpdateConfig> builder(MarshallingType.SDK_POJO).memberName("solutionUpdateConfig")
            .getter(getter(UpdateSolutionRequest::solutionUpdateConfig)).setter(setter(Builder::solutionUpdateConfig))
            .constructor(SolutionUpdateConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("solutionUpdateConfig").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOLUTION_ARN_FIELD,
            PERFORM_AUTO_TRAINING_FIELD, SOLUTION_UPDATE_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String solutionArn;

    private final Boolean performAutoTraining;

    private final SolutionUpdateConfig solutionUpdateConfig;

    private UpdateSolutionRequest(BuilderImpl builder) {
        super(builder);
        this.solutionArn = builder.solutionArn;
        this.performAutoTraining = builder.performAutoTraining;
        this.solutionUpdateConfig = builder.solutionUpdateConfig;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the solution to update.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the solution to update.
     */
    public final String solutionArn() {
        return solutionArn;
    }

    /**
     * <p>
     * Whether the solution uses automatic training to create new solution versions (trained models). You can change the
     * training frequency by specifying a <code>schedulingExpression</code> in the <code>AutoTrainingConfig</code> as
     * part of solution configuration.
     * </p>
     * <p>
     * If you turn on automatic training, the first automatic training starts within one hour after the solution update
     * completes. If you manually create a solution version within the hour, the solution skips the first automatic
     * training. For more information about automatic training, see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/solution-config-auto-training.html">Configuring automatic
     * training</a>.
     * </p>
     * <p>
     * After training starts, you can get the solution version's Amazon Resource Name (ARN) with the <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_ListSolutionVersions.html">ListSolutionVersions</a>
     * API operation. To get its status, use the <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeSolutionVersion.html"
     * >DescribeSolutionVersion</a>.
     * </p>
     * 
     * @return Whether the solution uses automatic training to create new solution versions (trained models). You can
     *         change the training frequency by specifying a <code>schedulingExpression</code> in the
     *         <code>AutoTrainingConfig</code> as part of solution configuration. </p>
     *         <p>
     *         If you turn on automatic training, the first automatic training starts within one hour after the solution
     *         update completes. If you manually create a solution version within the hour, the solution skips the first
     *         automatic training. For more information about automatic training, see <a
     *         href="https://docs.aws.amazon.com/personalize/latest/dg/solution-config-auto-training.html">Configuring
     *         automatic training</a>.
     *         </p>
     *         <p>
     *         After training starts, you can get the solution version's Amazon Resource Name (ARN) with the <a
     *         href="https://docs.aws.amazon.com/personalize/latest/dg/API_ListSolutionVersions.html"
     *         >ListSolutionVersions</a> API operation. To get its status, use the <a
     *         href="https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeSolutionVersion.html"
     *         >DescribeSolutionVersion</a>.
     */
    public final Boolean performAutoTraining() {
        return performAutoTraining;
    }

    /**
     * <p>
     * The new configuration details of the solution.
     * </p>
     * 
     * @return The new configuration details of the solution.
     */
    public final SolutionUpdateConfig solutionUpdateConfig() {
        return solutionUpdateConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(solutionArn());
        hashCode = 31 * hashCode + Objects.hashCode(performAutoTraining());
        hashCode = 31 * hashCode + Objects.hashCode(solutionUpdateConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSolutionRequest)) {
            return false;
        }
        UpdateSolutionRequest other = (UpdateSolutionRequest) obj;
        return Objects.equals(solutionArn(), other.solutionArn())
                && Objects.equals(performAutoTraining(), other.performAutoTraining())
                && Objects.equals(solutionUpdateConfig(), other.solutionUpdateConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateSolutionRequest").add("SolutionArn", solutionArn())
                .add("PerformAutoTraining", performAutoTraining()).add("SolutionUpdateConfig", solutionUpdateConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "solutionArn":
            return Optional.ofNullable(clazz.cast(solutionArn()));
        case "performAutoTraining":
            return Optional.ofNullable(clazz.cast(performAutoTraining()));
        case "solutionUpdateConfig":
            return Optional.ofNullable(clazz.cast(solutionUpdateConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("solutionArn", SOLUTION_ARN_FIELD);
        map.put("performAutoTraining", PERFORM_AUTO_TRAINING_FIELD);
        map.put("solutionUpdateConfig", SOLUTION_UPDATE_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateSolutionRequest, T> g) {
        return obj -> g.apply((UpdateSolutionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PersonalizeRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateSolutionRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the solution to update.
         * </p>
         * 
         * @param solutionArn
         *        The Amazon Resource Name (ARN) of the solution to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder solutionArn(String solutionArn);

        /**
         * <p>
         * Whether the solution uses automatic training to create new solution versions (trained models). You can change
         * the training frequency by specifying a <code>schedulingExpression</code> in the
         * <code>AutoTrainingConfig</code> as part of solution configuration.
         * </p>
         * <p>
         * If you turn on automatic training, the first automatic training starts within one hour after the solution
         * update completes. If you manually create a solution version within the hour, the solution skips the first
         * automatic training. For more information about automatic training, see <a
         * href="https://docs.aws.amazon.com/personalize/latest/dg/solution-config-auto-training.html">Configuring
         * automatic training</a>.
         * </p>
         * <p>
         * After training starts, you can get the solution version's Amazon Resource Name (ARN) with the <a
         * href="https://docs.aws.amazon.com/personalize/latest/dg/API_ListSolutionVersions.html"
         * >ListSolutionVersions</a> API operation. To get its status, use the <a
         * href="https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeSolutionVersion.html"
         * >DescribeSolutionVersion</a>.
         * </p>
         * 
         * @param performAutoTraining
         *        Whether the solution uses automatic training to create new solution versions (trained models). You can
         *        change the training frequency by specifying a <code>schedulingExpression</code> in the
         *        <code>AutoTrainingConfig</code> as part of solution configuration. </p>
         *        <p>
         *        If you turn on automatic training, the first automatic training starts within one hour after the
         *        solution update completes. If you manually create a solution version within the hour, the solution
         *        skips the first automatic training. For more information about automatic training, see <a
         *        href="https://docs.aws.amazon.com/personalize/latest/dg/solution-config-auto-training.html"
         *        >Configuring automatic training</a>.
         *        </p>
         *        <p>
         *        After training starts, you can get the solution version's Amazon Resource Name (ARN) with the <a
         *        href="https://docs.aws.amazon.com/personalize/latest/dg/API_ListSolutionVersions.html"
         *        >ListSolutionVersions</a> API operation. To get its status, use the <a
         *        href="https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeSolutionVersion.html"
         *        >DescribeSolutionVersion</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder performAutoTraining(Boolean performAutoTraining);

        /**
         * <p>
         * The new configuration details of the solution.
         * </p>
         * 
         * @param solutionUpdateConfig
         *        The new configuration details of the solution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder solutionUpdateConfig(SolutionUpdateConfig solutionUpdateConfig);

        /**
         * <p>
         * The new configuration details of the solution.
         * </p>
         * This is a convenience method that creates an instance of the {@link SolutionUpdateConfig.Builder} avoiding
         * the need to create one manually via {@link SolutionUpdateConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SolutionUpdateConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #solutionUpdateConfig(SolutionUpdateConfig)}.
         * 
         * @param solutionUpdateConfig
         *        a consumer that will call methods on {@link SolutionUpdateConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #solutionUpdateConfig(SolutionUpdateConfig)
         */
        default Builder solutionUpdateConfig(Consumer<SolutionUpdateConfig.Builder> solutionUpdateConfig) {
            return solutionUpdateConfig(SolutionUpdateConfig.builder().applyMutation(solutionUpdateConfig).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PersonalizeRequest.BuilderImpl implements Builder {
        private String solutionArn;

        private Boolean performAutoTraining;

        private SolutionUpdateConfig solutionUpdateConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSolutionRequest model) {
            super(model);
            solutionArn(model.solutionArn);
            performAutoTraining(model.performAutoTraining);
            solutionUpdateConfig(model.solutionUpdateConfig);
        }

        public final String getSolutionArn() {
            return solutionArn;
        }

        public final void setSolutionArn(String solutionArn) {
            this.solutionArn = solutionArn;
        }

        @Override
        public final Builder solutionArn(String solutionArn) {
            this.solutionArn = solutionArn;
            return this;
        }

        public final Boolean getPerformAutoTraining() {
            return performAutoTraining;
        }

        public final void setPerformAutoTraining(Boolean performAutoTraining) {
            this.performAutoTraining = performAutoTraining;
        }

        @Override
        public final Builder performAutoTraining(Boolean performAutoTraining) {
            this.performAutoTraining = performAutoTraining;
            return this;
        }

        public final SolutionUpdateConfig.Builder getSolutionUpdateConfig() {
            return solutionUpdateConfig != null ? solutionUpdateConfig.toBuilder() : null;
        }

        public final void setSolutionUpdateConfig(SolutionUpdateConfig.BuilderImpl solutionUpdateConfig) {
            this.solutionUpdateConfig = solutionUpdateConfig != null ? solutionUpdateConfig.build() : null;
        }

        @Override
        public final Builder solutionUpdateConfig(SolutionUpdateConfig solutionUpdateConfig) {
            this.solutionUpdateConfig = solutionUpdateConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateSolutionRequest build() {
            return new UpdateSolutionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
