/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.personalize.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeSolutionResponse extends PersonalizeResponse implements
        ToCopyableBuilder<DescribeSolutionResponse.Builder, DescribeSolutionResponse> {
    private static final SdkField<Solution> SOLUTION_FIELD = SdkField.<Solution> builder(MarshallingType.SDK_POJO)
            .memberName("solution").getter(getter(DescribeSolutionResponse::solution)).setter(setter(Builder::solution))
            .constructor(Solution::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("solution").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOLUTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Solution solution;

    private DescribeSolutionResponse(BuilderImpl builder) {
        super(builder);
        this.solution = builder.solution;
    }

    /**
     * <p>
     * An object that describes the solution.
     * </p>
     * 
     * @return An object that describes the solution.
     */
    public final Solution solution() {
        return solution;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(solution());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSolutionResponse)) {
            return false;
        }
        DescribeSolutionResponse other = (DescribeSolutionResponse) obj;
        return Objects.equals(solution(), other.solution());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeSolutionResponse").add("Solution", solution()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "solution":
            return Optional.ofNullable(clazz.cast(solution()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("solution", SOLUTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeSolutionResponse, T> g) {
        return obj -> g.apply((DescribeSolutionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PersonalizeResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeSolutionResponse> {
        /**
         * <p>
         * An object that describes the solution.
         * </p>
         * 
         * @param solution
         *        An object that describes the solution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder solution(Solution solution);

        /**
         * <p>
         * An object that describes the solution.
         * </p>
         * This is a convenience method that creates an instance of the {@link Solution.Builder} avoiding the need to
         * create one manually via {@link Solution#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Solution.Builder#build()} is called immediately and its result is
         * passed to {@link #solution(Solution)}.
         * 
         * @param solution
         *        a consumer that will call methods on {@link Solution.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #solution(Solution)
         */
        default Builder solution(Consumer<Solution.Builder> solution) {
            return solution(Solution.builder().applyMutation(solution).build());
        }
    }

    static final class BuilderImpl extends PersonalizeResponse.BuilderImpl implements Builder {
        private Solution solution;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSolutionResponse model) {
            super(model);
            solution(model.solution);
        }

        public final Solution.Builder getSolution() {
            return solution != null ? solution.toBuilder() : null;
        }

        public final void setSolution(Solution.BuilderImpl solution) {
            this.solution = solution != null ? solution.build() : null;
        }

        @Override
        public final Builder solution(Solution solution) {
            this.solution = solution;
            return this;
        }

        @Override
        public DescribeSolutionResponse build() {
            return new DescribeSolutionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
