/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.personalize.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the resource configuration for hyperparameter optimization (HPO).
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HPOResourceConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<HPOResourceConfig.Builder, HPOResourceConfig> {
    private static final SdkField<String> MAX_NUMBER_OF_TRAINING_JOBS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("maxNumberOfTrainingJobs").getter(getter(HPOResourceConfig::maxNumberOfTrainingJobs))
            .setter(setter(Builder::maxNumberOfTrainingJobs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxNumberOfTrainingJobs").build())
            .build();

    private static final SdkField<String> MAX_PARALLEL_TRAINING_JOBS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("maxParallelTrainingJobs").getter(getter(HPOResourceConfig::maxParallelTrainingJobs))
            .setter(setter(Builder::maxParallelTrainingJobs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxParallelTrainingJobs").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            MAX_NUMBER_OF_TRAINING_JOBS_FIELD, MAX_PARALLEL_TRAINING_JOBS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String maxNumberOfTrainingJobs;

    private final String maxParallelTrainingJobs;

    private HPOResourceConfig(BuilderImpl builder) {
        this.maxNumberOfTrainingJobs = builder.maxNumberOfTrainingJobs;
        this.maxParallelTrainingJobs = builder.maxParallelTrainingJobs;
    }

    /**
     * <p>
     * The maximum number of training jobs when you create a solution version. The maximum value for
     * <code>maxNumberOfTrainingJobs</code> is <code>40</code>.
     * </p>
     * 
     * @return The maximum number of training jobs when you create a solution version. The maximum value for
     *         <code>maxNumberOfTrainingJobs</code> is <code>40</code>.
     */
    public final String maxNumberOfTrainingJobs() {
        return maxNumberOfTrainingJobs;
    }

    /**
     * <p>
     * The maximum number of parallel training jobs when you create a solution version. The maximum value for
     * <code>maxParallelTrainingJobs</code> is <code>10</code>.
     * </p>
     * 
     * @return The maximum number of parallel training jobs when you create a solution version. The maximum value for
     *         <code>maxParallelTrainingJobs</code> is <code>10</code>.
     */
    public final String maxParallelTrainingJobs() {
        return maxParallelTrainingJobs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(maxNumberOfTrainingJobs());
        hashCode = 31 * hashCode + Objects.hashCode(maxParallelTrainingJobs());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HPOResourceConfig)) {
            return false;
        }
        HPOResourceConfig other = (HPOResourceConfig) obj;
        return Objects.equals(maxNumberOfTrainingJobs(), other.maxNumberOfTrainingJobs())
                && Objects.equals(maxParallelTrainingJobs(), other.maxParallelTrainingJobs());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("HPOResourceConfig").add("MaxNumberOfTrainingJobs", maxNumberOfTrainingJobs())
                .add("MaxParallelTrainingJobs", maxParallelTrainingJobs()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "maxNumberOfTrainingJobs":
            return Optional.ofNullable(clazz.cast(maxNumberOfTrainingJobs()));
        case "maxParallelTrainingJobs":
            return Optional.ofNullable(clazz.cast(maxParallelTrainingJobs()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("maxNumberOfTrainingJobs", MAX_NUMBER_OF_TRAINING_JOBS_FIELD);
        map.put("maxParallelTrainingJobs", MAX_PARALLEL_TRAINING_JOBS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<HPOResourceConfig, T> g) {
        return obj -> g.apply((HPOResourceConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HPOResourceConfig> {
        /**
         * <p>
         * The maximum number of training jobs when you create a solution version. The maximum value for
         * <code>maxNumberOfTrainingJobs</code> is <code>40</code>.
         * </p>
         * 
         * @param maxNumberOfTrainingJobs
         *        The maximum number of training jobs when you create a solution version. The maximum value for
         *        <code>maxNumberOfTrainingJobs</code> is <code>40</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxNumberOfTrainingJobs(String maxNumberOfTrainingJobs);

        /**
         * <p>
         * The maximum number of parallel training jobs when you create a solution version. The maximum value for
         * <code>maxParallelTrainingJobs</code> is <code>10</code>.
         * </p>
         * 
         * @param maxParallelTrainingJobs
         *        The maximum number of parallel training jobs when you create a solution version. The maximum value for
         *        <code>maxParallelTrainingJobs</code> is <code>10</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxParallelTrainingJobs(String maxParallelTrainingJobs);
    }

    static final class BuilderImpl implements Builder {
        private String maxNumberOfTrainingJobs;

        private String maxParallelTrainingJobs;

        private BuilderImpl() {
        }

        private BuilderImpl(HPOResourceConfig model) {
            maxNumberOfTrainingJobs(model.maxNumberOfTrainingJobs);
            maxParallelTrainingJobs(model.maxParallelTrainingJobs);
        }

        public final String getMaxNumberOfTrainingJobs() {
            return maxNumberOfTrainingJobs;
        }

        public final void setMaxNumberOfTrainingJobs(String maxNumberOfTrainingJobs) {
            this.maxNumberOfTrainingJobs = maxNumberOfTrainingJobs;
        }

        @Override
        public final Builder maxNumberOfTrainingJobs(String maxNumberOfTrainingJobs) {
            this.maxNumberOfTrainingJobs = maxNumberOfTrainingJobs;
            return this;
        }

        public final String getMaxParallelTrainingJobs() {
            return maxParallelTrainingJobs;
        }

        public final void setMaxParallelTrainingJobs(String maxParallelTrainingJobs) {
            this.maxParallelTrainingJobs = maxParallelTrainingJobs;
        }

        @Override
        public final Builder maxParallelTrainingJobs(String maxParallelTrainingJobs) {
            this.maxParallelTrainingJobs = maxParallelTrainingJobs;
            return this;
        }

        @Override
        public HPOResourceConfig build() {
            return new HPOResourceConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
