/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.personalize.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a job that deletes all references to specific users from an Amazon Personalize dataset group in batches.
 * For information about creating a data deletion job, see <a
 * href="https://docs.aws.amazon.com/personalize/latest/dg/delete-records.html">Deleting users</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataDeletionJob implements SdkPojo, Serializable, ToCopyableBuilder<DataDeletionJob.Builder, DataDeletionJob> {
    private static final SdkField<String> JOB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("jobName").getter(getter(DataDeletionJob::jobName)).setter(setter(Builder::jobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobName").build()).build();

    private static final SdkField<String> DATA_DELETION_JOB_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dataDeletionJobArn").getter(getter(DataDeletionJob::dataDeletionJobArn))
            .setter(setter(Builder::dataDeletionJobArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataDeletionJobArn").build())
            .build();

    private static final SdkField<String> DATASET_GROUP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("datasetGroupArn").getter(getter(DataDeletionJob::datasetGroupArn))
            .setter(setter(Builder::datasetGroupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datasetGroupArn").build()).build();

    private static final SdkField<DataSource> DATA_SOURCE_FIELD = SdkField.<DataSource> builder(MarshallingType.SDK_POJO)
            .memberName("dataSource").getter(getter(DataDeletionJob::dataSource)).setter(setter(Builder::dataSource))
            .constructor(DataSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSource").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(DataDeletionJob::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(DataDeletionJob::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Integer> NUM_DELETED_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("numDeleted").getter(getter(DataDeletionJob::numDeleted)).setter(setter(Builder::numDeleted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numDeleted").build()).build();

    private static final SdkField<Instant> CREATION_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationDateTime").getter(getter(DataDeletionJob::creationDateTime))
            .setter(setter(Builder::creationDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDateTime").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdatedDateTime").getter(getter(DataDeletionJob::lastUpdatedDateTime))
            .setter(setter(Builder::lastUpdatedDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedDateTime").build())
            .build();

    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("failureReason").getter(getter(DataDeletionJob::failureReason)).setter(setter(Builder::failureReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureReason").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_NAME_FIELD,
            DATA_DELETION_JOB_ARN_FIELD, DATASET_GROUP_ARN_FIELD, DATA_SOURCE_FIELD, ROLE_ARN_FIELD, STATUS_FIELD,
            NUM_DELETED_FIELD, CREATION_DATE_TIME_FIELD, LAST_UPDATED_DATE_TIME_FIELD, FAILURE_REASON_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String jobName;

    private final String dataDeletionJobArn;

    private final String datasetGroupArn;

    private final DataSource dataSource;

    private final String roleArn;

    private final String status;

    private final Integer numDeleted;

    private final Instant creationDateTime;

    private final Instant lastUpdatedDateTime;

    private final String failureReason;

    private DataDeletionJob(BuilderImpl builder) {
        this.jobName = builder.jobName;
        this.dataDeletionJobArn = builder.dataDeletionJobArn;
        this.datasetGroupArn = builder.datasetGroupArn;
        this.dataSource = builder.dataSource;
        this.roleArn = builder.roleArn;
        this.status = builder.status;
        this.numDeleted = builder.numDeleted;
        this.creationDateTime = builder.creationDateTime;
        this.lastUpdatedDateTime = builder.lastUpdatedDateTime;
        this.failureReason = builder.failureReason;
    }

    /**
     * <p>
     * The name of the data deletion job.
     * </p>
     * 
     * @return The name of the data deletion job.
     */
    public final String jobName() {
        return jobName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the data deletion job.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the data deletion job.
     */
    public final String dataDeletionJobArn() {
        return dataDeletionJobArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the dataset group the job deletes records from.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the dataset group the job deletes records from.
     */
    public final String datasetGroupArn() {
        return datasetGroupArn;
    }

    /**
     * Returns the value of the DataSource property for this object.
     * 
     * @return The value of the DataSource property for this object.
     */
    public final DataSource dataSource() {
        return dataSource;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role that has permissions to read from the Amazon S3 data source.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM role that has permissions to read from the Amazon S3 data
     *         source.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The status of the data deletion job.
     * </p>
     * <p>
     * A data deletion job can have one of the following statuses:
     * </p>
     * <ul>
     * <li>
     * <p>
     * PENDING &gt; IN_PROGRESS &gt; COMPLETED -or- FAILED
     * </p>
     * </li>
     * </ul>
     * 
     * @return The status of the data deletion job.</p>
     *         <p>
     *         A data deletion job can have one of the following statuses:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         PENDING &gt; IN_PROGRESS &gt; COMPLETED -or- FAILED
     *         </p>
     *         </li>
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * The number of records deleted by a COMPLETED job.
     * </p>
     * 
     * @return The number of records deleted by a COMPLETED job.
     */
    public final Integer numDeleted() {
        return numDeleted;
    }

    /**
     * <p>
     * The creation date and time (in Unix time) of the data deletion job.
     * </p>
     * 
     * @return The creation date and time (in Unix time) of the data deletion job.
     */
    public final Instant creationDateTime() {
        return creationDateTime;
    }

    /**
     * <p>
     * The date and time (in Unix time) the data deletion job was last updated.
     * </p>
     * 
     * @return The date and time (in Unix time) the data deletion job was last updated.
     */
    public final Instant lastUpdatedDateTime() {
        return lastUpdatedDateTime;
    }

    /**
     * <p>
     * If a data deletion job fails, provides the reason why.
     * </p>
     * 
     * @return If a data deletion job fails, provides the reason why.
     */
    public final String failureReason() {
        return failureReason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(jobName());
        hashCode = 31 * hashCode + Objects.hashCode(dataDeletionJobArn());
        hashCode = 31 * hashCode + Objects.hashCode(datasetGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(dataSource());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(numDeleted());
        hashCode = 31 * hashCode + Objects.hashCode(creationDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(failureReason());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataDeletionJob)) {
            return false;
        }
        DataDeletionJob other = (DataDeletionJob) obj;
        return Objects.equals(jobName(), other.jobName()) && Objects.equals(dataDeletionJobArn(), other.dataDeletionJobArn())
                && Objects.equals(datasetGroupArn(), other.datasetGroupArn()) && Objects.equals(dataSource(), other.dataSource())
                && Objects.equals(roleArn(), other.roleArn()) && Objects.equals(status(), other.status())
                && Objects.equals(numDeleted(), other.numDeleted())
                && Objects.equals(creationDateTime(), other.creationDateTime())
                && Objects.equals(lastUpdatedDateTime(), other.lastUpdatedDateTime())
                && Objects.equals(failureReason(), other.failureReason());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataDeletionJob").add("JobName", jobName()).add("DataDeletionJobArn", dataDeletionJobArn())
                .add("DatasetGroupArn", datasetGroupArn()).add("DataSource", dataSource()).add("RoleArn", roleArn())
                .add("Status", status()).add("NumDeleted", numDeleted()).add("CreationDateTime", creationDateTime())
                .add("LastUpdatedDateTime", lastUpdatedDateTime()).add("FailureReason", failureReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "jobName":
            return Optional.ofNullable(clazz.cast(jobName()));
        case "dataDeletionJobArn":
            return Optional.ofNullable(clazz.cast(dataDeletionJobArn()));
        case "datasetGroupArn":
            return Optional.ofNullable(clazz.cast(datasetGroupArn()));
        case "dataSource":
            return Optional.ofNullable(clazz.cast(dataSource()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "status":
            return Optional.ofNullable(clazz.cast(status()));
        case "numDeleted":
            return Optional.ofNullable(clazz.cast(numDeleted()));
        case "creationDateTime":
            return Optional.ofNullable(clazz.cast(creationDateTime()));
        case "lastUpdatedDateTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedDateTime()));
        case "failureReason":
            return Optional.ofNullable(clazz.cast(failureReason()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("jobName", JOB_NAME_FIELD);
        map.put("dataDeletionJobArn", DATA_DELETION_JOB_ARN_FIELD);
        map.put("datasetGroupArn", DATASET_GROUP_ARN_FIELD);
        map.put("dataSource", DATA_SOURCE_FIELD);
        map.put("roleArn", ROLE_ARN_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("numDeleted", NUM_DELETED_FIELD);
        map.put("creationDateTime", CREATION_DATE_TIME_FIELD);
        map.put("lastUpdatedDateTime", LAST_UPDATED_DATE_TIME_FIELD);
        map.put("failureReason", FAILURE_REASON_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataDeletionJob, T> g) {
        return obj -> g.apply((DataDeletionJob) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataDeletionJob> {
        /**
         * <p>
         * The name of the data deletion job.
         * </p>
         * 
         * @param jobName
         *        The name of the data deletion job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobName(String jobName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the data deletion job.
         * </p>
         * 
         * @param dataDeletionJobArn
         *        The Amazon Resource Name (ARN) of the data deletion job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataDeletionJobArn(String dataDeletionJobArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the dataset group the job deletes records from.
         * </p>
         * 
         * @param datasetGroupArn
         *        The Amazon Resource Name (ARN) of the dataset group the job deletes records from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetGroupArn(String datasetGroupArn);

        /**
         * Sets the value of the DataSource property for this object.
         *
         * @param dataSource
         *        The new value for the DataSource property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSource(DataSource dataSource);

        /**
         * Sets the value of the DataSource property for this object.
         *
         * This is a convenience method that creates an instance of the {@link DataSource.Builder} avoiding the need to
         * create one manually via {@link DataSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataSource.Builder#build()} is called immediately and its result
         * is passed to {@link #dataSource(DataSource)}.
         * 
         * @param dataSource
         *        a consumer that will call methods on {@link DataSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataSource(DataSource)
         */
        default Builder dataSource(Consumer<DataSource.Builder> dataSource) {
            return dataSource(DataSource.builder().applyMutation(dataSource).build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM role that has permissions to read from the Amazon S3 data source.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of the IAM role that has permissions to read from the Amazon S3 data
         *        source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The status of the data deletion job.
         * </p>
         * <p>
         * A data deletion job can have one of the following statuses:
         * </p>
         * <ul>
         * <li>
         * <p>
         * PENDING &gt; IN_PROGRESS &gt; COMPLETED -or- FAILED
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the data deletion job.</p>
         *        <p>
         *        A data deletion job can have one of the following statuses:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        PENDING &gt; IN_PROGRESS &gt; COMPLETED -or- FAILED
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The number of records deleted by a COMPLETED job.
         * </p>
         * 
         * @param numDeleted
         *        The number of records deleted by a COMPLETED job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numDeleted(Integer numDeleted);

        /**
         * <p>
         * The creation date and time (in Unix time) of the data deletion job.
         * </p>
         * 
         * @param creationDateTime
         *        The creation date and time (in Unix time) of the data deletion job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDateTime(Instant creationDateTime);

        /**
         * <p>
         * The date and time (in Unix time) the data deletion job was last updated.
         * </p>
         * 
         * @param lastUpdatedDateTime
         *        The date and time (in Unix time) the data deletion job was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedDateTime(Instant lastUpdatedDateTime);

        /**
         * <p>
         * If a data deletion job fails, provides the reason why.
         * </p>
         * 
         * @param failureReason
         *        If a data deletion job fails, provides the reason why.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReason(String failureReason);
    }

    static final class BuilderImpl implements Builder {
        private String jobName;

        private String dataDeletionJobArn;

        private String datasetGroupArn;

        private DataSource dataSource;

        private String roleArn;

        private String status;

        private Integer numDeleted;

        private Instant creationDateTime;

        private Instant lastUpdatedDateTime;

        private String failureReason;

        private BuilderImpl() {
        }

        private BuilderImpl(DataDeletionJob model) {
            jobName(model.jobName);
            dataDeletionJobArn(model.dataDeletionJobArn);
            datasetGroupArn(model.datasetGroupArn);
            dataSource(model.dataSource);
            roleArn(model.roleArn);
            status(model.status);
            numDeleted(model.numDeleted);
            creationDateTime(model.creationDateTime);
            lastUpdatedDateTime(model.lastUpdatedDateTime);
            failureReason(model.failureReason);
        }

        public final String getJobName() {
            return jobName;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final String getDataDeletionJobArn() {
            return dataDeletionJobArn;
        }

        public final void setDataDeletionJobArn(String dataDeletionJobArn) {
            this.dataDeletionJobArn = dataDeletionJobArn;
        }

        @Override
        public final Builder dataDeletionJobArn(String dataDeletionJobArn) {
            this.dataDeletionJobArn = dataDeletionJobArn;
            return this;
        }

        public final String getDatasetGroupArn() {
            return datasetGroupArn;
        }

        public final void setDatasetGroupArn(String datasetGroupArn) {
            this.datasetGroupArn = datasetGroupArn;
        }

        @Override
        public final Builder datasetGroupArn(String datasetGroupArn) {
            this.datasetGroupArn = datasetGroupArn;
            return this;
        }

        public final DataSource.Builder getDataSource() {
            return dataSource != null ? dataSource.toBuilder() : null;
        }

        public final void setDataSource(DataSource.BuilderImpl dataSource) {
            this.dataSource = dataSource != null ? dataSource.build() : null;
        }

        @Override
        public final Builder dataSource(DataSource dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final Integer getNumDeleted() {
            return numDeleted;
        }

        public final void setNumDeleted(Integer numDeleted) {
            this.numDeleted = numDeleted;
        }

        @Override
        public final Builder numDeleted(Integer numDeleted) {
            this.numDeleted = numDeleted;
            return this;
        }

        public final Instant getCreationDateTime() {
            return creationDateTime;
        }

        public final void setCreationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
        }

        @Override
        public final Builder creationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
            return this;
        }

        public final Instant getLastUpdatedDateTime() {
            return lastUpdatedDateTime;
        }

        public final void setLastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
        }

        @Override
        public final Builder lastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
            return this;
        }

        public final String getFailureReason() {
            return failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        @Override
        public DataDeletionJob build() {
            return new DataDeletionJob(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
