/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.personalize.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class HPOResourceConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, HPOResourceConfig> {
    private static final SdkField<String> MAX_NUMBER_OF_TRAINING_JOBS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("maxNumberOfTrainingJobs").getter(HPOResourceConfig.getter(HPOResourceConfig::maxNumberOfTrainingJobs)).setter(HPOResourceConfig.setter(Builder::maxNumberOfTrainingJobs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxNumberOfTrainingJobs").build()}).build();
    private static final SdkField<String> MAX_PARALLEL_TRAINING_JOBS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("maxParallelTrainingJobs").getter(HPOResourceConfig.getter(HPOResourceConfig::maxParallelTrainingJobs)).setter(HPOResourceConfig.setter(Builder::maxParallelTrainingJobs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxParallelTrainingJobs").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_NUMBER_OF_TRAINING_JOBS_FIELD, MAX_PARALLEL_TRAINING_JOBS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = HPOResourceConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String maxNumberOfTrainingJobs;
    private final String maxParallelTrainingJobs;

    private HPOResourceConfig(BuilderImpl builder) {
        this.maxNumberOfTrainingJobs = builder.maxNumberOfTrainingJobs;
        this.maxParallelTrainingJobs = builder.maxParallelTrainingJobs;
    }

    public final String maxNumberOfTrainingJobs() {
        return this.maxNumberOfTrainingJobs;
    }

    public final String maxParallelTrainingJobs() {
        return this.maxParallelTrainingJobs;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.maxNumberOfTrainingJobs());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxParallelTrainingJobs());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HPOResourceConfig)) {
            return false;
        }
        HPOResourceConfig other = (HPOResourceConfig)obj;
        return Objects.equals(this.maxNumberOfTrainingJobs(), other.maxNumberOfTrainingJobs()) && Objects.equals(this.maxParallelTrainingJobs(), other.maxParallelTrainingJobs());
    }

    public final String toString() {
        return ToString.builder((String)"HPOResourceConfig").add("MaxNumberOfTrainingJobs", (Object)this.maxNumberOfTrainingJobs()).add("MaxParallelTrainingJobs", (Object)this.maxParallelTrainingJobs()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "maxNumberOfTrainingJobs": {
                return Optional.ofNullable(clazz.cast(this.maxNumberOfTrainingJobs()));
            }
            case "maxParallelTrainingJobs": {
                return Optional.ofNullable(clazz.cast(this.maxParallelTrainingJobs()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("maxNumberOfTrainingJobs", MAX_NUMBER_OF_TRAINING_JOBS_FIELD);
        map.put("maxParallelTrainingJobs", MAX_PARALLEL_TRAINING_JOBS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<HPOResourceConfig, T> g) {
        return obj -> g.apply((HPOResourceConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String maxNumberOfTrainingJobs;
        private String maxParallelTrainingJobs;

        private BuilderImpl() {
        }

        private BuilderImpl(HPOResourceConfig model) {
            this.maxNumberOfTrainingJobs(model.maxNumberOfTrainingJobs);
            this.maxParallelTrainingJobs(model.maxParallelTrainingJobs);
        }

        public final String getMaxNumberOfTrainingJobs() {
            return this.maxNumberOfTrainingJobs;
        }

        public final void setMaxNumberOfTrainingJobs(String maxNumberOfTrainingJobs) {
            this.maxNumberOfTrainingJobs = maxNumberOfTrainingJobs;
        }

        @Override
        public final Builder maxNumberOfTrainingJobs(String maxNumberOfTrainingJobs) {
            this.maxNumberOfTrainingJobs = maxNumberOfTrainingJobs;
            return this;
        }

        public final String getMaxParallelTrainingJobs() {
            return this.maxParallelTrainingJobs;
        }

        public final void setMaxParallelTrainingJobs(String maxParallelTrainingJobs) {
            this.maxParallelTrainingJobs = maxParallelTrainingJobs;
        }

        @Override
        public final Builder maxParallelTrainingJobs(String maxParallelTrainingJobs) {
            this.maxParallelTrainingJobs = maxParallelTrainingJobs;
            return this;
        }

        public HPOResourceConfig build() {
            return new HPOResourceConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, HPOResourceConfig> {
        public Builder maxNumberOfTrainingJobs(String var1);

        public Builder maxParallelTrainingJobs(String var1);
    }
}

