/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.personalize.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.personalize.model.DatasetExportJobOutput;
import software.amazon.awssdk.services.personalize.model.IngestionMode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DatasetExportJob
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DatasetExportJob> {
    private static final SdkField<String> JOB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobName").getter(DatasetExportJob.getter(DatasetExportJob::jobName)).setter(DatasetExportJob.setter(Builder::jobName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobName").build()}).build();
    private static final SdkField<String> DATASET_EXPORT_JOB_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("datasetExportJobArn").getter(DatasetExportJob.getter(DatasetExportJob::datasetExportJobArn)).setter(DatasetExportJob.setter(Builder::datasetExportJobArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datasetExportJobArn").build()}).build();
    private static final SdkField<String> DATASET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("datasetArn").getter(DatasetExportJob.getter(DatasetExportJob::datasetArn)).setter(DatasetExportJob.setter(Builder::datasetArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datasetArn").build()}).build();
    private static final SdkField<String> INGESTION_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ingestionMode").getter(DatasetExportJob.getter(DatasetExportJob::ingestionModeAsString)).setter(DatasetExportJob.setter(Builder::ingestionMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ingestionMode").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(DatasetExportJob.getter(DatasetExportJob::roleArn)).setter(DatasetExportJob.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(DatasetExportJob.getter(DatasetExportJob::status)).setter(DatasetExportJob.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<DatasetExportJobOutput> JOB_OUTPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("jobOutput").getter(DatasetExportJob.getter(DatasetExportJob::jobOutput)).setter(DatasetExportJob.setter(Builder::jobOutput)).constructor(DatasetExportJobOutput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobOutput").build()}).build();
    private static final SdkField<Instant> CREATION_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationDateTime").getter(DatasetExportJob.getter(DatasetExportJob::creationDateTime)).setter(DatasetExportJob.setter(Builder::creationDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDateTime").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdatedDateTime").getter(DatasetExportJob.getter(DatasetExportJob::lastUpdatedDateTime)).setter(DatasetExportJob.setter(Builder::lastUpdatedDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedDateTime").build()}).build();
    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("failureReason").getter(DatasetExportJob.getter(DatasetExportJob::failureReason)).setter(DatasetExportJob.setter(Builder::failureReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureReason").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_NAME_FIELD, DATASET_EXPORT_JOB_ARN_FIELD, DATASET_ARN_FIELD, INGESTION_MODE_FIELD, ROLE_ARN_FIELD, STATUS_FIELD, JOB_OUTPUT_FIELD, CREATION_DATE_TIME_FIELD, LAST_UPDATED_DATE_TIME_FIELD, FAILURE_REASON_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DatasetExportJob.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String jobName;
    private final String datasetExportJobArn;
    private final String datasetArn;
    private final String ingestionMode;
    private final String roleArn;
    private final String status;
    private final DatasetExportJobOutput jobOutput;
    private final Instant creationDateTime;
    private final Instant lastUpdatedDateTime;
    private final String failureReason;

    private DatasetExportJob(BuilderImpl builder) {
        this.jobName = builder.jobName;
        this.datasetExportJobArn = builder.datasetExportJobArn;
        this.datasetArn = builder.datasetArn;
        this.ingestionMode = builder.ingestionMode;
        this.roleArn = builder.roleArn;
        this.status = builder.status;
        this.jobOutput = builder.jobOutput;
        this.creationDateTime = builder.creationDateTime;
        this.lastUpdatedDateTime = builder.lastUpdatedDateTime;
        this.failureReason = builder.failureReason;
    }

    public final String jobName() {
        return this.jobName;
    }

    public final String datasetExportJobArn() {
        return this.datasetExportJobArn;
    }

    public final String datasetArn() {
        return this.datasetArn;
    }

    public final IngestionMode ingestionMode() {
        return IngestionMode.fromValue(this.ingestionMode);
    }

    public final String ingestionModeAsString() {
        return this.ingestionMode;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final String status() {
        return this.status;
    }

    public final DatasetExportJobOutput jobOutput() {
        return this.jobOutput;
    }

    public final Instant creationDateTime() {
        return this.creationDateTime;
    }

    public final Instant lastUpdatedDateTime() {
        return this.lastUpdatedDateTime;
    }

    public final String failureReason() {
        return this.failureReason;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.jobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.datasetExportJobArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.datasetArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.ingestionModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobOutput());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureReason());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DatasetExportJob)) {
            return false;
        }
        DatasetExportJob other = (DatasetExportJob)obj;
        return Objects.equals(this.jobName(), other.jobName()) && Objects.equals(this.datasetExportJobArn(), other.datasetExportJobArn()) && Objects.equals(this.datasetArn(), other.datasetArn()) && Objects.equals(this.ingestionModeAsString(), other.ingestionModeAsString()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.jobOutput(), other.jobOutput()) && Objects.equals(this.creationDateTime(), other.creationDateTime()) && Objects.equals(this.lastUpdatedDateTime(), other.lastUpdatedDateTime()) && Objects.equals(this.failureReason(), other.failureReason());
    }

    public final String toString() {
        return ToString.builder((String)"DatasetExportJob").add("JobName", (Object)this.jobName()).add("DatasetExportJobArn", (Object)this.datasetExportJobArn()).add("DatasetArn", (Object)this.datasetArn()).add("IngestionMode", (Object)this.ingestionModeAsString()).add("RoleArn", (Object)this.roleArn()).add("Status", (Object)this.status()).add("JobOutput", (Object)this.jobOutput()).add("CreationDateTime", (Object)this.creationDateTime()).add("LastUpdatedDateTime", (Object)this.lastUpdatedDateTime()).add("FailureReason", (Object)this.failureReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "jobName": {
                return Optional.ofNullable(clazz.cast(this.jobName()));
            }
            case "datasetExportJobArn": {
                return Optional.ofNullable(clazz.cast(this.datasetExportJobArn()));
            }
            case "datasetArn": {
                return Optional.ofNullable(clazz.cast(this.datasetArn()));
            }
            case "ingestionMode": {
                return Optional.ofNullable(clazz.cast(this.ingestionModeAsString()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "jobOutput": {
                return Optional.ofNullable(clazz.cast(this.jobOutput()));
            }
            case "creationDateTime": {
                return Optional.ofNullable(clazz.cast(this.creationDateTime()));
            }
            case "lastUpdatedDateTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedDateTime()));
            }
            case "failureReason": {
                return Optional.ofNullable(clazz.cast(this.failureReason()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("jobName", JOB_NAME_FIELD);
        map.put("datasetExportJobArn", DATASET_EXPORT_JOB_ARN_FIELD);
        map.put("datasetArn", DATASET_ARN_FIELD);
        map.put("ingestionMode", INGESTION_MODE_FIELD);
        map.put("roleArn", ROLE_ARN_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("jobOutput", JOB_OUTPUT_FIELD);
        map.put("creationDateTime", CREATION_DATE_TIME_FIELD);
        map.put("lastUpdatedDateTime", LAST_UPDATED_DATE_TIME_FIELD);
        map.put("failureReason", FAILURE_REASON_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DatasetExportJob, T> g) {
        return obj -> g.apply((DatasetExportJob)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String jobName;
        private String datasetExportJobArn;
        private String datasetArn;
        private String ingestionMode;
        private String roleArn;
        private String status;
        private DatasetExportJobOutput jobOutput;
        private Instant creationDateTime;
        private Instant lastUpdatedDateTime;
        private String failureReason;

        private BuilderImpl() {
        }

        private BuilderImpl(DatasetExportJob model) {
            this.jobName(model.jobName);
            this.datasetExportJobArn(model.datasetExportJobArn);
            this.datasetArn(model.datasetArn);
            this.ingestionMode(model.ingestionMode);
            this.roleArn(model.roleArn);
            this.status(model.status);
            this.jobOutput(model.jobOutput);
            this.creationDateTime(model.creationDateTime);
            this.lastUpdatedDateTime(model.lastUpdatedDateTime);
            this.failureReason(model.failureReason);
        }

        public final String getJobName() {
            return this.jobName;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final String getDatasetExportJobArn() {
            return this.datasetExportJobArn;
        }

        public final void setDatasetExportJobArn(String datasetExportJobArn) {
            this.datasetExportJobArn = datasetExportJobArn;
        }

        @Override
        public final Builder datasetExportJobArn(String datasetExportJobArn) {
            this.datasetExportJobArn = datasetExportJobArn;
            return this;
        }

        public final String getDatasetArn() {
            return this.datasetArn;
        }

        public final void setDatasetArn(String datasetArn) {
            this.datasetArn = datasetArn;
        }

        @Override
        public final Builder datasetArn(String datasetArn) {
            this.datasetArn = datasetArn;
            return this;
        }

        public final String getIngestionMode() {
            return this.ingestionMode;
        }

        public final void setIngestionMode(String ingestionMode) {
            this.ingestionMode = ingestionMode;
        }

        @Override
        public final Builder ingestionMode(String ingestionMode) {
            this.ingestionMode = ingestionMode;
            return this;
        }

        @Override
        public final Builder ingestionMode(IngestionMode ingestionMode) {
            this.ingestionMode(ingestionMode == null ? null : ingestionMode.toString());
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final DatasetExportJobOutput.Builder getJobOutput() {
            return this.jobOutput != null ? this.jobOutput.toBuilder() : null;
        }

        public final void setJobOutput(DatasetExportJobOutput.BuilderImpl jobOutput) {
            this.jobOutput = jobOutput != null ? jobOutput.build() : null;
        }

        @Override
        public final Builder jobOutput(DatasetExportJobOutput jobOutput) {
            this.jobOutput = jobOutput;
            return this;
        }

        public final Instant getCreationDateTime() {
            return this.creationDateTime;
        }

        public final void setCreationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
        }

        @Override
        public final Builder creationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
            return this;
        }

        public final Instant getLastUpdatedDateTime() {
            return this.lastUpdatedDateTime;
        }

        public final void setLastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
        }

        @Override
        public final Builder lastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
            return this;
        }

        public final String getFailureReason() {
            return this.failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public DatasetExportJob build() {
            return new DatasetExportJob(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DatasetExportJob> {
        public Builder jobName(String var1);

        public Builder datasetExportJobArn(String var1);

        public Builder datasetArn(String var1);

        public Builder ingestionMode(String var1);

        public Builder ingestionMode(IngestionMode var1);

        public Builder roleArn(String var1);

        public Builder status(String var1);

        public Builder jobOutput(DatasetExportJobOutput var1);

        default public Builder jobOutput(Consumer<DatasetExportJobOutput.Builder> jobOutput) {
            return this.jobOutput((DatasetExportJobOutput)((DatasetExportJobOutput.Builder)DatasetExportJobOutput.builder().applyMutation(jobOutput)).build());
        }

        public Builder creationDateTime(Instant var1);

        public Builder lastUpdatedDateTime(Instant var1);

        public Builder failureReason(String var1);
    }
}

