/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.personalize.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The input configuration of a batch segment job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchSegmentJobInput implements SdkPojo, Serializable,
        ToCopyableBuilder<BatchSegmentJobInput.Builder, BatchSegmentJobInput> {
    private static final SdkField<S3DataConfig> S3_DATA_SOURCE_FIELD = SdkField.<S3DataConfig> builder(MarshallingType.SDK_POJO)
            .memberName("s3DataSource").getter(getter(BatchSegmentJobInput::s3DataSource)).setter(setter(Builder::s3DataSource))
            .constructor(S3DataConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3DataSource").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_DATA_SOURCE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final S3DataConfig s3DataSource;

    private BatchSegmentJobInput(BuilderImpl builder) {
        this.s3DataSource = builder.s3DataSource;
    }

    /**
     * Returns the value of the S3DataSource property for this object.
     * 
     * @return The value of the S3DataSource property for this object.
     */
    public final S3DataConfig s3DataSource() {
        return s3DataSource;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(s3DataSource());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchSegmentJobInput)) {
            return false;
        }
        BatchSegmentJobInput other = (BatchSegmentJobInput) obj;
        return Objects.equals(s3DataSource(), other.s3DataSource());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchSegmentJobInput").add("S3DataSource", s3DataSource()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "s3DataSource":
            return Optional.ofNullable(clazz.cast(s3DataSource()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("s3DataSource", S3_DATA_SOURCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchSegmentJobInput, T> g) {
        return obj -> g.apply((BatchSegmentJobInput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BatchSegmentJobInput> {
        /**
         * Sets the value of the S3DataSource property for this object.
         *
         * @param s3DataSource
         *        The new value for the S3DataSource property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3DataSource(S3DataConfig s3DataSource);

        /**
         * Sets the value of the S3DataSource property for this object.
         *
         * This is a convenience method that creates an instance of the {@link S3DataConfig.Builder} avoiding the need
         * to create one manually via {@link S3DataConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3DataConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #s3DataSource(S3DataConfig)}.
         * 
         * @param s3DataSource
         *        a consumer that will call methods on {@link S3DataConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3DataSource(S3DataConfig)
         */
        default Builder s3DataSource(Consumer<S3DataConfig.Builder> s3DataSource) {
            return s3DataSource(S3DataConfig.builder().applyMutation(s3DataSource).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private S3DataConfig s3DataSource;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchSegmentJobInput model) {
            s3DataSource(model.s3DataSource);
        }

        public final S3DataConfig.Builder getS3DataSource() {
            return s3DataSource != null ? s3DataSource.toBuilder() : null;
        }

        public final void setS3DataSource(S3DataConfig.BuilderImpl s3DataSource) {
            this.s3DataSource = s3DataSource != null ? s3DataSource.build() : null;
        }

        @Override
        public final Builder s3DataSource(S3DataConfig s3DataSource) {
            this.s3DataSource = s3DataSource;
            return this;
        }

        @Override
        public BatchSegmentJobInput build() {
            return new BatchSegmentJobInput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
