/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.personalize.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration details of a campaign.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CampaignConfig implements SdkPojo, Serializable, ToCopyableBuilder<CampaignConfig.Builder, CampaignConfig> {
    private static final SdkField<Map<String, String>> ITEM_EXPLORATION_CONFIG_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("itemExplorationConfig")
            .getter(getter(CampaignConfig::itemExplorationConfig))
            .setter(setter(Builder::itemExplorationConfig))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("itemExplorationConfig").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Boolean> ENABLE_METADATA_WITH_RECOMMENDATIONS_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("enableMetadataWithRecommendations")
            .getter(getter(CampaignConfig::enableMetadataWithRecommendations))
            .setter(setter(Builder::enableMetadataWithRecommendations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableMetadataWithRecommendations")
                    .build()).build();

    private static final SdkField<Boolean> SYNC_WITH_LATEST_SOLUTION_VERSION_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("syncWithLatestSolutionVersion")
            .getter(getter(CampaignConfig::syncWithLatestSolutionVersion))
            .setter(setter(Builder::syncWithLatestSolutionVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("syncWithLatestSolutionVersion")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ITEM_EXPLORATION_CONFIG_FIELD,
            ENABLE_METADATA_WITH_RECOMMENDATIONS_FIELD, SYNC_WITH_LATEST_SOLUTION_VERSION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Map<String, String> itemExplorationConfig;

    private final Boolean enableMetadataWithRecommendations;

    private final Boolean syncWithLatestSolutionVersion;

    private CampaignConfig(BuilderImpl builder) {
        this.itemExplorationConfig = builder.itemExplorationConfig;
        this.enableMetadataWithRecommendations = builder.enableMetadataWithRecommendations;
        this.syncWithLatestSolutionVersion = builder.syncWithLatestSolutionVersion;
    }

    /**
     * For responses, this returns true if the service returned a value for the ItemExplorationConfig property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasItemExplorationConfig() {
        return itemExplorationConfig != null && !(itemExplorationConfig instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Specifies the exploration configuration hyperparameters, including <code>explorationWeight</code> and
     * <code>explorationItemAgeCutOff</code>, you want to use to configure the amount of item exploration Amazon
     * Personalize uses when recommending items. Provide <code>itemExplorationConfig</code> data only if your solution
     * uses the <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/native-recipe-new-item-USER_PERSONALIZATION.html"
     * >User-Personalization</a> recipe.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasItemExplorationConfig} method.
     * </p>
     * 
     * @return Specifies the exploration configuration hyperparameters, including <code>explorationWeight</code> and
     *         <code>explorationItemAgeCutOff</code>, you want to use to configure the amount of item exploration Amazon
     *         Personalize uses when recommending items. Provide <code>itemExplorationConfig</code> data only if your
     *         solution uses the <a href=
     *         "https://docs.aws.amazon.com/personalize/latest/dg/native-recipe-new-item-USER_PERSONALIZATION.html"
     *         >User-Personalization</a> recipe.
     */
    public final Map<String, String> itemExplorationConfig() {
        return itemExplorationConfig;
    }

    /**
     * <p>
     * Whether metadata with recommendations is enabled for the campaign. If enabled, you can specify the columns from
     * your Items dataset in your request for recommendations. Amazon Personalize returns this data for each item in the
     * recommendation response. For information about enabling metadata for a campaign, see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/campaigns.html#create-campaign-return-metadata">Enabling
     * metadata in recommendations for a campaign</a>.
     * </p>
     * <p>
     * If you enable metadata in recommendations, you will incur additional costs. For more information, see <a
     * href="https://aws.amazon.com/personalize/pricing/">Amazon Personalize pricing</a>.
     * </p>
     * 
     * @return Whether metadata with recommendations is enabled for the campaign. If enabled, you can specify the
     *         columns from your Items dataset in your request for recommendations. Amazon Personalize returns this data
     *         for each item in the recommendation response. For information about enabling metadata for a campaign, see
     *         <a
     *         href="https://docs.aws.amazon.com/personalize/latest/dg/campaigns.html#create-campaign-return-metadata"
     *         >Enabling metadata in recommendations for a campaign</a>.</p>
     *         <p>
     *         If you enable metadata in recommendations, you will incur additional costs. For more information, see <a
     *         href="https://aws.amazon.com/personalize/pricing/">Amazon Personalize pricing</a>.
     */
    public final Boolean enableMetadataWithRecommendations() {
        return enableMetadataWithRecommendations;
    }

    /**
     * <p>
     * Whether the campaign automatically updates to use the latest solution version (trained model) of a solution. If
     * you specify <code>True</code>, you must specify the ARN of your <i>solution</i> for the
     * <code>SolutionVersionArn</code> parameter. It must be in <code>SolutionArn/$LATEST</code> format. The default is
     * <code>False</code> and you must manually update the campaign to deploy the latest solution version.
     * </p>
     * <p>
     * For more information about automatic campaign updates, see <a href=
     * "https://docs.aws.amazon.com/personalize/latest/dg/campaigns.html#create-campaign-automatic-latest-sv-update"
     * >Enabling automatic campaign updates</a>.
     * </p>
     * 
     * @return Whether the campaign automatically updates to use the latest solution version (trained model) of a
     *         solution. If you specify <code>True</code>, you must specify the ARN of your <i>solution</i> for the
     *         <code>SolutionVersionArn</code> parameter. It must be in <code>SolutionArn/$LATEST</code> format. The
     *         default is <code>False</code> and you must manually update the campaign to deploy the latest solution
     *         version. </p>
     *         <p>
     *         For more information about automatic campaign updates, see <a href=
     *         "https://docs.aws.amazon.com/personalize/latest/dg/campaigns.html#create-campaign-automatic-latest-sv-update"
     *         >Enabling automatic campaign updates</a>.
     */
    public final Boolean syncWithLatestSolutionVersion() {
        return syncWithLatestSolutionVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasItemExplorationConfig() ? itemExplorationConfig() : null);
        hashCode = 31 * hashCode + Objects.hashCode(enableMetadataWithRecommendations());
        hashCode = 31 * hashCode + Objects.hashCode(syncWithLatestSolutionVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CampaignConfig)) {
            return false;
        }
        CampaignConfig other = (CampaignConfig) obj;
        return hasItemExplorationConfig() == other.hasItemExplorationConfig()
                && Objects.equals(itemExplorationConfig(), other.itemExplorationConfig())
                && Objects.equals(enableMetadataWithRecommendations(), other.enableMetadataWithRecommendations())
                && Objects.equals(syncWithLatestSolutionVersion(), other.syncWithLatestSolutionVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CampaignConfig")
                .add("ItemExplorationConfig", hasItemExplorationConfig() ? itemExplorationConfig() : null)
                .add("EnableMetadataWithRecommendations", enableMetadataWithRecommendations())
                .add("SyncWithLatestSolutionVersion", syncWithLatestSolutionVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "itemExplorationConfig":
            return Optional.ofNullable(clazz.cast(itemExplorationConfig()));
        case "enableMetadataWithRecommendations":
            return Optional.ofNullable(clazz.cast(enableMetadataWithRecommendations()));
        case "syncWithLatestSolutionVersion":
            return Optional.ofNullable(clazz.cast(syncWithLatestSolutionVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("itemExplorationConfig", ITEM_EXPLORATION_CONFIG_FIELD);
        map.put("enableMetadataWithRecommendations", ENABLE_METADATA_WITH_RECOMMENDATIONS_FIELD);
        map.put("syncWithLatestSolutionVersion", SYNC_WITH_LATEST_SOLUTION_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CampaignConfig, T> g) {
        return obj -> g.apply((CampaignConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CampaignConfig> {
        /**
         * <p>
         * Specifies the exploration configuration hyperparameters, including <code>explorationWeight</code> and
         * <code>explorationItemAgeCutOff</code>, you want to use to configure the amount of item exploration Amazon
         * Personalize uses when recommending items. Provide <code>itemExplorationConfig</code> data only if your
         * solution uses the <a
         * href="https://docs.aws.amazon.com/personalize/latest/dg/native-recipe-new-item-USER_PERSONALIZATION.html"
         * >User-Personalization</a> recipe.
         * </p>
         * 
         * @param itemExplorationConfig
         *        Specifies the exploration configuration hyperparameters, including <code>explorationWeight</code> and
         *        <code>explorationItemAgeCutOff</code>, you want to use to configure the amount of item exploration
         *        Amazon Personalize uses when recommending items. Provide <code>itemExplorationConfig</code> data only
         *        if your solution uses the <a href=
         *        "https://docs.aws.amazon.com/personalize/latest/dg/native-recipe-new-item-USER_PERSONALIZATION.html"
         *        >User-Personalization</a> recipe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder itemExplorationConfig(Map<String, String> itemExplorationConfig);

        /**
         * <p>
         * Whether metadata with recommendations is enabled for the campaign. If enabled, you can specify the columns
         * from your Items dataset in your request for recommendations. Amazon Personalize returns this data for each
         * item in the recommendation response. For information about enabling metadata for a campaign, see <a
         * href="https://docs.aws.amazon.com/personalize/latest/dg/campaigns.html#create-campaign-return-metadata"
         * >Enabling metadata in recommendations for a campaign</a>.
         * </p>
         * <p>
         * If you enable metadata in recommendations, you will incur additional costs. For more information, see <a
         * href="https://aws.amazon.com/personalize/pricing/">Amazon Personalize pricing</a>.
         * </p>
         * 
         * @param enableMetadataWithRecommendations
         *        Whether metadata with recommendations is enabled for the campaign. If enabled, you can specify the
         *        columns from your Items dataset in your request for recommendations. Amazon Personalize returns this
         *        data for each item in the recommendation response. For information about enabling metadata for a
         *        campaign, see <a href=
         *        "https://docs.aws.amazon.com/personalize/latest/dg/campaigns.html#create-campaign-return-metadata"
         *        >Enabling metadata in recommendations for a campaign</a>.</p>
         *        <p>
         *        If you enable metadata in recommendations, you will incur additional costs. For more information, see
         *        <a href="https://aws.amazon.com/personalize/pricing/">Amazon Personalize pricing</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableMetadataWithRecommendations(Boolean enableMetadataWithRecommendations);

        /**
         * <p>
         * Whether the campaign automatically updates to use the latest solution version (trained model) of a solution.
         * If you specify <code>True</code>, you must specify the ARN of your <i>solution</i> for the
         * <code>SolutionVersionArn</code> parameter. It must be in <code>SolutionArn/$LATEST</code> format. The default
         * is <code>False</code> and you must manually update the campaign to deploy the latest solution version.
         * </p>
         * <p>
         * For more information about automatic campaign updates, see <a href=
         * "https://docs.aws.amazon.com/personalize/latest/dg/campaigns.html#create-campaign-automatic-latest-sv-update"
         * >Enabling automatic campaign updates</a>.
         * </p>
         * 
         * @param syncWithLatestSolutionVersion
         *        Whether the campaign automatically updates to use the latest solution version (trained model) of a
         *        solution. If you specify <code>True</code>, you must specify the ARN of your <i>solution</i> for the
         *        <code>SolutionVersionArn</code> parameter. It must be in <code>SolutionArn/$LATEST</code> format. The
         *        default is <code>False</code> and you must manually update the campaign to deploy the latest solution
         *        version. </p>
         *        <p>
         *        For more information about automatic campaign updates, see <a href=
         *        "https://docs.aws.amazon.com/personalize/latest/dg/campaigns.html#create-campaign-automatic-latest-sv-update"
         *        >Enabling automatic campaign updates</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder syncWithLatestSolutionVersion(Boolean syncWithLatestSolutionVersion);
    }

    static final class BuilderImpl implements Builder {
        private Map<String, String> itemExplorationConfig = DefaultSdkAutoConstructMap.getInstance();

        private Boolean enableMetadataWithRecommendations;

        private Boolean syncWithLatestSolutionVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(CampaignConfig model) {
            itemExplorationConfig(model.itemExplorationConfig);
            enableMetadataWithRecommendations(model.enableMetadataWithRecommendations);
            syncWithLatestSolutionVersion(model.syncWithLatestSolutionVersion);
        }

        public final Map<String, String> getItemExplorationConfig() {
            if (itemExplorationConfig instanceof SdkAutoConstructMap) {
                return null;
            }
            return itemExplorationConfig;
        }

        public final void setItemExplorationConfig(Map<String, String> itemExplorationConfig) {
            this.itemExplorationConfig = HyperParametersCopier.copy(itemExplorationConfig);
        }

        @Override
        public final Builder itemExplorationConfig(Map<String, String> itemExplorationConfig) {
            this.itemExplorationConfig = HyperParametersCopier.copy(itemExplorationConfig);
            return this;
        }

        public final Boolean getEnableMetadataWithRecommendations() {
            return enableMetadataWithRecommendations;
        }

        public final void setEnableMetadataWithRecommendations(Boolean enableMetadataWithRecommendations) {
            this.enableMetadataWithRecommendations = enableMetadataWithRecommendations;
        }

        @Override
        public final Builder enableMetadataWithRecommendations(Boolean enableMetadataWithRecommendations) {
            this.enableMetadataWithRecommendations = enableMetadataWithRecommendations;
            return this;
        }

        public final Boolean getSyncWithLatestSolutionVersion() {
            return syncWithLatestSolutionVersion;
        }

        public final void setSyncWithLatestSolutionVersion(Boolean syncWithLatestSolutionVersion) {
            this.syncWithLatestSolutionVersion = syncWithLatestSolutionVersion;
        }

        @Override
        public final Builder syncWithLatestSolutionVersion(Boolean syncWithLatestSolutionVersion) {
            this.syncWithLatestSolutionVersion = syncWithLatestSolutionVersion;
            return this;
        }

        @Override
        public CampaignConfig build() {
            return new CampaignConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
