/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.personalize.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateBatchSegmentJobRequest extends PersonalizeRequest implements
        ToCopyableBuilder<CreateBatchSegmentJobRequest.Builder, CreateBatchSegmentJobRequest> {
    private static final SdkField<String> JOB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("jobName").getter(getter(CreateBatchSegmentJobRequest::jobName)).setter(setter(Builder::jobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobName").build()).build();

    private static final SdkField<String> SOLUTION_VERSION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("solutionVersionArn").getter(getter(CreateBatchSegmentJobRequest::solutionVersionArn))
            .setter(setter(Builder::solutionVersionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("solutionVersionArn").build())
            .build();

    private static final SdkField<String> FILTER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("filterArn").getter(getter(CreateBatchSegmentJobRequest::filterArn)).setter(setter(Builder::filterArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterArn").build()).build();

    private static final SdkField<Integer> NUM_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("numResults").getter(getter(CreateBatchSegmentJobRequest::numResults))
            .setter(setter(Builder::numResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numResults").build()).build();

    private static final SdkField<BatchSegmentJobInput> JOB_INPUT_FIELD = SdkField
            .<BatchSegmentJobInput> builder(MarshallingType.SDK_POJO).memberName("jobInput")
            .getter(getter(CreateBatchSegmentJobRequest::jobInput)).setter(setter(Builder::jobInput))
            .constructor(BatchSegmentJobInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobInput").build()).build();

    private static final SdkField<BatchSegmentJobOutput> JOB_OUTPUT_FIELD = SdkField
            .<BatchSegmentJobOutput> builder(MarshallingType.SDK_POJO).memberName("jobOutput")
            .getter(getter(CreateBatchSegmentJobRequest::jobOutput)).setter(setter(Builder::jobOutput))
            .constructor(BatchSegmentJobOutput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobOutput").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(CreateBatchSegmentJobRequest::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("tags")
            .getter(getter(CreateBatchSegmentJobRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_NAME_FIELD,
            SOLUTION_VERSION_ARN_FIELD, FILTER_ARN_FIELD, NUM_RESULTS_FIELD, JOB_INPUT_FIELD, JOB_OUTPUT_FIELD, ROLE_ARN_FIELD,
            TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String jobName;

    private final String solutionVersionArn;

    private final String filterArn;

    private final Integer numResults;

    private final BatchSegmentJobInput jobInput;

    private final BatchSegmentJobOutput jobOutput;

    private final String roleArn;

    private final List<Tag> tags;

    private CreateBatchSegmentJobRequest(BuilderImpl builder) {
        super(builder);
        this.jobName = builder.jobName;
        this.solutionVersionArn = builder.solutionVersionArn;
        this.filterArn = builder.filterArn;
        this.numResults = builder.numResults;
        this.jobInput = builder.jobInput;
        this.jobOutput = builder.jobOutput;
        this.roleArn = builder.roleArn;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name of the batch segment job to create.
     * </p>
     * 
     * @return The name of the batch segment job to create.
     */
    public final String jobName() {
        return jobName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the solution version you want the batch segment job to use to generate batch
     * segments.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the solution version you want the batch segment job to use to generate
     *         batch segments.
     */
    public final String solutionVersionArn() {
        return solutionVersionArn;
    }

    /**
     * <p>
     * The ARN of the filter to apply to the batch segment job. For more information on using filters, see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/filter-batch.html">Filtering batch recommendations</a>.
     * </p>
     * 
     * @return The ARN of the filter to apply to the batch segment job. For more information on using filters, see <a
     *         href="https://docs.aws.amazon.com/personalize/latest/dg/filter-batch.html">Filtering batch
     *         recommendations</a>.
     */
    public final String filterArn() {
        return filterArn;
    }

    /**
     * <p>
     * The number of predicted users generated by the batch segment job for each line of input data. The maximum number
     * of users per segment is 5 million.
     * </p>
     * 
     * @return The number of predicted users generated by the batch segment job for each line of input data. The maximum
     *         number of users per segment is 5 million.
     */
    public final Integer numResults() {
        return numResults;
    }

    /**
     * <p>
     * The Amazon S3 path for the input data used to generate the batch segment job.
     * </p>
     * 
     * @return The Amazon S3 path for the input data used to generate the batch segment job.
     */
    public final BatchSegmentJobInput jobInput() {
        return jobInput;
    }

    /**
     * <p>
     * The Amazon S3 path for the bucket where the job's output will be stored.
     * </p>
     * 
     * @return The Amazon S3 path for the bucket where the job's output will be stored.
     */
    public final BatchSegmentJobOutput jobOutput() {
        return jobOutput;
    }

    /**
     * <p>
     * The ARN of the Amazon Identity and Access Management role that has permissions to read and write to your input
     * and output Amazon S3 buckets respectively.
     * </p>
     * 
     * @return The ARN of the Amazon Identity and Access Management role that has permissions to read and write to your
     *         input and output Amazon S3 buckets respectively.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <a href="https://docs.aws.amazon.com/personalize/latest/dg/tagging-resources.html">tags</a> to apply to
     * the batch segment job.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A list of <a href="https://docs.aws.amazon.com/personalize/latest/dg/tagging-resources.html">tags</a> to
     *         apply to the batch segment job.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(jobName());
        hashCode = 31 * hashCode + Objects.hashCode(solutionVersionArn());
        hashCode = 31 * hashCode + Objects.hashCode(filterArn());
        hashCode = 31 * hashCode + Objects.hashCode(numResults());
        hashCode = 31 * hashCode + Objects.hashCode(jobInput());
        hashCode = 31 * hashCode + Objects.hashCode(jobOutput());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateBatchSegmentJobRequest)) {
            return false;
        }
        CreateBatchSegmentJobRequest other = (CreateBatchSegmentJobRequest) obj;
        return Objects.equals(jobName(), other.jobName()) && Objects.equals(solutionVersionArn(), other.solutionVersionArn())
                && Objects.equals(filterArn(), other.filterArn()) && Objects.equals(numResults(), other.numResults())
                && Objects.equals(jobInput(), other.jobInput()) && Objects.equals(jobOutput(), other.jobOutput())
                && Objects.equals(roleArn(), other.roleArn()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateBatchSegmentJobRequest").add("JobName", jobName())
                .add("SolutionVersionArn", solutionVersionArn()).add("FilterArn", filterArn()).add("NumResults", numResults())
                .add("JobInput", jobInput()).add("JobOutput", jobOutput()).add("RoleArn", roleArn())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "jobName":
            return Optional.ofNullable(clazz.cast(jobName()));
        case "solutionVersionArn":
            return Optional.ofNullable(clazz.cast(solutionVersionArn()));
        case "filterArn":
            return Optional.ofNullable(clazz.cast(filterArn()));
        case "numResults":
            return Optional.ofNullable(clazz.cast(numResults()));
        case "jobInput":
            return Optional.ofNullable(clazz.cast(jobInput()));
        case "jobOutput":
            return Optional.ofNullable(clazz.cast(jobOutput()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("jobName", JOB_NAME_FIELD);
        map.put("solutionVersionArn", SOLUTION_VERSION_ARN_FIELD);
        map.put("filterArn", FILTER_ARN_FIELD);
        map.put("numResults", NUM_RESULTS_FIELD);
        map.put("jobInput", JOB_INPUT_FIELD);
        map.put("jobOutput", JOB_OUTPUT_FIELD);
        map.put("roleArn", ROLE_ARN_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateBatchSegmentJobRequest, T> g) {
        return obj -> g.apply((CreateBatchSegmentJobRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends PersonalizeRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateBatchSegmentJobRequest> {
        /**
         * <p>
         * The name of the batch segment job to create.
         * </p>
         * 
         * @param jobName
         *        The name of the batch segment job to create.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobName(String jobName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the solution version you want the batch segment job to use to generate
         * batch segments.
         * </p>
         * 
         * @param solutionVersionArn
         *        The Amazon Resource Name (ARN) of the solution version you want the batch segment job to use to
         *        generate batch segments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder solutionVersionArn(String solutionVersionArn);

        /**
         * <p>
         * The ARN of the filter to apply to the batch segment job. For more information on using filters, see <a
         * href="https://docs.aws.amazon.com/personalize/latest/dg/filter-batch.html">Filtering batch
         * recommendations</a>.
         * </p>
         * 
         * @param filterArn
         *        The ARN of the filter to apply to the batch segment job. For more information on using filters, see <a
         *        href="https://docs.aws.amazon.com/personalize/latest/dg/filter-batch.html">Filtering batch
         *        recommendations</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterArn(String filterArn);

        /**
         * <p>
         * The number of predicted users generated by the batch segment job for each line of input data. The maximum
         * number of users per segment is 5 million.
         * </p>
         * 
         * @param numResults
         *        The number of predicted users generated by the batch segment job for each line of input data. The
         *        maximum number of users per segment is 5 million.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numResults(Integer numResults);

        /**
         * <p>
         * The Amazon S3 path for the input data used to generate the batch segment job.
         * </p>
         * 
         * @param jobInput
         *        The Amazon S3 path for the input data used to generate the batch segment job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobInput(BatchSegmentJobInput jobInput);

        /**
         * <p>
         * The Amazon S3 path for the input data used to generate the batch segment job.
         * </p>
         * This is a convenience method that creates an instance of the {@link BatchSegmentJobInput.Builder} avoiding
         * the need to create one manually via {@link BatchSegmentJobInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BatchSegmentJobInput.Builder#build()} is called immediately and
         * its result is passed to {@link #jobInput(BatchSegmentJobInput)}.
         * 
         * @param jobInput
         *        a consumer that will call methods on {@link BatchSegmentJobInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #jobInput(BatchSegmentJobInput)
         */
        default Builder jobInput(Consumer<BatchSegmentJobInput.Builder> jobInput) {
            return jobInput(BatchSegmentJobInput.builder().applyMutation(jobInput).build());
        }

        /**
         * <p>
         * The Amazon S3 path for the bucket where the job's output will be stored.
         * </p>
         * 
         * @param jobOutput
         *        The Amazon S3 path for the bucket where the job's output will be stored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobOutput(BatchSegmentJobOutput jobOutput);

        /**
         * <p>
         * The Amazon S3 path for the bucket where the job's output will be stored.
         * </p>
         * This is a convenience method that creates an instance of the {@link BatchSegmentJobOutput.Builder} avoiding
         * the need to create one manually via {@link BatchSegmentJobOutput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BatchSegmentJobOutput.Builder#build()} is called immediately and
         * its result is passed to {@link #jobOutput(BatchSegmentJobOutput)}.
         * 
         * @param jobOutput
         *        a consumer that will call methods on {@link BatchSegmentJobOutput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #jobOutput(BatchSegmentJobOutput)
         */
        default Builder jobOutput(Consumer<BatchSegmentJobOutput.Builder> jobOutput) {
            return jobOutput(BatchSegmentJobOutput.builder().applyMutation(jobOutput).build());
        }

        /**
         * <p>
         * The ARN of the Amazon Identity and Access Management role that has permissions to read and write to your
         * input and output Amazon S3 buckets respectively.
         * </p>
         * 
         * @param roleArn
         *        The ARN of the Amazon Identity and Access Management role that has permissions to read and write to
         *        your input and output Amazon S3 buckets respectively.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * A list of <a href="https://docs.aws.amazon.com/personalize/latest/dg/tagging-resources.html">tags</a> to
         * apply to the batch segment job.
         * </p>
         * 
         * @param tags
         *        A list of <a href="https://docs.aws.amazon.com/personalize/latest/dg/tagging-resources.html">tags</a>
         *        to apply to the batch segment job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * A list of <a href="https://docs.aws.amazon.com/personalize/latest/dg/tagging-resources.html">tags</a> to
         * apply to the batch segment job.
         * </p>
         * 
         * @param tags
         *        A list of <a href="https://docs.aws.amazon.com/personalize/latest/dg/tagging-resources.html">tags</a>
         *        to apply to the batch segment job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * A list of <a href="https://docs.aws.amazon.com/personalize/latest/dg/tagging-resources.html">tags</a> to
         * apply to the batch segment job.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.personalize.model.Tag.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.personalize.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.personalize.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.personalize.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PersonalizeRequest.BuilderImpl implements Builder {
        private String jobName;

        private String solutionVersionArn;

        private String filterArn;

        private Integer numResults;

        private BatchSegmentJobInput jobInput;

        private BatchSegmentJobOutput jobOutput;

        private String roleArn;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateBatchSegmentJobRequest model) {
            super(model);
            jobName(model.jobName);
            solutionVersionArn(model.solutionVersionArn);
            filterArn(model.filterArn);
            numResults(model.numResults);
            jobInput(model.jobInput);
            jobOutput(model.jobOutput);
            roleArn(model.roleArn);
            tags(model.tags);
        }

        public final String getJobName() {
            return jobName;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final String getSolutionVersionArn() {
            return solutionVersionArn;
        }

        public final void setSolutionVersionArn(String solutionVersionArn) {
            this.solutionVersionArn = solutionVersionArn;
        }

        @Override
        public final Builder solutionVersionArn(String solutionVersionArn) {
            this.solutionVersionArn = solutionVersionArn;
            return this;
        }

        public final String getFilterArn() {
            return filterArn;
        }

        public final void setFilterArn(String filterArn) {
            this.filterArn = filterArn;
        }

        @Override
        public final Builder filterArn(String filterArn) {
            this.filterArn = filterArn;
            return this;
        }

        public final Integer getNumResults() {
            return numResults;
        }

        public final void setNumResults(Integer numResults) {
            this.numResults = numResults;
        }

        @Override
        public final Builder numResults(Integer numResults) {
            this.numResults = numResults;
            return this;
        }

        public final BatchSegmentJobInput.Builder getJobInput() {
            return jobInput != null ? jobInput.toBuilder() : null;
        }

        public final void setJobInput(BatchSegmentJobInput.BuilderImpl jobInput) {
            this.jobInput = jobInput != null ? jobInput.build() : null;
        }

        @Override
        public final Builder jobInput(BatchSegmentJobInput jobInput) {
            this.jobInput = jobInput;
            return this;
        }

        public final BatchSegmentJobOutput.Builder getJobOutput() {
            return jobOutput != null ? jobOutput.toBuilder() : null;
        }

        public final void setJobOutput(BatchSegmentJobOutput.BuilderImpl jobOutput) {
            this.jobOutput = jobOutput != null ? jobOutput.build() : null;
        }

        @Override
        public final Builder jobOutput(BatchSegmentJobOutput jobOutput) {
            this.jobOutput = jobOutput;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateBatchSegmentJobRequest build() {
            return new CreateBatchSegmentJobRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
